/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class UserTypeSerializer
extends BytesSerializer {
    public final LinkedHashMap<String, TypeSerializer<?>> fields;

    public UserTypeSerializer(LinkedHashMap<String, TypeSerializer<?>> fields) {
        this.fields = fields;
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        ByteBuffer input = bytes.duplicate();
        int i = -1;
        for (Map.Entry<String, TypeSerializer<?>> entry : this.fields.entrySet()) {
            ++i;
            if (!input.hasRemaining()) {
                return;
            }
            if (input.remaining() < 4) {
                throw new MarshalException(String.format("Not enough bytes to read size of %dth field %s", i, entry.getKey()));
            }
            int size = input.getInt();
            if (size < 0) continue;
            if (input.remaining() < size) {
                throw new MarshalException(String.format("Not enough bytes to read %dth field %s", i, entry.getKey()));
            }
            ByteBuffer field = ByteBufferUtil.readBytes(input, size);
            try {
                entry.getValue().validate(field);
            }
            catch (MarshalException e) {
                throw new MarshalException(String.format("Failure validating the %dth field %s; %s", i, entry.getKey(), e.getMessage()), e);
            }
        }
        if (input.hasRemaining()) {
            throw new MarshalException("Invalid remaining data after end of UDT value");
        }
    }
}

