/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.AsyncChannelPromise;
import org.apache.cassandra.net.ConnectionType;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.net.FrameEncoderCrc;
import org.apache.cassandra.net.FrameEncoderLZ4;
import org.apache.cassandra.net.FrameEncoderLegacy;
import org.apache.cassandra.net.FrameEncoderLegacyLZ4;
import org.apache.cassandra.net.FrameEncoderUnprotected;
import org.apache.cassandra.net.FutureResult;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.net.HandshakeProtocol;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoSizeEstimator;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.net.SocketFactory;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.memory.BufferPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundConnectionInitiator<SuccessType extends Result.Success> {
    private static final Logger logger = LoggerFactory.getLogger(OutboundConnectionInitiator.class);
    private final ConnectionType type;
    private final OutboundConnectionSettings settings;
    private final int requestMessagingVersion;
    private final Promise<Result<SuccessType>> resultPromise;

    private OutboundConnectionInitiator(ConnectionType type, OutboundConnectionSettings settings, int requestMessagingVersion, Promise<Result<SuccessType>> resultPromise) {
        this.type = type;
        this.requestMessagingVersion = requestMessagingVersion;
        this.settings = settings;
        this.resultPromise = resultPromise;
    }

    public static Future<Result<Result.StreamingSuccess>> initiateStreaming(EventLoop eventLoop, OutboundConnectionSettings settings, int requestMessagingVersion) {
        return super.initiate(eventLoop);
    }

    static Future<Result<Result.MessagingSuccess>> initiateMessaging(EventLoop eventLoop, ConnectionType type, OutboundConnectionSettings settings, int requestMessagingVersion, Promise<Result<Result.MessagingSuccess>> result) {
        return super.initiate(eventLoop);
    }

    private Future<Result<SuccessType>> initiate(EventLoop eventLoop) {
        if (logger.isTraceEnabled()) {
            logger.trace("creating outbound bootstrap to {}, requestVersion: {}", (Object)this.settings, (Object)this.requestMessagingVersion);
        }
        if (!this.settings.authenticate()) {
            MessagingService.instance().interruptOutbound(this.settings.to);
            return new FailedFuture((EventExecutor)eventLoop, (Throwable)new IOException("authentication failed to " + this.settings.connectToId()));
        }
        AtomicBoolean timedout = new AtomicBoolean();
        ChannelFuture bootstrap = this.createBootstrap(eventLoop).connect().addListener(future -> eventLoop.execute(() -> {
            if (!future.isSuccess()) {
                if (future.isCancelled() && !timedout.get()) {
                    this.resultPromise.cancel(true);
                } else if (future.isCancelled()) {
                    this.resultPromise.tryFailure((Throwable)new IOException("Timeout handshaking with " + this.settings.connectToId()));
                } else {
                    this.resultPromise.tryFailure(future.cause());
                }
            }
        }));
        ScheduledFuture timeout = eventLoop.schedule(() -> OutboundConnectionInitiator.lambda$initiate$2(timedout, (Future)bootstrap), HandshakeProtocol.TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        bootstrap.addListener(future -> timeout.cancel(true));
        return new FutureResult<Result<SuccessType>>(this.resultPromise, (Future<?>)bootstrap);
    }

    private Bootstrap createBootstrap(EventLoop eventLoop) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.settings.socketFactory.newClientBootstrap(eventLoop, this.settings.tcpUserTimeoutInMS).option(ChannelOption.ALLOCATOR, (Object)GlobalBufferPoolAllocator.instance)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.settings.tcpConnectTimeoutInMS)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)this.settings.tcpNoDelay)).option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)NoSizeEstimator.instance)).handler((ChannelHandler)new Initializer());
        if (this.settings.socketSendBufferSizeInBytes > 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.settings.socketSendBufferSizeInBytes);
        }
        InetAddressAndPort remoteAddress = this.settings.connectTo;
        bootstrap.remoteAddress((SocketAddress)new InetSocketAddress(remoteAddress.address, remoteAddress.port));
        return bootstrap;
    }

    private static /* synthetic */ void lambda$initiate$2(AtomicBoolean timedout, Future bootstrap) {
        timedout.set(true);
        bootstrap.cancel(false);
    }

    public static class Result<SuccessType extends Success> {
        final Outcome outcome;

        private Result(Outcome outcome) {
            this.outcome = outcome;
        }

        boolean isSuccess() {
            return this.outcome == Outcome.SUCCESS;
        }

        public SuccessType success() {
            return (SuccessType)((Success)this);
        }

        static MessagingSuccess messagingSuccess(Channel channel, int messagingVersion, FrameEncoder.PayloadAllocator allocator) {
            return new MessagingSuccess(channel, messagingVersion, allocator);
        }

        static StreamingSuccess streamingSuccess(Channel channel, int messagingVersion) {
            return new StreamingSuccess(channel, messagingVersion);
        }

        public Retry retry() {
            return (Retry)this;
        }

        static <SuccessType extends Success> Result<SuccessType> retry(int withMessagingVersion) {
            return new Retry(withMessagingVersion);
        }

        public Incompatible incompatible() {
            return (Incompatible)this;
        }

        static <SuccessType extends Success> Result<SuccessType> incompatible(int closestSupportedVersion, int maxMessagingVersion) {
            return new Incompatible(closestSupportedVersion, maxMessagingVersion);
        }

        static class Incompatible<SuccessType extends Success>
        extends Result<SuccessType> {
            final int closestSupportedVersion;
            final int maxMessagingVersion;

            Incompatible(int closestSupportedVersion, int maxMessagingVersion) {
                super(Outcome.INCOMPATIBLE);
                this.closestSupportedVersion = closestSupportedVersion;
                this.maxMessagingVersion = maxMessagingVersion;
            }
        }

        static class Retry<SuccessType extends Success>
        extends Result<SuccessType> {
            final int withMessagingVersion;

            Retry(int withMessagingVersion) {
                super(Outcome.RETRY);
                this.withMessagingVersion = withMessagingVersion;
            }
        }

        public static class MessagingSuccess
        extends Success<MessagingSuccess> {
            public final FrameEncoder.PayloadAllocator allocator;

            MessagingSuccess(Channel channel, int messagingVersion, FrameEncoder.PayloadAllocator allocator) {
                super(channel, messagingVersion);
                this.allocator = allocator;
            }
        }

        public static class StreamingSuccess
        extends Success<StreamingSuccess> {
            StreamingSuccess(Channel channel, int messagingVersion) {
                super(channel, messagingVersion);
            }
        }

        public static class Success<SuccessType extends Success>
        extends Result<SuccessType> {
            public final Channel channel;
            public final int messagingVersion;

            Success(Channel channel, int messagingVersion) {
                super(Outcome.SUCCESS);
                this.channel = channel;
                this.messagingVersion = messagingVersion;
            }
        }

        static enum Outcome {
            SUCCESS,
            RETRY,
            INCOMPATIBLE;

        }
    }

    private class Handler
    extends ByteToMessageDecoder {
        private Handler() {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            HandshakeProtocol.Initiate msg = new HandshakeProtocol.Initiate(OutboundConnectionInitiator.this.requestMessagingVersion, ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.acceptVersions, OutboundConnectionInitiator.this.type, ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.framing, ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.from);
            logger.trace("starting handshake with peer {}, msg = {}", (Object)OutboundConnectionInitiator.this.settings.connectToId(), (Object)msg);
            AsyncChannelPromise.writeAndFlush(ctx, (Object)msg.encode(), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> {
                if (!future.isSuccess()) {
                    this.exceptionCaught(ctx, future.cause());
                }
            }));
            if (OutboundConnectionInitiator.this.type.isStreaming() && OutboundConnectionInitiator.this.requestMessagingVersion < 12) {
                ctx.pipeline().remove((ChannelHandler)this);
            }
            ctx.fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            OutboundConnectionInitiator.this.resultPromise.tryFailure((Throwable)new ClosedChannelException());
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            try {
                Result result;
                HandshakeProtocol.Accept msg = HandshakeProtocol.Accept.maybeDecode(in, OutboundConnectionInitiator.this.requestMessagingVersion);
                if (msg == null) {
                    return;
                }
                int useMessagingVersion = msg.useMessagingVersion;
                int peerMessagingVersion = msg.maxMessagingVersion;
                logger.trace("received second handshake message from peer {}, msg = {}", (Object)((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.connectTo, (Object)msg);
                FrameEncoder frameEncoder = null;
                if (useMessagingVersion > 0) {
                    if (useMessagingVersion < ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.acceptVersions.min || useMessagingVersion > ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.acceptVersions.max) {
                        result = Result.incompatible(useMessagingVersion, peerMessagingVersion);
                    } else if (OutboundConnectionInitiator.this.type.isMessaging()) {
                        switch (((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.framing) {
                            case LZ4: {
                                frameEncoder = FrameEncoderLZ4.fastInstance;
                                break;
                            }
                            case CRC: {
                                frameEncoder = FrameEncoderCrc.instance;
                                break;
                            }
                            case UNPROTECTED: {
                                frameEncoder = FrameEncoderUnprotected.instance;
                            }
                        }
                        result = Result.messagingSuccess(ctx.channel(), useMessagingVersion, frameEncoder.allocator());
                    } else {
                        result = Result.streamingSuccess(ctx.channel(), useMessagingVersion);
                    }
                } else {
                    assert (OutboundConnectionInitiator.this.type.isMessaging());
                    if (peerMessagingVersion == OutboundConnectionInitiator.this.requestMessagingVersion || peerMessagingVersion > ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.acceptVersions.max) {
                        switch (((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.framing) {
                            case CRC: 
                            case UNPROTECTED: {
                                frameEncoder = FrameEncoderLegacy.instance;
                                break;
                            }
                            case LZ4: {
                                frameEncoder = FrameEncoderLegacyLZ4.instance;
                            }
                        }
                        result = Result.messagingSuccess(ctx.channel(), OutboundConnectionInitiator.this.requestMessagingVersion, frameEncoder.allocator());
                    } else {
                        result = peerMessagingVersion < ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.acceptVersions.min ? Result.incompatible(-1, peerMessagingVersion) : Result.retry(peerMessagingVersion);
                    }
                    if (result.isSuccess()) {
                        HandshakeProtocol.ConfirmOutboundPre40 message = new HandshakeProtocol.ConfirmOutboundPre40(((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.acceptVersions.max, ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.from);
                        AsyncChannelPromise.writeAndFlush(ctx, (Object)message.encode());
                    }
                }
                ChannelPipeline pipeline = ctx.pipeline();
                if (result.isSuccess()) {
                    BufferPool.setRecycleWhenFreeForCurrentThread(false);
                    if (OutboundConnectionInitiator.this.type.isMessaging()) {
                        assert (frameEncoder != null);
                        pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
                    }
                    pipeline.remove((ChannelHandler)this);
                } else {
                    pipeline.close();
                }
                if (!OutboundConnectionInitiator.this.resultPromise.trySuccess((Object)result) && result.isSuccess()) {
                    ((Result.Success)result.success()).channel.close();
                }
            }
            catch (Throwable t) {
                this.exceptionCaught(ctx, t);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            try {
                JVMStabilityInspector.inspectThrowable(cause, false);
                OutboundConnectionInitiator.this.resultPromise.tryFailure(cause);
                if (SocketFactory.isCausedByConnectionReset(cause)) {
                    logger.info("Failed to connect to peer {}", (Object)OutboundConnectionInitiator.this.settings.connectToId(), (Object)cause);
                } else {
                    logger.error("Failed to handshake with peer {}", (Object)OutboundConnectionInitiator.this.settings.connectToId(), (Object)cause);
                }
                ctx.close();
            }
            catch (Throwable t) {
                logger.error("Unexpected exception in {}.exceptionCaught", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)t);
            }
        }
    }

    private class Initializer
    extends ChannelInitializer<SocketChannel> {
        private Initializer() {
        }

        public void initChannel(SocketChannel channel) throws Exception {
            ChannelPipeline pipeline = channel.pipeline();
            if (OutboundConnectionInitiator.this.settings.withEncryption()) {
                SslContext sslContext = SSLFactory.getOrCreateSslContext(((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.encryption, true, SSLFactory.SocketType.CLIENT);
                InetAddressAndPort address = ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.to;
                InetSocketAddress peer = ((OutboundConnectionInitiator)OutboundConnectionInitiator.this).settings.encryption.require_endpoint_verification ? new InetSocketAddress(address.address, address.port) : null;
                SslHandler sslHandler = SocketFactory.newSslHandler((Channel)channel, sslContext, peer);
                logger.trace("creating outbound netty SslContext: context={}, engine={}", (Object)sslContext.getClass().getName(), (Object)sslHandler.engine().getClass().getName());
                pipeline.addFirst("ssl", (ChannelHandler)sslHandler);
            }
            pipeline.addLast("handshake", (ChannelHandler)new Handler());
        }
    }
}

