/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.FrequencySampler;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MaxSampler;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.Sampler;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.Pair;

public class TableMetrics {
    public static final long[] EMPTY = new long[0];
    public final Gauge<Long> memtableOnHeapSize;
    public final Gauge<Long> memtableOffHeapSize;
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapSize;
    public final Gauge<Long> allMemtablesOffHeapSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Counter memtableSwitchCount;
    public final Gauge<Double> compressionRatio;
    public final Gauge<long[]> estimatedPartitionSizeHistogram;
    public final Gauge<Long> estimatedPartitionCount;
    public final Gauge<long[]> estimatedColumnCountHistogram;
    public final TableHistogram sstablesPerReadHistogram;
    public final LatencyMetrics readLatency;
    public final LatencyMetrics rangeLatency;
    public final LatencyMetrics writeLatency;
    public final Counter pendingFlushes;
    public final Counter bytesFlushed;
    public final Counter compactionBytesWritten;
    public final Gauge<Integer> pendingCompactions;
    public final Gauge<Integer> liveSSTableCount;
    public final Gauge<Integer> oldVersionSSTableCount;
    public final Counter liveDiskSpaceUsed;
    public final Counter totalDiskSpaceUsed;
    public final Gauge<Long> minPartitionSize;
    public final Gauge<Long> maxPartitionSize;
    public final Gauge<Long> meanPartitionSize;
    public final Gauge<Long> bloomFilterFalsePositives;
    public final Gauge<Long> recentBloomFilterFalsePositives;
    public final Gauge<Double> bloomFilterFalseRatio;
    public final Gauge<Double> recentBloomFilterFalseRatio;
    public final Gauge<Long> bloomFilterDiskSpaceUsed;
    public final Gauge<Long> bloomFilterOffHeapMemoryUsed;
    public final Gauge<Long> indexSummaryOffHeapMemoryUsed;
    public final Gauge<Long> compressionMetadataOffHeapMemoryUsed;
    public final Gauge<Double> keyCacheHitRate;
    public final TableHistogram tombstoneScannedHistogram;
    public final TableHistogram liveScannedHistogram;
    public final TableHistogram colUpdateTimeDeltaHistogram;
    public final TableTimer viewLockAcquireTime;
    public final TableTimer viewReadTime;
    public final Gauge<Long> trueSnapshotsSize;
    public final Counter rowCacheHitOutOfRange;
    public final Counter rowCacheHit;
    public final Counter rowCacheMiss;
    public final Counter tombstoneFailures;
    public final Counter tombstoneWarnings;
    public final LatencyMetrics casPrepare;
    public final LatencyMetrics casPropose;
    public final LatencyMetrics casCommit;
    public final Gauge<Double> percentRepaired;
    public final Gauge<Long> bytesRepaired;
    public final Gauge<Long> bytesUnrepaired;
    public final Gauge<Long> bytesPendingRepair;
    public final Counter repairsStarted;
    public final Counter repairsCompleted;
    public final TableTimer anticompactionTime;
    public final TableTimer validationTime;
    public final TableTimer syncTime;
    public final TableHistogram bytesValidated;
    public final TableHistogram partitionsValidated;
    public final Counter bytesAnticompacted;
    public final Counter bytesMutatedAnticompaction;
    public final Gauge<Double> mutatedAnticompactionGauge;
    public final Timer coordinatorReadLatency;
    public final Timer coordinatorScanLatency;
    public final Timer coordinatorWriteLatency;
    public final Histogram waitingOnFreeMemtableSpace;
    @Deprecated
    public final Counter droppedMutations;
    private final MetricNameFactory factory;
    private final MetricNameFactory aliasFactory;
    private static final MetricNameFactory globalFactory = new AllTableMetricNameFactory("Table");
    private static final MetricNameFactory globalAliasFactory = new AllTableMetricNameFactory("ColumnFamily");
    public final Counter speculativeRetries;
    public final Counter speculativeFailedRetries;
    public final Counter speculativeInsufficientReplicas;
    public final Gauge<Long> speculativeSampleLatencyNanos;
    public final Counter additionalWrites;
    public final Gauge<Long> additionalWriteLatencyNanos;
    public final Gauge<Integer> unleveledSSTables;
    public final TableMeter confirmedRepairedInconsistencies;
    public final TableMeter unconfirmedRepairedInconsistencies;
    public final TableHistogram repairedDataTrackingOverreadRows;
    public final TableTimer repairedDataTrackingOverreadTime;
    public static final LatencyMetrics globalReadLatency = new LatencyMetrics(globalFactory, globalAliasFactory, "Read");
    public static final LatencyMetrics globalWriteLatency = new LatencyMetrics(globalFactory, globalAliasFactory, "Write");
    public static final LatencyMetrics globalRangeLatency = new LatencyMetrics(globalFactory, globalAliasFactory, "Range");
    public final Sampler<ByteBuffer> topReadPartitionFrequency;
    public final Sampler<ByteBuffer> topWritePartitionFrequency;
    public final Sampler<ByteBuffer> topWritePartitionSize;
    public final Sampler<ByteBuffer> topCasPartitionContention;
    public final Sampler<String> topLocalReadQueryTime;
    public static final Gauge<Double> globalPercentRepaired = CassandraMetricsRegistry.Metrics.register(globalFactory.createMetricName("PercentRepaired"), new Gauge<Double>(){

        public Double getValue() {
            Pair result = TableMetrics.totalNonSystemTablesSize(SSTableReader::isRepaired);
            double repaired = ((Long)result.left).longValue();
            double total = ((Long)result.right).longValue();
            return total > 0.0 ? repaired / total * 100.0 : 100.0;
        }
    });
    public static final Gauge<Long> globalBytesRepaired = CassandraMetricsRegistry.Metrics.register(globalFactory.createMetricName("BytesRepaired"), new Gauge<Long>(){

        public Long getValue() {
            return (Long)TableMetrics.totalNonSystemTablesSize((Predicate<SSTableReader>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isRepaired(), (Lorg/apache/cassandra/io/sstable/format/SSTableReader;)Z)()).left;
        }
    });
    public static final Gauge<Long> globalBytesUnrepaired = CassandraMetricsRegistry.Metrics.register(globalFactory.createMetricName("BytesUnrepaired"), new Gauge<Long>(){

        public Long getValue() {
            return (Long)TableMetrics.totalNonSystemTablesSize((Predicate<SSTableReader>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getValue$0(org.apache.cassandra.io.sstable.format.SSTableReader ), (Lorg/apache/cassandra/io/sstable/format/SSTableReader;)Z)()).left;
        }

        private static /* synthetic */ boolean lambda$getValue$0(SSTableReader s) {
            return !s.isRepaired() && !s.isPendingRepair();
        }
    });
    public static final Gauge<Long> globalBytesPendingRepair = CassandraMetricsRegistry.Metrics.register(globalFactory.createMetricName("BytesPendingRepair"), new Gauge<Long>(){

        public Long getValue() {
            return (Long)TableMetrics.totalNonSystemTablesSize((Predicate<SSTableReader>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isPendingRepair(), (Lorg/apache/cassandra/io/sstable/format/SSTableReader;)Z)()).left;
        }
    });
    public final Meter readRepairRequests;
    public final Meter shortReadProtectionRequests;
    public final Meter replicaFilteringProtectionRequests;
    public final Histogram rfpRowsCachedPerQuery;
    public final EnumMap<Sampler.SamplerType, Sampler<?>> samplers;
    public static final ConcurrentMap<String, Set<Metric>> allTableMetrics = Maps.newConcurrentMap();
    public static final Set<ReleasableMetric> all = Sets.newHashSet();

    private static Pair<Long, Long> totalNonSystemTablesSize(Predicate<SSTableReader> predicate) {
        long total = 0L;
        long filtered = 0L;
        for (String keyspace : Schema.instance.getNonSystemKeyspaces()) {
            Keyspace k = Schema.instance.getKeyspaceInstance(keyspace);
            if ("system_distributed".equals(k.getName()) || k.getReplicationStrategy().getReplicationFactor().allReplicas < 2) continue;
            for (ColumnFamilyStore cf : k.getColumnFamilyStores()) {
                if (SecondaryIndexManager.isIndexColumnFamily(cf.name)) continue;
                for (SSTableReader sstable : cf.getSSTables(SSTableSet.CANONICAL)) {
                    if (predicate.test(sstable)) {
                        filtered += sstable.uncompressedLength();
                    }
                    total += sstable.uncompressedLength();
                }
            }
        }
        return Pair.create(filtered, total);
    }

    private static long[] combineHistograms(Iterable<SSTableReader> sstables, GetHistogram getHistogram) {
        Iterator<SSTableReader> iterator = sstables.iterator();
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        long[] firstBucket = getHistogram.getHistogram(iterator.next()).getBuckets(false);
        long[] values = new long[firstBucket.length];
        System.arraycopy(firstBucket, 0, values, 0, values.length);
        while (iterator.hasNext()) {
            long[] nextBucket = getHistogram.getHistogram(iterator.next()).getBuckets(false);
            if (nextBucket.length > values.length) {
                long[] newValues = new long[nextBucket.length];
                System.arraycopy(firstBucket, 0, newValues, 0, firstBucket.length);
                for (int i = 0; i < newValues.length; ++i) {
                    int n = i;
                    newValues[n] = newValues[n] + nextBucket[i];
                }
                values = newValues;
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                int n = i;
                values[n] = values[n] + nextBucket[i];
            }
        }
        return values;
    }

    public TableMetrics(final ColumnFamilyStore cfs) {
        this.factory = new TableMetricNameFactory(cfs, "Table");
        this.aliasFactory = new TableMetricNameFactory(cfs, "ColumnFamily");
        this.samplers = new EnumMap(Sampler.SamplerType.class);
        this.topReadPartitionFrequency = new FrequencySampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topWritePartitionFrequency = new FrequencySampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topWritePartitionSize = new MaxSampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topCasPartitionContention = new FrequencySampler<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                return cfs.metadata().partitionKeyType.getString(value);
            }
        };
        this.topLocalReadQueryTime = new MaxSampler<String>(){

            @Override
            public String toString(String value) {
                return value;
            }
        };
        this.samplers.put(Sampler.SamplerType.READS, this.topReadPartitionFrequency);
        this.samplers.put(Sampler.SamplerType.WRITES, this.topWritePartitionFrequency);
        this.samplers.put(Sampler.SamplerType.WRITE_SIZE, this.topWritePartitionSize);
        this.samplers.put(Sampler.SamplerType.CAS_CONTENTIONS, this.topCasPartitionContention);
        this.samplers.put(Sampler.SamplerType.LOCAL_READ_TIME, this.topLocalReadQueryTime);
        this.memtableColumnsCount = this.createTableGauge("MemtableColumnsCount", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().getCurrentMemtable().getOperations();
            }
        });
        this.memtableOnHeapSize = this.createTableGauge("MemtableOnHeapSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
            }
        });
        this.memtableOffHeapSize = this.createTableGauge("MemtableOffHeapSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
            }
        });
        this.memtableLiveDataSize = this.createTableGauge("MemtableLiveDataSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().getCurrentMemtable().getLiveDataSize();
            }
        });
        this.allMemtablesOnHeapSize = this.createTableGauge("AllMemtablesHeapSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesOffHeapSize = this.createTableGauge("AllMemtablesOffHeapSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesLiveDataSize = this.createTableGauge("AllMemtablesLiveDataSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getTracker().getView().getCurrentMemtable().getLiveDataSize();
                }
                return size;
            }
        });
        this.memtableSwitchCount = this.createTableCounter("MemtableSwitchCount");
        this.estimatedPartitionSizeHistogram = this.createTableGauge("EstimatedPartitionSizeHistogram", "EstimatedRowSizeHistogram", new Gauge<long[]>(){

            public long[] getValue() {
                return TableMetrics.combineHistograms(cfs.getSSTables(SSTableSet.CANONICAL), new GetHistogram(){

                    @Override
                    public EstimatedHistogram getHistogram(SSTableReader reader) {
                        return reader.getEstimatedPartitionSize();
                    }
                });
            }
        }, null);
        this.estimatedPartitionCount = this.createTableGauge("EstimatedPartitionCount", "EstimatedRowCount", new Gauge<Long>(){

            public Long getValue() {
                long memtablePartitions = 0L;
                for (Memtable memtable : cfs.getTracker().getView().getAllMemtables()) {
                    memtablePartitions += (long)memtable.partitionCount();
                }
                try (ColumnFamilyStore.RefViewFragment refViewFragment = cfs.selectAndReference(View.selectFunction(SSTableSet.CANONICAL));){
                    Long l = SSTableReader.getApproximateKeyCount(refViewFragment.sstables) + memtablePartitions;
                    return l;
                }
            }
        }, null);
        this.estimatedColumnCountHistogram = this.createTableGauge("EstimatedColumnCountHistogram", "EstimatedColumnCountHistogram", new Gauge<long[]>(){

            public long[] getValue() {
                return TableMetrics.combineHistograms(cfs.getSSTables(SSTableSet.CANONICAL), new GetHistogram(){

                    @Override
                    public EstimatedHistogram getHistogram(SSTableReader reader) {
                        return reader.getEstimatedCellPerPartitionCount();
                    }
                });
            }
        }, null);
        this.sstablesPerReadHistogram = this.createTableHistogram("SSTablesPerReadHistogram", cfs.keyspace.metric.sstablesPerReadHistogram, true);
        this.compressionRatio = this.createTableGauge("CompressionRatio", new Gauge<Double>(){

            public Double getValue() {
                return TableMetrics.computeCompressionRatio(cfs.getSSTables(SSTableSet.CANONICAL));
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                ArrayList sstables = new ArrayList();
                Keyspace.all().forEach(ks -> sstables.addAll(ks.getAllSSTables(SSTableSet.CANONICAL)));
                return TableMetrics.computeCompressionRatio(sstables);
            }
        });
        this.percentRepaired = this.createTableGauge("PercentRepaired", new Gauge<Double>(){

            public Double getValue() {
                double repaired = 0.0;
                double total = 0.0;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    if (sstable.isRepaired()) {
                        repaired += (double)sstable.uncompressedLength();
                    }
                    total += (double)sstable.uncompressedLength();
                }
                return total > 0.0 ? repaired / total * 100.0 : 100.0;
            }
        });
        this.bytesRepaired = this.createTableGauge("BytesRepaired", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (SSTableReader sstable : Iterables.filter(cfs.getSSTables(SSTableSet.CANONICAL), SSTableReader::isRepaired)) {
                    size += sstable.uncompressedLength();
                }
                return size;
            }
        });
        this.bytesUnrepaired = this.createTableGauge("BytesUnrepaired", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (SSTableReader sstable : Iterables.filter(cfs.getSSTables(SSTableSet.CANONICAL), s -> !s.isRepaired() && !s.isPendingRepair())) {
                    size += sstable.uncompressedLength();
                }
                return size;
            }
        });
        this.bytesPendingRepair = this.createTableGauge("BytesPendingRepair", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (SSTableReader sstable : Iterables.filter(cfs.getSSTables(SSTableSet.CANONICAL), SSTableReader::isPendingRepair)) {
                    size += sstable.uncompressedLength();
                }
                return size;
            }
        });
        this.readLatency = this.createLatencyMetrics("Read", cfs.keyspace.metric.readLatency, globalReadLatency);
        this.writeLatency = this.createLatencyMetrics("Write", cfs.keyspace.metric.writeLatency, globalWriteLatency);
        this.rangeLatency = this.createLatencyMetrics("Range", cfs.keyspace.metric.rangeLatency, globalRangeLatency);
        this.pendingFlushes = this.createTableCounter("PendingFlushes");
        this.bytesFlushed = this.createTableCounter("BytesFlushed");
        this.compactionBytesWritten = this.createTableCounter("CompactionBytesWritten");
        this.pendingCompactions = this.createTableGauge("PendingCompactions", new Gauge<Integer>(){

            public Integer getValue() {
                return cfs.getCompactionStrategyManager().getEstimatedRemainingTasks();
            }
        });
        this.liveSSTableCount = this.createTableGauge("LiveSSTableCount", new Gauge<Integer>(){

            public Integer getValue() {
                return cfs.getTracker().getView().liveSSTables().size();
            }
        });
        this.oldVersionSSTableCount = this.createTableGauge("OldVersionSSTableCount", new Gauge<Integer>(){

            public Integer getValue() {
                int count = 0;
                for (SSTableReader sstable : cfs.getLiveSSTables()) {
                    if (sstable.descriptor.version.isLatestVersion()) continue;
                    ++count;
                }
                return count;
            }
        });
        this.liveDiskSpaceUsed = this.createTableCounter("LiveDiskSpaceUsed");
        this.totalDiskSpaceUsed = this.createTableCounter("TotalDiskSpaceUsed");
        this.minPartitionSize = this.createTableGauge("MinPartitionSize", "MinRowSize", new Gauge<Long>(){

            public Long getValue() {
                long min = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    if (min != 0L && sstable.getEstimatedPartitionSize().min() >= min) continue;
                    min = sstable.getEstimatedPartitionSize().min();
                }
                return min;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long min = Long.MAX_VALUE;
                for (Metric cfGauge : (Set)allTableMetrics.get("MinPartitionSize")) {
                    min = Math.min(min, ((Number)((Gauge)cfGauge).getValue()).longValue());
                }
                return min;
            }
        });
        this.maxPartitionSize = this.createTableGauge("MaxPartitionSize", "MaxRowSize", new Gauge<Long>(){

            public Long getValue() {
                long max = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    if (sstable.getEstimatedPartitionSize().max() <= max) continue;
                    max = sstable.getEstimatedPartitionSize().max();
                }
                return max;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long max = 0L;
                for (Metric cfGauge : (Set)allTableMetrics.get("MaxPartitionSize")) {
                    max = Math.max(max, ((Number)((Gauge)cfGauge).getValue()).longValue());
                }
                return max;
            }
        });
        this.meanPartitionSize = this.createTableGauge("MeanPartitionSize", "MeanRowSize", new Gauge<Long>(){

            public Long getValue() {
                long sum = 0L;
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    long n = sstable.getEstimatedPartitionSize().count();
                    sum += sstable.getEstimatedPartitionSize().mean() * n;
                    count += n;
                }
                return count > 0L ? sum / count : 0L;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long sum = 0L;
                long count = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables(SSTableSet.CANONICAL)) {
                        long n = sstable.getEstimatedPartitionSize().count();
                        sum += sstable.getEstimatedPartitionSize().mean() * n;
                        count += n;
                    }
                }
                return count > 0L ? sum / count : 0L;
            }
        });
        this.bloomFilterFalsePositives = this.createTableGauge("BloomFilterFalsePositives", new Gauge<Long>(){

            public Long getValue() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    count += sstable.getBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.recentBloomFilterFalsePositives = this.createTableGauge("RecentBloomFilterFalsePositives", new Gauge<Long>(){

            public Long getValue() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    count += sstable.getRecentBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.bloomFilterFalseRatio = this.createTableGauge("BloomFilterFalseRatio", new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    falseCount += sstable.getBloomFilterFalsePositiveCount();
                    trueCount += sstable.getBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables(SSTableSet.LIVE)) {
                        falseCount += sstable.getBloomFilterFalsePositiveCount();
                        trueCount += sstable.getBloomFilterTruePositiveCount();
                    }
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.recentBloomFilterFalseRatio = this.createTableGauge("RecentBloomFilterFalseRatio", new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    falseCount += sstable.getRecentBloomFilterFalsePositiveCount();
                    trueCount += sstable.getRecentBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables(SSTableSet.LIVE)) {
                        falseCount += sstable.getRecentBloomFilterFalsePositiveCount();
                        trueCount += sstable.getRecentBloomFilterTruePositiveCount();
                    }
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.bloomFilterDiskSpaceUsed = this.createTableGauge("BloomFilterDiskSpaceUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    total += sst.getBloomFilterSerializedSize();
                }
                return total;
            }
        });
        this.bloomFilterOffHeapMemoryUsed = this.createTableGauge("BloomFilterOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables(SSTableSet.LIVE)) {
                    total += sst.getBloomFilterOffHeapSize();
                }
                return total;
            }
        });
        this.indexSummaryOffHeapMemoryUsed = this.createTableGauge("IndexSummaryOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables(SSTableSet.LIVE)) {
                    total += sst.getIndexSummaryOffHeapSize();
                }
                return total;
            }
        });
        this.compressionMetadataOffHeapMemoryUsed = this.createTableGauge("CompressionMetadataOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables(SSTableSet.LIVE)) {
                    total += sst.getCompressionMetadataOffHeapSize();
                }
                return total;
            }
        });
        this.speculativeRetries = this.createTableCounter("SpeculativeRetries");
        this.speculativeFailedRetries = this.createTableCounter("SpeculativeFailedRetries");
        this.speculativeInsufficientReplicas = this.createTableCounter("SpeculativeInsufficientReplicas");
        this.speculativeSampleLatencyNanos = this.createTableGauge("SpeculativeSampleLatencyNanos", () -> cfs.sampleReadLatencyNanos);
        this.additionalWrites = this.createTableCounter("AdditionalWrites");
        this.additionalWriteLatencyNanos = this.createTableGauge("AdditionalWriteLatencyNanos", () -> cfs.additionalWriteLatencyNanos);
        this.keyCacheHitRate = this.createTableGauge("KeyCacheHitRate", "KeyCacheHitRate", (Gauge)new RatioGauge(){

            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)this.getNumerator(), (double)this.getDenominator());
            }

            protected double getNumerator() {
                long hits = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    hits += sstable.getKeyCacheHit();
                }
                return hits;
            }

            protected double getDenominator() {
                long requests = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    requests += sstable.getKeyCacheRequest();
                }
                return Math.max(requests, 1L);
            }
        }, null);
        this.tombstoneScannedHistogram = this.createTableHistogram("TombstoneScannedHistogram", cfs.keyspace.metric.tombstoneScannedHistogram, false);
        this.liveScannedHistogram = this.createTableHistogram("LiveScannedHistogram", cfs.keyspace.metric.liveScannedHistogram, false);
        this.colUpdateTimeDeltaHistogram = this.createTableHistogram("ColUpdateTimeDeltaHistogram", cfs.keyspace.metric.colUpdateTimeDeltaHistogram, false);
        this.coordinatorReadLatency = this.createTableTimer("CoordinatorReadLatency");
        this.coordinatorScanLatency = this.createTableTimer("CoordinatorScanLatency");
        this.coordinatorWriteLatency = this.createTableTimer("CoordinatorWriteLatency");
        this.waitingOnFreeMemtableSpace = this.createTableHistogram("WaitingOnFreeMemtableSpace", false);
        if (cfs.metadata().isView()) {
            this.viewLockAcquireTime = null;
            this.viewReadTime = null;
        } else {
            this.viewLockAcquireTime = this.createTableTimer("ViewLockAcquireTime", cfs.keyspace.metric.viewLockAcquireTime);
            this.viewReadTime = this.createTableTimer("ViewReadTime", cfs.keyspace.metric.viewReadTime);
        }
        this.trueSnapshotsSize = this.createTableGauge("SnapshotsSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.trueSnapshotsSize();
            }
        });
        this.rowCacheHitOutOfRange = this.createTableCounter("RowCacheHitOutOfRange");
        this.rowCacheHit = this.createTableCounter("RowCacheHit");
        this.rowCacheMiss = this.createTableCounter("RowCacheMiss");
        this.tombstoneFailures = this.createTableCounter("TombstoneFailures");
        this.tombstoneWarnings = this.createTableCounter("TombstoneWarnings");
        this.droppedMutations = this.createTableCounter("DroppedMutations");
        this.casPrepare = this.createLatencyMetrics("CasPrepare", cfs.keyspace.metric.casPrepare);
        this.casPropose = this.createLatencyMetrics("CasPropose", cfs.keyspace.metric.casPropose);
        this.casCommit = this.createLatencyMetrics("CasCommit", cfs.keyspace.metric.casCommit);
        this.repairsStarted = this.createTableCounter("RepairJobsStarted");
        this.repairsCompleted = this.createTableCounter("RepairJobsCompleted");
        this.anticompactionTime = this.createTableTimer("AnticompactionTime", cfs.keyspace.metric.anticompactionTime);
        this.validationTime = this.createTableTimer("ValidationTime", cfs.keyspace.metric.validationTime);
        this.syncTime = this.createTableTimer("SyncTime", cfs.keyspace.metric.repairSyncTime);
        this.bytesValidated = this.createTableHistogram("BytesValidated", cfs.keyspace.metric.bytesValidated, false);
        this.partitionsValidated = this.createTableHistogram("PartitionsValidated", cfs.keyspace.metric.partitionsValidated, false);
        this.bytesAnticompacted = this.createTableCounter("BytesAnticompacted");
        this.bytesMutatedAnticompaction = this.createTableCounter("BytesMutatedAnticompaction");
        this.mutatedAnticompactionGauge = this.createTableGauge("MutatedAnticompactionGauge", () -> {
            double bytesMutated = this.bytesMutatedAnticompaction.getCount();
            double bytesAnticomp = this.bytesAnticompacted.getCount();
            if (bytesAnticomp + bytesMutated > 0.0) {
                return bytesMutated / (bytesAnticomp + bytesMutated);
            }
            return 0.0;
        });
        this.readRepairRequests = this.createTableMeter("ReadRepairRequests");
        this.shortReadProtectionRequests = this.createTableMeter("ShortReadProtectionRequests");
        this.replicaFilteringProtectionRequests = this.createTableMeter("ReplicaFilteringProtectionRequests");
        this.rfpRowsCachedPerQuery = this.createHistogram("ReplicaFilteringProtectionRowsCachedPerQuery", true);
        this.confirmedRepairedInconsistencies = this.createTableMeter("RepairedDataInconsistenciesConfirmed", cfs.keyspace.metric.confirmedRepairedInconsistencies);
        this.unconfirmedRepairedInconsistencies = this.createTableMeter("RepairedDataInconsistenciesUnconfirmed", cfs.keyspace.metric.unconfirmedRepairedInconsistencies);
        this.repairedDataTrackingOverreadRows = this.createTableHistogram("RepairedDataTrackingOverreadRows", cfs.keyspace.metric.repairedDataTrackingOverreadRows, false);
        this.repairedDataTrackingOverreadTime = this.createTableTimer("RepairedDataTrackingOverreadTime", cfs.keyspace.metric.repairedDataTrackingOverreadTime);
        this.unleveledSSTables = this.createTableGauge("UnleveledSSTables", cfs::getUnleveledSSTables, () -> {
            int cnt = 0;
            for (Metric cfGauge : (Set)allTableMetrics.get("UnleveledSSTables")) {
                cnt += ((Number)((Gauge)cfGauge).getValue()).intValue();
            }
            return cnt;
        });
    }

    public void updateSSTableIterated(int count) {
        this.sstablesPerReadHistogram.update(count);
    }

    public void release() {
        for (ReleasableMetric entry : all) {
            entry.release();
        }
    }

    protected <T extends Number> Gauge<T> createTableGauge(final String name, Gauge<T> gauge) {
        return this.createTableGauge(name, gauge, new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (Metric cfGauge : (Set)allTableMetrics.get(name)) {
                    total += ((Number)((Gauge)cfGauge).getValue()).longValue();
                }
                return total;
            }
        });
    }

    protected <G, T> Gauge<T> createTableGauge(String name, Gauge<T> gauge, Gauge<G> globalGauge) {
        return this.createTableGauge(name, name, gauge, globalGauge);
    }

    protected <G, T> Gauge<T> createTableGauge(String name, String alias, Gauge<T> gauge, Gauge<G> globalGauge) {
        Gauge<T> cfGauge = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias), gauge);
        if (this.register(name, alias, (Metric)cfGauge) && globalGauge != null) {
            CassandraMetricsRegistry.Metrics.register(globalFactory.createMetricName(name), globalAliasFactory.createMetricName(alias), globalGauge);
        }
        return cfGauge;
    }

    protected Counter createTableCounter(String name) {
        return this.createTableCounter(name, name);
    }

    protected Counter createTableCounter(final String name, String alias) {
        Counter cfCounter = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        if (this.register(name, alias, (Metric)cfCounter)) {
            CassandraMetricsRegistry.Metrics.register(globalFactory.createMetricName(name), globalAliasFactory.createMetricName(alias), new Gauge<Long>(){

                public Long getValue() {
                    long total = 0L;
                    for (Metric cfGauge : (Set)allTableMetrics.get(name)) {
                        total += ((Counter)cfGauge).getCount();
                    }
                    return total;
                }
            });
        }
        return cfCounter;
    }

    private Meter createTableMeter(String name) {
        return this.createTableMeter(name, name);
    }

    private Meter createTableMeter(String name, String alias) {
        Meter tableMeter = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        this.register(name, alias, (Metric)tableMeter);
        return tableMeter;
    }

    private Histogram createHistogram(String name, boolean considerZeroes) {
        Histogram histogram = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName(name), this.aliasFactory.createMetricName(name), considerZeroes);
        this.register(name, name, (Metric)histogram);
        return histogram;
    }

    private static Double computeCompressionRatio(Iterable<SSTableReader> sstables) {
        double compressedLengthSum = 0.0;
        double dataLengthSum = 0.0;
        for (SSTableReader sstable : sstables) {
            if (!sstable.compression) continue;
            assert (sstable.openReason != SSTableReader.OpenReason.EARLY);
            CompressionMetadata compressionMetadata = sstable.getCompressionMetadata();
            compressedLengthSum += (double)compressionMetadata.compressedFileLength;
            dataLengthSum += (double)compressionMetadata.dataLength;
        }
        return dataLengthSum != 0.0 ? compressedLengthSum / dataLengthSum : -1.0;
    }

    protected TableHistogram createTableHistogram(String name, Histogram keyspaceHistogram, boolean considerZeroes) {
        return this.createTableHistogram(name, name, keyspaceHistogram, considerZeroes);
    }

    protected TableHistogram createTableHistogram(String name, String alias, Histogram keyspaceHistogram, boolean considerZeroes) {
        Histogram cfHistogram = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias), considerZeroes);
        this.register(name, alias, (Metric)cfHistogram);
        return new TableHistogram(cfHistogram, keyspaceHistogram, CassandraMetricsRegistry.Metrics.histogram(globalFactory.createMetricName(name), globalAliasFactory.createMetricName(alias), considerZeroes));
    }

    protected Histogram createTableHistogram(String name, boolean considerZeroes) {
        return this.createTableHistogram(name, name, considerZeroes);
    }

    protected Histogram createTableHistogram(String name, String alias, boolean considerZeroes) {
        Histogram tableHistogram = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias), considerZeroes);
        this.register(name, alias, (Metric)tableHistogram);
        return tableHistogram;
    }

    protected TableTimer createTableTimer(String name, Timer keyspaceTimer) {
        return this.createTableTimer(name, name, keyspaceTimer);
    }

    protected TableTimer createTableTimer(String name, String alias, Timer keyspaceTimer) {
        Timer cfTimer = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        this.register(name, alias, (Metric)cfTimer);
        return new TableTimer(cfTimer, keyspaceTimer, CassandraMetricsRegistry.Metrics.timer(globalFactory.createMetricName(name), globalAliasFactory.createMetricName(alias)));
    }

    protected Timer createTableTimer(String name) {
        return this.createTableTimer(name, name);
    }

    protected Timer createTableTimer(String name, String alias) {
        Timer tableTimer = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        this.register(name, alias, (Metric)tableTimer);
        return tableTimer;
    }

    protected TableMeter createTableMeter(String name, Meter keyspaceMeter) {
        return this.createTableMeter(name, name, keyspaceMeter);
    }

    protected TableMeter createTableMeter(String name, String alias, Meter keyspaceMeter) {
        Meter meter = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        this.register(name, alias, (Metric)meter);
        return new TableMeter(meter, keyspaceMeter, CassandraMetricsRegistry.Metrics.meter(globalFactory.createMetricName(name), globalAliasFactory.createMetricName(alias)));
    }

    private LatencyMetrics createLatencyMetrics(String namePrefix, LatencyMetrics ... parents) {
        LatencyMetrics metric = new LatencyMetrics(this.factory, namePrefix, parents);
        all.add(() -> metric.release());
        return metric;
    }

    private boolean register(String name, String alias, Metric metric) {
        boolean ret = allTableMetrics.putIfAbsent(name, ConcurrentHashMap.newKeySet()) == null;
        ((Set)allTableMetrics.get(name)).add(metric);
        all.add(() -> this.releaseMetric(name, alias));
        return ret;
    }

    private void releaseMetric(String metricName, String metricAlias) {
        CassandraMetricsRegistry.MetricName name = this.factory.createMetricName(metricName);
        CassandraMetricsRegistry.MetricName alias = this.aliasFactory.createMetricName(metricAlias);
        Metric metric = (Metric)CassandraMetricsRegistry.Metrics.getMetrics().get(name.getMetricName());
        if (metric != null) {
            ((Set)allTableMetrics.get(metricName)).remove(metric);
            CassandraMetricsRegistry.Metrics.remove(name, alias);
        }
    }

    @FunctionalInterface
    public static interface ReleasableMetric {
        public void release();
    }

    static class AllTableMetricNameFactory
    implements MetricNameFactory {
        private final String type;

        public AllTableMetricNameFactory(String type) {
            this.type = type;
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = TableMetrics.class.getPackage().getName();
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append(this.type);
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, this.type, metricName, "all", mbeanName.toString());
        }
    }

    static class TableMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;
        private final String tableName;
        private final boolean isIndex;
        private final String type;

        TableMetricNameFactory(ColumnFamilyStore cfs, String type) {
            this.keyspaceName = cfs.keyspace.getName();
            this.tableName = cfs.name;
            this.isIndex = cfs.isIndex();
            this.type = type;
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = TableMetrics.class.getPackage().getName();
            String type = this.isIndex ? "Index" + this.type : this.type;
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append(type);
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",scope=").append(this.tableName);
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, type, metricName, this.keyspaceName + "." + this.tableName, mbeanName.toString());
        }
    }

    public static class TableTimer {
        public final Timer[] all;
        public final Timer cf;

        private TableTimer(Timer cf, Timer keyspace, Timer global) {
            this.cf = cf;
            this.all = new Timer[]{cf, keyspace, global};
        }

        public void update(long i, TimeUnit unit) {
            for (Timer timer : this.all) {
                timer.update(i, unit);
            }
        }

        public Context time() {
            return new Context(this.all);
        }

        public static class Context
        implements AutoCloseable {
            private final long start;
            private final Timer[] all;

            private Context(Timer[] all) {
                this.all = all;
                this.start = System.nanoTime();
            }

            @Override
            public void close() {
                long duration = System.nanoTime() - this.start;
                for (Timer t : this.all) {
                    t.update(duration, TimeUnit.NANOSECONDS);
                }
            }
        }
    }

    public static class TableHistogram {
        public final Histogram[] all;
        public final Histogram cf;

        private TableHistogram(Histogram cf, Histogram keyspace, Histogram global) {
            this.cf = cf;
            this.all = new Histogram[]{cf, keyspace, global};
        }

        public void update(long i) {
            for (Histogram histo : this.all) {
                histo.update(i);
            }
        }
    }

    public static class TableMeter {
        public final Meter[] all;
        public final Meter table;

        private TableMeter(Meter table, Meter keyspace, Meter global) {
            this.table = table;
            this.all = new Meter[]{table, keyspace, global};
        }

        public void mark() {
            for (Meter meter : this.all) {
                meter.mark();
            }
        }
    }

    private static interface GetHistogram {
        public EstimatedHistogram getHistogram(SSTableReader var1);
    }
}

