/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.AbstractClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;

public class ClusteringIndexSliceFilter
extends AbstractClusteringIndexFilter {
    static final ClusteringIndexFilter.InternalDeserializer deserializer = new SliceDeserializer();
    private final Slices slices;

    public ClusteringIndexSliceFilter(Slices slices, boolean reversed) {
        super(reversed);
        this.slices = slices;
    }

    public Slices requestedSlices() {
        return this.slices;
    }

    @Override
    public boolean selectsAllPartition() {
        return this.slices.size() == 1 && !this.slices.hasLowerBound() && !this.slices.hasUpperBound();
    }

    @Override
    public boolean selects(Clustering clustering) {
        return this.slices.selects(clustering);
    }

    @Override
    public ClusteringIndexSliceFilter forPaging(ClusteringComparator comparator, Clustering lastReturned, boolean inclusive) {
        Slices newSlices = this.slices.forPaging(comparator, lastReturned, inclusive, this.reversed);
        return this.slices == newSlices ? this : new ClusteringIndexSliceFilter(newSlices, this.reversed);
    }

    @Override
    public boolean isFullyCoveredBy(CachedPartition partition) {
        if (!this.slices.hasUpperBound() || partition.isEmpty()) {
            return false;
        }
        return partition.metadata().comparator.compare(this.slices.get(this.slices.size() - 1).end(), (ClusteringPrefix)partition.lastRow().clustering()) <= 0;
    }

    @Override
    public boolean isHeadFilter() {
        return !this.reversed && this.slices.size() == 1 && !this.slices.hasLowerBound();
    }

    @Override
    public UnfilteredRowIterator filterNotIndexed(final ColumnFilter columnFilter, final UnfilteredRowIterator iterator) {
        final Slices.InOrderTester tester = this.slices.inOrderTester(this.reversed);
        class FilterNotIndexed
        extends Transformation {
            FilterNotIndexed() {
            }

            @Override
            public Row applyToRow(Row row) {
                return tester.includes(row.clustering()) ? row.filter(columnFilter, iterator.metadata()) : null;
            }

            @Override
            public Row applyToStatic(Row row) {
                return columnFilter.fetchedColumns().statics.isEmpty() ? Rows.EMPTY_STATIC_ROW : row.filter(columnFilter, iterator.metadata());
            }
        }
        return Transformation.apply(iterator, new FilterNotIndexed());
    }

    @Override
    public Slices getSlices(TableMetadata metadata) {
        return this.slices;
    }

    @Override
    public UnfilteredRowIterator getUnfilteredRowIterator(ColumnFilter columnFilter, Partition partition) {
        return partition.unfilteredIterator(columnFilter, this.slices, this.reversed);
    }

    @Override
    public boolean shouldInclude(SSTableReader sstable) {
        List<ByteBuffer> minClusteringValues = sstable.getSSTableMetadata().minClusteringValues;
        List<ByteBuffer> maxClusteringValues = sstable.getSSTableMetadata().maxClusteringValues;
        if (minClusteringValues.isEmpty() || maxClusteringValues.isEmpty()) {
            return true;
        }
        return this.slices.intersects(minClusteringValues, maxClusteringValues);
    }

    @Override
    public String toString(TableMetadata metadata) {
        return String.format("slice(slices=%s, reversed=%b)", this.slices, this.reversed);
    }

    @Override
    public String toCQLString(TableMetadata metadata) {
        StringBuilder sb = new StringBuilder();
        if (!this.selectsAllPartition()) {
            sb.append(this.slices.toCQLString(metadata));
        }
        this.appendOrderByToCQLString(metadata, sb);
        return sb.toString();
    }

    @Override
    public ClusteringIndexFilter.Kind kind() {
        return ClusteringIndexFilter.Kind.SLICE;
    }

    @Override
    protected void serializeInternal(DataOutputPlus out, int version) throws IOException {
        Slices.serializer.serialize(this.slices, out, version);
    }

    @Override
    protected long serializedSizeInternal(int version) {
        return Slices.serializer.serializedSize(this.slices, version);
    }

    private static class SliceDeserializer
    implements ClusteringIndexFilter.InternalDeserializer {
        private SliceDeserializer() {
        }

        @Override
        public ClusteringIndexFilter deserialize(DataInputPlus in, int version, TableMetadata metadata, boolean reversed) throws IOException {
            Slices slices = Slices.serializer.deserialize(in, version, metadata);
            return new ClusteringIndexSliceFilter(slices, reversed);
        }
    }
}

