/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.ReplicaPlans;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.reads.DataResolver;
import org.apache.cassandra.service.reads.ReadCallback;
import org.apache.cassandra.service.reads.repair.NoopReadRepair;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicaFilteringProtection<E extends Endpoints<E>> {
    private static final Logger logger = LoggerFactory.getLogger(ReplicaFilteringProtection.class);
    private final Keyspace keyspace;
    private final ReadCommand command;
    private final ConsistencyLevel consistency;
    private final long queryStartNanoTime;
    private final E sources;
    private final TableMetrics tableMetrics;
    private final List<SortedMap<DecoratedKey, BTreeSet.Builder<Clustering>>> rowsToFetch;
    private final List<List<PartitionBuilder>> originalPartitions;

    ReplicaFilteringProtection(Keyspace keyspace, ReadCommand command, ConsistencyLevel consistency, long queryStartNanoTime, E sources) {
        this.keyspace = keyspace;
        this.command = command;
        this.consistency = consistency;
        this.queryStartNanoTime = queryStartNanoTime;
        this.sources = sources;
        this.rowsToFetch = new ArrayList<SortedMap<DecoratedKey, BTreeSet.Builder<Clustering>>>(((AbstractReplicaCollection)sources).size());
        this.originalPartitions = new ArrayList<List<PartitionBuilder>>(((AbstractReplicaCollection)sources).size());
        for (Replica ignored : sources) {
            this.rowsToFetch.add(new TreeMap());
            this.originalPartitions.add(new ArrayList());
        }
        this.tableMetrics = ColumnFamilyStore.metricsFor(command.metadata().id);
    }

    private BTreeSet.Builder<Clustering> getOrCreateToFetch(int source, DecoratedKey partitionKey) {
        return this.rowsToFetch.get(source).computeIfAbsent(partitionKey, k -> BTreeSet.builder(this.command.metadata().comparator));
    }

    UnfilteredPartitionIterator queryProtectedPartitions(int source) {
        UnfilteredPartitionIterator original = this.makeIterator(this.originalPartitions.get(source));
        SortedMap<DecoratedKey, BTreeSet.Builder<Clustering>> toFetch = this.rowsToFetch.get(source);
        if (toFetch.isEmpty()) {
            return original;
        }
        List<UnfilteredPartitionIterator> fetched = toFetch.keySet().stream().map(k -> this.querySourceOnKey(source, (DecoratedKey)k)).collect(Collectors.toList());
        return UnfilteredPartitionIterators.merge(Arrays.asList(original, UnfilteredPartitionIterators.concat(fetched)), null);
    }

    private UnfilteredPartitionIterator querySourceOnKey(int i, DecoratedKey key) {
        BTreeSet.Builder builder = (BTreeSet.Builder)this.rowsToFetch.get(i).get(key);
        assert (builder != null);
        Replica source = ((AbstractReplicaCollection)this.sources).get(i);
        BTreeSet<Clustering> clusterings = builder.build();
        this.tableMetrics.replicaSideFilteringProtectionRequests.mark();
        if (logger.isTraceEnabled()) {
            logger.trace("Requesting rows {} in partition {} from {} for replica-side filtering protection", new Object[]{clusterings, key, source});
        }
        Tracing.trace("Requesting {} rows in partition {} from {} for replica-side filtering protection", clusterings.size(), key, source);
        DataLimits limits = clusterings.isEmpty() ? DataLimits.cqlLimits(1) : DataLimits.NONE;
        ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(clusterings, this.command.isReversed());
        SinglePartitionReadCommand cmd = SinglePartitionReadCommand.create(this.command.metadata(), this.command.nowInSec(), this.command.columnFilter(), RowFilter.NONE, limits, key, filter);
        ReplicaPlan.ForTokenRead replicaPlan = ReplicaPlans.forSingleReplicaRead(this.keyspace, key.getToken(), source);
        ReplicaPlan.SharedForTokenRead sharedReplicaPlan = ReplicaPlan.shared(replicaPlan);
        try {
            return this.executeReadCommand(cmd, source, sharedReplicaPlan);
        }
        catch (ReadTimeoutException e) {
            int blockFor = this.consistency.blockFor(this.keyspace);
            throw new ReadTimeoutException(this.consistency, blockFor - 1, blockFor, true);
        }
        catch (UnavailableException e) {
            int blockFor = this.consistency.blockFor(this.keyspace);
            throw UnavailableException.create(this.consistency, blockFor, blockFor - 1);
        }
    }

    private <E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E>> UnfilteredPartitionIterator executeReadCommand(ReadCommand cmd, Replica source, ReplicaPlan.Shared<E, P> replicaPlan) {
        DataResolver<E, P> resolver = new DataResolver<E, P>(cmd, replicaPlan, NoopReadRepair.instance, this.queryStartNanoTime);
        ReadCallback<E, P> handler = new ReadCallback<E, P>(resolver, cmd, replicaPlan, this.queryStartNanoTime);
        if (source.isSelf()) {
            Stage.READ.maybeExecuteImmediately(new StorageProxy.LocalReadRunnable(cmd, handler));
        } else {
            if (source.isTransient()) {
                cmd = cmd.copyAsTransientQuery(source);
            }
            MessagingService.instance().sendWithCallback(cmd.createMessage(false), source.endpoint(), handler);
        }
        handler.awaitResults();
        assert (resolver.getMessages().size() == 1);
        return ((ReadResponse)resolver.getMessages().get((int)0).payload).makeIterator(this.command);
    }

    UnfilteredPartitionIterators.MergeListener mergeController() {
        return (partitionKey, versions) -> {
            final PartitionBuilder[] builders = new PartitionBuilder[((AbstractReplicaCollection)this.sources).size()];
            for (int i = 0; i < ((AbstractReplicaCollection)this.sources).size(); ++i) {
                builders[i] = new PartitionBuilder(this.command, partitionKey, ReplicaFilteringProtection.columns(versions), ReplicaFilteringProtection.stats(versions));
            }
            return new UnfilteredRowIterators.MergeListener(){

                @Override
                public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
                    for (int i = 0; i < versions.length; ++i) {
                        builders[i].setDeletionTime(versions[i]);
                    }
                }

                @Override
                public Row onMergedRows(Row merged, Row[] versions) {
                    for (int i = 0; i < versions.length; ++i) {
                        builders[i].addRow(versions[i]);
                    }
                    if (merged.isEmpty()) {
                        return merged;
                    }
                    boolean isPotentiallyOutdated = false;
                    boolean isStatic = merged.isStatic();
                    for (int i = 0; i < versions.length; ++i) {
                        Row version = versions[i];
                        if (version != null && (!isStatic || !version.isEmpty())) continue;
                        isPotentiallyOutdated = true;
                        BTreeSet.Builder toFetch = ReplicaFilteringProtection.this.getOrCreateToFetch(i, partitionKey);
                        if (isStatic) continue;
                        toFetch.add(merged.clustering());
                    }
                    return isPotentiallyOutdated ? null : merged;
                }

                @Override
                public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
                    for (int i = 0; i < versions.length; ++i) {
                        builders[i].addRangeTombstoneMarker(versions[i]);
                    }
                }

                @Override
                public void close() {
                    for (int i = 0; i < ReplicaFilteringProtection.this.sources.size(); ++i) {
                        ((List)ReplicaFilteringProtection.this.originalPartitions.get(i)).add(builders[i]);
                    }
                }
            };
        };
    }

    private static RegularAndStaticColumns columns(List<UnfilteredRowIterator> versions) {
        Columns statics = Columns.NONE;
        Columns regulars = Columns.NONE;
        for (UnfilteredRowIterator iter : versions) {
            if (iter == null) continue;
            RegularAndStaticColumns cols = iter.columns();
            statics = statics.mergeTo(cols.statics);
            regulars = regulars.mergeTo(cols.regulars);
        }
        return new RegularAndStaticColumns(statics, regulars);
    }

    private static EncodingStats stats(List<UnfilteredRowIterator> iterators) {
        EncodingStats stats = EncodingStats.NO_STATS;
        for (UnfilteredRowIterator iter : iterators) {
            if (iter == null) continue;
            stats = stats.mergeWith(iter.stats());
        }
        return stats;
    }

    private UnfilteredPartitionIterator makeIterator(final List<PartitionBuilder> builders) {
        return new UnfilteredPartitionIterator(){
            final Iterator<PartitionBuilder> iterator;
            {
                this.iterator = builders.iterator();
            }

            @Override
            public TableMetadata metadata() {
                return ReplicaFilteringProtection.this.command.metadata();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                return this.iterator.next().build();
            }
        };
    }

    private static class PartitionBuilder {
        private final ReadCommand command;
        private final DecoratedKey partitionKey;
        private final RegularAndStaticColumns columns;
        private final EncodingStats stats;
        private DeletionTime deletionTime;
        private Row staticRow = Rows.EMPTY_STATIC_ROW;
        private final List<Unfiltered> contents = new ArrayList<Unfiltered>();

        private PartitionBuilder(ReadCommand command, DecoratedKey partitionKey, RegularAndStaticColumns columns, EncodingStats stats) {
            this.command = command;
            this.partitionKey = partitionKey;
            this.columns = columns;
            this.stats = stats;
        }

        private void setDeletionTime(DeletionTime deletionTime) {
            this.deletionTime = deletionTime;
        }

        private void addRow(Row row) {
            if (row == null) {
                return;
            }
            if (row.isStatic()) {
                this.staticRow = row;
            } else {
                this.contents.add(row);
            }
        }

        private void addRangeTombstoneMarker(RangeTombstoneMarker marker) {
            if (marker != null) {
                this.contents.add(marker);
            }
        }

        private UnfilteredRowIterator build() {
            return new UnfilteredRowIterator(){
                final Iterator<Unfiltered> iterator;
                {
                    this.iterator = contents.iterator();
                }

                @Override
                public DeletionTime partitionLevelDeletion() {
                    return deletionTime;
                }

                @Override
                public EncodingStats stats() {
                    return stats;
                }

                @Override
                public TableMetadata metadata() {
                    return command.metadata();
                }

                @Override
                public boolean isReverseOrder() {
                    return command.isReversed();
                }

                @Override
                public RegularAndStaticColumns columns() {
                    return columns;
                }

                @Override
                public DecoratedKey partitionKey() {
                    return partitionKey;
                }

                @Override
                public Row staticRow() {
                    return staticRow;
                }

                @Override
                public void close() {
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Unfiltered next() {
                    return this.iterator.next();
                }
            };
        }
    }
}

