/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.ViewMetadata;

public class SchemaCQLHelper {
    public static Stream<String> reCreateStatementsForSchemaCql(TableMetadata metadata, Types types) {
        Stream<String> udts = SchemaCQLHelper.getUserTypesAsCQL(metadata, types);
        return Stream.concat(udts, SchemaCQLHelper.reCreateStatements(metadata, true, true, true, true));
    }

    public static Stream<String> reCreateStatements(TableMetadata metadata, boolean includeDroppedColumns, boolean internals, boolean ifNotExists, boolean includeIndexes) {
        Stream<String> r = Stream.of(metadata).map(tm -> SchemaCQLHelper.getTableMetadataAsCQL(tm, includeDroppedColumns, internals, ifNotExists));
        if (includeIndexes) {
            r = Stream.concat(r, SchemaCQLHelper.getIndexesAsCQL(metadata));
        }
        return r;
    }

    @VisibleForTesting
    public static String getTableMetadataAsCQL(TableMetadata metadata, boolean includeDroppedColumns, boolean internals, boolean ifNotExists) {
        if (metadata.isView()) {
            KeyspaceMetadata keyspaceMetadata = Schema.instance.getKeyspaceMetadata(metadata.keyspace);
            ViewMetadata viewMetadata = keyspaceMetadata.views.get(metadata.name).orElse(null);
            assert (viewMetadata != null);
            return viewMetadata.toCqlString(internals, ifNotExists);
        }
        return metadata.toCqlString(includeDroppedColumns, internals, ifNotExists);
    }

    @VisibleForTesting
    public static Stream<String> getUserTypesAsCQL(TableMetadata metadata, Types types) {
        return metadata.getReferencedUserTypes().stream().map(name -> SchemaCQLHelper.getType(metadata, types, name).toCqlString(false));
    }

    @VisibleForTesting
    public static Stream<String> getIndexesAsCQL(TableMetadata metadata) {
        return metadata.indexes.stream().map(indexMetadata -> indexMetadata.toCqlString(metadata));
    }

    private static UserType getType(TableMetadata metadata, Types types, ByteBuffer name) {
        return types.get(name).orElseThrow(() -> new IllegalStateException(String.format("user type %s is part of table %s definition but its definition was missing", UTF8Type.instance.getString(name), metadata)));
    }
}

