/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.collect.MinMaxPriorityQueue;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.tools.Util;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class SSTableMetadataViewer {
    private static final Options options = new Options();
    private static CommandLine cmd;
    private static final String COLORS = "c";
    private static final String UNICODE = "u";
    private static final String GCGS_KEY = "g";
    private static final String TIMESTAMP_UNIT = "t";
    private static final String SCAN = "s";
    private static Comparator<ValuedByteBuffer> VCOMP;
    boolean color;
    boolean unicode;
    int gc;
    PrintStream out;
    String[] files;
    TimeUnit tsUnit;

    public SSTableMetadataViewer() {
        this(true, true, 0, TimeUnit.MICROSECONDS, System.out);
    }

    public SSTableMetadataViewer(boolean color, boolean unicode, int gc, TimeUnit tsUnit, PrintStream out) {
        this.color = color;
        this.tsUnit = tsUnit;
        this.unicode = unicode;
        this.out = out;
        this.gc = gc;
    }

    public static String deletion(long time) {
        if (time == 0L || time == Integer.MAX_VALUE) {
            return "no tombstones";
        }
        return SSTableMetadataViewer.toDateString(time, TimeUnit.SECONDS);
    }

    public static String toDateString(long time, TimeUnit unit) {
        if (time == 0L) {
            return null;
        }
        return new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(unit.toMillis(time)));
    }

    public static String toDurationString(long duration, TimeUnit unit) {
        if (duration == 0L) {
            return null;
        }
        if (duration == Integer.MAX_VALUE) {
            return "never";
        }
        return DurationFormatUtils.formatDurationWords((long)unit.toMillis(duration), (boolean)true, (boolean)true);
    }

    public static String toByteString(long bytes) {
        if (bytes == 0L) {
            return null;
        }
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        char pre = "kMGTP".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exp), Character.valueOf(pre));
    }

    public String scannedOverviewOutput(String key, long value) {
        StringBuilder sb = new StringBuilder();
        if (this.color) {
            sb.append("\u001b[36m");
        }
        sb.append('[');
        if (this.color) {
            sb.append("\u001b[0m");
        }
        sb.append(key);
        if (this.color) {
            sb.append("\u001b[36m");
        }
        sb.append("] ");
        if (this.color) {
            sb.append("\u001b[0m");
        }
        sb.append(value);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printScannedOverview(Descriptor descriptor, StatsMetadata stats) throws IOException {
        TableMetadata cfm = Util.metadataFromSSTable(descriptor);
        SSTableReader reader = SSTableReader.openNoValidation(descriptor, TableMetadataRef.forOfflineTools(cfm));
        try (ISSTableScanner scanner = reader.getScanner();){
            long bytes = scanner.getLengthInBytes();
            MinMaxPriorityQueue widestPartitions = MinMaxPriorityQueue.orderedBy(VCOMP).maximumSize(5).create();
            MinMaxPriorityQueue largestPartitions = MinMaxPriorityQueue.orderedBy(VCOMP).maximumSize(5).create();
            MinMaxPriorityQueue mostTombstones = MinMaxPriorityQueue.orderedBy(VCOMP).maximumSize(5).create();
            long partitionCount = 0L;
            long rowCount = 0L;
            long tombstoneCount = 0L;
            long cellCount = 0L;
            double totalCells = stats.totalColumnsSet;
            int lastPercent = 0;
            long lastPercentTime = 0L;
            while (scanner.hasNext()) {
                UnfilteredRowIterator partition = (UnfilteredRowIterator)scanner.next();
                Throwable throwable = null;
                try {
                    long psize = 0L;
                    long pcount = 0L;
                    int ptombcount = 0;
                    ++partitionCount;
                    if (!partition.staticRow().isEmpty()) {
                        ++rowCount;
                        ++pcount;
                        psize += (long)partition.staticRow().dataSize();
                    }
                    if (!partition.partitionLevelDeletion().isLive()) {
                        ++tombstoneCount;
                        ++ptombcount;
                    }
                    block26: while (partition.hasNext()) {
                        Unfiltered unfiltered = (Unfiltered)partition.next();
                        switch (unfiltered.kind()) {
                            case ROW: {
                                ++rowCount;
                                Row row = (Row)unfiltered;
                                psize += (long)row.dataSize();
                                ++pcount;
                                for (Cell cell : row.cells()) {
                                    double percentComplete;
                                    if (lastPercent != (int)((percentComplete = Math.min(1.0, (double)(++cellCount) / totalCells)) * 100.0) && System.currentTimeMillis() - lastPercentTime > 1000L) {
                                        lastPercentTime = System.currentTimeMillis();
                                        lastPercent = (int)(percentComplete * 100.0);
                                        if (this.color) {
                                            this.out.printf("\r%sAnalyzing SSTable...  %s%s %s(%%%s)", "\u001b[34m", "\u001b[36m", Util.progress(percentComplete, 30, this.unicode), "\u001b[0m", (int)(percentComplete * 100.0));
                                        } else {
                                            this.out.printf("\rAnalyzing SSTable...  %s (%%%s)", Util.progress(percentComplete, 30, this.unicode), (int)(percentComplete * 100.0));
                                        }
                                        this.out.flush();
                                    }
                                    if (!cell.isTombstone()) continue;
                                    ++tombstoneCount;
                                    ++ptombcount;
                                }
                                continue block26;
                            }
                            case RANGE_TOMBSTONE_MARKER: {
                                ++tombstoneCount;
                                ++ptombcount;
                            }
                        }
                    }
                    widestPartitions.add((Object)new ValuedByteBuffer(partition.partitionKey().getKey(), pcount));
                    largestPartitions.add((Object)new ValuedByteBuffer(partition.partitionKey().getKey(), psize));
                    mostTombstones.add((Object)new ValuedByteBuffer(partition.partitionKey().getKey(), ptombcount));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (partition == null) continue;
                    if (throwable != null) {
                        try {
                            partition.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    partition.close();
                }
            }
            this.out.printf("\r%80s\r", " ");
            this.field("Size", bytes);
            this.field("Partitions", partitionCount);
            this.field("Rows", rowCount);
            this.field("Tombstones", tombstoneCount);
            this.field("Cells", cellCount);
            this.field("Widest Partitions", "");
            Util.iterToStream(widestPartitions.iterator()).sorted(VCOMP).forEach(p -> this.out.println("  " + this.scannedOverviewOutput(cfm.partitionKeyType.getString(p.buffer), p.value)));
            this.field("Largest Partitions", "");
            Util.iterToStream(largestPartitions.iterator()).sorted(VCOMP).forEach(p -> {
                this.out.print("  ");
                this.out.print(this.scannedOverviewOutput(cfm.partitionKeyType.getString(p.buffer), p.value));
                if (this.color) {
                    this.out.print("\u001b[37m");
                }
                this.out.print(" (");
                this.out.print(SSTableMetadataViewer.toByteString(p.value));
                this.out.print(")");
                if (this.color) {
                    this.out.print("\u001b[0m");
                }
                this.out.println();
            });
            StringBuilder tleaders = new StringBuilder();
            Util.iterToStream(mostTombstones.iterator()).sorted(VCOMP).forEach(p -> {
                if (p.value > 0L) {
                    tleaders.append("  ");
                    tleaders.append(this.scannedOverviewOutput(cfm.partitionKeyType.getString(p.buffer), p.value));
                    tleaders.append(System.lineSeparator());
                }
            });
            String tombstoneLeaders = tleaders.toString();
            if (tombstoneLeaders.length() > 10) {
                this.field("Tombstone Leaders", "");
                this.out.print(tombstoneLeaders);
            }
        }
        finally {
            reader.selfRef().ensureReleased();
        }
    }

    private void printSStableMetadata(String fname, boolean scan) throws IOException {
        Descriptor descriptor = Descriptor.fromFilename(fname);
        Map<MetadataType, MetadataComponent> metadata = descriptor.getMetadataSerializer().deserialize(descriptor, EnumSet.allOf(MetadataType.class));
        ValidationMetadata validation = (ValidationMetadata)metadata.get((Object)MetadataType.VALIDATION);
        StatsMetadata stats = (StatsMetadata)metadata.get((Object)MetadataType.STATS);
        CompactionMetadata compaction = (CompactionMetadata)metadata.get((Object)MetadataType.COMPACTION);
        CompressionMetadata compression = null;
        File compressionFile = new File(descriptor.filenameFor(Component.COMPRESSION_INFO));
        if (compressionFile.exists()) {
            compression = CompressionMetadata.create(fname);
        }
        SerializationHeader.Component header = (SerializationHeader.Component)metadata.get((Object)MetadataType.HEADER);
        this.field("SSTable", descriptor);
        if (scan && descriptor.version.getVersion().compareTo("ma") >= 0) {
            this.printScannedOverview(descriptor, stats);
        }
        if (validation != null) {
            this.field("Partitioner", validation.partitioner);
            this.field("Bloom Filter FP chance", validation.bloomFilterFPChance);
        }
        if (stats != null) {
            this.field("Minimum timestamp", stats.minTimestamp, SSTableMetadataViewer.toDateString(stats.minTimestamp, this.tsUnit));
            this.field("Maximum timestamp", stats.maxTimestamp, SSTableMetadataViewer.toDateString(stats.maxTimestamp, this.tsUnit));
            this.field("SSTable min local deletion time", stats.minLocalDeletionTime, SSTableMetadataViewer.deletion(stats.minLocalDeletionTime));
            this.field("SSTable max local deletion time", stats.maxLocalDeletionTime, SSTableMetadataViewer.deletion(stats.maxLocalDeletionTime));
            this.field("Compressor", compression != null ? compression.compressor().getClass().getName() : "-");
            if (compression != null) {
                this.field("Compression ratio", stats.compressionRatio);
            }
            this.field("TTL min", stats.minTTL, SSTableMetadataViewer.toDurationString(stats.minTTL, TimeUnit.SECONDS));
            this.field("TTL max", stats.maxTTL, SSTableMetadataViewer.toDurationString(stats.maxTTL, TimeUnit.SECONDS));
            if (validation != null && header != null) {
                this.printMinMaxToken(descriptor, FBUtilities.newPartitioner(descriptor), header.getKeyType());
            }
            if (header != null && header.getClusteringTypes().size() == stats.minClusteringValues.size()) {
                List<AbstractType<?>> clusteringTypes = header.getClusteringTypes();
                List<ByteBuffer> minClusteringValues = stats.minClusteringValues;
                List<ByteBuffer> maxClusteringValues = stats.maxClusteringValues;
                Object[] minValues = new String[clusteringTypes.size()];
                Object[] maxValues = new String[clusteringTypes.size()];
                for (int i = 0; i < clusteringTypes.size(); ++i) {
                    minValues[i] = clusteringTypes.get(i).getString(minClusteringValues.get(i));
                    maxValues[i] = clusteringTypes.get(i).getString(maxClusteringValues.get(i));
                }
                this.field("minClusteringValues", Arrays.toString(minValues));
                this.field("maxClusteringValues", Arrays.toString(maxValues));
            }
            this.field("Estimated droppable tombstones", stats.getEstimatedDroppableTombstoneRatio((int)(System.currentTimeMillis() / 1000L) - this.gc));
            this.field("SSTable Level", stats.sstableLevel);
            this.field("Repaired at", stats.repairedAt, SSTableMetadataViewer.toDateString(stats.repairedAt, TimeUnit.MILLISECONDS));
            this.field("Pending repair", stats.pendingRepair);
            this.field("Replay positions covered", stats.commitLogIntervals);
            this.field("totalColumnsSet", stats.totalColumnsSet);
            this.field("totalRows", stats.totalRows);
            this.field("Estimated tombstone drop times", "");
            Util.TermHistogram estDropped = new Util.TermHistogram(stats.estimatedTombstoneDropTime, "Drop Time", offset -> String.format("%d %s", offset, Util.wrapQuiet(SSTableMetadataViewer.toDateString(offset, TimeUnit.SECONDS), this.color)), String::valueOf);
            estDropped.printHistogram(this.out, this.color, this.unicode);
            this.field("Partition Size", "");
            Util.TermHistogram rowSize = new Util.TermHistogram(stats.estimatedPartitionSize, "Size (bytes)", offset -> String.format("%d %s", offset, Util.wrapQuiet(SSTableMetadataViewer.toByteString(offset), this.color)), String::valueOf);
            rowSize.printHistogram(this.out, this.color, this.unicode);
            this.field("Column Count", "");
            Util.TermHistogram cellCount = new Util.TermHistogram(stats.estimatedCellPerPartitionCount, "Columns", String::valueOf, String::valueOf);
            cellCount.printHistogram(this.out, this.color, this.unicode);
        }
        if (compaction != null) {
            this.field("Estimated cardinality", compaction.cardinalityEstimator.cardinality());
        }
        if (header != null) {
            EncodingStats encodingStats = header.getEncodingStats();
            AbstractType<?> keyType = header.getKeyType();
            List<AbstractType<?>> clusteringTypes = header.getClusteringTypes();
            Map<ByteBuffer, AbstractType<?>> staticColumns = header.getStaticColumns();
            Map<String, String> statics = staticColumns.entrySet().stream().collect(Collectors.toMap(e -> UTF8Type.instance.getString((ByteBuffer)e.getKey()), e -> ((AbstractType)e.getValue()).toString()));
            Map<ByteBuffer, AbstractType<?>> regularColumns = header.getRegularColumns();
            Map<String, String> regulars = regularColumns.entrySet().stream().collect(Collectors.toMap(e -> UTF8Type.instance.getString((ByteBuffer)e.getKey()), e -> ((AbstractType)e.getValue()).toString()));
            this.field("EncodingStats minTTL", encodingStats.minTTL, SSTableMetadataViewer.toDurationString(encodingStats.minTTL, TimeUnit.SECONDS));
            this.field("EncodingStats minLocalDeletionTime", encodingStats.minLocalDeletionTime, SSTableMetadataViewer.toDateString(encodingStats.minLocalDeletionTime, TimeUnit.SECONDS));
            this.field("EncodingStats minTimestamp", encodingStats.minTimestamp, SSTableMetadataViewer.toDateString(encodingStats.minTimestamp, this.tsUnit));
            this.field("KeyType", keyType.toString());
            this.field("ClusteringTypes", clusteringTypes.toString());
            this.field("StaticColumns", FBUtilities.toString(statics));
            this.field("RegularColumns", FBUtilities.toString(regulars));
        }
    }

    private void field(String field, Object value) {
        this.field(field, value, null);
    }

    private void field(String field, Object value, String comment) {
        StringBuilder sb = new StringBuilder();
        if (this.color) {
            sb.append("\u001b[34m");
        }
        sb.append(field);
        if (this.color) {
            sb.append("\u001b[36m");
        }
        sb.append(": ");
        if (this.color) {
            sb.append("\u001b[0m");
        }
        sb.append(value == null ? "--" : value.toString());
        if (comment != null) {
            if (this.color) {
                sb.append("\u001b[37m");
            }
            sb.append(" (");
            sb.append(comment);
            sb.append(")");
            if (this.color) {
                sb.append("\u001b[0m");
            }
        }
        this.out.println(sb.toString());
    }

    private static void printUsage() {
        try (PrintWriter errWriter = new PrintWriter(System.err, true);){
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(errWriter, 120, "sstablemetadata <options> <sstable...>", String.format("%nDump information about SSTable[s] for Apache Cassandra 3.x%nOptions:", new Object[0]), options, 2, 1, "", true);
            errWriter.println();
        }
    }

    private void printMinMaxToken(Descriptor descriptor, IPartitioner partitioner, AbstractType<?> keyType) throws IOException {
        File summariesFile = new File(descriptor.filenameFor(Component.SUMMARY));
        if (!summariesFile.exists()) {
            return;
        }
        try (DataInputStream iStream = new DataInputStream(Files.newInputStream(summariesFile.toPath(), new OpenOption[0]));){
            Pair<DecoratedKey, DecoratedKey> firstLast = new IndexSummary.IndexSummarySerializer().deserializeFirstLastKey(iStream, partitioner);
            this.field("First token", ((DecoratedKey)firstLast.left).getToken(), keyType.getString(((DecoratedKey)firstLast.left).getKey()));
            this.field("Last token", ((DecoratedKey)firstLast.right).getToken(), keyType.getString(((DecoratedKey)firstLast.right).getKey()));
        }
    }

    public static void main(String[] args) throws IOException {
        PosixParser parser = new PosixParser();
        Option disableColors = new Option(COLORS, "colors", false, "Use ANSI color sequences");
        disableColors.setOptionalArg(true);
        options.addOption(disableColors);
        Option unicode = new Option(UNICODE, "unicode", false, "Use unicode to draw histograms and progress bars");
        unicode.setOptionalArg(true);
        options.addOption(unicode);
        Option gcgs = new Option(GCGS_KEY, "gc_grace_seconds", true, "Time to use when calculating droppable tombstones");
        gcgs.setOptionalArg(true);
        options.addOption(gcgs);
        Option tsUnit = new Option(TIMESTAMP_UNIT, "timestamp_unit", true, "Time unit that cell timestamps are written with");
        tsUnit.setOptionalArg(true);
        options.addOption(tsUnit);
        Option scanEnabled = new Option(SCAN, "scan", false, "Full sstable scan for additional details. Only available in 3.0+ sstables. Defaults: false");
        scanEnabled.setOptionalArg(true);
        options.addOption(scanEnabled);
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.err.println(e1.getMessage());
            SSTableMetadataViewer.printUsage();
            System.exit(1);
        }
        if (cmd.getArgs().length < 1) {
            System.err.println("You must supply at least one sstable");
            SSTableMetadataViewer.printUsage();
            System.exit(1);
        }
        boolean enabledColors = cmd.hasOption(COLORS);
        boolean enabledUnicode = cmd.hasOption(UNICODE);
        boolean fullScan = cmd.hasOption(SCAN);
        int gc = Integer.parseInt(cmd.getOptionValue(GCGS_KEY, "0"));
        TimeUnit ts = TimeUnit.valueOf(cmd.getOptionValue(TIMESTAMP_UNIT, "MICROSECONDS"));
        SSTableMetadataViewer metawriter = new SSTableMetadataViewer(enabledColors, enabledUnicode, gc, ts, System.out);
        for (String fname : cmd.getArgs()) {
            File sstable = new File(fname);
            if (sstable.exists()) {
                metawriter.printSStableMetadata(sstable.getAbsolutePath(), fullScan);
                continue;
            }
            System.out.println("No such file: " + fname);
        }
    }

    static {
        VCOMP = Comparator.comparingLong(ValuedByteBuffer::getValue).reversed();
        DatabaseDescriptor.clientInitialization();
    }

    private static class ValuedByteBuffer {
        public long value;
        public ByteBuffer buffer;

        public ValuedByteBuffer(ByteBuffer buffer, long value) {
            this.value = value;
            this.buffer = buffer;
        }

        public long getValue() {
            return this.value;
        }
    }
}

