/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.RequestCallbacks;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseVerbHandler
implements IVerbHandler {
    public static final ResponseVerbHandler instance = new ResponseVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(ResponseVerbHandler.class);

    ResponseVerbHandler() {
    }

    public void doVerb(Message message) {
        RequestCallbacks.CallbackInfo callbackInfo = MessagingService.instance().callbacks.remove(message.id(), message.from());
        if (callbackInfo == null) {
            String msg = "Callback already removed for {} (from {})";
            logger.trace(msg, (Object)message.id(), (Object)message.from());
            Tracing.trace(msg, (Object)message.id(), (Object)message.from());
            return;
        }
        long latencyNanos = MonotonicClock.approxTime.now() - callbackInfo.createdAtNanos;
        Tracing.trace("Processing response from {}", (Object)message.from());
        RequestCallback cb = callbackInfo.callback;
        if (message.isFailureResponse()) {
            cb.onFailure(message.from(), (RequestFailureReason)((Object)message.payload));
        } else {
            MessagingService.instance().latencySubscribers.maybeAdd(cb, message.from(), latencyNanos, TimeUnit.NANOSECONDS);
            cb.onResponse(message);
        }
        if (callbackInfo.callback.supportsBackPressure()) {
            MessagingService.instance().updateBackPressureOnReceive(message.from(), cb, false);
        }
    }
}

