/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.FrozenType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.serializers.UserTypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class UserType
extends TupleType {
    public final String keyspace;
    public final ByteBuffer name;
    private final List<FieldIdentifier> fieldNames;
    private final List<String> stringFieldNames;
    private final boolean isMultiCell;
    private final UserTypeSerializer serializer;

    public UserType(String keyspace, ByteBuffer name, List<FieldIdentifier> fieldNames, List<AbstractType<?>> fieldTypes, boolean isMultiCell) {
        super(fieldTypes, false);
        assert (fieldNames.size() == fieldTypes.size());
        this.keyspace = keyspace;
        this.name = name;
        this.fieldNames = fieldNames;
        this.stringFieldNames = new ArrayList<String>(fieldNames.size());
        this.isMultiCell = isMultiCell;
        LinkedHashMap fieldSerializers = new LinkedHashMap(fieldTypes.size());
        int m = fieldNames.size();
        for (int i = 0; i < m; ++i) {
            String stringFieldName = fieldNames.get(i).toString();
            this.stringFieldNames.add(stringFieldName);
            fieldSerializers.put(stringFieldName, fieldTypes.get(i).getSerializer());
        }
        this.serializer = new UserTypeSerializer(fieldSerializers);
    }

    public static UserType getInstance(TypeParser parser) {
        Pair<Pair<String, ByteBuffer>, List<Pair<ByteBuffer, AbstractType>>> params = parser.getUserTypeParameters();
        String keyspace = (String)((Pair)params.left).left;
        ByteBuffer name = (ByteBuffer)((Pair)params.left).right;
        ArrayList<FieldIdentifier> columnNames = new ArrayList<FieldIdentifier>(((List)params.right).size());
        ArrayList columnTypes = new ArrayList(((List)params.right).size());
        for (Pair p : (List)params.right) {
            columnNames.add(new FieldIdentifier((ByteBuffer)p.left));
            columnTypes.add((AbstractType<?>)p.right);
        }
        return new UserType(keyspace, name, columnNames, columnTypes, true);
    }

    @Override
    public boolean isUDT() {
        return true;
    }

    @Override
    public boolean isTuple() {
        return false;
    }

    @Override
    public boolean isMultiCell() {
        return this.isMultiCell;
    }

    @Override
    public boolean isFreezable() {
        return true;
    }

    public AbstractType<?> fieldType(int i) {
        return this.type(i);
    }

    public List<AbstractType<?>> fieldTypes() {
        return this.types;
    }

    public FieldIdentifier fieldName(int i) {
        return this.fieldNames.get(i);
    }

    public String fieldNameAsString(int i) {
        return this.stringFieldNames.get(i);
    }

    public List<FieldIdentifier> fieldNames() {
        return this.fieldNames;
    }

    public String getNameAsString() {
        return (String)UTF8Type.instance.compose(this.name);
    }

    public int fieldPosition(FieldIdentifier fieldName) {
        return this.fieldNames.indexOf(fieldName);
    }

    public CellPath cellPathForField(FieldIdentifier fieldName) {
        return CellPath.create(ByteBufferUtil.bytes((short)this.fieldPosition(fieldName)));
    }

    public ShortType nameComparator() {
        return ShortType.instance;
    }

    public ByteBuffer serializeForNativeProtocol(Iterator<Cell> cells, ProtocolVersion protocolVersion) {
        assert (this.isMultiCell);
        ByteBuffer[] components = new ByteBuffer[this.size()];
        int fieldPosition = 0;
        while (cells.hasNext()) {
            Cell cell = cells.next();
            short fieldPositionOfCell = ByteBufferUtil.toShort(cell.path().get(0));
            while (fieldPosition < fieldPositionOfCell) {
                int n = fieldPosition;
                fieldPosition = (short)(fieldPosition + 1);
                components[n] = null;
            }
            int n = fieldPosition;
            fieldPosition = (short)(fieldPosition + 1);
            components[n] = cell.value();
        }
        while (fieldPosition < this.size()) {
            int n = fieldPosition;
            fieldPosition = (short)(fieldPosition + 1);
            components[n] = null;
        }
        return TupleType.buildValue(components);
    }

    public void validateCell(Cell cell) throws MarshalException {
        if (this.isMultiCell) {
            ByteBuffer path = cell.path().get(0);
            this.nameComparator().validate(path);
            Short fieldPosition = this.nameComparator().getSerializer().deserialize(path);
            this.fieldType(fieldPosition.shortValue()).validate(cell.value());
        } else {
            this.validate(cell.value());
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = Json.decodeJson((String)parsed);
        }
        if (!(parsed instanceof Map)) {
            throw new MarshalException(String.format("Expected a map, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        Map map = (Map)parsed;
        Json.handleCaseSensitivity(map);
        ArrayList<Term> terms = new ArrayList<Term>(this.types.size());
        Set keys = map.keySet();
        assert (keys.isEmpty() || keys.iterator().next() instanceof String);
        int foundValues = 0;
        for (int i = 0; i < this.types.size(); ++i) {
            Object value = map.get(this.stringFieldNames.get(i));
            if (value == null) {
                terms.add(Constants.NULL_VALUE);
                continue;
            }
            terms.add(((AbstractType)this.types.get(i)).fromJSONObject(value));
            ++foundValues;
        }
        if (foundValues != map.size()) {
            for (Object fieldName : keys) {
                if (this.stringFieldNames.contains(fieldName)) continue;
                throw new MarshalException(String.format("Unknown field '%s' in value of user defined type %s", fieldName, this.getNameAsString()));
            }
        }
        return new UserTypes.DelayedValue(this, terms);
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        ByteBuffer[] buffers = this.split(buffer);
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.types.size(); ++i) {
            ByteBuffer valueBuffer;
            String name;
            if (i > 0) {
                sb.append(", ");
            }
            if (!(name = this.stringFieldNames.get(i)).equals(name.toLowerCase(Locale.US))) {
                name = "\"" + name + "\"";
            }
            sb.append('\"');
            sb.append(Json.quoteAsJsonString(name));
            sb.append("\": ");
            ByteBuffer byteBuffer = valueBuffer = i >= buffers.length ? null : buffers[i];
            if (valueBuffer == null) {
                sb.append("null");
                continue;
            }
            sb.append(((AbstractType)this.types.get(i)).toJSONString(valueBuffer, protocolVersion));
        }
        return sb.append("}").toString();
    }

    public UserType freeze() {
        if (this.isMultiCell) {
            return new UserType(this.keyspace, this.name, this.fieldNames, this.fieldTypes(), false);
        }
        return this;
    }

    @Override
    public AbstractType<?> freezeNestedMulticellTypes() {
        if (!this.isMultiCell()) {
            return this;
        }
        List<AbstractType<?>> newTypes = this.fieldTypes().stream().map(subtype -> subtype.isFreezable() && subtype.isMultiCell() ? subtype.freeze() : subtype).collect(Collectors.toList());
        return new UserType(this.keyspace, this.name, this.fieldNames, newTypes, this.isMultiCell);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyspace, this.name, this.fieldNames, this.types, this.isMultiCell});
    }

    @Override
    public boolean isValueCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof UserType)) {
            return false;
        }
        UserType other = (UserType)previous;
        if (this.isMultiCell != other.isMultiCell()) {
            return false;
        }
        if (!this.keyspace.equals(other.keyspace)) {
            return false;
        }
        Iterator thisTypeIter = this.types.iterator();
        Iterator previousTypeIter = other.types.iterator();
        while (thisTypeIter.hasNext() && previousTypeIter.hasNext()) {
            if (((AbstractType)thisTypeIter.next()).isCompatibleWith((AbstractType)previousTypeIter.next())) continue;
            return false;
        }
        return !previousTypeIter.hasNext();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UserType)) {
            return false;
        }
        UserType that = (UserType)o;
        return this.equalsWithoutTypes(that) && this.types.equals(that.types);
    }

    private boolean equalsWithoutTypes(UserType other) {
        return this.name.equals(other.name) && this.fieldNames.equals(other.fieldNames) && this.keyspace.equals(other.keyspace) && this.isMultiCell == other.isMultiCell;
    }

    public Optional<Difference> compare(UserType other) {
        if (!this.equalsWithoutTypes(other)) {
            return Optional.of(Difference.SHALLOW);
        }
        boolean differsDeeply = false;
        for (int i = 0; i < this.fieldTypes().size(); ++i) {
            AbstractType<?> thatType;
            AbstractType<?> thisType = this.fieldType(i);
            if (thisType.equals(thatType = other.fieldType(i))) continue;
            if (thisType.asCQL3Type().toString().equals(thatType.asCQL3Type().toString())) {
                differsDeeply = true;
                continue;
            }
            return Optional.of(Difference.SHALLOW);
        }
        return differsDeeply ? Optional.of(Difference.DEEP) : Optional.empty();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.UserDefined.create(this);
    }

    @Override
    public boolean referencesUserType(ByteBuffer name) {
        return this.name.equals(name) || Iterables.any(this.fieldTypes(), t -> t.referencesUserType(name));
    }

    @Override
    public UserType withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        if (this.name.equals(udt.name)) {
            return this.isMultiCell == udt.isMultiCell ? udt : new UserType(this.keyspace, this.name, udt.fieldNames(), udt.fieldTypes(), this.isMultiCell);
        }
        return new UserType(this.keyspace, this.name, this.fieldNames, Lists.newArrayList((Iterable)Iterables.transform(this.fieldTypes(), t -> t.withUpdatedUserType(udt))), this.isMultiCell());
    }

    @Override
    public boolean referencesDuration() {
        return this.fieldTypes().stream().anyMatch(f -> f.referencesDuration());
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean ignoreFreezing) {
        boolean includeFrozenType = !ignoreFreezing && !this.isMultiCell();
        StringBuilder sb = new StringBuilder();
        if (includeFrozenType) {
            sb.append(FrozenType.class.getName()).append("(");
        }
        sb.append(this.getClass().getName());
        sb.append(TypeParser.stringifyUserTypeParameters(this.keyspace, this.name, this.fieldNames, this.types, ignoreFreezing || !this.isMultiCell));
        if (includeFrozenType) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String toCQLString() {
        return String.format("%s.%s", ColumnIdentifier.maybeQuote(this.keyspace), ColumnIdentifier.maybeQuote(this.getNameAsString()));
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return this.serializer;
    }
}

