/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.LongPredicate;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.AbstractReadQuery;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.db.partitions.PurgeFunction;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.RTBoundCloser;
import org.apache.cassandra.db.transform.RTBoundValidator;
import org.apache.cassandra.db.transform.StoppingTransformation;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.exceptions.UnknownIndexException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexNotAvailableException;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageFlag;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadCommand
extends AbstractReadQuery {
    private static final int TEST_ITERATION_DELAY_MILLIS = Integer.parseInt(System.getProperty("cassandra.test.read_iteration_delay_ms", "0"));
    protected static final Logger logger = LoggerFactory.getLogger(ReadCommand.class);
    public static final IVersionedSerializer<ReadCommand> serializer = new Serializer();
    private final Kind kind;
    private final boolean isDigestQuery;
    private final boolean acceptsTransient;
    private int digestVersion;
    private boolean trackRepairedStatus = false;
    private static final RepairedDataInfo NULL_REPAIRED_DATA_INFO = new RepairedDataInfo(){

        @Override
        void trackPartitionKey(DecoratedKey key) {
        }

        @Override
        void trackDeletion(DeletionTime deletion) {
        }

        @Override
        void trackRangeTombstoneMarker(RangeTombstoneMarker marker) {
        }

        @Override
        void trackRow(Row row) {
        }

        @Override
        boolean isConclusive() {
            return true;
        }

        @Override
        ByteBuffer getDigest() {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
    };
    private RepairedDataInfo repairedDataInfo = NULL_REPAIRED_DATA_INFO;
    int oldestUnrepairedTombstone = Integer.MAX_VALUE;
    @Nullable
    private final IndexMetadata index;

    protected ReadCommand(Kind kind, boolean isDigestQuery, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, IndexMetadata index) {
        super(metadata, nowInSec, columnFilter, rowFilter, limits);
        if (acceptsTransient && isDigestQuery) {
            throw new IllegalArgumentException("Attempted to issue a digest response to transient replica");
        }
        this.kind = kind;
        this.isDigestQuery = isDigestQuery;
        this.digestVersion = digestVersion;
        this.acceptsTransient = acceptsTransient;
        this.index = index;
    }

    protected abstract void serializeSelection(DataOutputPlus var1, int var2) throws IOException;

    protected abstract long selectionSerializedSize(int var1);

    public abstract boolean isLimitedToOnePartition();

    public abstract boolean isRangeRequest();

    public abstract ReadCommand withUpdatedLimit(DataLimits var1);

    public abstract long getTimeout(TimeUnit var1);

    public boolean isDigestQuery() {
        return this.isDigestQuery;
    }

    public int digestVersion() {
        return this.digestVersion;
    }

    public ReadCommand setDigestVersion(int digestVersion) {
        this.digestVersion = digestVersion;
        return this;
    }

    public boolean acceptsTransient() {
        return this.acceptsTransient;
    }

    public void trackRepairedStatus() {
        this.trackRepairedStatus = true;
    }

    public boolean isTrackingRepairedStatus() {
        return this.trackRepairedStatus;
    }

    public ByteBuffer getRepairedDataDigest() {
        return this.repairedDataInfo.getDigest();
    }

    public boolean isRepairedDataDigestConclusive() {
        return this.repairedDataInfo.isConclusive();
    }

    @Nullable
    public IndexMetadata indexMetadata() {
        return this.index;
    }

    public abstract ClusteringIndexFilter clusteringIndexFilter(DecoratedKey var1);

    public abstract ReadCommand copy();

    public ReadCommand copyAsTransientQuery(Replica replica) {
        Preconditions.checkArgument((boolean)replica.isTransient(), (Object)("Can't make a transient request on a full replica: " + replica));
        return this.copyAsTransientQuery();
    }

    public ReadCommand copyAsTransientQuery(Iterable<Replica> replicas) {
        if (Iterables.any(replicas, Replica::isFull)) {
            throw new IllegalArgumentException("Can't make a transient request on full replicas: " + Iterables.toString((Iterable)Iterables.filter(replicas, Replica::isFull)));
        }
        return this.copyAsTransientQuery();
    }

    protected abstract ReadCommand copyAsTransientQuery();

    public ReadCommand copyAsDigestQuery(Replica replica) {
        Preconditions.checkArgument((boolean)replica.isFull(), (Object)("Can't make a digest request on a transient replica " + replica));
        return this.copyAsDigestQuery();
    }

    public ReadCommand copyAsDigestQuery(Iterable<Replica> replicas) {
        if (Iterables.any(replicas, Replica::isTransient)) {
            throw new IllegalArgumentException("Can't make a digest request on a transient replica " + Iterables.toString((Iterable)Iterables.filter(replicas, Replica::isTransient)));
        }
        return this.copyAsDigestQuery();
    }

    protected abstract ReadCommand copyAsDigestQuery();

    protected abstract UnfilteredPartitionIterator queryStorage(ColumnFamilyStore var1, ReadExecutionController var2);

    protected int oldestUnrepairedTombstone() {
        return this.oldestUnrepairedTombstone;
    }

    public ReadResponse createResponse(UnfilteredPartitionIterator iterator) {
        iterator = RTBoundValidator.validate(iterator, RTBoundValidator.Stage.PROCESSED, true);
        return this.isDigestQuery() ? ReadResponse.createDigestResponse(iterator, this) : ReadResponse.createDataResponse(iterator, this);
    }

    long indexSerializedSize(int version) {
        return null != this.index ? IndexMetadata.serializer.serializedSize(this.index, version) : 0L;
    }

    public Index getIndex(ColumnFamilyStore cfs) {
        return null != this.index ? cfs.indexManager.getIndex(this.index) : null;
    }

    static IndexMetadata findIndex(TableMetadata table, RowFilter rowFilter) {
        if (table.indexes.isEmpty() || rowFilter.isEmpty()) {
            return null;
        }
        ColumnFamilyStore cfs = Keyspace.openAndGetStore(table);
        Index index = cfs.indexManager.getBestIndexFor(rowFilter);
        return null != index ? index.getIndexMetadata() : null;
    }

    @Override
    public void maybeValidateIndex() {
        if (null != this.index) {
            IndexRegistry.obtain(this.metadata()).getIndex(this.index).validate(this);
        }
    }

    @Override
    public UnfilteredPartitionIterator executeLocally(ReadExecutionController executionController) {
        long startTimeNanos = System.nanoTime();
        ColumnFamilyStore cfs = Keyspace.openAndGetStore(this.metadata());
        Index index = this.getIndex(cfs);
        Index.Searcher searcher = null;
        if (index != null) {
            if (!cfs.indexManager.isIndexQueryable(index)) {
                throw new IndexNotAvailableException(index);
            }
            searcher = index.searcherFor(this);
            Tracing.trace("Executing read on {}.{} using index {}", cfs.metadata.keyspace, cfs.metadata.name, index.getIndexMetadata().name);
        }
        if (this.isTrackingRepairedStatus()) {
            this.repairedDataInfo = new RepairedDataInfo();
        }
        UnfilteredPartitionIterator iterator = null == searcher ? this.queryStorage(cfs, executionController) : searcher.search(executionController);
        iterator = RTBoundValidator.validate(iterator, RTBoundValidator.Stage.MERGED, false);
        try {
            iterator = this.withStateTracking(iterator);
            iterator = RTBoundValidator.validate(this.withoutPurgeableTombstones(iterator, cfs), RTBoundValidator.Stage.PURGED, false);
            iterator = this.withMetricsRecording(iterator, cfs.metric, startTimeNanos);
            RowFilter filter = null == searcher ? this.rowFilter() : index.getPostIndexQueryFilter(this.rowFilter());
            iterator = filter.filter(iterator, this.nowInSec());
            iterator = this.limits().filter(iterator, this.nowInSec(), this.selectsFullPartition());
            return RTBoundCloser.close(iterator);
        }
        catch (Error | RuntimeException e) {
            iterator.close();
            throw e;
        }
    }

    protected abstract void recordLatency(TableMetrics var1, long var2);

    @Override
    public ReadExecutionController executionController() {
        return ReadExecutionController.forCommand(this);
    }

    private UnfilteredPartitionIterator withMetricsRecording(UnfilteredPartitionIterator iter, final TableMetrics metric, final long startTimeNanos) {
        class MetricRecording
        extends Transformation<UnfilteredRowIterator> {
            private final int failureThreshold = DatabaseDescriptor.getTombstoneFailureThreshold();
            private final int warningThreshold = DatabaseDescriptor.getTombstoneWarnThreshold();
            private final boolean respectTombstoneThresholds;
            private final boolean enforceStrictLiveness;
            private int liveRows;
            private int tombstones;
            private DecoratedKey currentKey;

            MetricRecording() {
                this.respectTombstoneThresholds = !SchemaConstants.isLocalSystemKeyspace(ReadCommand.this.metadata().keyspace);
                this.enforceStrictLiveness = ReadCommand.this.metadata().enforceStrictLiveness();
                this.liveRows = 0;
                this.tombstones = 0;
            }

            @Override
            public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator iter) {
                this.currentKey = iter.partitionKey();
                return Transformation.apply(iter, this);
            }

            @Override
            public Row applyToStatic(Row row) {
                return this.applyToRow(row);
            }

            @Override
            public Row applyToRow(Row row) {
                boolean hasTombstones = false;
                for (Cell cell : row.cells()) {
                    if (cell.isLive(ReadCommand.this.nowInSec())) continue;
                    this.countTombstone(row.clustering());
                    hasTombstones = true;
                }
                if (row.hasLiveData(ReadCommand.this.nowInSec(), this.enforceStrictLiveness)) {
                    ++this.liveRows;
                } else if (!row.primaryKeyLivenessInfo().isLive(ReadCommand.this.nowInSec()) && row.hasDeletion(ReadCommand.this.nowInSec()) && !hasTombstones) {
                    this.countTombstone(row.clustering());
                }
                return row;
            }

            @Override
            public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
                this.countTombstone(marker.clustering());
                return marker;
            }

            private void countTombstone(ClusteringPrefix clustering) {
                ++this.tombstones;
                if (this.tombstones > this.failureThreshold && this.respectTombstoneThresholds) {
                    String query = ReadCommand.this.toCQLString();
                    Tracing.trace("Scanned over {} tombstones for query {}; query aborted (see tombstone_failure_threshold)", (Object)this.failureThreshold, (Object)query);
                    metric.tombstoneFailures.inc();
                    throw new TombstoneOverwhelmingException(this.tombstones, query, ReadCommand.this.metadata(), this.currentKey, clustering);
                }
            }

            @Override
            public void onClose() {
                boolean warnTombstones;
                ReadCommand.this.recordLatency(metric, System.nanoTime() - startTimeNanos);
                metric.tombstoneScannedHistogram.update(this.tombstones);
                metric.liveScannedHistogram.update(this.liveRows);
                boolean bl = warnTombstones = this.tombstones > this.warningThreshold && this.respectTombstoneThresholds;
                if (warnTombstones) {
                    String msg = String.format("Read %d live rows and %d tombstone cells for query %1.512s (see tombstone_warn_threshold)", this.liveRows, this.tombstones, ReadCommand.this.toCQLString());
                    ClientWarn.instance.warn(msg);
                    if (this.tombstones < this.failureThreshold) {
                        metric.tombstoneWarnings.inc();
                    }
                    logger.warn(msg);
                }
                Tracing.trace("Read {} live rows and {} tombstone cells{}", this.liveRows, this.tombstones, warnTombstones ? " (see tombstone_warn_threshold)" : "");
            }
        }
        return Transformation.apply(iter, new MetricRecording());
    }

    protected UnfilteredPartitionIterator withStateTracking(UnfilteredPartitionIterator iter) {
        return Transformation.apply(iter, new CheckForAbort());
    }

    public Message<ReadCommand> createMessage(boolean trackRepairedData) {
        return trackRepairedData ? Message.outWithFlags(this.verb(), this, MessageFlag.CALL_BACK_ON_FAILURE, MessageFlag.TRACK_REPAIRED_DATA) : Message.outWithFlag(this.verb(), this, MessageFlag.CALL_BACK_ON_FAILURE);
    }

    public abstract Verb verb();

    @Override
    protected abstract void appendCQLWhereClause(StringBuilder var1);

    protected UnfilteredPartitionIterator withoutPurgeableTombstones(final UnfilteredPartitionIterator iterator, final ColumnFamilyStore cfs) {
        class WithoutPurgeableTombstones
        extends PurgeFunction {
            public WithoutPurgeableTombstones() {
                super(ReadCommand.this.nowInSec(), columnFamilyStore.gcBefore(ReadCommand.this.nowInSec()), ReadCommand.this.oldestUnrepairedTombstone(), columnFamilyStore.getCompactionStrategyManager().onlyPurgeRepairedTombstones(), unfilteredPartitionIterator.metadata().enforceStrictLiveness());
            }

            @Override
            protected LongPredicate getPurgeEvaluator() {
                return time -> true;
            }
        }
        return Transformation.apply(iterator, new WithoutPurgeableTombstones());
    }

    @Override
    public String toCQLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(this.columnFilter());
        sb.append(" FROM ").append(this.metadata().keyspace).append('.').append(this.metadata().name);
        this.appendCQLWhereClause(sb);
        if (this.limits() != DataLimits.NONE) {
            sb.append(' ').append(this.limits());
        }
        return sb.toString();
    }

    @Override
    public String name() {
        return this.toCQLString();
    }

    private static UnfilteredPartitionIterator withRepairedDataInfo(UnfilteredPartitionIterator iterator, RepairedDataInfo repairedDataInfo) {
        class WithRepairedDataTracking
        extends Transformation<UnfilteredRowIterator> {
            final /* synthetic */ RepairedDataInfo val$repairedDataInfo;

            WithRepairedDataTracking(RepairedDataInfo repairedDataInfo) {
                this.val$repairedDataInfo = repairedDataInfo;
            }

            @Override
            protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
                return ReadCommand.withRepairedDataInfo(partition, this.val$repairedDataInfo);
            }
        }
        return Transformation.apply(iterator, new WithRepairedDataTracking(repairedDataInfo));
    }

    private static UnfilteredRowIterator withRepairedDataInfo(final UnfilteredRowIterator iterator, final RepairedDataInfo repairedDataInfo) {
        class WithTracking
        extends Transformation {
            WithTracking() {
            }

            @Override
            protected DecoratedKey applyToPartitionKey(DecoratedKey key) {
                repairedDataInfo.onNewPartition(iterator);
                repairedDataInfo.trackPartitionKey(key);
                return key;
            }

            @Override
            protected DeletionTime applyToDeletion(DeletionTime deletionTime) {
                repairedDataInfo.trackDeletion(deletionTime);
                return deletionTime;
            }

            @Override
            protected RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
                repairedDataInfo.trackRangeTombstoneMarker(marker);
                return marker;
            }

            @Override
            protected Row applyToStatic(Row row) {
                repairedDataInfo.trackStaticRow(row);
                return row;
            }

            @Override
            protected Row applyToRow(Row row) {
                repairedDataInfo.trackRow(row);
                return row;
            }

            @Override
            protected void onPartitionClose() {
                repairedDataInfo.onPartitionClose();
            }
        }
        return Transformation.apply(iterator, new WithTracking());
    }

    InputCollector<UnfilteredRowIterator> iteratorsForPartition(ColumnFamilyStore.ViewFragment view) {
        BiFunction<List, RepairedDataInfo, UnfilteredRowIterator> merge = (unfilteredRowIterators, repairedDataInfo) -> ReadCommand.withRepairedDataInfo(UnfilteredRowIterators.merge(unfilteredRowIterators), repairedDataInfo);
        return new InputCollector<UnfilteredRowIterator>(view, this.repairedDataInfo, merge, this.isTrackingRepairedStatus());
    }

    InputCollector<UnfilteredPartitionIterator> iteratorsForRange(ColumnFamilyStore.ViewFragment view) {
        BiFunction<List, RepairedDataInfo, UnfilteredPartitionIterator> merge = (unfilteredPartitionIterators, repairedDataInfo) -> ReadCommand.withRepairedDataInfo(UnfilteredPartitionIterators.merge(unfilteredPartitionIterators, UnfilteredPartitionIterators.MergeListener.NOOP), repairedDataInfo);
        return new InputCollector<UnfilteredPartitionIterator>(view, this.repairedDataInfo, merge, this.isTrackingRepairedStatus());
    }

    private static class Serializer
    implements IVersionedSerializer<ReadCommand> {
        private Serializer() {
        }

        private static int digestFlag(boolean isDigest) {
            return isDigest ? 1 : 0;
        }

        private static boolean isDigest(int flags) {
            return (flags & 1) != 0;
        }

        private static boolean acceptsTransient(int flags) {
            return (flags & 8) != 0;
        }

        private static int acceptsTransientFlag(boolean acceptsTransient) {
            return acceptsTransient ? 8 : 0;
        }

        private static boolean isForThrift(int flags) {
            return (flags & 2) != 0;
        }

        private static int indexFlag(boolean hasIndex) {
            return hasIndex ? 4 : 0;
        }

        private static boolean hasIndex(int flags) {
            return (flags & 4) != 0;
        }

        @Override
        public void serialize(ReadCommand command, DataOutputPlus out, int version) throws IOException {
            out.writeByte(command.kind.ordinal());
            out.writeByte(Serializer.digestFlag(command.isDigestQuery()) | Serializer.indexFlag(null != command.indexMetadata()) | Serializer.acceptsTransientFlag(command.acceptsTransient()));
            if (command.isDigestQuery()) {
                out.writeUnsignedVInt(command.digestVersion());
            }
            command.metadata().id.serialize(out);
            out.writeInt(command.nowInSec());
            ColumnFilter.serializer.serialize(command.columnFilter(), out, version);
            RowFilter.serializer.serialize(command.rowFilter(), out, version);
            DataLimits.serializer.serialize(command.limits(), out, version, command.metadata().comparator);
            if (null != command.index) {
                IndexMetadata.serializer.serialize(command.index, out, version);
            }
            command.serializeSelection(out, version);
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version) throws IOException {
            Kind kind = Kind.values()[in.readByte()];
            byte flags = in.readByte();
            boolean isDigest = Serializer.isDigest(flags);
            boolean acceptsTransient = Serializer.acceptsTransient(flags);
            if (Serializer.isForThrift(flags)) {
                throw new IllegalStateException("Received a command with the thrift flag set. This means thrift is in use in a mixed 3.0/3.X and 4.0+ cluster, which is unsupported. Make sure to stop using thrift before upgrading to 4.0");
            }
            boolean hasIndex = Serializer.hasIndex(flags);
            int digestVersion = isDigest ? (int)in.readUnsignedVInt() : 0;
            TableMetadata metadata = Schema.instance.getExistingTableMetadata(TableId.deserialize(in));
            int nowInSec = in.readInt();
            ColumnFilter columnFilter = ColumnFilter.serializer.deserialize(in, version, metadata);
            RowFilter rowFilter = RowFilter.serializer.deserialize(in, version, metadata);
            DataLimits limits = DataLimits.serializer.deserialize(in, version, metadata.comparator);
            IndexMetadata index = hasIndex ? this.deserializeIndexMetadata(in, version, metadata) : null;
            return kind.selectionDeserializer.deserialize(in, version, isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, index);
        }

        private IndexMetadata deserializeIndexMetadata(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            try {
                return IndexMetadata.serializer.deserialize(in, version, metadata);
            }
            catch (UnknownIndexException e) {
                logger.info("Couldn't find a defined index on {}.{} with the id {}. If an index was just created, this is likely due to the schema not being fully propagated. Local read will proceed without using the index. Please wait for schema agreement after index creation.", new Object[]{metadata.keyspace, metadata.name, e.indexId});
                return null;
            }
        }

        @Override
        public long serializedSize(ReadCommand command, int version) {
            return (long)(2 + (command.isDigestQuery() ? TypeSizes.sizeofUnsignedVInt(command.digestVersion()) : 0) + command.metadata().id.serializedSize() + TypeSizes.sizeof(command.nowInSec())) + ColumnFilter.serializer.serializedSize(command.columnFilter(), version) + RowFilter.serializer.serializedSize(command.rowFilter(), version) + DataLimits.serializer.serializedSize(command.limits(), version, command.metadata().comparator) + command.selectionSerializedSize(version) + command.indexSerializedSize(version);
        }
    }

    static class InputCollector<T extends AutoCloseable> {
        final RepairedDataInfo repairedDataInfo;
        private final boolean isTrackingRepairedStatus;
        Set<SSTableReader> repairedSSTables;
        BiFunction<List<T>, RepairedDataInfo, T> repairedMerger;
        List<T> repairedIters;
        List<T> unrepairedIters;

        InputCollector(ColumnFamilyStore.ViewFragment view, RepairedDataInfo repairedDataInfo, BiFunction<List<T>, RepairedDataInfo, T> repairedMerger, boolean isTrackingRepairedStatus) {
            this.repairedDataInfo = repairedDataInfo;
            this.isTrackingRepairedStatus = isTrackingRepairedStatus;
            if (isTrackingRepairedStatus) {
                for (SSTableReader sstable : view.sstables) {
                    if (!this.considerRepairedForTracking(sstable)) continue;
                    if (this.repairedSSTables == null) {
                        this.repairedSSTables = Sets.newHashSetWithExpectedSize((int)view.sstables.size());
                    }
                    this.repairedSSTables.add(sstable);
                }
            }
            if (this.repairedSSTables == null) {
                this.repairedIters = Collections.emptyList();
                this.unrepairedIters = new ArrayList<T>(view.sstables.size());
            } else {
                this.repairedIters = new ArrayList<T>(this.repairedSSTables.size());
                this.unrepairedIters = new ArrayList<T>(view.sstables.size() - this.repairedSSTables.size() + Iterables.size(view.memtables) + 1);
            }
            this.repairedMerger = repairedMerger;
        }

        void addMemtableIterator(T iter) {
            this.unrepairedIters.add(iter);
        }

        void addSSTableIterator(SSTableReader sstable, T iter) {
            if (this.repairedSSTables != null && this.repairedSSTables.contains(sstable)) {
                this.repairedIters.add(iter);
            } else {
                this.unrepairedIters.add(iter);
            }
        }

        List<T> finalizeIterators(ColumnFamilyStore cfs, int nowInSec, int oldestUnrepairedTombstone) {
            if (this.repairedIters.isEmpty()) {
                return this.unrepairedIters;
            }
            RepairedDataPurger purger = new RepairedDataPurger(cfs, nowInSec, oldestUnrepairedTombstone);
            this.repairedDataInfo.setPurger(purger);
            this.unrepairedIters.add(this.repairedMerger.apply(this.repairedIters, this.repairedDataInfo));
            return this.unrepairedIters;
        }

        boolean isEmpty() {
            return this.repairedIters.isEmpty() && this.unrepairedIters.isEmpty();
        }

        private boolean considerRepairedForTracking(SSTableReader sstable) {
            if (!this.isTrackingRepairedStatus) {
                return false;
            }
            UUID pendingRepair = sstable.getPendingRepair();
            if (pendingRepair != ActiveRepairService.NO_PENDING_REPAIR) {
                if (ActiveRepairService.instance.consistent.local.isSessionFinalized(pendingRepair)) {
                    return true;
                }
                if (!ActiveRepairService.instance.consistent.local.sessionExists(pendingRepair)) {
                    return false;
                }
                this.repairedDataInfo.markInconclusive();
            }
            return sstable.isRepaired();
        }

        void markInconclusive() {
            this.repairedDataInfo.markInconclusive();
        }

        public void close() throws Exception {
            FBUtilities.closeAll(this.unrepairedIters);
            FBUtilities.closeAll(this.repairedIters);
        }
    }

    private static class RepairedDataPurger
    extends PurgeFunction {
        RepairedDataPurger(ColumnFamilyStore cfs, int nowInSec, int oldestUnrepairedTombstone) {
            super(nowInSec, cfs.gcBefore(nowInSec), oldestUnrepairedTombstone, cfs.getCompactionStrategyManager().onlyPurgeRepairedTombstones(), cfs.metadata.get().enforceStrictLiveness());
        }

        @Override
        protected LongPredicate getPurgeEvaluator() {
            return time -> true;
        }

        void setCurrentKey(DecoratedKey key) {
            super.onNewPartition(key);
        }

        void setIsReverseOrder(boolean isReverseOrder) {
            super.setReverseOrder(isReverseOrder);
        }

        @Override
        public DeletionTime applyToDeletion(DeletionTime deletionTime) {
            return super.applyToDeletion(deletionTime);
        }

        @Override
        public Row applyToRow(Row row) {
            return super.applyToRow(row);
        }

        @Override
        public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
            return super.applyToMarker(marker);
        }
    }

    private static class RepairedDataInfo {
        private Digest perPartitionDigest;
        private Digest perCommandDigest;
        private boolean isConclusive = true;
        private RepairedDataPurger purger;
        private boolean isFullyPurged = true;

        private RepairedDataInfo() {
        }

        ByteBuffer getDigest() {
            return this.perCommandDigest == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBuffer.wrap(this.perCommandDigest.digest());
        }

        protected void onNewPartition(UnfilteredRowIterator partition) {
            assert (this.purger != null);
            this.purger.setCurrentKey(partition.partitionKey());
            this.purger.setIsReverseOrder(partition.isReverseOrder());
        }

        protected void setPurger(RepairedDataPurger purger) {
            this.purger = purger;
        }

        boolean isConclusive() {
            return this.isConclusive;
        }

        void markInconclusive() {
            this.isConclusive = false;
        }

        void trackPartitionKey(DecoratedKey key) {
            this.getPerPartitionDigest().update(key.getKey());
        }

        void trackDeletion(DeletionTime deletion) {
            assert (this.purger != null);
            DeletionTime purged = this.purger.applyToDeletion(deletion);
            if (!purged.isLive()) {
                this.isFullyPurged = false;
            }
            purged.digest(this.getPerPartitionDigest());
        }

        void trackRangeTombstoneMarker(RangeTombstoneMarker marker) {
            assert (this.purger != null);
            RangeTombstoneMarker purged = this.purger.applyToMarker(marker);
            if (purged != null) {
                this.isFullyPurged = false;
                purged.digest(this.getPerPartitionDigest());
            }
        }

        void trackStaticRow(Row row) {
            assert (this.purger != null);
            Row purged = this.purger.applyToRow(row);
            if (!purged.isEmpty()) {
                this.isFullyPurged = false;
                purged.digest(this.getPerPartitionDigest());
            }
        }

        void trackRow(Row row) {
            assert (this.purger != null);
            Row purged = this.purger.applyToRow(row);
            if (purged != null) {
                this.isFullyPurged = false;
                purged.digest(this.getPerPartitionDigest());
            }
        }

        private Digest getPerPartitionDigest() {
            if (this.perPartitionDigest == null) {
                this.perPartitionDigest = Digest.forRepairedDataTracking();
            }
            return this.perPartitionDigest;
        }

        private void onPartitionClose() {
            if (this.perPartitionDigest != null) {
                if (!this.isFullyPurged) {
                    if (this.perCommandDigest == null) {
                        this.perCommandDigest = Digest.forRepairedDataTracking();
                    }
                    byte[] partitionDigest = this.perPartitionDigest.digest();
                    this.perCommandDigest.update(partitionDigest, 0, partitionDigest.length);
                    this.isFullyPurged = true;
                }
                this.perPartitionDigest = null;
            }
        }
    }

    protected class CheckForAbort
    extends StoppingTransformation<UnfilteredRowIterator> {
        long lastChecked = 0L;

        protected CheckForAbort() {
        }

        @Override
        protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
            if (this.maybeAbort()) {
                partition.close();
                return null;
            }
            return Transformation.apply(partition, this);
        }

        @Override
        protected Row applyToRow(Row row) {
            if (TEST_ITERATION_DELAY_MILLIS > 0) {
                this.maybeDelayForTesting();
            }
            return this.maybeAbort() ? null : row;
        }

        private boolean maybeAbort() {
            if (this.lastChecked == MonotonicClock.approxTime.now()) {
                return false;
            }
            this.lastChecked = MonotonicClock.approxTime.now();
            if (ReadCommand.this.isAborted()) {
                this.stop();
                return true;
            }
            return false;
        }

        private void maybeDelayForTesting() {
            if (!ReadCommand.this.metadata().keyspace.startsWith("system")) {
                FBUtilities.sleepQuietly(TEST_ITERATION_DELAY_MILLIS);
            }
        }
    }

    protected static enum Kind {
        SINGLE_PARTITION(SinglePartitionReadCommand.selectionDeserializer),
        PARTITION_RANGE(PartitionRangeReadCommand.selectionDeserializer);

        private final SelectionDeserializer selectionDeserializer;

        private Kind(SelectionDeserializer selectionDeserializer) {
            this.selectionDeserializer = selectionDeserializer;
        }
    }

    protected static abstract class SelectionDeserializer {
        protected SelectionDeserializer() {
        }

        public abstract ReadCommand deserialize(DataInputPlus var1, int var2, boolean var3, int var4, boolean var5, TableMetadata var6, int var7, ColumnFilter var8, RowFilter var9, DataLimits var10, IndexMetadata var11) throws IOException;
    }
}

