/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.TableAttributes;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.reads.repair.ReadRepairStrategy;
import org.apache.cassandra.transport.Event;

public abstract class AlterTableStatement
extends AlterSchemaStatement {
    protected final String tableName;

    public AlterTableStatement(String keyspaceName, String tableName) {
        super(keyspaceName);
        this.tableName = tableName;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        TableMetadata table;
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        TableMetadata tableMetadata = table = null == keyspace ? null : keyspace.getTableOrViewNullable(this.tableName);
        if (null == table) {
            throw AlterTableStatement.ire("Table '%s.%s' doesn't exist", this.keyspaceName, this.tableName);
        }
        if (table.isView()) {
            throw AlterTableStatement.ire("Cannot use ALTER TABLE on a materialized view; use ALTER MATERIALIZED VIEW instead", new Object[0]);
        }
        return schema.withAddedOrUpdated(this.apply(keyspace, table));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.tableName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureTablePermission(this.keyspaceName, this.tableName, Permission.ALTER);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.ALTER_TABLE, this.keyspaceName, this.tableName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.tableName);
    }

    abstract KeyspaceMetadata apply(KeyspaceMetadata var1, TableMetadata var2);

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName name;
        private Kind kind;
        private final List<AddColumns.Column> addedColumns = new ArrayList<AddColumns.Column>();
        private final List<ColumnMetadata.Raw> droppedColumns = new ArrayList<ColumnMetadata.Raw>();
        private Long timestamp = null;
        private final Map<ColumnMetadata.Raw, ColumnMetadata.Raw> renamedColumns = new HashMap<ColumnMetadata.Raw, ColumnMetadata.Raw>();
        public final TableAttributes attrs = new TableAttributes();

        public Raw(QualifiedName name) {
            this.name = name;
        }

        @Override
        public AlterTableStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            String tableName = this.name.getName();
            switch (this.kind) {
                case ALTER_COLUMN: {
                    return new AlterColumn(keyspaceName, tableName);
                }
                case ADD_COLUMNS: {
                    return new AddColumns(keyspaceName, tableName, this.addedColumns);
                }
                case DROP_COLUMNS: {
                    return new DropColumns(keyspaceName, tableName, this.droppedColumns, this.timestamp);
                }
                case RENAME_COLUMNS: {
                    return new RenameColumns(keyspaceName, tableName, this.renamedColumns);
                }
                case ALTER_OPTIONS: {
                    return new AlterOptions(keyspaceName, tableName, this.attrs);
                }
            }
            throw new AssertionError();
        }

        public void alter(ColumnMetadata.Raw name, CQL3Type.Raw type) {
            this.kind = Kind.ALTER_COLUMN;
        }

        public void add(ColumnMetadata.Raw name, CQL3Type.Raw type, boolean isStatic) {
            this.kind = Kind.ADD_COLUMNS;
            this.addedColumns.add(new AddColumns.Column(name, type, isStatic));
        }

        public void drop(ColumnMetadata.Raw name) {
            this.kind = Kind.DROP_COLUMNS;
            this.droppedColumns.add(name);
        }

        public void timestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void rename(ColumnMetadata.Raw from, ColumnMetadata.Raw to) {
            this.kind = Kind.RENAME_COLUMNS;
            this.renamedColumns.put(from, to);
        }

        public void attrs() {
            this.kind = Kind.ALTER_OPTIONS;
        }

        private static enum Kind {
            ALTER_COLUMN,
            ADD_COLUMNS,
            DROP_COLUMNS,
            RENAME_COLUMNS,
            ALTER_OPTIONS;

        }
    }

    private static class AlterOptions
    extends AlterTableStatement {
        private final TableAttributes attrs;

        private AlterOptions(String keyspaceName, String tableName, TableAttributes attrs) {
            super(keyspaceName, tableName);
            this.attrs = attrs;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            this.attrs.validate();
            TableParams params = this.attrs.asAlteredTableParams(table.params);
            if (table.isCounter() && params.defaultTimeToLive > 0) {
                throw AlterOptions.ire("Cannot set default_time_to_live on a table with counters", new Object[0]);
            }
            if (!Iterables.isEmpty(keyspace.views.forTable(table.id)) && params.gcGraceSeconds == 0) {
                throw AlterOptions.ire("Cannot alter gc_grace_seconds of the base table of a materialized view to 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.", new Object[0]);
            }
            if (keyspace.createReplicationStrategy().hasTransientReplicas() && params.readRepair != ReadRepairStrategy.NONE) {
                throw AlterOptions.ire("read_repair must be set to 'NONE' for transiently replicated keyspaces", new Object[0]);
            }
            return keyspace.withSwapped(keyspace.tables.withSwapped(table.withSwapped(params)));
        }
    }

    private static class RenameColumns
    extends AlterTableStatement {
        private final Map<ColumnMetadata.Raw, ColumnMetadata.Raw> renamedColumns;

        private RenameColumns(String keyspaceName, String tableName, Map<ColumnMetadata.Raw, ColumnMetadata.Raw> renamedColumns) {
            super(keyspaceName, tableName);
            this.renamedColumns = renamedColumns;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            TableMetadata.Builder tableBuilder = table.unbuild();
            Views.Builder viewsBuilder = keyspace.views.unbuild();
            this.renamedColumns.forEach((o, n) -> this.renameColumn(keyspace, table, (ColumnMetadata.Raw)o, (ColumnMetadata.Raw)n, tableBuilder, viewsBuilder));
            return keyspace.withSwapped(keyspace.tables.withSwapped(tableBuilder.build())).withSwapped(viewsBuilder.build());
        }

        private void renameColumn(KeyspaceMetadata keyspace, TableMetadata table, ColumnMetadata.Raw oldName, ColumnMetadata.Raw newName, TableMetadata.Builder tableBuilder, Views.Builder viewsBuilder) {
            ColumnIdentifier oldColumnName = oldName.getIdentifier(table);
            ColumnIdentifier newColumnName = newName.getIdentifier(table);
            ColumnMetadata column = table.getColumn(oldColumnName);
            if (null == column) {
                throw RenameColumns.ire("Column %s was not found in table %s", oldColumnName, table);
            }
            if (!column.isPrimaryKeyColumn()) {
                throw RenameColumns.ire("Cannot rename non PRIMARY KEY column %s", oldColumnName);
            }
            if (null != table.getColumn(newColumnName)) {
                throw RenameColumns.ire("Cannot rename column %s to %s in table '%s'; another column with that name already exists", oldColumnName, newColumnName, table);
            }
            Set<IndexMetadata> dependentIndexes = Keyspace.openAndGetStore((TableMetadata)table).indexManager.getDependentIndexes(column);
            if (!dependentIndexes.isEmpty()) {
                throw RenameColumns.ire("Can't rename column %s because it has dependent secondary indexes (%s)", oldColumnName, String.join((CharSequence)", ", Iterables.transform(dependentIndexes, i -> i.name)));
            }
            for (ViewMetadata view : keyspace.views.forTable(table.id)) {
                if (!view.includes(oldColumnName)) continue;
                ColumnIdentifier oldViewColumn = oldName.getIdentifier(view.metadata);
                ColumnIdentifier newViewColumn = newName.getIdentifier(view.metadata);
                viewsBuilder.put(viewsBuilder.get(view.name()).withRenamedPrimaryKeyColumn(oldViewColumn, newViewColumn));
            }
            tableBuilder.renamePrimaryKeyColumn(oldColumnName, newColumnName);
        }
    }

    private static class DropColumns
    extends AlterTableStatement {
        private final Collection<ColumnMetadata.Raw> removedColumns;
        private final Long timestamp;

        private DropColumns(String keyspaceName, String tableName, Collection<ColumnMetadata.Raw> removedColumns, Long timestamp) {
            super(keyspaceName, tableName);
            this.removedColumns = removedColumns;
            this.timestamp = timestamp;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            TableMetadata.Builder builder = table.unbuild();
            this.removedColumns.forEach(c -> this.dropColumn(keyspace, table, (ColumnMetadata.Raw)c, builder));
            return keyspace.withSwapped(keyspace.tables.withSwapped(builder.build()));
        }

        private void dropColumn(KeyspaceMetadata keyspace, TableMetadata table, ColumnMetadata.Raw column, TableMetadata.Builder builder) {
            ColumnIdentifier name = column.getIdentifier(table);
            ColumnMetadata currentColumn = table.getColumn(name);
            if (null == currentColumn) {
                throw DropColumns.ire("Column %s was not found in table '%s'", name, table);
            }
            if (currentColumn.isPrimaryKeyColumn()) {
                throw DropColumns.ire("Cannot drop PRIMARY KEY column %s", name);
            }
            if (currentColumn.type.isUDT() && currentColumn.type.isMultiCell()) {
                throw DropColumns.ire("Cannot drop non-frozen column %s of user type %s", name, currentColumn.type.asCQL3Type());
            }
            Set<IndexMetadata> dependentIndexes = Keyspace.openAndGetStore((TableMetadata)table).indexManager.getDependentIndexes(currentColumn);
            if (!dependentIndexes.isEmpty()) {
                throw DropColumns.ire("Cannot drop column %s because it has dependent secondary indexes (%s)", currentColumn, String.join((CharSequence)", ", Iterables.transform(dependentIndexes, i -> i.name)));
            }
            if (!Iterables.isEmpty(keyspace.views.forTable(table.id))) {
                throw DropColumns.ire("Cannot drop column %s on base table %s with materialized views", currentColumn, table.name);
            }
            builder.removeRegularOrStaticColumn(name);
            builder.recordColumnDrop(currentColumn, this.getTimestamp());
        }

        private long getTimestamp() {
            return this.timestamp == null ? ClientState.getTimestamp() : this.timestamp;
        }
    }

    private static class AddColumns
    extends AlterTableStatement {
        private final Collection<Column> newColumns;

        private AddColumns(String keyspaceName, String tableName, Collection<Column> newColumns) {
            super(keyspaceName, tableName);
            this.newColumns = newColumns;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            TableMetadata.Builder tableBuilder = table.unbuild();
            Views.Builder viewsBuilder = keyspace.views.unbuild();
            this.newColumns.forEach(c -> this.addColumn(keyspace, table, (Column)c, tableBuilder, viewsBuilder));
            return keyspace.withSwapped(keyspace.tables.withSwapped(tableBuilder.build())).withSwapped(viewsBuilder.build());
        }

        private void addColumn(KeyspaceMetadata keyspace, TableMetadata table, Column column, TableMetadata.Builder tableBuilder, Views.Builder viewsBuilder) {
            ColumnIdentifier name = column.name.getIdentifier(table);
            AbstractType<?> type = column.type.prepare(this.keyspaceName, keyspace.types).getType();
            boolean isStatic = column.isStatic;
            if (null != tableBuilder.getColumn(name)) {
                throw AddColumns.ire("Column with name '%s' already exists", name);
            }
            if (isStatic && table.clusteringColumns().isEmpty()) {
                throw AddColumns.ire("Static columns are only useful (and thus allowed) if the table has at least one clustering column", new Object[0]);
            }
            ColumnMetadata droppedColumn = table.getDroppedColumn(name.bytes);
            if (null != droppedColumn) {
                if (!type.isValueCompatibleWith(droppedColumn.type)) {
                    throw AddColumns.ire("Cannot re-add previously dropped column '%s' of type %s, incompatible with previous type %s", name, type.asCQL3Type(), droppedColumn.type.asCQL3Type());
                }
                if (droppedColumn.isStatic() != isStatic) {
                    throw AddColumns.ire("Cannot re-add previously dropped column '%s' of kind %s, incompatible with previous kind %s", new Object[]{name, isStatic ? ColumnMetadata.Kind.STATIC : ColumnMetadata.Kind.REGULAR, droppedColumn.kind});
                }
                if (table.isCounter()) {
                    throw AddColumns.ire("Cannot re-add previously dropped counter column %s", name);
                }
            }
            if (isStatic) {
                tableBuilder.addStaticColumn(name, type);
            } else {
                tableBuilder.addRegularColumn(name, type);
            }
            if (!isStatic) {
                for (ViewMetadata view : keyspace.views.forTable(table.id)) {
                    if (!view.includeAllColumns) continue;
                    ColumnMetadata viewColumn = ColumnMetadata.regularColumn(view.metadata, name.bytes, type);
                    viewsBuilder.put(viewsBuilder.get(view.name()).withAddedRegularColumn(viewColumn));
                }
            }
        }

        private static class Column {
            private final ColumnMetadata.Raw name;
            private final CQL3Type.Raw type;
            private final boolean isStatic;

            Column(ColumnMetadata.Raw name, CQL3Type.Raw type, boolean isStatic) {
                this.name = name;
                this.type = type;
                this.isStatic = isStatic;
            }
        }
    }

    public static class AlterColumn
    extends AlterTableStatement {
        AlterColumn(String keyspaceName, String tableName) {
            super(keyspaceName, tableName);
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            throw AlterColumn.ire("Altering column types is no longer supported", new Object[0]);
        }
    }
}

