/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public final class SingleColumnRelation
extends Relation {
    private final ColumnMetadata.Raw entity;
    private final Term.Raw mapKey;
    private final Term.Raw value;
    private final List<Term.Raw> inValues;

    private SingleColumnRelation(ColumnMetadata.Raw entity, Term.Raw mapKey, Operator type, Term.Raw value, List<Term.Raw> inValues) {
        this.entity = entity;
        this.mapKey = mapKey;
        this.relationType = type;
        this.value = value;
        this.inValues = inValues;
        if (type == Operator.IS_NOT) assert (value == Constants.NULL_LITERAL);
    }

    public SingleColumnRelation(ColumnMetadata.Raw entity, Term.Raw mapKey, Operator type, Term.Raw value) {
        this(entity, mapKey, type, value, null);
    }

    public SingleColumnRelation(ColumnMetadata.Raw entity, Operator type, Term.Raw value) {
        this(entity, null, type, value);
    }

    @Override
    public Term.Raw getValue() {
        return this.value;
    }

    @Override
    public List<? extends Term.Raw> getInValues() {
        return this.inValues;
    }

    public static SingleColumnRelation createInRelation(ColumnMetadata.Raw entity, List<Term.Raw> inValues) {
        return new SingleColumnRelation(entity, null, Operator.IN, null, inValues);
    }

    public ColumnMetadata.Raw getEntity() {
        return this.entity;
    }

    public Term.Raw getMapKey() {
        return this.mapKey;
    }

    @Override
    protected Term toTerm(List<? extends ColumnSpecification> receivers, Term.Raw raw, String keyspace, VariableSpecifications boundNames) throws InvalidRequestException {
        assert (receivers.size() == 1);
        Term term = raw.prepare(keyspace, receivers.get(0));
        term.collectMarkerSpecification(boundNames);
        return term;
    }

    public SingleColumnRelation withNonStrictOperator() {
        switch (this.relationType) {
            case GT: {
                return new SingleColumnRelation(this.entity, Operator.GTE, this.value);
            }
            case LT: {
                return new SingleColumnRelation(this.entity, Operator.LTE, this.value);
            }
        }
        return this;
    }

    @Override
    public Relation renameIdentifier(ColumnMetadata.Raw from, ColumnMetadata.Raw to) {
        return this.entity.equals(from) ? new SingleColumnRelation(to, this.mapKey, this.operator(), this.value, this.inValues) : this;
    }

    public String toString() {
        String entityAsString = this.entity.toString();
        if (this.mapKey != null) {
            entityAsString = String.format("%s[%s]", entityAsString, this.mapKey);
        }
        if (this.isIN()) {
            return String.format("%s IN %s", entityAsString, Tuples.tupleToString(this.inValues));
        }
        return String.format("%s %s %s", new Object[]{entityAsString, this.relationType, this.value});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relationType, this.entity, this.mapKey, this.value, this.inValues});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleColumnRelation)) {
            return false;
        }
        SingleColumnRelation scr = (SingleColumnRelation)o;
        return Objects.equals(this.entity, scr.entity) && Objects.equals((Object)this.relationType, (Object)scr.relationType) && Objects.equals(this.mapKey, scr.mapKey) && Objects.equals(this.value, scr.value) && Objects.equals(this.inValues, scr.inValues);
    }

    @Override
    protected Restriction newEQRestriction(TableMetadata table, VariableSpecifications boundNames) {
        ColumnMetadata columnDef = this.entity.prepare(table);
        if (this.mapKey == null) {
            Term term = this.toTerm(this.toReceivers(columnDef), this.value, table.keyspace, boundNames);
            return new SingleColumnRestriction.EQRestriction(columnDef, term);
        }
        List<? extends ColumnSpecification> receivers = this.toReceivers(columnDef);
        Term entryKey = this.toTerm(Collections.singletonList(receivers.get(0)), this.mapKey, table.keyspace, boundNames);
        Term entryValue = this.toTerm(Collections.singletonList(receivers.get(1)), this.value, table.keyspace, boundNames);
        return new SingleColumnRestriction.ContainsRestriction(columnDef, entryKey, entryValue);
    }

    @Override
    protected Restriction newINRestriction(TableMetadata table, VariableSpecifications boundNames) {
        ColumnMetadata columnDef = this.entity.prepare(table);
        List<? extends ColumnSpecification> receivers = this.toReceivers(columnDef);
        List<Term> terms = this.toTerms(receivers, this.inValues, table.keyspace, boundNames);
        if (terms == null) {
            Term term = this.toTerm(receivers, this.value, table.keyspace, boundNames);
            return new SingleColumnRestriction.InRestrictionWithMarker(columnDef, (Lists.Marker)term);
        }
        if (terms.size() == 1) {
            return new SingleColumnRestriction.EQRestriction(columnDef, terms.get(0));
        }
        return new SingleColumnRestriction.InRestrictionWithValues(columnDef, terms);
    }

    @Override
    protected Restriction newSliceRestriction(TableMetadata table, VariableSpecifications boundNames, Bound bound, boolean inclusive) {
        ColumnMetadata columnDef = this.entity.prepare(table);
        if (columnDef.type.referencesDuration()) {
            RequestValidations.checkFalse(columnDef.type.isCollection(), "Slice restrictions are not supported on collections containing durations");
            RequestValidations.checkFalse(columnDef.type.isTuple(), "Slice restrictions are not supported on tuples containing durations");
            RequestValidations.checkFalse(columnDef.type.isUDT(), "Slice restrictions are not supported on UDTs containing durations");
            throw RequestValidations.invalidRequest("Slice restrictions are not supported on duration columns", new Object[0]);
        }
        Term term = this.toTerm(this.toReceivers(columnDef), this.value, table.keyspace, boundNames);
        return new SingleColumnRestriction.SliceRestriction(columnDef, bound, inclusive, term);
    }

    @Override
    protected Restriction newContainsRestriction(TableMetadata table, VariableSpecifications boundNames, boolean isKey) throws InvalidRequestException {
        ColumnMetadata columnDef = this.entity.prepare(table);
        Term term = this.toTerm(this.toReceivers(columnDef), this.value, table.keyspace, boundNames);
        return new SingleColumnRestriction.ContainsRestriction(columnDef, term, isKey);
    }

    @Override
    protected Restriction newIsNotRestriction(TableMetadata table, VariableSpecifications boundNames) throws InvalidRequestException {
        ColumnMetadata columnDef = this.entity.prepare(table);
        assert (this.value == Constants.NULL_LITERAL) : "Expected null literal for IS NOT relation: " + this.toString();
        return new SingleColumnRestriction.IsNotNullRestriction(columnDef);
    }

    @Override
    protected Restriction newLikeRestriction(TableMetadata table, VariableSpecifications boundNames, Operator operator) {
        if (this.mapKey != null) {
            throw RequestValidations.invalidRequest("%s can't be used with collections.", new Object[]{this.operator()});
        }
        ColumnMetadata columnDef = this.entity.prepare(table);
        Term term = this.toTerm(this.toReceivers(columnDef), this.value, table.keyspace, boundNames);
        return new SingleColumnRestriction.LikeRestriction(columnDef, operator, term);
    }

    private List<? extends ColumnSpecification> toReceivers(ColumnMetadata columnDef) throws InvalidRequestException {
        ColumnSpecification receiver = columnDef;
        if (this.isIN()) {
            RequestValidations.checkFalse(!columnDef.isPrimaryKeyColumn() && !this.canHaveOnlyOneValue(), "IN predicates on non-primary-key columns (%s) is not yet supported", columnDef.name);
        }
        RequestValidations.checkFalse(this.isContainsKey() && !(receiver.type instanceof MapType), "Cannot use CONTAINS KEY on non-map column %s", receiver.name);
        RequestValidations.checkFalse(this.isContains() && !receiver.type.isCollection(), "Cannot use CONTAINS on non-collection column %s", receiver.name);
        if (this.mapKey != null) {
            RequestValidations.checkFalse(receiver.type instanceof ListType, "Indexes on list entries (%s[index] = value) are not currently supported.", receiver.name);
            RequestValidations.checkTrue(receiver.type instanceof MapType, "Column %s cannot be used as a map", receiver.name);
            RequestValidations.checkTrue(receiver.type.isMultiCell(), "Map-entry equality predicates on frozen map column %s are not supported", receiver.name);
            RequestValidations.checkTrue(this.isEQ(), "Only EQ relations are supported on map entries");
        }
        RequestValidations.checkFalse(receiver.type.isUDT() && receiver.type.isMultiCell(), "Non-frozen UDT column '%s' (%s) cannot be restricted by any relation", receiver.name, receiver.type.asCQL3Type());
        if (receiver.type.isCollection()) {
            RequestValidations.checkFalse(receiver.type.isMultiCell() && !this.isLegalRelationForNonFrozenCollection(), "Collection column '%s' (%s) cannot be restricted by a '%s' relation", new Object[]{receiver.name, receiver.type.asCQL3Type(), this.operator()});
            if (this.isContainsKey() || this.isContains()) {
                receiver = SingleColumnRelation.makeCollectionReceiver(receiver, this.isContainsKey());
            } else if (receiver.type.isMultiCell() && this.mapKey != null && this.isEQ()) {
                ArrayList<ColumnSpecification> receivers = new ArrayList<ColumnSpecification>(2);
                receivers.add(SingleColumnRelation.makeCollectionReceiver(receiver, true));
                receivers.add(SingleColumnRelation.makeCollectionReceiver(receiver, false));
                return receivers;
            }
        }
        return Collections.singletonList(receiver);
    }

    private static ColumnSpecification makeCollectionReceiver(ColumnSpecification receiver, boolean forKey) {
        return ((CollectionType)receiver.type).makeCollectionReceiver(receiver, forKey);
    }

    private boolean isLegalRelationForNonFrozenCollection() {
        return this.isContainsKey() || this.isContains() || this.isMapEntryEquality();
    }

    private boolean isMapEntryEquality() {
        return this.mapKey != null && this.isEQ();
    }

    private boolean canHaveOnlyOneValue() {
        return this.isEQ() || this.isLIKE() || this.isIN() && this.inValues != null && this.inValues.size() == 1;
    }
}

