/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;

public class CustomPayloadMirroringQueryHandler
implements QueryHandler {
    static QueryProcessor queryProcessor = QueryProcessor.instance;

    @Override
    public ResultMessage process(String query, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload, long queryStartNanoTime) {
        ResultMessage result = queryProcessor.process(query, state, options, customPayload, queryStartNanoTime);
        result.setCustomPayload(customPayload);
        return result;
    }

    @Override
    public ResultMessage.Prepared prepare(String query, ClientState clientState, Map<String, ByteBuffer> customPayload) {
        ResultMessage.Prepared prepared = queryProcessor.prepare(query, clientState, customPayload);
        prepared.setCustomPayload(customPayload);
        return prepared;
    }

    @Override
    public QueryHandler.Prepared getPrepared(MD5Digest id) {
        return queryProcessor.getPrepared(id);
    }

    @Override
    public ResultMessage processPrepared(CQLStatement statement, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload, long queryStartNanoTime) {
        ResultMessage result = queryProcessor.processPrepared(statement, state, options, customPayload, queryStartNanoTime);
        result.setCustomPayload(customPayload);
        return result;
    }

    @Override
    public ResultMessage processBatch(BatchStatement statement, QueryState state, BatchQueryOptions options, Map<String, ByteBuffer> customPayload, long queryStartNanoTime) {
        ResultMessage result = queryProcessor.processBatch(statement, state, options, customPayload, queryStartNanoTime);
        result.setCustomPayload(customPayload);
        return result;
    }
}

