/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;

public class LeafBTreeSearchIterator<K, V>
implements BTreeSearchIterator<K, V> {
    private final boolean forwards;
    private final K[] keys;
    private final Comparator<? super K> comparator;
    private int nextPos;
    private final int lowerBound;
    private final int upperBound;
    private boolean hasNext;
    private boolean hasCurrent;

    public LeafBTreeSearchIterator(Object[] btree, Comparator<? super K> comparator, BTree.Dir dir) {
        this(btree, comparator, dir, 0, BTree.size(btree) - 1);
    }

    LeafBTreeSearchIterator(Object[] btree, Comparator<? super K> comparator, BTree.Dir dir, int lowerBound, int upperBound) {
        this.keys = btree;
        this.forwards = dir == BTree.Dir.ASC;
        this.comparator = comparator;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.nextPos = this.forwards ? lowerBound : upperBound;
        this.hasNext = this.nextPos >= lowerBound && this.nextPos <= upperBound;
    }

    @Override
    public V next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        K elem = this.keys[this.nextPos];
        this.nextPos += this.forwards ? 1 : -1;
        this.hasNext = this.nextPos >= this.lowerBound && this.nextPos <= this.upperBound;
        this.hasCurrent = true;
        return (V)elem;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    private int searchNext(K key) {
        int lb = this.forwards ? this.nextPos : this.lowerBound;
        int ub = this.forwards ? this.upperBound : this.nextPos;
        return Arrays.binarySearch(this.keys, lb, ub + 1, key, this.comparator);
    }

    @Override
    public V next(K key) {
        if (!this.hasNext) {
            return null;
        }
        V result = null;
        int find = this.searchNext(key);
        if (find >= 0) {
            this.hasCurrent = true;
            result = (V)this.keys[find];
            this.nextPos = find + (this.forwards ? 1 : -1);
        } else {
            this.nextPos = (this.forwards ? -1 : -2) - find;
            this.hasCurrent = false;
        }
        this.hasNext = this.nextPos >= this.lowerBound && this.nextPos <= this.upperBound;
        return result;
    }

    @Override
    public V current() {
        if (!this.hasCurrent) {
            throw new NoSuchElementException();
        }
        int current = this.forwards ? this.nextPos - 1 : this.nextPos + 1;
        return (V)this.keys[current];
    }

    @Override
    public int indexOfCurrent() {
        if (!this.hasCurrent) {
            throw new NoSuchElementException();
        }
        int current = this.forwards ? this.nextPos - 1 : this.nextPos + 1;
        return this.forwards ? current - this.lowerBound : this.upperBound - current;
    }
}

