/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.RowIterators;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.schema.DroppedColumn;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.reads.SpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.repair.ReadRepairStrategy;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaKeyspace {
    private static final Logger logger = LoggerFactory.getLogger(SchemaKeyspace.class);
    private static final boolean FLUSH_SCHEMA_TABLES = Boolean.parseBoolean(System.getProperty("cassandra.test.flush_local_schema_changes", "true"));
    private static final boolean IGNORE_CORRUPTED_SCHEMA_TABLES = Boolean.parseBoolean(System.getProperty("cassandra.ignore_corrupted_schema_tables", "false"));
    public static final String KEYSPACES = "keyspaces";
    public static final String TABLES = "tables";
    public static final String COLUMNS = "columns";
    public static final String DROPPED_COLUMNS = "dropped_columns";
    public static final String TRIGGERS = "triggers";
    public static final String VIEWS = "views";
    public static final String TYPES = "types";
    public static final String FUNCTIONS = "functions";
    public static final String AGGREGATES = "aggregates";
    public static final String INDEXES = "indexes";
    public static final ImmutableList<String> ALL = ImmutableList.of((Object)"columns", (Object)"dropped_columns", (Object)"triggers", (Object)"types", (Object)"functions", (Object)"aggregates", (Object)"indexes", (Object)"tables", (Object)"views", (Object)"keyspaces");
    private static final Set<String> TABLES_WITH_CDC_ADDED = ImmutableSet.of((Object)"tables", (Object)"views");
    private static final TableMetadata Keyspaces = SchemaKeyspace.parse("keyspaces", "keyspace definitions", "CREATE TABLE %s (keyspace_name text,durable_writes boolean,replication frozen<map<text, text>>,PRIMARY KEY ((keyspace_name)))");
    private static final TableMetadata Tables = SchemaKeyspace.parse("tables", "table definitions", "CREATE TABLE %s (keyspace_name text,table_name text,bloom_filter_fp_chance double,caching frozen<map<text, text>>,comment text,compaction frozen<map<text, text>>,compression frozen<map<text, text>>,crc_check_chance double,dclocal_read_repair_chance double,default_time_to_live int,extensions frozen<map<text, blob>>,flags frozen<set<text>>,gc_grace_seconds int,id uuid,max_index_interval int,memtable_flush_period_in_ms int,min_index_interval int,read_repair_chance double,speculative_retry text,additional_write_policy text,cdc boolean,read_repair text,PRIMARY KEY ((keyspace_name), table_name))");
    private static final TableMetadata Columns = SchemaKeyspace.parse("columns", "column definitions", "CREATE TABLE %s (keyspace_name text,table_name text,column_name text,clustering_order text,column_name_bytes blob,kind text,position int,type text,PRIMARY KEY ((keyspace_name), table_name, column_name))");
    private static final TableMetadata DroppedColumns = SchemaKeyspace.parse("dropped_columns", "dropped column registry", "CREATE TABLE %s (keyspace_name text,table_name text,column_name text,dropped_time timestamp,kind text,type text,PRIMARY KEY ((keyspace_name), table_name, column_name))");
    private static final TableMetadata Triggers = SchemaKeyspace.parse("triggers", "trigger definitions", "CREATE TABLE %s (keyspace_name text,table_name text,trigger_name text,options frozen<map<text, text>>,PRIMARY KEY ((keyspace_name), table_name, trigger_name))");
    private static final TableMetadata Views = SchemaKeyspace.parse("views", "view definitions", "CREATE TABLE %s (keyspace_name text,view_name text,base_table_id uuid,base_table_name text,where_clause text,bloom_filter_fp_chance double,caching frozen<map<text, text>>,comment text,compaction frozen<map<text, text>>,compression frozen<map<text, text>>,crc_check_chance double,dclocal_read_repair_chance double,default_time_to_live int,extensions frozen<map<text, blob>>,gc_grace_seconds int,id uuid,include_all_columns boolean,max_index_interval int,memtable_flush_period_in_ms int,min_index_interval int,read_repair_chance double,speculative_retry text,additional_write_policy text,cdc boolean,read_repair text,PRIMARY KEY ((keyspace_name), view_name))");
    private static final TableMetadata Indexes = SchemaKeyspace.parse("indexes", "secondary index definitions", "CREATE TABLE %s (keyspace_name text,table_name text,index_name text,kind text,options frozen<map<text, text>>,PRIMARY KEY ((keyspace_name), table_name, index_name))");
    private static final TableMetadata Types = SchemaKeyspace.parse("types", "user defined type definitions", "CREATE TABLE %s (keyspace_name text,type_name text,field_names frozen<list<text>>,field_types frozen<list<text>>,PRIMARY KEY ((keyspace_name), type_name))");
    private static final TableMetadata Functions = SchemaKeyspace.parse("functions", "user defined function definitions", "CREATE TABLE %s (keyspace_name text,function_name text,argument_types frozen<list<text>>,argument_names frozen<list<text>>,body text,language text,return_type text,called_on_null_input boolean,PRIMARY KEY ((keyspace_name), function_name, argument_types))");
    private static final TableMetadata Aggregates = SchemaKeyspace.parse("aggregates", "user defined aggregate definitions", "CREATE TABLE %s (keyspace_name text,aggregate_name text,argument_types frozen<list<text>>,final_func text,initcond text,return_type text,state_func text,state_type text,PRIMARY KEY ((keyspace_name), aggregate_name, argument_types))");
    private static final List<TableMetadata> ALL_TABLE_METADATA = ImmutableList.of((Object)Keyspaces, (Object)Tables, (Object)Columns, (Object)Triggers, (Object)DroppedColumns, (Object)Views, (Object)Types, (Object)Functions, (Object)Aggregates, (Object)Indexes);

    private SchemaKeyspace() {
    }

    private static TableMetadata parse(String name, String description, String cql) {
        return CreateTableStatement.parse(String.format(cql, name), "system_schema").id(TableId.forSystemTable("system_schema", name)).gcGraceSeconds((int)TimeUnit.DAYS.toSeconds(7L)).memtableFlushPeriod((int)TimeUnit.HOURS.toMillis(1L)).comment(description).build();
    }

    public static KeyspaceMetadata metadata() {
        return KeyspaceMetadata.create("system_schema", KeyspaceParams.local(), org.apache.cassandra.schema.Tables.of(ALL_TABLE_METADATA));
    }

    static Collection<Mutation> convertSchemaDiffToMutations(Keyspaces.KeyspacesDiff diff, long timestamp) {
        HashMap mutations = new HashMap();
        diff.created.forEach(k -> mutations.put(k.name, SchemaKeyspace.makeCreateKeyspaceMutation(k, timestamp).build()));
        diff.dropped.forEach(k -> mutations.put(k.name, SchemaKeyspace.makeDropKeyspaceMutation(k, timestamp).build()));
        diff.altered.forEach(kd -> {
            KeyspaceMetadata ks = kd.after;
            Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(ks.name, ks.params, timestamp);
            ((Types)kd.types.created).forEach(t -> SchemaKeyspace.addTypeToSchemaMutation(t, builder));
            ((Types)kd.types.dropped).forEach(t -> SchemaKeyspace.addDropTypeToSchemaMutation(t, builder));
            kd.types.altered(Difference.SHALLOW).forEach(td -> SchemaKeyspace.addTypeToSchemaMutation((UserType)td.after, builder));
            ((Tables)kd.tables.created).forEach(t -> SchemaKeyspace.addTableToSchemaMutation(t, true, builder));
            ((Tables)kd.tables.dropped).forEach(t -> SchemaKeyspace.addDropTableToSchemaMutation(t, builder));
            kd.tables.altered(Difference.SHALLOW).forEach(td -> SchemaKeyspace.addAlterTableToSchemaMutation((TableMetadata)td.before, (TableMetadata)td.after, builder));
            ((Views)kd.views.created).forEach(v -> SchemaKeyspace.addViewToSchemaMutation(v, true, builder));
            ((Views)kd.views.dropped).forEach(v -> SchemaKeyspace.addDropViewToSchemaMutation(v, builder));
            kd.views.altered(Difference.SHALLOW).forEach(vd -> SchemaKeyspace.addAlterViewToSchemaMutation((ViewMetadata)vd.before, (ViewMetadata)vd.after, builder));
            ((Functions)kd.udfs.created).forEach(f -> SchemaKeyspace.addFunctionToSchemaMutation((UDFunction)f, builder));
            ((Functions)kd.udfs.dropped).forEach(f -> SchemaKeyspace.addDropFunctionToSchemaMutation((UDFunction)f, builder));
            kd.udfs.altered(Difference.SHALLOW).forEach(fd -> SchemaKeyspace.addFunctionToSchemaMutation((UDFunction)fd.after, builder));
            ((Functions)kd.udas.created).forEach(a -> SchemaKeyspace.addAggregateToSchemaMutation((UDAggregate)a, builder));
            ((Functions)kd.udas.dropped).forEach(a -> SchemaKeyspace.addDropAggregateToSchemaMutation((UDAggregate)a, builder));
            kd.udas.altered(Difference.SHALLOW).forEach(ad -> SchemaKeyspace.addAggregateToSchemaMutation((UDAggregate)ad.after, builder));
            mutations.put(ks.name, builder.build());
        });
        return mutations.values();
    }

    public static void saveSystemKeyspacesSchema() {
        KeyspaceMetadata system = Schema.instance.getKeyspaceMetadata("system");
        KeyspaceMetadata schema = Schema.instance.getKeyspaceMetadata("system_schema");
        long timestamp = FBUtilities.timestampMicros();
        for (String schemaTable : ALL) {
            String query = String.format("DELETE FROM %s.%s USING TIMESTAMP ? WHERE keyspace_name = ?", "system_schema", schemaTable);
            for (String systemKeyspace : SchemaConstants.LOCAL_SYSTEM_KEYSPACE_NAMES) {
                QueryProcessor.executeOnceInternal(query, timestamp, systemKeyspace);
            }
        }
        SchemaKeyspace.makeCreateKeyspaceMutation(system, timestamp + 1L).build().apply();
        SchemaKeyspace.makeCreateKeyspaceMutation(schema, timestamp + 1L).build().apply();
    }

    public static void truncate() {
        ALL.reverse().forEach(table -> SchemaKeyspace.getSchemaCFS(table).truncateBlocking());
    }

    private static void flush() {
        if (!DatabaseDescriptor.isUnsafeSystem()) {
            ALL.forEach(table -> FBUtilities.waitOnFuture(SchemaKeyspace.getSchemaCFS(table).forceFlush()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static UUID calculateSchemaDigest() {
        Digest digest = Digest.forSchema();
        UnmodifiableIterator unmodifiableIterator = ALL.iterator();
        block26: while (unmodifiableIterator.hasNext()) {
            String table = (String)unmodifiableIterator.next();
            if (table.equals(DROPPED_COLUMNS)) continue;
            ReadCommand cmd = SchemaKeyspace.getReadCommandForTableSchema(table);
            ReadExecutionController executionController = cmd.executionController();
            Throwable throwable = null;
            try {
                PartitionIterator schema = cmd.executeInternal(executionController);
                Throwable throwable2 = null;
                try {
                    while (true) {
                        RowIterator partition;
                        block32: {
                            if (!schema.hasNext()) continue block26;
                            partition = (RowIterator)schema.next();
                            Throwable throwable3 = null;
                            try {
                                if (!SchemaKeyspace.isSystemKeyspaceSchemaPartition(partition.partitionKey())) {
                                    RowIterators.digest(partition, digest);
                                }
                                if (partition == null) continue;
                                if (throwable3 == null) break block32;
                            }
                            catch (Throwable throwable4) {
                                try {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (partition == null) throw throwable5;
                                    if (throwable3 != null) {
                                        try {
                                            partition.close();
                                            throw throwable5;
                                        }
                                        catch (Throwable throwable6) {
                                            throwable3.addSuppressed(throwable6);
                                            throw throwable5;
                                        }
                                    }
                                    partition.close();
                                    throw throwable5;
                                }
                            }
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (schema == null) continue;
                    if (throwable2 != null) {
                        try {
                            schema.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    schema.close();
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (executionController == null) continue;
                if (throwable != null) {
                    try {
                        executionController.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                executionController.close();
            }
        }
        return UUID.nameUUIDFromBytes(digest.digest());
    }

    private static ColumnFamilyStore getSchemaCFS(String schemaTableName) {
        return Keyspace.open("system_schema").getColumnFamilyStore(schemaTableName);
    }

    private static ReadCommand getReadCommandForTableSchema(String schemaTableName) {
        ColumnFamilyStore cfs = SchemaKeyspace.getSchemaCFS(schemaTableName);
        return PartitionRangeReadCommand.allDataRead(cfs.metadata(), FBUtilities.nowInSeconds());
    }

    static Collection<Mutation> convertSchemaToMutations() {
        HashMap<DecoratedKey, Mutation.PartitionUpdateCollector> mutationMap = new HashMap<DecoratedKey, Mutation.PartitionUpdateCollector>();
        for (String table : ALL) {
            SchemaKeyspace.convertSchemaToMutations(mutationMap, table);
        }
        return mutationMap.values().stream().map(Mutation.PartitionUpdateCollector::build).collect(Collectors.toList());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void convertSchemaToMutations(Map<DecoratedKey, Mutation.PartitionUpdateCollector> mutationMap, String schemaTableName) {
        ReadCommand cmd = SchemaKeyspace.getReadCommandForTableSchema(schemaTableName);
        try (ReadExecutionController executionController = cmd.executionController();
             UnfilteredPartitionIterator iter = cmd.executeLocally(executionController);){
            Throwable throwable;
            UnfilteredRowIterator partition;
            while (iter.hasNext()) {
                block39: {
                    block37: {
                        block38: {
                            partition = (UnfilteredRowIterator)iter.next();
                            throwable = null;
                            if (!SchemaKeyspace.isSystemKeyspaceSchemaPartition(partition.partitionKey())) break block37;
                            if (partition == null) continue;
                            if (throwable == null) break block38;
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        partition.close();
                        continue;
                    }
                    DecoratedKey key = partition.partitionKey();
                    Mutation.PartitionUpdateCollector puCollector = mutationMap.computeIfAbsent(key, k -> new Mutation.PartitionUpdateCollector("system_schema", key));
                    puCollector.add(SchemaKeyspace.makeUpdateForSchema(partition, cmd.columnFilter()));
                    if (partition == null) continue;
                    if (throwable == null) break block39;
                    try {
                        partition.close();
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        continue;
                    }
                }
                partition.close();
            }
            return;
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (partition == null) throw throwable5;
                    if (throwable != null) {
                        try {
                            partition.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                    partition.close();
                    throw throwable5;
                }
            }
        }
    }

    private static PartitionUpdate makeUpdateForSchema(UnfilteredRowIterator partition, ColumnFilter filter) {
        if (DatabaseDescriptor.isCDCEnabled() || !TABLES_WITH_CDC_ADDED.contains(partition.metadata().name)) {
            return PartitionUpdate.fromIterator(partition, filter);
        }
        ColumnFilter.Builder builder = ColumnFilter.allRegularColumnsBuilder(partition.metadata());
        for (ColumnMetadata column : filter.fetchedColumns()) {
            if (column.name.toString().equals("cdc")) continue;
            builder.add(column);
        }
        return PartitionUpdate.fromIterator(partition, builder.build());
    }

    private static boolean isSystemKeyspaceSchemaPartition(DecoratedKey partitionKey) {
        return SchemaConstants.isLocalSystemKeyspace((String)UTF8Type.instance.compose(partitionKey.getKey()));
    }

    private static DecoratedKey decorate(TableMetadata metadata, Object value) {
        return metadata.partitioner.decorateKey(metadata.partitionKeyType.decompose(value));
    }

    static Mutation.SimpleBuilder makeCreateKeyspaceMutation(String name, KeyspaceParams params, long timestamp) {
        Mutation.SimpleBuilder builder = Mutation.simpleBuilder(SchemaKeyspace.Keyspaces.keyspace, SchemaKeyspace.decorate(Keyspaces, name)).timestamp(timestamp);
        builder.update(Keyspaces).row(new Object[0]).add(KeyspaceParams.Option.DURABLE_WRITES.toString(), params.durableWrites).add(KeyspaceParams.Option.REPLICATION.toString(), params.replication.asMap());
        return builder;
    }

    static Mutation.SimpleBuilder makeCreateKeyspaceMutation(KeyspaceMetadata keyspace, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        keyspace.tables.forEach(table -> SchemaKeyspace.addTableToSchemaMutation(table, true, builder));
        keyspace.views.forEach(view -> SchemaKeyspace.addViewToSchemaMutation(view, true, builder));
        keyspace.types.forEach(type -> SchemaKeyspace.addTypeToSchemaMutation(type, builder));
        keyspace.functions.udfs().forEach(udf -> SchemaKeyspace.addFunctionToSchemaMutation(udf, builder));
        keyspace.functions.udas().forEach(uda -> SchemaKeyspace.addAggregateToSchemaMutation(uda, builder));
        return builder;
    }

    static Mutation.SimpleBuilder makeDropKeyspaceMutation(KeyspaceMetadata keyspace, long timestamp) {
        Mutation.SimpleBuilder builder = Mutation.simpleBuilder("system_schema", SchemaKeyspace.decorate(Keyspaces, keyspace.name)).timestamp(timestamp);
        for (TableMetadata schemaTable : ALL_TABLE_METADATA) {
            builder.update(schemaTable).delete();
        }
        return builder;
    }

    private static void addTypeToSchemaMutation(UserType type, Mutation.SimpleBuilder mutation) {
        mutation.update(Types).row(type.getNameAsString()).add("field_names", type.fieldNames().stream().map(FieldIdentifier::toString).collect(Collectors.toList())).add("field_types", type.fieldTypes().stream().map(AbstractType::asCQL3Type).map(Object::toString).collect(Collectors.toList()));
    }

    private static void addDropTypeToSchemaMutation(UserType type, Mutation.SimpleBuilder builder) {
        builder.update(Types).row(type.name).delete();
    }

    static Mutation.SimpleBuilder makeCreateTableMutation(KeyspaceMetadata keyspace, TableMetadata table, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTableToSchemaMutation(table, true, builder);
        return builder;
    }

    static void addTableToSchemaMutation(TableMetadata table, boolean withColumnsAndTriggers, Mutation.SimpleBuilder builder) {
        Row.SimpleBuilder rowBuilder = builder.update(Tables).row(table.name).add("id", table.id.asUUID()).add("flags", TableMetadata.Flag.toStringSet(table.flags));
        SchemaKeyspace.addTableParamsToRowBuilder(table.params, rowBuilder);
        if (withColumnsAndTriggers) {
            for (Object column : table.columns()) {
                SchemaKeyspace.addColumnToSchemaMutation(table, (ColumnMetadata)column, builder);
            }
            for (Object column : table.droppedColumns.values()) {
                SchemaKeyspace.addDroppedColumnToSchemaMutation(table, (DroppedColumn)column, builder);
            }
            for (TriggerMetadata trigger : table.triggers) {
                SchemaKeyspace.addTriggerToSchemaMutation(table, trigger, builder);
            }
            for (IndexMetadata index : table.indexes) {
                SchemaKeyspace.addIndexToSchemaMutation(table, index, builder);
            }
        }
    }

    private static void addTableParamsToRowBuilder(TableParams params, Row.SimpleBuilder builder) {
        builder.add("bloom_filter_fp_chance", params.bloomFilterFpChance).add("comment", params.comment).add("dclocal_read_repair_chance", 0.0).add("default_time_to_live", params.defaultTimeToLive).add("gc_grace_seconds", params.gcGraceSeconds).add("max_index_interval", params.maxIndexInterval).add("memtable_flush_period_in_ms", params.memtableFlushPeriodInMs).add("min_index_interval", params.minIndexInterval).add("read_repair_chance", 0.0).add("speculative_retry", params.speculativeRetry.toString()).add("additional_write_policy", params.additionalWritePolicy.toString()).add("crc_check_chance", params.crcCheckChance).add("caching", params.caching.asMap()).add("compaction", params.compaction.asMap()).add("compression", params.compression.asMap()).add("read_repair", params.readRepair.toString()).add("extensions", params.extensions);
        if (DatabaseDescriptor.isCDCEnabled()) {
            builder.add("cdc", params.cdc);
        }
    }

    private static void addAlterTableToSchemaMutation(TableMetadata oldTable, TableMetadata newTable, Mutation.SimpleBuilder builder) {
        SchemaKeyspace.addTableToSchemaMutation(newTable, false, builder);
        MapDifference columnDiff = Maps.difference(oldTable.columns, newTable.columns);
        for (ColumnMetadata column : columnDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(oldTable, column, builder);
        }
        for (ColumnMetadata column : columnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addColumnToSchemaMutation(newTable, column, builder);
        }
        for (Iterator name : columnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addColumnToSchemaMutation(newTable, newTable.getColumn((ByteBuffer)((Object)name)), builder);
        }
        MapDifference droppedColumnDiff = Maps.difference(oldTable.droppedColumns, newTable.droppedColumns);
        for (DroppedColumn column : droppedColumnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newTable, column, builder);
        }
        for (Iterator name : droppedColumnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newTable, (DroppedColumn)newTable.droppedColumns.get((Object)name), builder);
        }
        MapDifference<String, TriggerMetadata> triggerDiff = SchemaKeyspace.triggersDiff(oldTable.triggers, newTable.triggers);
        for (TriggerMetadata trigger : triggerDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropTriggerFromSchemaMutation(oldTable, trigger, builder);
        }
        for (TriggerMetadata trigger : triggerDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addTriggerToSchemaMutation(newTable, trigger, builder);
        }
        MapDifference<String, IndexMetadata> indexesDiff = SchemaKeyspace.indexesDiff(oldTable.indexes, newTable.indexes);
        for (IndexMetadata index : indexesDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropIndexFromSchemaMutation(oldTable, index, builder);
        }
        for (IndexMetadata index : indexesDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addIndexToSchemaMutation(newTable, index, builder);
        }
        for (MapDifference.ValueDifference diff : indexesDiff.entriesDiffering().values()) {
            SchemaKeyspace.addUpdatedIndexToSchemaMutation(newTable, (IndexMetadata)diff.rightValue(), builder);
        }
    }

    static Mutation.SimpleBuilder makeUpdateTableMutation(KeyspaceMetadata keyspace, TableMetadata oldTable, TableMetadata newTable, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addAlterTableToSchemaMutation(oldTable, newTable, builder);
        return builder;
    }

    private static MapDifference<String, IndexMetadata> indexesDiff(Indexes before, Indexes after) {
        HashMap beforeMap = new HashMap();
        before.forEach(i -> beforeMap.put(i.name, i));
        HashMap afterMap = new HashMap();
        after.forEach(i -> afterMap.put(i.name, i));
        return Maps.difference(beforeMap, afterMap);
    }

    private static MapDifference<String, TriggerMetadata> triggersDiff(Triggers before, Triggers after) {
        HashMap beforeMap = new HashMap();
        before.forEach(t -> beforeMap.put(t.name, t));
        HashMap afterMap = new HashMap();
        after.forEach(t -> afterMap.put(t.name, t));
        return Maps.difference(beforeMap, afterMap);
    }

    static Mutation.SimpleBuilder makeDropTableMutation(KeyspaceMetadata keyspace, TableMetadata table, long timestamp) {
        Mutation.SimpleBuilder builder = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addDropTableToSchemaMutation(table, builder);
        return builder;
    }

    private static void addDropTableToSchemaMutation(TableMetadata table, Mutation.SimpleBuilder builder) {
        builder.update(Tables).row(table.name).delete();
        for (Object column : table.columns()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(table, (ColumnMetadata)column, builder);
        }
        for (TriggerMetadata trigger : table.triggers) {
            SchemaKeyspace.dropTriggerFromSchemaMutation(table, trigger, builder);
        }
        for (Object column : table.droppedColumns.values()) {
            SchemaKeyspace.dropDroppedColumnFromSchemaMutation(table, (DroppedColumn)column, builder);
        }
        for (IndexMetadata index : table.indexes) {
            SchemaKeyspace.dropIndexFromSchemaMutation(table, index, builder);
        }
    }

    private static void addColumnToSchemaMutation(TableMetadata table, ColumnMetadata column, Mutation.SimpleBuilder builder) {
        AbstractType type = column.type;
        if (type instanceof ReversedType) {
            type = ((ReversedType)type).baseType;
        }
        builder.update(Columns).row(table.name, column.name.toString()).add("column_name_bytes", column.name.bytes).add("kind", column.kind.toString().toLowerCase()).add("position", column.position()).add("clustering_order", column.clusteringOrder().toString().toLowerCase()).add("type", type.asCQL3Type().toString());
    }

    private static void dropColumnFromSchemaMutation(TableMetadata table, ColumnMetadata column, Mutation.SimpleBuilder builder) {
        builder.update(Columns).row(table.name, column.name.toString()).delete();
    }

    private static void addDroppedColumnToSchemaMutation(TableMetadata table, DroppedColumn column, Mutation.SimpleBuilder builder) {
        builder.update(DroppedColumns).row(table.name, column.column.name.toString()).add("dropped_time", new Date(TimeUnit.MICROSECONDS.toMillis(column.droppedTime))).add("type", column.column.type.asCQL3Type().toString()).add("kind", column.column.kind.toString().toLowerCase());
    }

    private static void dropDroppedColumnFromSchemaMutation(TableMetadata table, DroppedColumn column, Mutation.SimpleBuilder builder) {
        builder.update(DroppedColumns).row(table.name, column.column.name.toString()).delete();
    }

    private static void addTriggerToSchemaMutation(TableMetadata table, TriggerMetadata trigger, Mutation.SimpleBuilder builder) {
        builder.update(Triggers).row(table.name, trigger.name).add("options", Collections.singletonMap("class", trigger.classOption));
    }

    private static void dropTriggerFromSchemaMutation(TableMetadata table, TriggerMetadata trigger, Mutation.SimpleBuilder builder) {
        builder.update(Triggers).row(table.name, trigger.name).delete();
    }

    private static void addViewToSchemaMutation(ViewMetadata view, boolean includeColumns, Mutation.SimpleBuilder builder) {
        TableMetadata table = view.metadata;
        Row.SimpleBuilder rowBuilder = builder.update(Views).row(view.name()).add("include_all_columns", view.includeAllColumns).add("base_table_id", view.baseTableId.asUUID()).add("base_table_name", view.baseTableName).add("where_clause", view.whereClause.toString()).add("id", table.id.asUUID());
        SchemaKeyspace.addTableParamsToRowBuilder(table.params, rowBuilder);
        if (includeColumns) {
            for (Object column : table.columns()) {
                SchemaKeyspace.addColumnToSchemaMutation(table, (ColumnMetadata)column, builder);
            }
            for (Object column : table.droppedColumns.values()) {
                SchemaKeyspace.addDroppedColumnToSchemaMutation(table, (DroppedColumn)column, builder);
            }
        }
    }

    private static void addDropViewToSchemaMutation(ViewMetadata view, Mutation.SimpleBuilder builder) {
        builder.update(Views).row(view.name()).delete();
        TableMetadata table = view.metadata;
        for (ColumnMetadata column : table.columns()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(table, column, builder);
        }
    }

    private static void addAlterViewToSchemaMutation(ViewMetadata before, ViewMetadata after, Mutation.SimpleBuilder builder) {
        SchemaKeyspace.addViewToSchemaMutation(after, false, builder);
        MapDifference columnDiff = Maps.difference(before.metadata.columns, after.metadata.columns);
        for (ColumnMetadata column : columnDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(before.metadata, column, builder);
        }
        for (ColumnMetadata column : columnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addColumnToSchemaMutation(after.metadata, column, builder);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addColumnToSchemaMutation(after.metadata, after.metadata.getColumn(name), builder);
        }
    }

    private static void addIndexToSchemaMutation(TableMetadata table, IndexMetadata index, Mutation.SimpleBuilder builder) {
        builder.update(Indexes).row(table.name, index.name).add("kind", index.kind.toString()).add("options", index.options);
    }

    private static void dropIndexFromSchemaMutation(TableMetadata table, IndexMetadata index, Mutation.SimpleBuilder builder) {
        builder.update(Indexes).row(table.name, index.name).delete();
    }

    private static void addUpdatedIndexToSchemaMutation(TableMetadata table, IndexMetadata index, Mutation.SimpleBuilder builder) {
        SchemaKeyspace.addIndexToSchemaMutation(table, index, builder);
    }

    private static void addFunctionToSchemaMutation(UDFunction function, Mutation.SimpleBuilder builder) {
        builder.update(Functions).row(function.name().name, function.argumentsList()).add("body", function.body()).add("language", function.language()).add("return_type", function.returnType().asCQL3Type().toString()).add("called_on_null_input", function.isCalledOnNullInput()).add("argument_names", function.argNames().stream().map(c -> SchemaKeyspace.bbToString(c.bytes)).collect(Collectors.toList()));
    }

    private static String bbToString(ByteBuffer bb) {
        try {
            return ByteBufferUtil.string(bb);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addDropFunctionToSchemaMutation(UDFunction function, Mutation.SimpleBuilder builder) {
        builder.update(Functions).row(function.name().name, function.argumentsList()).delete();
    }

    private static void addAggregateToSchemaMutation(UDAggregate aggregate, Mutation.SimpleBuilder builder) {
        builder.update(Aggregates).row(aggregate.name().name, aggregate.argumentsList()).add("return_type", aggregate.returnType().asCQL3Type().toString()).add("state_func", aggregate.stateFunction().name().name).add("state_type", aggregate.stateType().asCQL3Type().toString()).add("final_func", aggregate.finalFunction() != null ? aggregate.finalFunction().name().name : null).add("initcond", aggregate.initialCondition() != null ? aggregate.stateType().freeze().asCQL3Type().toCQLLiteral(aggregate.initialCondition(), ProtocolVersion.CURRENT) : null);
    }

    private static void addDropAggregateToSchemaMutation(UDAggregate aggregate, Mutation.SimpleBuilder builder) {
        builder.update(Aggregates).row(aggregate.name().name, aggregate.argumentsList()).delete();
    }

    static Keyspaces fetchNonSystemKeyspaces() {
        return SchemaKeyspace.fetchKeyspacesWithout(SchemaConstants.LOCAL_SYSTEM_KEYSPACE_NAMES);
    }

    private static Keyspaces fetchKeyspacesWithout(Set<String> excludedKeyspaceNames) {
        String query = String.format("SELECT keyspace_name FROM %s.%s", "system_schema", KEYSPACES);
        Keyspaces.Builder keyspaces = org.apache.cassandra.schema.Keyspaces.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, new Object[0])) {
            String keyspaceName = row.getString("keyspace_name");
            if (excludedKeyspaceNames.contains(keyspaceName)) continue;
            keyspaces.add(SchemaKeyspace.fetchKeyspace(keyspaceName));
        }
        return keyspaces.build();
    }

    private static KeyspaceMetadata fetchKeyspace(String keyspaceName) {
        KeyspaceParams params = SchemaKeyspace.fetchKeyspaceParams(keyspaceName);
        Types types = SchemaKeyspace.fetchTypes(keyspaceName);
        Tables tables = SchemaKeyspace.fetchTables(keyspaceName, types);
        Views views = SchemaKeyspace.fetchViews(keyspaceName, types);
        Functions functions = SchemaKeyspace.fetchFunctions(keyspaceName, types);
        return KeyspaceMetadata.create(keyspaceName, params, tables, views, types, functions);
    }

    private static KeyspaceParams fetchKeyspaceParams(String keyspaceName) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", KEYSPACES);
        UntypedResultSet.Row row = SchemaKeyspace.query(query, keyspaceName).one();
        boolean durableWrites = row.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString());
        Map<String, String> replication = row.getFrozenTextMap(KeyspaceParams.Option.REPLICATION.toString());
        return KeyspaceParams.create(durableWrites, replication);
    }

    private static Types fetchTypes(String keyspaceName) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", TYPES);
        Types.RawBuilder types = org.apache.cassandra.schema.Types.rawBuilder(keyspaceName);
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            String name = row.getString("type_name");
            List<String> fieldNames = row.getFrozenList("field_names", UTF8Type.instance);
            List<String> fieldTypes = row.getFrozenList("field_types", UTF8Type.instance);
            types.add(name, fieldNames, fieldTypes);
        }
        return types.build();
    }

    private static Tables fetchTables(String keyspaceName, Types types) {
        String query = String.format("SELECT table_name FROM %s.%s WHERE keyspace_name = ?", "system_schema", TABLES);
        Tables.Builder tables = org.apache.cassandra.schema.Tables.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            String tableName = row.getString("table_name");
            try {
                tables.add(SchemaKeyspace.fetchTable(keyspaceName, tableName, types));
            }
            catch (MissingColumns exc) {
                String errorMsg = String.format("No partition columns found for table %s.%s in %s.%s.  This may be due to corruption or concurrent dropping and altering of a table. If this table is supposed to be dropped, {}run the following query to cleanup: \"DELETE FROM %s.%s WHERE keyspace_name = '%s' AND table_name = '%s'; DELETE FROM %s.%s WHERE keyspace_name = '%s' AND table_name = '%s';\" If the table is not supposed to be dropped, restore %s.%s sstables from backups.", keyspaceName, tableName, "system_schema", COLUMNS, "system_schema", TABLES, keyspaceName, tableName, "system_schema", COLUMNS, keyspaceName, tableName, "system_schema", COLUMNS);
                if (IGNORE_CORRUPTED_SCHEMA_TABLES) {
                    logger.error(errorMsg, (Object)"", (Object)exc);
                    continue;
                }
                logger.error(errorMsg, (Object)"restart cassandra with -Dcassandra.ignore_corrupted_schema_tables=true and ");
                throw exc;
            }
        }
        return tables.build();
    }

    private static TableMetadata fetchTable(String keyspaceName, String tableName, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", TABLES);
        UntypedResultSet rows = SchemaKeyspace.query(query, keyspaceName, tableName);
        if (rows.isEmpty()) {
            throw new RuntimeException(String.format("%s:%s not found in the schema definitions keyspace.", keyspaceName, tableName));
        }
        UntypedResultSet.Row row = rows.one();
        Set<TableMetadata.Flag> flags = TableMetadata.Flag.fromStringSet(row.getFrozenSet("flags", UTF8Type.instance));
        if (!TableMetadata.Flag.isCQLCompatible(flags)) {
            throw new IllegalArgumentException("Compact Tables are not allowed in Cassandra starting with 4.0 version. Use `ALTER ... DROP COMPACT STORAGE` command supplied in 3.x/3.11 Cassandra in order to migrate off Compact Storage.");
        }
        return TableMetadata.builder(keyspaceName, tableName, TableId.fromUUID(row.getUUID("id"))).flags(flags).params(SchemaKeyspace.createTableParamsFromRow(row)).addColumns(SchemaKeyspace.fetchColumns(keyspaceName, tableName, types)).droppedColumns(SchemaKeyspace.fetchDroppedColumns(keyspaceName, tableName)).indexes(SchemaKeyspace.fetchIndexes(keyspaceName, tableName)).triggers(SchemaKeyspace.fetchTriggers(keyspaceName, tableName)).build();
    }

    static TableParams createTableParamsFromRow(UntypedResultSet.Row row) {
        return TableParams.builder().bloomFilterFpChance(row.getDouble("bloom_filter_fp_chance")).caching(CachingParams.fromMap(row.getFrozenTextMap("caching"))).comment(row.getString("comment")).compaction(CompactionParams.fromMap(row.getFrozenTextMap("compaction"))).compression(CompressionParams.fromMap(row.getFrozenTextMap("compression"))).defaultTimeToLive(row.getInt("default_time_to_live")).extensions(row.getFrozenMap("extensions", UTF8Type.instance, BytesType.instance)).gcGraceSeconds(row.getInt("gc_grace_seconds")).maxIndexInterval(row.getInt("max_index_interval")).memtableFlushPeriodInMs(row.getInt("memtable_flush_period_in_ms")).minIndexInterval(row.getInt("min_index_interval")).crcCheckChance(row.getDouble("crc_check_chance")).speculativeRetry(SpeculativeRetryPolicy.fromString(row.getString("speculative_retry"))).additionalWritePolicy(row.has("additional_write_policy") ? SpeculativeRetryPolicy.fromString(row.getString("additional_write_policy")) : SpeculativeRetryPolicy.fromString("99PERCENTILE")).cdc(row.has("cdc") && row.getBoolean("cdc")).readRepair(SchemaKeyspace.getReadRepairStrategy(row)).build();
    }

    private static List<ColumnMetadata> fetchColumns(String keyspace, String table, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", COLUMNS);
        UntypedResultSet columnRows = SchemaKeyspace.query(query, keyspace, table);
        if (columnRows.isEmpty()) {
            throw new MissingColumns("Columns not found in schema table for " + keyspace + '.' + table);
        }
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        columnRows.forEach(row -> columns.add(SchemaKeyspace.createColumnFromRow(row, types)));
        if (columns.stream().noneMatch(ColumnMetadata::isPartitionKey)) {
            throw new MissingColumns("No partition key columns found in schema table for " + keyspace + "." + table);
        }
        return columns;
    }

    static ColumnMetadata createColumnFromRow(UntypedResultSet.Row row, Types types) {
        String keyspace = row.getString("keyspace_name");
        String table = row.getString("table_name");
        ColumnMetadata.Kind kind = ColumnMetadata.Kind.valueOf(row.getString("kind").toUpperCase());
        int position = row.getInt("position");
        ColumnMetadata.ClusteringOrder order = ColumnMetadata.ClusteringOrder.valueOf(row.getString("clustering_order").toUpperCase());
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), types);
        if (order == ColumnMetadata.ClusteringOrder.DESC) {
            type = ReversedType.getInstance(type);
        }
        ColumnIdentifier name = new ColumnIdentifier(row.getBytes("column_name_bytes"), row.getString("column_name"));
        return new ColumnMetadata(keyspace, table, name, type, position, kind);
    }

    private static Map<ByteBuffer, DroppedColumn> fetchDroppedColumns(String keyspace, String table) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", DROPPED_COLUMNS);
        HashMap<ByteBuffer, DroppedColumn> columns = new HashMap<ByteBuffer, DroppedColumn>();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspace, table)) {
            DroppedColumn column = SchemaKeyspace.createDroppedColumnFromRow(row);
            columns.put(column.column.name.bytes, column);
        }
        return columns;
    }

    private static DroppedColumn createDroppedColumnFromRow(UntypedResultSet.Row row) {
        ColumnMetadata.Kind kind;
        String keyspace = row.getString("keyspace_name");
        String table = row.getString("table_name");
        String name = row.getString("column_name");
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), org.apache.cassandra.schema.Types.none());
        ColumnMetadata.Kind kind2 = kind = row.has("kind") ? ColumnMetadata.Kind.valueOf(row.getString("kind").toUpperCase()) : ColumnMetadata.Kind.REGULAR;
        assert (kind == ColumnMetadata.Kind.REGULAR || kind == ColumnMetadata.Kind.STATIC) : "Unexpected dropped column kind: " + kind.toString();
        ColumnMetadata column = new ColumnMetadata(keyspace, table, ColumnIdentifier.getInterned(name, true), type, -1, kind);
        long droppedTime = TimeUnit.MILLISECONDS.toMicros(row.getLong("dropped_time"));
        return new DroppedColumn(column, droppedTime);
    }

    private static Indexes fetchIndexes(String keyspace, String table) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", INDEXES);
        Indexes.Builder indexes = org.apache.cassandra.schema.Indexes.builder();
        SchemaKeyspace.query(query, keyspace, table).forEach(row -> indexes.add(SchemaKeyspace.createIndexMetadataFromRow(row)));
        return indexes.build();
    }

    private static IndexMetadata createIndexMetadataFromRow(UntypedResultSet.Row row) {
        String name = row.getString("index_name");
        IndexMetadata.Kind type = IndexMetadata.Kind.valueOf(row.getString("kind"));
        Map<String, String> options = row.getFrozenTextMap("options");
        return IndexMetadata.fromSchemaMetadata(name, type, options);
    }

    private static Triggers fetchTriggers(String keyspace, String table) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", TRIGGERS);
        Triggers.Builder triggers = org.apache.cassandra.schema.Triggers.builder();
        SchemaKeyspace.query(query, keyspace, table).forEach(row -> triggers.add(SchemaKeyspace.createTriggerFromRow(row)));
        return triggers.build();
    }

    private static TriggerMetadata createTriggerFromRow(UntypedResultSet.Row row) {
        String name = row.getString("trigger_name");
        String classOption = row.getFrozenTextMap("options").get("class");
        return new TriggerMetadata(name, classOption);
    }

    private static Views fetchViews(String keyspaceName, Types types) {
        String query = String.format("SELECT view_name FROM %s.%s WHERE keyspace_name = ?", "system_schema", VIEWS);
        Views.Builder views = org.apache.cassandra.schema.Views.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            views.put(SchemaKeyspace.fetchView(keyspaceName, row.getString("view_name"), types));
        }
        return views.build();
    }

    private static ViewMetadata fetchView(String keyspaceName, String viewName, Types types) {
        WhereClause whereClause;
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND view_name = ?", "system_schema", VIEWS);
        UntypedResultSet rows = SchemaKeyspace.query(query, keyspaceName, viewName);
        if (rows.isEmpty()) {
            throw new RuntimeException(String.format("%s:%s not found in the schema definitions keyspace.", keyspaceName, viewName));
        }
        UntypedResultSet.Row row = rows.one();
        TableId baseTableId = TableId.fromUUID(row.getUUID("base_table_id"));
        String baseTableName = row.getString("base_table_name");
        boolean includeAll = row.getBoolean("include_all_columns");
        String whereClauseString = row.getString("where_clause");
        List<ColumnMetadata> columns = SchemaKeyspace.fetchColumns(keyspaceName, viewName, types);
        TableMetadata metadata = TableMetadata.builder(keyspaceName, viewName, TableId.fromUUID(row.getUUID("id"))).kind(TableMetadata.Kind.VIEW).addColumns(columns).droppedColumns(SchemaKeyspace.fetchDroppedColumns(keyspaceName, viewName)).params(SchemaKeyspace.createTableParamsFromRow(row)).build();
        try {
            whereClause = WhereClause.parse(whereClauseString);
        }
        catch (RecognitionException e) {
            throw new RuntimeException(String.format("Unexpected error while parsing materialized view's where clause for '%s' (got %s)", viewName, whereClauseString));
        }
        return new ViewMetadata(baseTableId, baseTableName, includeAll, whereClause, metadata);
    }

    private static Functions fetchFunctions(String keyspaceName, Types types) {
        Collection<UDFunction> udfs = SchemaKeyspace.fetchUDFs(keyspaceName, types);
        Collection<UDAggregate> udas = SchemaKeyspace.fetchUDAs(keyspaceName, udfs, types);
        return org.apache.cassandra.schema.Functions.builder().add(udfs).add(udas).build();
    }

    private static Collection<UDFunction> fetchUDFs(String keyspaceName, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", FUNCTIONS);
        ArrayList<UDFunction> functions = new ArrayList<UDFunction>();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            functions.add(SchemaKeyspace.createUDFFromRow(row, types));
        }
        return functions;
    }

    private static UDFunction createUDFFromRow(UntypedResultSet.Row row, Types types) {
        UDFunction udf;
        String ksName = row.getString("keyspace_name");
        String functionName = row.getString("function_name");
        FunctionName name = new FunctionName(ksName, functionName);
        ArrayList<ColumnIdentifier> argNames = new ArrayList<ColumnIdentifier>();
        for (String string : row.getFrozenList("argument_names", UTF8Type.instance)) {
            argNames.add(new ColumnIdentifier(string, true));
        }
        ArrayList argTypes = new ArrayList();
        for (String type : row.getFrozenList("argument_types", UTF8Type.instance)) {
            argTypes.add(CQLTypeParser.parse(ksName, type, types));
        }
        AbstractType<?> abstractType = CQLTypeParser.parse(ksName, row.getString("return_type"), types);
        String language = row.getString("language");
        String body = row.getString("body");
        boolean calledOnNullInput = row.getBoolean("called_on_null_input");
        Function existing = Schema.instance.findFunction(name, argTypes).orElse(null);
        if (existing instanceof UDFunction && (udf = (UDFunction)existing).argNames().equals(argNames) && udf.argTypes().equals(argTypes) && udf.returnType().equals(abstractType) && !udf.isAggregate() && udf.language().equals(language) && udf.body().equals(body) && udf.isCalledOnNullInput() == calledOnNullInput) {
            logger.trace("Skipping duplicate compilation of already existing UDF {}", (Object)name);
            return udf;
        }
        try {
            return UDFunction.create(name, argNames, argTypes, abstractType, calledOnNullInput, language, body);
        }
        catch (InvalidRequestException e) {
            logger.error(String.format("Cannot load function '%s' from schema: this function won't be available (on this node)", name), (Throwable)e);
            return UDFunction.createBrokenFunction(name, argNames, argTypes, abstractType, calledOnNullInput, language, body, e);
        }
    }

    private static Collection<UDAggregate> fetchUDAs(String keyspaceName, Collection<UDFunction> udfs, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", AGGREGATES);
        ArrayList<UDAggregate> aggregates = new ArrayList<UDAggregate>();
        SchemaKeyspace.query(query, keyspaceName).forEach(row -> aggregates.add(SchemaKeyspace.createUDAFromRow(row, udfs, types)));
        return aggregates;
    }

    private static UDAggregate createUDAFromRow(UntypedResultSet.Row row, Collection<UDFunction> functions, Types types) {
        String ksName = row.getString("keyspace_name");
        String functionName = row.getString("aggregate_name");
        FunctionName name = new FunctionName(ksName, functionName);
        List<AbstractType<?>> argTypes = row.getFrozenList("argument_types", UTF8Type.instance).stream().map(t -> CQLTypeParser.parse(ksName, t, types)).collect(Collectors.toList());
        AbstractType<?> returnType = CQLTypeParser.parse(ksName, row.getString("return_type"), types);
        FunctionName stateFunc = new FunctionName(ksName, row.getString("state_func"));
        FunctionName finalFunc = row.has("final_func") ? new FunctionName(ksName, row.getString("final_func")) : null;
        AbstractType<?> stateType = row.has("state_type") ? CQLTypeParser.parse(ksName, row.getString("state_type"), types) : null;
        ByteBuffer initcond = row.has("initcond") ? Terms.asBytes(ksName, row.getString("initcond"), stateType) : null;
        return UDAggregate.create(functions, name, argTypes, returnType, stateFunc, finalFunc, stateType, initcond);
    }

    private static UntypedResultSet query(String query, Object ... variables) {
        return QueryProcessor.executeInternal(query, variables);
    }

    static Set<String> affectedKeyspaces(Collection<Mutation> mutations) {
        return mutations.stream().map(m -> (String)UTF8Type.instance.compose(m.key().getKey())).collect(Collectors.toSet());
    }

    static void applyChanges(Collection<Mutation> mutations) {
        mutations.forEach(Mutation::apply);
        if (FLUSH_SCHEMA_TABLES) {
            SchemaKeyspace.flush();
        }
    }

    static Keyspaces fetchKeyspaces(Set<String> toFetch) {
        String query = String.format("SELECT keyspace_name FROM %s.%s WHERE keyspace_name IN ?", "system_schema", KEYSPACES);
        Keyspaces.Builder keyspaces = org.apache.cassandra.schema.Keyspaces.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, new ArrayList<String>(toFetch))) {
            keyspaces.add(SchemaKeyspace.fetchKeyspace(row.getString("keyspace_name")));
        }
        return keyspaces.build();
    }

    private static ReadRepairStrategy getReadRepairStrategy(UntypedResultSet.Row row) {
        return row.has("read_repair") ? ReadRepairStrategy.fromString(row.getString("read_repair")) : ReadRepairStrategy.BLOCKING;
    }

    @VisibleForTesting
    static class MissingColumns
    extends RuntimeException {
        MissingColumns(String message) {
            super(message);
        }
    }
}

