/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.TableRepairManager;
import org.apache.cassandra.repair.ValidationPartitionIterator;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.apache.cassandra.utils.MerkleTrees;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationManager {
    private static final Logger logger = LoggerFactory.getLogger(ValidationManager.class);
    public static final ValidationManager instance = new ValidationManager();

    private ValidationManager() {
    }

    private static MerkleTrees createMerkleTrees(ValidationPartitionIterator validationIterator, Collection<Range<Token>> ranges, ColumnFamilyStore cfs) {
        MerkleTrees tree = new MerkleTrees(cfs.getPartitioner());
        long allPartitions = validationIterator.estimatedPartitions();
        Map<Range<Token>, Long> rangePartitionCounts = validationIterator.getRangePartitionCounts();
        long availableBytes = DatabaseDescriptor.getRepairSessionSpaceInMegabytes() * 0x100000 / cfs.keyspace.getReplicationStrategy().getReplicationFactor().allReplicas;
        for (Range<Token> range : ranges) {
            long numPartitions = rangePartitionCounts.get(range);
            double rangeOwningRatio = allPartitions > 0L ? (double)numPartitions / (double)allPartitions : 0.0;
            int rangeAvailableBytes = Math.max(1, (int)(rangeOwningRatio * (double)availableBytes));
            int estimatedMaxDepth = MerkleTree.estimatedMaxDepthForBytes(cfs.getPartitioner(), rangeAvailableBytes, 32);
            int maxDepth = rangeOwningRatio > 0.0 ? Math.min(estimatedMaxDepth, DatabaseDescriptor.getRepairSessionMaxTreeDepth()) : 0;
            int depth = numPartitions > 0L ? (int)Math.min(Math.ceil(Math.log(numPartitions) / Math.log(2.0)), (double)maxDepth) : 0;
            tree.addMerkleTree((int)Math.pow(2.0, depth), range);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created {} merkle trees with merkle trees size {}, {} partitions, {} bytes", new Object[]{tree.ranges().size(), tree.size(), allPartitions, MerkleTrees.serializer.serializedSize(tree, 0)});
        }
        return tree;
    }

    private static ValidationPartitionIterator getValidationIterator(TableRepairManager repairManager, Validator validator) throws IOException {
        RepairJobDesc desc = validator.desc;
        return repairManager.getValidationIterator(desc.ranges, desc.parentSessionId, desc.sessionId, validator.isIncremental, validator.nowInSec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidation(ColumnFamilyStore cfs, Validator validator) throws IOException {
        if (!cfs.isValid()) {
            return;
        }
        long start = System.nanoTime();
        long partitionCount = 0L;
        long estimatedTotalBytes = 0L;
        try (ValidationPartitionIterator vi = ValidationManager.getValidationIterator(cfs.getRepairManager(), validator);){
            MerkleTrees tree = ValidationManager.createMerkleTrees(vi, validator.desc.ranges, cfs);
            try {
                validator.prepare(cfs, tree);
                while (vi.hasNext()) {
                    UnfilteredRowIterator partition = (UnfilteredRowIterator)vi.next();
                    Throwable throwable = null;
                    try {
                        validator.add(partition);
                        ++partitionCount;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (partition == null) continue;
                        if (throwable != null) {
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                validator.complete();
            }
            finally {
                estimatedTotalBytes = vi.getEstimatedBytes();
                partitionCount = vi.estimatedPartitions();
            }
        }
        finally {
            cfs.metric.bytesValidated.update(estimatedTotalBytes);
            cfs.metric.partitionsValidated.update(partitionCount);
        }
        if (logger.isDebugEnabled()) {
            long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            logger.debug("Validation of {} partitions (~{}) finished in {} msec, for {}", new Object[]{partitionCount, FBUtilities.prettyPrintMemory(estimatedTotalBytes), duration, validator.desc});
        }
    }

    public Future<?> submitValidation(final ColumnFamilyStore cfs, final Validator validator) {
        Callable<Object> validation = new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                try (TableMetrics.TableTimer.Context c = cfs.metric.validationTime.time();){
                    ValidationManager.this.doValidation(cfs, validator);
                }
                catch (Throwable e) {
                    validator.fail();
                    throw e;
                }
                return this;
            }
        };
        return cfs.getRepairManager().submitValidation(validation);
    }
}

