/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.cache.CounterCacheKey;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.CassandraTableWriteHandler;
import org.apache.cassandra.db.ClockAndCount;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DiskBoundaries;
import org.apache.cassandra.db.DiskBoundaryManager;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SSTableImporter;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.StorageHook;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.TableCQLHelper;
import org.apache.cassandra.db.TableWriteHandler;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.Verifier;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.repair.CassandraTableRepairManager;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.streaming.CassandraStreamManager;
import org.apache.cassandra.db.view.TableViews;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.StartupException;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.Sampler;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.repair.TableRepairManager;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.TableStreamManager;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.DefaultValue;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyStore
implements ColumnFamilyStoreMBean {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyStore.class);
    private static final ExecutorService flushExecutor = new JMXEnabledThreadPoolExecutor(DatabaseDescriptor.getFlushWriters(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("MemtableFlushWriter"), "internal");
    private static final ExecutorService[] perDiskflushExecutors = new ExecutorService[DatabaseDescriptor.getAllDataFileLocations().length];
    private static final ExecutorService postFlushExecutor;
    private static final ExecutorService reclaimExecutor;
    private static final String[] COUNTER_NAMES;
    private static final String[] COUNTER_DESCS;
    private static final CompositeType COUNTER_COMPOSITE_TYPE;
    private static final String SAMPLING_RESULTS_NAME = "SAMPLING_RESULTS";
    public static final String SNAPSHOT_TRUNCATE_PREFIX = "truncated";
    public static final String SNAPSHOT_DROP_PREFIX = "dropped";
    public final Keyspace keyspace;
    public final String name;
    public final TableMetadataRef metadata;
    private final String mbeanName;
    @Deprecated
    private final String oldMBeanName;
    private volatile boolean valid = true;
    private final Tracker data;
    public final OpOrder readOrdering = new OpOrder();
    private final AtomicInteger fileIndexGenerator = new AtomicInteger(0);
    public final SecondaryIndexManager indexManager;
    public final TableViews viewManager;
    private volatile DefaultValue<Integer> minCompactionThreshold;
    private volatile DefaultValue<Integer> maxCompactionThreshold;
    private volatile DefaultValue<Double> crcCheckChance;
    private final CompactionStrategyManager compactionStrategyManager;
    private final Directories directories;
    public final TableMetrics metric;
    public volatile long sampleReadLatencyNanos;
    public volatile long additionalWriteLatencyNanos;
    private final CassandraTableWriteHandler writeHandler;
    private final CassandraStreamManager streamManager;
    private final TableRepairManager repairManager;
    private final SSTableImporter sstableImporter;
    private volatile boolean compactionSpaceCheck = true;
    @VisibleForTesting
    final DiskBoundaryManager diskBoundaryManager = new DiskBoundaryManager();
    private volatile boolean neverPurgeTombstones = false;

    public static void shutdownPostFlushExecutor() throws InterruptedException {
        postFlushExecutor.shutdown();
        postFlushExecutor.awaitTermination(60L, TimeUnit.SECONDS);
    }

    public static void shutdownExecutorsAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ArrayList executors = new ArrayList(perDiskflushExecutors.length + 3);
        Collections.addAll(executors, reclaimExecutor, postFlushExecutor, flushExecutor);
        Collections.addAll(executors, perDiskflushExecutors);
        ExecutorUtils.shutdownAndWait(timeout, unit, executors);
    }

    public void reload() {
        if (!this.minCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.minCompactionThreshold = new DefaultValue<Integer>(this.metadata().params.compaction.minCompactionThreshold());
            }
        }
        if (!this.maxCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.maxCompactionThreshold = new DefaultValue<Integer>(this.metadata().params.compaction.maxCompactionThreshold());
            }
        }
        if (!this.crcCheckChance.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.crcCheckChance = new DefaultValue<Double>(this.metadata().params.crcCheckChance);
            }
        }
        this.compactionStrategyManager.maybeReload(this.metadata());
        this.scheduleFlush();
        this.indexManager.reload();
        if (this.data.getView().getCurrentMemtable().initialComparator != this.metadata().comparator) {
            this.switchMemtable();
        }
    }

    void scheduleFlush() {
        int period = this.metadata().params.memtableFlushPeriodInMs;
        if (period > 0) {
            logger.trace("scheduling flush in {} ms", (Object)period);
            WrappedRunnable runnable = new WrappedRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void runMayThrow() {
                    Tracker tracker = ColumnFamilyStore.this.data;
                    synchronized (tracker) {
                        Memtable current = ColumnFamilyStore.this.data.getView().getCurrentMemtable();
                        if (current.isExpired()) {
                            if (current.isClean()) {
                                ColumnFamilyStore.this.scheduleFlush();
                            } else {
                                ColumnFamilyStore.this.forceFlush();
                            }
                        }
                    }
                }
            };
            ScheduledExecutors.scheduledTasks.schedule(runnable, (long)period, TimeUnit.MILLISECONDS);
        }
    }

    public static Runnable getBackgroundCompactionTaskSubmitter() {
        return new Runnable(){

            @Override
            public void run() {
                for (Keyspace keyspace : Keyspace.all()) {
                    for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                        CompactionManager.instance.submitBackground(cfs);
                    }
                }
            }
        };
    }

    @Override
    public Map<String, String> getCompactionParameters() {
        return this.compactionStrategyManager.getCompactionParams().asMap();
    }

    @Override
    public String getCompactionParametersJson() {
        return FBUtilities.json(this.getCompactionParameters());
    }

    @Override
    public void setCompactionParameters(Map<String, String> options) {
        try {
            CompactionParams compactionParams = CompactionParams.fromMap(options);
            compactionParams.validate();
            this.compactionStrategyManager.setNewLocalCompactionStrategy(compactionParams);
        }
        catch (Throwable t) {
            logger.error("Could not set new local compaction strategy", t);
            throw new IllegalArgumentException("Could not set new local compaction strategy: " + t.getMessage());
        }
    }

    @Override
    public void setCompactionParametersJson(String options) {
        this.setCompactionParameters(FBUtilities.fromJsonMap(options));
    }

    @Override
    public Map<String, String> getCompressionParameters() {
        return this.metadata().params.compression.asMap();
    }

    @Override
    public String getCompressionParametersJson() {
        return FBUtilities.json(this.getCompressionParameters());
    }

    @Override
    public void setCompressionParameters(Map<String, String> opts) {
        try {
            CompressionParams params = CompressionParams.fromMap(opts);
            params.validate();
            throw new UnsupportedOperationException();
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void setCompressionParametersJson(String options) {
        this.setCompressionParameters(FBUtilities.fromJsonMap(options));
    }

    @VisibleForTesting
    public ColumnFamilyStore(Keyspace keyspace, String columnFamilyName, int generation, TableMetadataRef metadata, Directories directories, boolean loadSSTables, boolean registerBookeeping, boolean offline) {
        assert (directories != null);
        assert (metadata != null) : "null metadata for " + keyspace + ":" + columnFamilyName;
        this.keyspace = keyspace;
        this.metadata = metadata;
        this.directories = directories;
        this.name = columnFamilyName;
        this.minCompactionThreshold = new DefaultValue<Integer>(metadata.get().params.compaction.minCompactionThreshold());
        this.maxCompactionThreshold = new DefaultValue<Integer>(metadata.get().params.compaction.maxCompactionThreshold());
        this.crcCheckChance = new DefaultValue<Double>(metadata.get().params.crcCheckChance);
        this.viewManager = keyspace.viewManager.forTable(metadata.id);
        this.metric = new TableMetrics(this);
        this.fileIndexGenerator.set(generation);
        this.sampleReadLatencyNanos = DatabaseDescriptor.getReadRpcTimeout(TimeUnit.NANOSECONDS) / 2L;
        this.additionalWriteLatencyNanos = DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.NANOSECONDS) / 2L;
        logger.info("Initializing {}.{}", (Object)keyspace.getName(), (Object)this.name);
        Memtable initialMemtable = null;
        if (DatabaseDescriptor.isDaemonInitialized()) {
            initialMemtable = new Memtable(new AtomicReference<CommitLogPosition>(CommitLog.instance.getCurrentPosition()), this);
        }
        this.data = new Tracker(initialMemtable, loadSSTables);
        if (this.data.loadsstables) {
            Directories.SSTableLister sstableFiles = directories.sstableLister(Directories.OnTxnErr.IGNORE).skipTemporary(true);
            Collection<SSTableReader> sstables = SSTableReader.openAll(sstableFiles.list().entrySet(), metadata);
            this.data.addInitialSSTables(sstables);
        }
        this.compactionStrategyManager = new CompactionStrategyManager(this);
        if (this.maxCompactionThreshold.value() <= 0 || this.minCompactionThreshold.value() <= 0) {
            logger.warn("Disabling compaction strategy by setting compaction thresholds to 0 is deprecated, set the compaction option 'enabled' to 'false' instead.");
            this.compactionStrategyManager.disable();
        }
        this.indexManager = new SecondaryIndexManager(this);
        for (IndexMetadata info : metadata.get().indexes) {
            this.indexManager.addIndex(info, true);
        }
        if (registerBookeeping) {
            String[] objectNames;
            this.mbeanName = String.format("org.apache.cassandra.db:type=%s,keyspace=%s,table=%s", this.isIndex() ? "IndexTables" : "Tables", keyspace.getName(), this.name);
            this.oldMBeanName = String.format("org.apache.cassandra.db:type=%s,keyspace=%s,columnfamily=%s", this.isIndex() ? "IndexColumnFamilies" : "ColumnFamilies", keyspace.getName(), this.name);
            for (String objectName : objectNames = new String[]{this.mbeanName, this.oldMBeanName}) {
                MBeanWrapper.instance.registerMBean((Object)this, objectName);
            }
        } else {
            this.mbeanName = null;
            this.oldMBeanName = null;
        }
        this.writeHandler = new CassandraTableWriteHandler(this);
        this.streamManager = new CassandraStreamManager(this);
        this.repairManager = new CassandraTableRepairManager(this);
        this.sstableImporter = new SSTableImporter(this);
    }

    public void updateSpeculationThreshold() {
        try {
            this.sampleReadLatencyNanos = this.metadata().params.speculativeRetry.calculateThreshold(this.metric.coordinatorReadLatency.getSnapshot(), this.sampleReadLatencyNanos);
            this.additionalWriteLatencyNanos = this.metadata().params.additionalWritePolicy.calculateThreshold(this.metric.coordinatorWriteLatency.getSnapshot(), this.additionalWriteLatencyNanos);
        }
        catch (Throwable e) {
            logger.error("Exception caught while calculating speculative retry threshold for {}: {}", (Object)this.metadata(), (Object)e);
        }
    }

    public TableWriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    public TableStreamManager getStreamManager() {
        return this.streamManager;
    }

    public TableRepairManager getRepairManager() {
        return this.repairManager;
    }

    public TableMetadata metadata() {
        return this.metadata.get();
    }

    public Directories getDirectories() {
        return this.directories;
    }

    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, UUID pendingRepair, boolean isTransient, int sstableLevel, SerializationHeader header, LifecycleNewTracker lifecycleNewTracker) {
        MetadataCollector collector = new MetadataCollector(this.metadata().comparator).sstableLevel(sstableLevel);
        return this.createSSTableMultiWriter(descriptor, keyCount, repairedAt, pendingRepair, isTransient, collector, header, lifecycleNewTracker);
    }

    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, UUID pendingRepair, boolean isTransient, MetadataCollector metadataCollector, SerializationHeader header, LifecycleNewTracker lifecycleNewTracker) {
        return this.getCompactionStrategyManager().createSSTableMultiWriter(descriptor, keyCount, repairedAt, pendingRepair, isTransient, metadataCollector, header, this.indexManager.listIndexes(), lifecycleNewTracker);
    }

    public boolean supportsEarlyOpen() {
        return this.compactionStrategyManager.supportsEarlyOpen();
    }

    public void invalidate() {
        this.invalidate(true);
    }

    public void invalidate(boolean expectMBean) {
        block2: {
            this.valid = false;
            try {
                this.unregisterMBean();
            }
            catch (Exception e) {
                if (!expectMBean) break block2;
                JVMStabilityInspector.inspectThrowable(e);
                logger.warn("Failed unregistering mbean: {}", (Object)this.mbeanName, (Object)e);
            }
        }
        this.compactionStrategyManager.shutdown();
        SystemKeyspace.removeTruncationRecord(this.metadata.id);
        this.data.dropSSTables();
        LifecycleTransaction.waitForDeletions();
        this.indexManager.dropAllIndexes();
        this.invalidateCaches();
    }

    void maybeRemoveUnreadableSSTables(File directory) {
        this.data.removeUnreadableSSTables(directory);
    }

    void unregisterMBean() throws MalformedObjectNameException {
        ObjectName[] objectNames;
        for (ObjectName objectName : objectNames = new ObjectName[]{new ObjectName(this.mbeanName), new ObjectName(this.oldMBeanName)}) {
            if (!MBeanWrapper.instance.isRegistered(objectName)) continue;
            MBeanWrapper.instance.unregisterMBean(objectName);
        }
        this.metric.release();
    }

    public static ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, TableMetadataRef metadata, boolean loadSSTables) {
        return ColumnFamilyStore.createColumnFamilyStore(keyspace, metadata.name, metadata, loadSSTables);
    }

    public static synchronized ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, String columnFamily, TableMetadataRef metadata, boolean loadSSTables) {
        Directories directories = new Directories(metadata.get());
        return ColumnFamilyStore.createColumnFamilyStore(keyspace, columnFamily, metadata, directories, loadSSTables, true, false);
    }

    public static synchronized ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, String columnFamily, TableMetadataRef metadata, Directories directories, boolean loadSSTables, boolean registerBookkeeping, boolean offline) {
        Directories.SSTableLister lister = directories.sstableLister(Directories.OnTxnErr.IGNORE).includeBackups(true);
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
            Descriptor desc = entry.getKey();
            generations.add(desc.generation);
            if (desc.isCompatible()) continue;
            throw new RuntimeException(String.format("Incompatible SSTable found. Current version %s is unable to read file: %s. Please run upgradesstables.", desc.getFormat().getLatestVersion(), desc));
        }
        Collections.sort(generations);
        int value = generations.size() > 0 ? (Integer)generations.get(generations.size() - 1) : 0;
        return new ColumnFamilyStore(keyspace, columnFamily, value, metadata, directories, loadSSTables, registerBookkeeping, offline);
    }

    public static void scrubDataDirectories(TableMetadata metadata) throws StartupException {
        Directories directories = new Directories(metadata);
        HashSet<File> cleanedDirectories = new HashSet<File>();
        ColumnFamilyStore.clearEphemeralSnapshots(directories);
        directories.removeTemporaryDirectories();
        logger.trace("Removing temporary or obsoleted files from unfinished operations for table {}", (Object)metadata.name);
        if (!LifecycleTransaction.removeUnfinishedLeftovers(metadata)) {
            throw new StartupException(3, String.format("Cannot remove temporary or obsoleted files for %s due to a problem with transaction log files. Please check records with problems in the log messages above and fix them. Refer to the 3.0 upgrading instructions in NEWS.txt for a description of transaction log files.", metadata.toString()));
        }
        logger.trace("Further extra check for orphan sstable files for {}", (Object)metadata.name);
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : directories.sstableLister(Directories.OnTxnErr.IGNORE).list().entrySet()) {
            Descriptor desc = sstableFiles.getKey();
            File directory = desc.directory;
            Set<Component> components = sstableFiles.getValue();
            if (!cleanedDirectories.contains(directory)) {
                cleanedDirectories.add(directory);
                for (File tmpFile : desc.getTemporaryFiles()) {
                    tmpFile.delete();
                }
            }
            File dataFile = new File(desc.filenameFor(Component.DATA));
            if (components.contains(Component.DATA) && dataFile.length() > 0L) continue;
            logger.warn("Removing orphans for {}: {}", (Object)desc, components);
            for (Component component : components) {
                File file = new File(desc.filenameFor(component));
                if (!file.exists()) continue;
                FileUtils.deleteWithConfirm(desc.filenameFor(component));
            }
        }
        Pattern tmpCacheFilePattern = Pattern.compile(metadata.keyspace + "-" + metadata.name + "-(Key|Row)Cache.*\\.tmp$");
        File dir = new File(DatabaseDescriptor.getSavedCachesLocation());
        if (dir.exists()) {
            assert (dir.isDirectory());
            for (File file : dir.listFiles()) {
                if (!tmpCacheFilePattern.matcher(file.getName()).matches() || file.delete()) continue;
                logger.warn("could not delete {}", (Object)file.getAbsolutePath());
            }
        }
        for (IndexMetadata index : metadata.indexes) {
            if (index.isCustom()) continue;
            TableMetadata indexMetadata = CassandraIndex.indexCfsMetadata(metadata, index);
            ColumnFamilyStore.scrubDataDirectories(indexMetadata);
        }
    }

    public static void loadNewSSTables(String ksName, String cfName) {
        Keyspace keyspace = Keyspace.open(ksName);
        keyspace.getColumnFamilyStore(cfName).loadNewSSTables();
    }

    @Override
    @Deprecated
    public void loadNewSSTables() {
        SSTableImporter.Options options = SSTableImporter.Options.options().resetLevel(true).build();
        this.sstableImporter.importNewSSTables(options);
    }

    @Override
    public synchronized List<String> importNewSSTables(Set<String> srcPaths, boolean resetLevel, boolean clearRepaired, boolean verifySSTables, boolean verifyTokens, boolean invalidateCaches, boolean extendedVerify) {
        SSTableImporter.Options options = SSTableImporter.Options.options(srcPaths).resetLevel(resetLevel).clearRepaired(clearRepaired).verifySSTables(verifySSTables).verifyTokens(verifyTokens).invalidateCaches(invalidateCaches).extendedVerify(extendedVerify).build();
        return this.sstableImporter.importNewSSTables(options);
    }

    Descriptor getUniqueDescriptorFor(Descriptor descriptor, File targetDirectory) {
        Descriptor newDescriptor;
        while (new File((newDescriptor = new Descriptor(descriptor.version, targetDirectory, descriptor.ksname, descriptor.cfname, this.fileIndexGenerator.incrementAndGet(), descriptor.formatType)).filenameFor(Component.DATA)).exists()) {
        }
        return newDescriptor;
    }

    public void rebuildSecondaryIndex(String idxName) {
        ColumnFamilyStore.rebuildSecondaryIndex(this.keyspace.getName(), this.metadata.name, idxName);
    }

    public static void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        ColumnFamilyStore cfs = Keyspace.open(ksName).getColumnFamilyStore(cfName);
        logger.info("User Requested secondary index re-build for {}/{} indexes: {}", new Object[]{ksName, cfName, Joiner.on((char)',').join((Object[])idxNames)});
        cfs.indexManager.rebuildIndexesBlocking(Sets.newHashSet(Arrays.asList(idxNames)));
    }

    public AbstractCompactionStrategy createCompactionStrategyInstance(CompactionParams compactionParams) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = compactionParams.klass().getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(this, compactionParams.options());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public String getColumnFamilyName() {
        return this.getTableName();
    }

    @Override
    public String getTableName() {
        return this.name;
    }

    public Descriptor newSSTableDescriptor(File directory) {
        return this.newSSTableDescriptor(directory, SSTableFormat.Type.current().info.getLatestVersion(), SSTableFormat.Type.current());
    }

    public Descriptor newSSTableDescriptor(File directory, SSTableFormat.Type format) {
        return this.newSSTableDescriptor(directory, format.info.getLatestVersion(), format);
    }

    public Descriptor newSSTableDescriptor(File directory, Version version, SSTableFormat.Type format) {
        return new Descriptor(version, directory, this.keyspace.getName(), this.name, this.fileIndexGenerator.incrementAndGet(), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<CommitLogPosition> switchMemtableIfCurrent(Memtable memtable) {
        Tracker tracker = this.data;
        synchronized (tracker) {
            if (this.data.getView().getCurrentMemtable() == memtable) {
                return this.switchMemtable();
            }
        }
        return this.waitForFlushes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<CommitLogPosition> switchMemtable() {
        Tracker tracker = this.data;
        synchronized (tracker) {
            this.logFlush();
            Flush flush = new Flush(false);
            flushExecutor.execute(flush);
            postFlushExecutor.execute((Runnable)flush.postFlushTask);
            return flush.postFlushTask;
        }
    }

    private void logFlush() {
        float onHeapRatio = 0.0f;
        float offHeapRatio = 0.0f;
        long onHeapTotal = 0L;
        long offHeapTotal = 0L;
        Memtable memtable = this.getTracker().getView().getCurrentMemtable();
        onHeapRatio += memtable.getAllocator().onHeap().ownershipRatio();
        offHeapRatio += memtable.getAllocator().offHeap().ownershipRatio();
        onHeapTotal += memtable.getAllocator().onHeap().owns();
        offHeapTotal += memtable.getAllocator().offHeap().owns();
        for (ColumnFamilyStore indexCfs : this.indexManager.getAllIndexColumnFamilyStores()) {
            MemtableAllocator allocator = indexCfs.getTracker().getView().getCurrentMemtable().getAllocator();
            onHeapRatio += allocator.onHeap().ownershipRatio();
            offHeapRatio += allocator.offHeap().ownershipRatio();
            onHeapTotal += allocator.onHeap().owns();
            offHeapTotal += allocator.offHeap().owns();
        }
        logger.debug("Enqueuing flush of {}: {}", (Object)this.name, (Object)String.format("%s (%.0f%%) on-heap, %s (%.0f%%) off-heap", FBUtilities.prettyPrintMemory(onHeapTotal), Float.valueOf(onHeapRatio * 100.0f), FBUtilities.prettyPrintMemory(offHeapTotal), Float.valueOf(offHeapRatio * 100.0f)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<CommitLogPosition> forceFlush() {
        Tracker tracker = this.data;
        synchronized (tracker) {
            Memtable current = this.data.getView().getCurrentMemtable();
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                if (cfs.data.getView().getCurrentMemtable().isClean()) continue;
                return this.switchMemtableIfCurrent(current);
            }
            return this.waitForFlushes();
        }
    }

    public ListenableFuture<?> forceFlush(CommitLogPosition flushIfDirtyBefore) {
        Memtable current = this.data.getView().getCurrentMemtable();
        if (current.mayContainDataBefore(flushIfDirtyBefore)) {
            return this.switchMemtableIfCurrent(current);
        }
        return this.waitForFlushes();
    }

    private ListenableFuture<CommitLogPosition> waitForFlushes() {
        Memtable current = this.data.getView().getCurrentMemtable();
        ListenableFutureTask task = ListenableFutureTask.create(() -> {
            logger.debug("forceFlush requested but everything is clean in {}", (Object)this.name);
            return current.getCommitLogLowerBound();
        });
        postFlushExecutor.execute((Runnable)task);
        return task;
    }

    public CommitLogPosition forceBlockingFlush() {
        return FBUtilities.waitOnFuture(this.forceFlush());
    }

    private static void setCommitLogUpperBound(AtomicReference<CommitLogPosition> commitLogUpperBound) {
        Memtable.LastCommitLogPosition lastReplayPosition;
        CommitLogPosition currentLast;
        do {
            lastReplayPosition = new Memtable.LastCommitLogPosition(CommitLog.instance.getCurrentPosition());
        } while ((currentLast = commitLogUpperBound.get()) != null && currentLast.compareTo(lastReplayPosition) > 0 || !commitLogUpperBound.compareAndSet(currentLast, lastReplayPosition));
    }

    private static String ratio(float onHeap, float offHeap) {
        return String.format("%.2f/%.2f", Float.valueOf(onHeap), Float.valueOf(offHeap));
    }

    public void apply(PartitionUpdate update, UpdateTransaction indexer, OpOrder.Group opGroup, CommitLogPosition commitLogPosition) {
        long start = System.nanoTime();
        try {
            Memtable mt = this.data.getMemtableFor(opGroup, commitLogPosition);
            long timeDelta = mt.put(update, indexer, opGroup);
            DecoratedKey key = update.partitionKey();
            this.invalidateCachedPartition(key);
            this.metric.topWritePartitionFrequency.addSample(key.getKey(), 1);
            if (this.metric.topWritePartitionSize.isEnabled()) {
                this.metric.topWritePartitionSize.addSample(key.getKey(), update.dataSize());
            }
            StorageHook.instance.reportWrite(this.metadata.id, update);
            this.metric.writeLatency.addNano(System.nanoTime() - start);
            if (timeDelta < Long.MAX_VALUE) {
                this.metric.colUpdateTimeDeltaHistogram.update(Math.min(18165375903306L, timeDelta));
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage() + " for ks: " + this.keyspace.getName() + ", table: " + this.name, e);
        }
    }

    public Collection<SSTableReader> getOverlappingLiveSSTables(Iterable<SSTableReader> sstables) {
        logger.trace("Checking for sstables overlapping {}", sstables);
        if (!sstables.iterator().hasNext()) {
            return ImmutableSet.of();
        }
        View view = this.data.getView();
        ArrayList sortedByFirst = Lists.newArrayList(sstables);
        Collections.sort(sortedByFirst, (o1, o2) -> o1.first.compareTo(o2.first));
        ArrayList<AbstractBounds<DecoratedKey>> bounds = new ArrayList<AbstractBounds<DecoratedKey>>();
        DecoratedKey first = null;
        DecoratedKey last = null;
        for (SSTableReader sstable : sortedByFirst) {
            if (first == null) {
                first = sstable.first;
                last = sstable.last;
                continue;
            }
            if (sstable.first.compareTo(last) <= 0) {
                if (sstable.last.compareTo(last) <= 0) continue;
                last = sstable.last;
                continue;
            }
            bounds.add(AbstractBounds.bounds(first, true, last, true));
            first = sstable.first;
            last = sstable.last;
        }
        bounds.add(AbstractBounds.bounds(first, true, last, true));
        HashSet results = new HashSet();
        for (AbstractBounds abstractBounds : bounds) {
            Iterables.addAll(results, view.liveSSTablesInBounds((PartitionPosition)abstractBounds.left, (PartitionPosition)abstractBounds.right));
        }
        return Sets.difference(results, (Set)ImmutableSet.copyOf(sstables));
    }

    public Refs<SSTableReader> getAndReferenceOverlappingLiveSSTables(Iterable<SSTableReader> sstables) {
        Collection<SSTableReader> overlapped;
        Refs<SSTableReader> refs;
        while ((refs = Refs.tryRef(overlapped = this.getOverlappingLiveSSTables(sstables))) == null) {
        }
        return refs;
    }

    public void addSSTable(SSTableReader sstable) {
        assert (sstable.getColumnFamilyName().equals(this.name));
        this.addSSTables(Collections.singletonList(sstable));
    }

    public void addSSTables(Collection<SSTableReader> sstables) {
        this.data.addSSTables(sstables);
        CompactionManager.instance.submitBackground(this);
    }

    public long getExpectedCompactedFileSize(Iterable<SSTableReader> sstables, OperationType operation) {
        if (operation != OperationType.CLEANUP || this.isIndex()) {
            return SSTableReader.getTotalBytes(sstables);
        }
        long expectedFileSize = 0L;
        Set<Range<Token>> ranges = StorageService.instance.getLocalReplicas(this.keyspace.getName()).ranges();
        for (SSTableReader sstable : sstables) {
            List<SSTableReader.PartitionPositionBounds> positions = sstable.getPositionsForRanges(ranges);
            for (SSTableReader.PartitionPositionBounds position : positions) {
                expectedFileSize += position.upperPosition - position.lowerPosition;
            }
        }
        double compressionRatio = (Double)this.metric.compressionRatio.getValue();
        if (compressionRatio > 0.0) {
            expectedFileSize = (long)((double)expectedFileSize * compressionRatio);
        }
        return expectedFileSize;
    }

    public SSTableReader getMaxSizeFile(Iterable<SSTableReader> sstables) {
        long maxSize = 0L;
        SSTableReader maxFile = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.onDiskLength() <= maxSize) continue;
            maxSize = sstable.onDiskLength();
            maxFile = sstable;
        }
        return maxFile;
    }

    public CompactionManager.AllSSTableOpStatus forceCleanup(int jobs) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performCleanup(this, jobs);
    }

    public CompactionManager.AllSSTableOpStatus scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTL, int jobs) throws ExecutionException, InterruptedException {
        return this.scrub(disableSnapshot, skipCorrupted, reinsertOverflowedTTL, false, checkData, jobs);
    }

    @VisibleForTesting
    public CompactionManager.AllSSTableOpStatus scrub(boolean disableSnapshot, boolean skipCorrupted, boolean reinsertOverflowedTTL, boolean alwaysFail, boolean checkData, int jobs) throws ExecutionException, InterruptedException {
        if (!disableSnapshot) {
            this.snapshotWithoutFlush("pre-scrub-" + System.currentTimeMillis());
        }
        try {
            return CompactionManager.instance.performScrub(this, skipCorrupted, checkData, reinsertOverflowedTTL, jobs);
        }
        catch (Throwable t) {
            if (!this.rebuildOnFailedScrub(t)) {
                throw t;
            }
            return alwaysFail ? CompactionManager.AllSSTableOpStatus.ABORTED : CompactionManager.AllSSTableOpStatus.SUCCESSFUL;
        }
    }

    public boolean rebuildOnFailedScrub(Throwable failure) {
        if (!this.isIndex() || !SecondaryIndexManager.isIndexColumnFamilyStore(this)) {
            return false;
        }
        this.truncateBlocking();
        logger.warn("Rebuilding index for {} because of <{}>", (Object)this.name, (Object)failure.getMessage());
        ColumnFamilyStore parentCfs = SecondaryIndexManager.getParentCfs(this);
        assert (parentCfs.indexManager.getAllIndexColumnFamilyStores().contains(this));
        String indexName = SecondaryIndexManager.getIndexName(this);
        parentCfs.rebuildSecondaryIndex(indexName);
        return true;
    }

    public CompactionManager.AllSSTableOpStatus verify(Verifier.Options options) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performVerify(this, options);
    }

    public CompactionManager.AllSSTableOpStatus sstablesRewrite(boolean excludeCurrentVersion, int jobs) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performSSTableRewrite(this, excludeCurrentVersion, jobs);
    }

    public CompactionManager.AllSSTableOpStatus relocateSSTables(int jobs) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.relocateSSTables(this, jobs);
    }

    public CompactionManager.AllSSTableOpStatus garbageCollect(CompactionParams.TombstoneOption tombstoneOption, int jobs) throws ExecutionException, InterruptedException {
        return CompactionManager.instance.performGarbageCollection(this, tombstoneOption, jobs);
    }

    public void markObsolete(Collection<SSTableReader> sstables, OperationType compactionType) {
        assert (!sstables.isEmpty());
        org.apache.cassandra.utils.Throwables.maybeFail(this.data.dropSSTables((Predicate<SSTableReader>)Predicates.in(sstables), compactionType, null));
    }

    void replaceFlushed(Memtable memtable, Collection<SSTableReader> sstables) {
        this.data.replaceFlushed(memtable, sstables);
        if (sstables != null && !sstables.isEmpty()) {
            CompactionManager.instance.submitBackground(this);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public Tracker getTracker() {
        return this.data;
    }

    public Set<SSTableReader> getLiveSSTables() {
        return this.data.getView().liveSSTables();
    }

    public Iterable<SSTableReader> getSSTables(SSTableSet sstableSet) {
        return this.data.getView().select(sstableSet);
    }

    public Iterable<SSTableReader> getUncompactingSSTables() {
        return this.data.getUncompacting();
    }

    public boolean isFilterFullyCoveredBy(ClusteringIndexFilter filter, DataLimits limits, CachedPartition cached, int nowInSec, boolean enforceStrictLiveness) {
        if (cached.cachedLiveRows() < this.metadata().params.caching.rowsPerPartitionToCache()) {
            return true;
        }
        return filter.isHeadFilter() && limits.hasEnoughLiveData(cached, nowInSec, filter.selectsAllPartition(), enforceStrictLiveness) || filter.isFullyCoveredBy(cached);
    }

    public int gcBefore(int nowInSec) {
        return nowInSec - this.metadata().params.gcGraceSeconds;
    }

    public RefViewFragment selectAndReference(Function<View, Iterable<SSTableReader>> filter) {
        long failingSince = -1L;
        while (true) {
            ViewFragment view = this.select(filter);
            Refs<SSTableReader> refs = Refs.tryRef(view.sstables);
            if (refs != null) {
                return new RefViewFragment(view.sstables, view.memtables, refs);
            }
            if (failingSince <= 0L) {
                failingSince = System.nanoTime();
                continue;
            }
            if (System.nanoTime() - failingSince <= TimeUnit.MILLISECONDS.toNanos(100L)) continue;
            ArrayList<SSTableReader> released = new ArrayList<SSTableReader>();
            for (SSTableReader reader : view.sstables) {
                if (reader.selfRef().globalCount() != 0) continue;
                released.add(reader);
            }
            NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.SECONDS, "Spinning trying to capture readers {}, released: {}, ", view.sstables, released);
            failingSince = System.nanoTime();
        }
    }

    public ViewFragment select(Function<View, Iterable<SSTableReader>> filter) {
        View view = this.data.getView();
        ArrayList sstables = Lists.newArrayList((Iterable)((Iterable)filter.apply((Object)view)));
        return new ViewFragment(sstables, view.getAllMemtables());
    }

    @Override
    public List<String> getSSTablesForKey(String key) {
        return this.getSSTablesForKey(key, false);
    }

    @Override
    public List<String> getSSTablesForKey(String key, boolean hexFormat) {
        ByteBuffer keyBuffer = hexFormat ? ByteBufferUtil.hexToBytes(key) : this.metadata().partitionKeyType.fromString(key);
        DecoratedKey dk = this.decorateKey(keyBuffer);
        try (OpOrder.Group op = this.readOrdering.start();){
            ArrayList<String> files = new ArrayList<String>();
            for (SSTableReader sstr : this.select(View.select((SSTableSet)SSTableSet.LIVE, (DecoratedKey)dk)).sstables) {
                if (sstr.getPosition((PartitionPosition)dk, SSTableReader.Operator.EQ, false) == null) continue;
                files.add(sstr.getFilename());
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
    }

    @Override
    public void beginLocalSampling(String sampler, int capacity, int durationMillis) {
        this.metric.samplers.get((Object)Sampler.SamplerType.valueOf(sampler)).beginSampling(capacity, durationMillis);
    }

    @Override
    public List<CompositeData> finishLocalSampling(String sampler, int count) throws OpenDataException {
        Sampler<?> samplerImpl = this.metric.samplers.get((Object)Sampler.SamplerType.valueOf(sampler));
        List<Sampler.Sample<?>> samplerResults = samplerImpl.finishSampling(count);
        ArrayList<CompositeData> result = new ArrayList<CompositeData>(count);
        for (Sampler.Sample<?> counter : samplerResults) {
            result.add(new CompositeDataSupport(COUNTER_COMPOSITE_TYPE, COUNTER_NAMES, new Object[]{this.keyspace.getName() + "." + this.name, counter.count, counter.error, samplerImpl.toString(counter.value)}));
        }
        return result;
    }

    @Override
    public boolean isCompactionDiskSpaceCheckEnabled() {
        return this.compactionSpaceCheck;
    }

    @Override
    public void compactionDiskSpaceCheck(boolean enable) {
        this.compactionSpaceCheck = enable;
    }

    public void cleanupCache() {
        DecoratedKey dk;
        CacheKey key;
        Set ranges = StorageService.instance.getLocalReplicas(this.keyspace.getName()).ranges();
        Iterator keyIter = CacheService.instance.rowCache.keyIterator();
        while (keyIter.hasNext()) {
            key = (RowCacheKey)keyIter.next();
            dk = this.decorateKey(ByteBuffer.wrap(((RowCacheKey)key).key));
            if (!key.sameTable(this.metadata()) || Range.isInRanges(dk.getToken(), ranges)) continue;
            this.invalidateCachedPartition(dk);
        }
        if (this.metadata().isCounter()) {
            keyIter = CacheService.instance.counterCache.keyIterator();
            while (keyIter.hasNext()) {
                key = (CounterCacheKey)keyIter.next();
                dk = this.decorateKey(((CounterCacheKey)key).partitionKey());
                if (!key.sameTable(this.metadata()) || Range.isInRanges(dk.getToken(), ranges)) continue;
                CacheService.instance.counterCache.remove((CounterCacheKey)key);
            }
        }
    }

    public ClusteringComparator getComparator() {
        return this.metadata().comparator;
    }

    public void snapshotWithoutFlush(String snapshotName) {
        this.snapshotWithoutFlush(snapshotName, null, false);
    }

    public Set<SSTableReader> snapshotWithoutFlush(String snapshotName, Predicate<SSTableReader> predicate, boolean ephemeral) {
        HashSet<SSTableReader> snapshottedSSTables = new HashSet<SSTableReader>();
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            JSONArray filesJSONArr = new JSONArray();
            RefViewFragment currentView = cfs.selectAndReference(View.select(SSTableSet.CANONICAL, (Predicate<SSTableReader>)((Predicate)x -> predicate == null || predicate.apply(x))));
            Throwable throwable = null;
            try {
                for (SSTableReader ssTable : currentView.sstables) {
                    File snapshotDirectory = Directories.getSnapshotDirectory(ssTable.descriptor, snapshotName);
                    ssTable.createLinks(snapshotDirectory.getPath());
                    filesJSONArr.add((Object)ssTable.descriptor.relativeFilenameFor(Component.DATA));
                    if (logger.isTraceEnabled()) {
                        logger.trace("Snapshot for {} keyspace data file {} created in {}", new Object[]{this.keyspace, ssTable.getFilename(), snapshotDirectory});
                    }
                    snapshottedSSTables.add(ssTable);
                }
                this.writeSnapshotManifest(filesJSONArr, snapshotName);
                if (SchemaConstants.isLocalSystemKeyspace(this.metadata.keyspace) || SchemaConstants.isReplicatedSystemKeyspace(this.metadata.keyspace)) continue;
                this.writeSnapshotSchema(snapshotName);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (currentView == null) continue;
                if (throwable != null) {
                    try {
                        currentView.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                currentView.close();
            }
        }
        if (ephemeral) {
            this.createEphemeralSnapshotMarkerFile(snapshotName);
        }
        return snapshottedSSTables;
    }

    private void writeSnapshotManifest(JSONArray filesJSONArr, String snapshotName) {
        File manifestFile = this.getDirectories().getSnapshotManifestFile(snapshotName);
        try {
            if (!manifestFile.getParentFile().exists()) {
                manifestFile.getParentFile().mkdirs();
            }
            try (PrintStream out = new PrintStream(manifestFile);){
                JSONObject manifestJSON = new JSONObject();
                manifestJSON.put((Object)"files", (Object)filesJSONArr);
                out.println(manifestJSON.toJSONString());
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, manifestFile);
        }
    }

    private void writeSnapshotSchema(String snapshotName) {
        File schemaFile = this.getDirectories().getSnapshotSchemaFile(snapshotName);
        try {
            if (!schemaFile.getParentFile().exists()) {
                schemaFile.getParentFile().mkdirs();
            }
            try (PrintStream out = new PrintStream(schemaFile);){
                for (String s : TableCQLHelper.dumpReCreateStatements(this.metadata())) {
                    out.println(s);
                }
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, schemaFile);
        }
    }

    private void createEphemeralSnapshotMarkerFile(String snapshot) {
        File ephemeralSnapshotMarker = this.getDirectories().getNewEphemeralSnapshotMarkerFile(snapshot);
        try {
            if (!ephemeralSnapshotMarker.getParentFile().exists()) {
                ephemeralSnapshotMarker.getParentFile().mkdirs();
            }
            Files.createFile(ephemeralSnapshotMarker.toPath(), new FileAttribute[0]);
            if (logger.isTraceEnabled()) {
                logger.trace("Created ephemeral snapshot marker file on {}.", (Object)ephemeralSnapshotMarker.getAbsolutePath());
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Could not create marker file %s for ephemeral snapshot %s. In case there is a failure in the operation that created this snapshot, you may need to clean it manually afterwards.", ephemeralSnapshotMarker.getAbsolutePath(), snapshot), (Throwable)e);
        }
    }

    protected static void clearEphemeralSnapshots(Directories directories) {
        for (String ephemeralSnapshot : directories.listEphemeralSnapshots()) {
            logger.trace("Clearing ephemeral snapshot {} leftover from previous session.", (Object)ephemeralSnapshot);
            Directories.clearSnapshot(ephemeralSnapshot, directories.getCFDirectories());
        }
    }

    public Refs<SSTableReader> getSnapshotSSTableReaders(String tag) throws IOException {
        HashMap<Integer, SSTableReader> active = new HashMap<Integer, SSTableReader>();
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            active.put(sstable.descriptor.generation, sstable);
        }
        Map<Descriptor, Set<Component>> snapshots = this.getDirectories().sstableLister(Directories.OnTxnErr.IGNORE).snapshots(tag).list();
        Refs<SSTableReader> refs = new Refs<SSTableReader>();
        try {
            for (Map.Entry<Descriptor, Set<Component>> entries : snapshots.entrySet()) {
                SSTableReader sstable = (SSTableReader)active.get(entries.getKey().generation);
                if (sstable == null || !refs.tryRef(sstable)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("using snapshot sstable {}", (Object)entries.getKey());
                    }
                    sstable = SSTableReader.open(entries.getKey(), entries.getValue(), this.metadata, true, true);
                    refs.tryRef(sstable);
                    sstable.selfRef().release();
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("using active sstable {}", (Object)entries.getKey());
            }
        }
        catch (RuntimeException | FSReadError e) {
            refs.release();
            throw e;
        }
        return refs;
    }

    public Set<SSTableReader> snapshot(String snapshotName) {
        return this.snapshot(snapshotName, false);
    }

    public Set<SSTableReader> snapshot(String snapshotName, boolean skipFlush) {
        return this.snapshot(snapshotName, null, false, skipFlush);
    }

    public Set<SSTableReader> snapshot(String snapshotName, Predicate<SSTableReader> predicate, boolean ephemeral, boolean skipFlush) {
        if (!skipFlush) {
            this.forceBlockingFlush();
        }
        return this.snapshotWithoutFlush(snapshotName, predicate, ephemeral);
    }

    public boolean snapshotExists(String snapshotName) {
        return this.getDirectories().snapshotExists(snapshotName);
    }

    public long getSnapshotCreationTime(String snapshotName) {
        return this.getDirectories().snapshotCreationTime(snapshotName);
    }

    public void clearSnapshot(String snapshotName) {
        List<File> snapshotDirs = this.getDirectories().getCFDirectories();
        Directories.clearSnapshot(snapshotName, snapshotDirs);
    }

    public Map<String, Directories.SnapshotSizeDetails> getSnapshotDetails() {
        return this.getDirectories().getSnapshotDetails();
    }

    public CachedPartition getRawCachedPartition(DecoratedKey key) {
        if (!this.isRowCacheEnabled()) {
            return null;
        }
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.getInternal(new RowCacheKey(this.metadata(), key));
        return cached == null || cached instanceof RowCacheSentinel ? null : (CachedPartition)cached;
    }

    private void invalidateCaches() {
        CacheService.instance.invalidateKeyCacheForCf(this.metadata());
        CacheService.instance.invalidateRowCacheForCf(this.metadata());
        if (this.metadata().isCounter()) {
            CacheService.instance.invalidateCounterCacheForCf(this.metadata());
        }
    }

    public int invalidateRowCache(Collection<Bounds<Token>> boundsToInvalidate) {
        int invalidatedKeys = 0;
        Iterator keyIter = CacheService.instance.rowCache.keyIterator();
        while (keyIter.hasNext()) {
            RowCacheKey key = (RowCacheKey)keyIter.next();
            DecoratedKey dk = this.decorateKey(ByteBuffer.wrap(key.key));
            if (!key.sameTable(this.metadata()) || !Bounds.isInBounds(dk.getToken(), boundsToInvalidate)) continue;
            this.invalidateCachedPartition(dk);
            ++invalidatedKeys;
        }
        return invalidatedKeys;
    }

    public int invalidateCounterCache(Collection<Bounds<Token>> boundsToInvalidate) {
        int invalidatedKeys = 0;
        Iterator keyIter = CacheService.instance.counterCache.keyIterator();
        while (keyIter.hasNext()) {
            CounterCacheKey key = (CounterCacheKey)keyIter.next();
            DecoratedKey dk = this.decorateKey(key.partitionKey());
            if (!key.sameTable(this.metadata()) || !Bounds.isInBounds(dk.getToken(), boundsToInvalidate)) continue;
            CacheService.instance.counterCache.remove(key);
            ++invalidatedKeys;
        }
        return invalidatedKeys;
    }

    public boolean containsCachedParition(DecoratedKey key) {
        return CacheService.instance.rowCache.getCapacity() != 0L && CacheService.instance.rowCache.containsKey(new RowCacheKey(this.metadata(), key));
    }

    public void invalidateCachedPartition(RowCacheKey key) {
        CacheService.instance.rowCache.remove(key);
    }

    public void invalidateCachedPartition(DecoratedKey key) {
        if (!this.isRowCacheEnabled()) {
            return;
        }
        this.invalidateCachedPartition(new RowCacheKey(this.metadata(), key));
    }

    public ClockAndCount getCachedCounter(ByteBuffer partitionKey, Clustering clustering, ColumnMetadata column, CellPath path) {
        if (CacheService.instance.counterCache.getCapacity() == 0L) {
            return null;
        }
        return (ClockAndCount)CacheService.instance.counterCache.get(CounterCacheKey.create(this.metadata(), partitionKey, clustering, column, path));
    }

    public void putCachedCounter(ByteBuffer partitionKey, Clustering clustering, ColumnMetadata column, CellPath path, ClockAndCount clockAndCount) {
        if (CacheService.instance.counterCache.getCapacity() == 0L) {
            return;
        }
        CacheService.instance.counterCache.put(CounterCacheKey.create(this.metadata(), partitionKey, clustering, column, path), clockAndCount);
    }

    public void forceMajorCompaction() throws InterruptedException, ExecutionException {
        this.forceMajorCompaction(false);
    }

    @Override
    public void forceMajorCompaction(boolean splitOutput) throws InterruptedException, ExecutionException {
        CompactionManager.instance.performMaximal(this, splitOutput);
    }

    @Override
    public void forceCompactionForTokenRange(Collection<Range<Token>> tokenRanges) throws ExecutionException, InterruptedException {
        CompactionManager.instance.forceCompactionForTokenRange(this, tokenRanges);
    }

    public static Iterable<ColumnFamilyStore> all() {
        ArrayList<Collection<ColumnFamilyStore>> stores = new ArrayList<Collection<ColumnFamilyStore>>(Schema.instance.getKeyspaces().size());
        for (Keyspace keyspace : Keyspace.all()) {
            stores.add(keyspace.getColumnFamilyStores());
        }
        return Iterables.concat(stores);
    }

    public Iterable<DecoratedKey> keySamples(Range<Token> range) {
        try (RefViewFragment view = this.selectAndReference(View.selectFunction(SSTableSet.CANONICAL));){
            Iterable[] samples = new Iterable[view.sstables.size()];
            int i = 0;
            for (SSTableReader sstable : view.sstables) {
                samples[i++] = sstable.getKeySamples(range);
            }
            Iterable iterable = Iterables.concat((Iterable[])samples);
            return iterable;
        }
    }

    public long estimatedKeysForRange(Range<Token> range) {
        try (RefViewFragment view = this.selectAndReference(View.selectFunction(SSTableSet.CANONICAL));){
            long count = 0L;
            for (SSTableReader sstable : view.sstables) {
                count += sstable.estimatedKeysForRanges(Collections.singleton(range));
            }
            long l = count;
            return l;
        }
    }

    @VisibleForTesting
    public void clearUnsafe() {
        for (final ColumnFamilyStore cfs : this.concatWithIndexes()) {
            cfs.runWithCompactionsDisabled(new Callable<Void>(){

                @Override
                public Void call() {
                    cfs.data.reset(new Memtable(new AtomicReference<CommitLogPosition>(CommitLogPosition.NONE), cfs));
                    return null;
                }
            }, true, false);
        }
    }

    public void truncateBlocking() {
        CommitLogPosition replayAfter;
        logger.info("Truncating {}.{}", (Object)this.keyspace.getName(), (Object)this.name);
        if (this.keyspace.getMetadata().params.durableWrites || DatabaseDescriptor.isAutoSnapshot()) {
            replayAfter = this.forceBlockingFlush();
            this.viewManager.forceBlockingFlush();
        } else {
            this.viewManager.dumpMemtables();
            try {
                replayAfter = this.dumpMemtable().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        long now = System.currentTimeMillis();
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            for (SSTableReader sstable : cfs.getLiveSSTables()) {
                now = Math.max(now, sstable.maxDataAge);
            }
        }
        final long truncatedAt = now;
        Runnable truncateRunnable = new Runnable(){

            @Override
            public void run() {
                logger.debug("Discarding sstable data for truncated CF + indexes");
                ColumnFamilyStore.this.data.notifyTruncated(truncatedAt);
                if (DatabaseDescriptor.isAutoSnapshot()) {
                    ColumnFamilyStore.this.snapshot(Keyspace.getTimestampedSnapshotNameWithPrefix(ColumnFamilyStore.this.name, ColumnFamilyStore.SNAPSHOT_TRUNCATE_PREFIX));
                }
                ColumnFamilyStore.this.discardSSTables(truncatedAt);
                ColumnFamilyStore.this.indexManager.truncateAllIndexesBlocking(truncatedAt);
                ColumnFamilyStore.this.viewManager.truncateBlocking(replayAfter, truncatedAt);
                SystemKeyspace.saveTruncationRecord(ColumnFamilyStore.this, truncatedAt, replayAfter);
                logger.trace("cleaning out row cache");
                ColumnFamilyStore.this.invalidateCaches();
            }
        };
        this.runWithCompactionsDisabled(Executors.callable(truncateRunnable), true, true);
        logger.info("Truncate of {}.{} is complete", (Object)this.keyspace.getName(), (Object)this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<CommitLogPosition> dumpMemtable() {
        Tracker tracker = this.data;
        synchronized (tracker) {
            Flush flush = new Flush(true);
            flushExecutor.execute(flush);
            postFlushExecutor.execute((Runnable)flush.postFlushTask);
            return flush.postFlushTask;
        }
    }

    public <V> V runWithCompactionsDisabled(Callable<V> callable, boolean interruptValidation, boolean interruptViews) {
        return this.runWithCompactionsDisabled(callable, (Predicate<SSTableReader>)((Predicate)sstable -> true), interruptValidation, interruptViews, true);
    }

    /*
     * Exception decompiling
     */
    public <V> V runWithCompactionsDisabled(Callable<V> callable, Predicate<SSTableReader> sstablesPredicate, boolean interruptValidation, boolean interruptViews, boolean interruptIndexes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 31[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CompactionManager.CompactionPauser pauseCompactionStrategies(Iterable<ColumnFamilyStore> toPause) {
        ArrayList<ColumnFamilyStore> successfullyPaused = new ArrayList<ColumnFamilyStore>();
        try {
            for (ColumnFamilyStore cfs : toPause) {
                successfullyPaused.ensureCapacity(successfullyPaused.size() + 1);
                cfs.getCompactionStrategyManager().pause();
                successfullyPaused.add(cfs);
            }
            return () -> org.apache.cassandra.utils.Throwables.maybeFail(ColumnFamilyStore.resumeAll(null, toPause));
        }
        catch (Throwable t) {
            ColumnFamilyStore.resumeAll(t, successfullyPaused);
            throw t;
        }
    }

    private static Throwable resumeAll(Throwable accumulate, Iterable<ColumnFamilyStore> cfss) {
        for (ColumnFamilyStore cfs : cfss) {
            try {
                cfs.getCompactionStrategyManager().resume();
            }
            catch (Throwable t) {
                accumulate = org.apache.cassandra.utils.Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    public LifecycleTransaction markAllCompacting(final OperationType operationType) {
        Callable<LifecycleTransaction> callable = new Callable<LifecycleTransaction>(){

            @Override
            public LifecycleTransaction call() {
                assert (ColumnFamilyStore.this.data.getCompacting().isEmpty()) : ColumnFamilyStore.access$000(ColumnFamilyStore.this).getCompacting();
                Collection<SSTableReader> sstables = ColumnFamilyStore.this.getLiveSSTables();
                sstables = AbstractCompactionStrategy.filterSuspectSSTables(sstables);
                LifecycleTransaction modifier = ColumnFamilyStore.this.data.tryModify(sstables, operationType);
                assert (modifier != null) : "something marked things compacting while compactions are disabled";
                return modifier;
            }
        };
        return this.runWithCompactionsDisabled(callable, false, false);
    }

    public String toString() {
        return "CFS(Keyspace='" + this.keyspace.getName() + '\'' + ", ColumnFamily='" + this.name + '\'' + ')';
    }

    public void disableAutoCompaction() {
        this.compactionStrategyManager.disable();
    }

    public void enableAutoCompaction() {
        this.enableAutoCompaction(false);
    }

    @VisibleForTesting
    public void enableAutoCompaction(boolean waitForFutures) {
        this.compactionStrategyManager.enable();
        List<Future<?>> futures = CompactionManager.instance.submitBackground(this);
        if (waitForFutures) {
            FBUtilities.waitOnFutures(futures);
        }
    }

    @Override
    public boolean isAutoCompactionDisabled() {
        return !this.compactionStrategyManager.isEnabled();
    }

    public CompactionStrategyManager getCompactionStrategyManager() {
        return this.compactionStrategyManager;
    }

    @Override
    public void setCrcCheckChance(double crcCheckChance) {
        try {
            TableParams.builder().crcCheckChance(crcCheckChance).build().validate();
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.crcCheckChance.set(crcCheckChance);
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    sstable.setCrcCheckChance(crcCheckChance);
                }
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Double getCrcCheckChance() {
        return this.crcCheckChance.value();
    }

    @Override
    public void setCompactionThresholds(int minThreshold, int maxThreshold) {
        this.validateCompactionThresholds(minThreshold, maxThreshold);
        this.minCompactionThreshold.set(minThreshold);
        this.maxCompactionThreshold.set(maxThreshold);
        CompactionManager.instance.submitBackground(this);
    }

    @Override
    public int getMinimumCompactionThreshold() {
        return this.minCompactionThreshold.value();
    }

    @Override
    public void setMinimumCompactionThreshold(int minCompactionThreshold) {
        this.validateCompactionThresholds(minCompactionThreshold, this.maxCompactionThreshold.value());
        this.minCompactionThreshold.set(minCompactionThreshold);
    }

    @Override
    public int getMaximumCompactionThreshold() {
        return this.maxCompactionThreshold.value();
    }

    @Override
    public void setMaximumCompactionThreshold(int maxCompactionThreshold) {
        this.validateCompactionThresholds(this.minCompactionThreshold.value(), maxCompactionThreshold);
        this.maxCompactionThreshold.set(maxCompactionThreshold);
    }

    private void validateCompactionThresholds(int minThreshold, int maxThreshold) {
        if (minThreshold > maxThreshold) {
            throw new RuntimeException(String.format("The min_compaction_threshold cannot be larger than the max_compaction_threshold. Min is '%d', Max is '%d'.", minThreshold, maxThreshold));
        }
        if (maxThreshold == 0 || minThreshold == 0) {
            throw new RuntimeException("Disabling compaction by setting min_compaction_threshold or max_compaction_threshold to 0 is deprecated, set the compaction strategy option 'enabled' to 'false' instead or use the nodetool command 'disableautocompaction'.");
        }
    }

    public int getMeanEstimatedCellPerPartitionCount() {
        long sum = 0L;
        long count = 0L;
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            long n = sstable.getEstimatedCellPerPartitionCount().count();
            sum += sstable.getEstimatedCellPerPartitionCount().mean() * n;
            count += n;
        }
        return count > 0L ? (int)(sum / count) : 0;
    }

    public double getMeanPartitionSize() {
        long sum = 0L;
        long count = 0L;
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            long n = sstable.getEstimatedPartitionSize().count();
            sum += sstable.getEstimatedPartitionSize().mean() * n;
            count += n;
        }
        return count > 0L ? (double)sum * 1.0 / (double)count : 0.0;
    }

    public int getMeanRowCount() {
        long totalRows = 0L;
        long totalPartitions = 0L;
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            totalPartitions += sstable.getEstimatedPartitionSize().count();
            totalRows += sstable.getTotalRows();
        }
        return totalPartitions > 0L ? (int)(totalRows / totalPartitions) : 0;
    }

    @Override
    public long estimateKeys() {
        long n = 0L;
        for (SSTableReader sstable : this.getSSTables(SSTableSet.CANONICAL)) {
            n += sstable.estimatedKeys();
        }
        return n;
    }

    public IPartitioner getPartitioner() {
        return this.metadata().partitioner;
    }

    public DecoratedKey decorateKey(ByteBuffer key) {
        return this.getPartitioner().decorateKey(key);
    }

    public boolean isIndex() {
        return this.metadata().isIndex();
    }

    public Iterable<ColumnFamilyStore> concatWithIndexes() {
        return Iterables.concat(Collections.singleton(this), this.indexManager.getAllIndexColumnFamilyStores());
    }

    @Override
    public List<String> getBuiltIndexes() {
        return this.indexManager.getBuiltIndexNames();
    }

    @Override
    public int getUnleveledSSTables() {
        return this.compactionStrategyManager.getUnleveledSSTables();
    }

    @Override
    public int[] getSSTableCountPerLevel() {
        return this.compactionStrategyManager.getSSTableCountPerLevel();
    }

    @Override
    public int getLevelFanoutSize() {
        return this.compactionStrategyManager.getLevelFanoutSize();
    }

    public boolean isEmpty() {
        return this.data.getView().isEmpty();
    }

    public boolean isRowCacheEnabled() {
        boolean retval;
        boolean bl = retval = this.metadata().params.caching.cacheRows() && CacheService.instance.rowCache.getCapacity() > 0L;
        assert (!retval || !this.isIndex());
        return retval;
    }

    public boolean isCounterCacheEnabled() {
        return this.metadata().isCounter() && CacheService.instance.counterCache.getCapacity() > 0L;
    }

    public boolean isKeyCacheEnabled() {
        return this.metadata().params.caching.cacheKeys() && CacheService.instance.keyCache.getCapacity() > 0L;
    }

    public void discardSSTables(long truncatedAt) {
        assert (this.data.getCompacting().isEmpty()) : this.data.getCompacting();
        ArrayList<SSTableReader> truncatedSSTables = new ArrayList<SSTableReader>();
        for (SSTableReader sstable : this.getSSTables(SSTableSet.LIVE)) {
            if (sstable.newSince(truncatedAt)) continue;
            truncatedSSTables.add(sstable);
        }
        if (!truncatedSSTables.isEmpty()) {
            this.markObsolete(truncatedSSTables, OperationType.UNKNOWN);
        }
    }

    @Override
    public double getDroppableTombstoneRatio() {
        double allDroppable = 0.0;
        long allColumns = 0L;
        int localTime = (int)(System.currentTimeMillis() / 1000L);
        for (SSTableReader sstable : this.getSSTables(SSTableSet.LIVE)) {
            allDroppable += sstable.getDroppableTombstonesBefore(localTime - this.metadata().params.gcGraceSeconds);
            allColumns += sstable.getEstimatedCellPerPartitionCount().mean() * sstable.getEstimatedCellPerPartitionCount().count();
        }
        return allColumns > 0L ? allDroppable / (double)allColumns : 0.0;
    }

    @Override
    public long trueSnapshotsSize() {
        return this.getDirectories().trueSnapshotsSize();
    }

    public static ColumnFamilyStore getIfExists(TableId id) {
        TableMetadata metadata = Schema.instance.getTableMetadata(id);
        if (metadata == null) {
            return null;
        }
        Keyspace keyspace = Keyspace.open(metadata.keyspace);
        if (keyspace == null) {
            return null;
        }
        return keyspace.hasColumnFamilyStore(id) ? keyspace.getColumnFamilyStore(id) : null;
    }

    public static ColumnFamilyStore getIfExists(String ksName, String cfName) {
        if (ksName == null || cfName == null) {
            return null;
        }
        Keyspace keyspace = Keyspace.open(ksName);
        if (keyspace == null) {
            return null;
        }
        TableMetadata table = Schema.instance.getTableMetadata(ksName, cfName);
        if (table == null) {
            return null;
        }
        return keyspace.getColumnFamilyStore(table.id);
    }

    public static TableMetrics metricsFor(TableId tableId) {
        return ColumnFamilyStore.getIfExists((TableId)tableId).metric;
    }

    public DiskBoundaries getDiskBoundaries() {
        return this.diskBoundaryManager.getDiskBoundaries(this);
    }

    public void invalidateDiskBoundaries() {
        this.diskBoundaryManager.invalidate();
    }

    @Override
    public void setNeverPurgeTombstones(boolean value) {
        if (this.neverPurgeTombstones != value) {
            logger.info("Changing neverPurgeTombstones for {}.{} from {} to {}", new Object[]{this.keyspace.getName(), this.getTableName(), this.neverPurgeTombstones, value});
        } else {
            logger.info("Not changing neverPurgeTombstones for {}.{}, it is {}", new Object[]{this.keyspace.getName(), this.getTableName(), this.neverPurgeTombstones});
        }
        this.neverPurgeTombstones = value;
    }

    @Override
    public boolean getNeverPurgeTombstones() {
        return this.neverPurgeTombstones;
    }

    static {
        for (int i = 0; i < DatabaseDescriptor.getAllDataFileLocations().length; ++i) {
            ColumnFamilyStore.perDiskflushExecutors[i] = new JMXEnabledThreadPoolExecutor(DatabaseDescriptor.getFlushWriters(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("PerDiskMemtableFlushWriter_" + i), "internal");
        }
        postFlushExecutor = new JMXEnabledThreadPoolExecutor(1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("MemtablePostFlush"), "internal");
        reclaimExecutor = new JMXEnabledThreadPoolExecutor(1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("MemtableReclaimMemory"), "internal");
        COUNTER_NAMES = new String[]{"table", "count", "error", "value"};
        COUNTER_DESCS = new String[]{"keyspace.tablename", "number of occurances", "error bounds", "value"};
        try {
            OpenType[] counterTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING};
            COUNTER_COMPOSITE_TYPE = new CompositeType(SAMPLING_RESULTS_NAME, SAMPLING_RESULTS_NAME, COUNTER_NAMES, COUNTER_DESCS, counterTypes);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static class RefViewFragment
    extends ViewFragment
    implements AutoCloseable {
        public final Refs<SSTableReader> refs;

        public RefViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables, Refs<SSTableReader> refs) {
            super(sstables, memtables);
            this.refs = refs;
        }

        public void release() {
            this.refs.release();
        }

        @Override
        public void close() {
            this.refs.release();
        }
    }

    public static class ViewFragment {
        public final List<SSTableReader> sstables;
        public final Iterable<Memtable> memtables;

        public ViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables) {
            this.sstables = sstables;
            this.memtables = memtables;
        }
    }

    public static class FlushLargestColumnFamily
    implements Runnable {
        @Override
        public void run() {
            float largestRatio = 0.0f;
            Memtable largest = null;
            float liveOnHeap = 0.0f;
            float liveOffHeap = 0.0f;
            for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
                Memtable current = cfs.getTracker().getView().getCurrentMemtable();
                float onHeap = 0.0f;
                float offHeap = 0.0f;
                onHeap += current.getAllocator().onHeap().ownershipRatio();
                offHeap += current.getAllocator().offHeap().ownershipRatio();
                for (ColumnFamilyStore indexCfs : cfs.indexManager.getAllIndexColumnFamilyStores()) {
                    MemtableAllocator allocator = indexCfs.getTracker().getView().getCurrentMemtable().getAllocator();
                    onHeap += allocator.onHeap().ownershipRatio();
                    offHeap += allocator.offHeap().ownershipRatio();
                }
                float ratio = Math.max(onHeap, offHeap);
                if (ratio > largestRatio) {
                    largest = current;
                    largestRatio = ratio;
                }
                liveOnHeap += onHeap;
                liveOffHeap += offHeap;
            }
            if (largest != null) {
                float usedOnHeap = Memtable.MEMORY_POOL.onHeap.usedRatio();
                float usedOffHeap = Memtable.MEMORY_POOL.offHeap.usedRatio();
                float flushingOnHeap = Memtable.MEMORY_POOL.onHeap.reclaimingRatio();
                float flushingOffHeap = Memtable.MEMORY_POOL.offHeap.reclaimingRatio();
                float thisOnHeap = largest.getAllocator().onHeap().ownershipRatio();
                float thisOffHeap = largest.getAllocator().offHeap().ownershipRatio();
                logger.debug("Flushing largest {} to free up room. Used total: {}, live: {}, flushing: {}, this: {}", new Object[]{largest.cfs, ColumnFamilyStore.ratio(usedOnHeap, usedOffHeap), ColumnFamilyStore.ratio(liveOnHeap, liveOffHeap), ColumnFamilyStore.ratio(flushingOnHeap, flushingOffHeap), ColumnFamilyStore.ratio(thisOnHeap, thisOffHeap)});
                largest.cfs.switchMemtableIfCurrent(largest);
            }
        }
    }

    private final class Flush
    implements Runnable {
        final OpOrder.Barrier writeBarrier;
        final List<Memtable> memtables = new ArrayList<Memtable>();
        final ListenableFutureTask<CommitLogPosition> postFlushTask;
        final PostFlush postFlush;
        final boolean truncate;

        private Flush(boolean truncate) {
            this.truncate = truncate;
            ColumnFamilyStore.this.metric.pendingFlushes.inc();
            Keyspace cfr_ignored_0 = ColumnFamilyStore.this.keyspace;
            this.writeBarrier = Keyspace.writeOrder.newBarrier();
            AtomicReference<CommitLogPosition> commitLogUpperBound = new AtomicReference<CommitLogPosition>();
            for (ColumnFamilyStore cfs : ColumnFamilyStore.this.concatWithIndexes()) {
                Memtable newMemtable = new Memtable(commitLogUpperBound, cfs);
                Memtable oldMemtable = cfs.data.switchMemtable(truncate, newMemtable);
                oldMemtable.setDiscarding(this.writeBarrier, commitLogUpperBound);
                this.memtables.add(oldMemtable);
            }
            ColumnFamilyStore.setCommitLogUpperBound(commitLogUpperBound);
            this.writeBarrier.issue();
            this.postFlush = new PostFlush(this.memtables);
            this.postFlushTask = ListenableFutureTask.create((Callable)this.postFlush);
        }

        @Override
        public void run() {
            this.writeBarrier.markBlocking();
            this.writeBarrier.await();
            for (Memtable memtable : this.memtables) {
                memtable.cfs.data.markFlushing(memtable);
            }
            ColumnFamilyStore.this.metric.memtableSwitchCount.inc();
            try {
                this.flushMemtable(this.memtables.get(0), true);
                for (int i = 1; i < this.memtables.size(); ++i) {
                    this.flushMemtable(this.memtables.get(i), false);
                }
            }
            catch (Throwable t) {
                JVMStabilityInspector.inspectThrowable(t);
                this.postFlush.flushFailure = t;
            }
            this.postFlush.latch.countDown();
        }

        public Collection<SSTableReader> flushMemtable(Memtable memtable, boolean flushNonCf2i) {
            if (memtable.isClean() || this.truncate) {
                memtable.cfs.replaceFlushed(memtable, Collections.emptyList());
                this.reclaim(memtable);
                return Collections.emptyList();
            }
            ArrayList futures = new ArrayList();
            long totalBytesOnDisk = 0L;
            long maxBytesOnDisk = 0L;
            long minBytesOnDisk = Long.MAX_VALUE;
            ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
            try (LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.FLUSH);){
                List<Memtable.FlushRunnable> flushRunnables = null;
                ArrayList flushResults = null;
                try {
                    flushRunnables = memtable.flushRunnables(txn);
                    for (int i = 0; i < flushRunnables.size(); ++i) {
                        futures.add(perDiskflushExecutors[i].submit(flushRunnables.get(i)));
                    }
                    if (flushNonCf2i) {
                        ColumnFamilyStore.this.indexManager.flushAllNonCFSBackedIndexesBlocking();
                    }
                    flushResults = Lists.newArrayList(FBUtilities.waitOnFutures(futures));
                }
                catch (Throwable t) {
                    t = memtable.abortRunnables(flushRunnables, t);
                    t = txn.abort(t);
                    throw Throwables.propagate((Throwable)t);
                }
                try {
                    Iterator writerIterator = flushResults.iterator();
                    while (writerIterator.hasNext()) {
                        SSTableMultiWriter writer = (SSTableMultiWriter)writerIterator.next();
                        if (writer.getFilePointer() > 0L) {
                            writer.setOpenResult(true).prepareToCommit();
                            continue;
                        }
                        org.apache.cassandra.utils.Throwables.maybeFail(writer.abort(null));
                        writerIterator.remove();
                    }
                }
                catch (Throwable t) {
                    for (SSTableMultiWriter writer : flushResults) {
                        t = writer.abort(t);
                    }
                    t = txn.abort(t);
                    Throwables.propagate((Throwable)t);
                }
                txn.prepareToCommit();
                Throwable accumulate = null;
                for (SSTableMultiWriter writer : flushResults) {
                    accumulate = writer.commit(accumulate);
                }
                org.apache.cassandra.utils.Throwables.maybeFail(txn.commit(accumulate));
                for (SSTableMultiWriter writer : flushResults) {
                    Collection<SSTableReader> flushedSSTables = writer.finished();
                    for (SSTableReader sstable : flushedSSTables) {
                        if (sstable == null) continue;
                        sstables.add(sstable);
                        long size = sstable.bytesOnDisk();
                        totalBytesOnDisk += size;
                        maxBytesOnDisk = Math.max(maxBytesOnDisk, size);
                        minBytesOnDisk = Math.min(minBytesOnDisk, size);
                    }
                }
            }
            memtable.cfs.replaceFlushed(memtable, sstables);
            this.reclaim(memtable);
            ((ColumnFamilyStore)memtable.cfs).compactionStrategyManager.compactionLogger.flush(sstables);
            logger.debug("Flushed to {} ({} sstables, {}), biggest {}, smallest {}", new Object[]{sstables, sstables.size(), FBUtilities.prettyPrintMemory(totalBytesOnDisk), FBUtilities.prettyPrintMemory(maxBytesOnDisk), FBUtilities.prettyPrintMemory(minBytesOnDisk)});
            return sstables;
        }

        private void reclaim(final Memtable memtable) {
            final OpOrder.Barrier readBarrier = ColumnFamilyStore.this.readOrdering.newBarrier();
            readBarrier.issue();
            this.postFlushTask.addListener((Runnable)new WrappedRunnable(){

                @Override
                public void runMayThrow() {
                    readBarrier.await();
                    memtable.setDiscarded();
                }
            }, (Executor)reclaimExecutor);
        }
    }

    private final class PostFlush
    implements Callable<CommitLogPosition> {
        final CountDownLatch latch = new CountDownLatch(1);
        final List<Memtable> memtables;
        volatile Throwable flushFailure = null;

        private PostFlush(List<Memtable> memtables) {
            this.memtables = memtables;
        }

        @Override
        public CommitLogPosition call() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException();
            }
            CommitLogPosition commitLogUpperBound = CommitLogPosition.NONE;
            if (this.flushFailure == null && !this.memtables.isEmpty()) {
                Memtable memtable = this.memtables.get(0);
                commitLogUpperBound = memtable.getCommitLogUpperBound();
                CommitLog.instance.discardCompletedSegments(ColumnFamilyStore.this.metadata.id, memtable.getCommitLogLowerBound(), commitLogUpperBound);
            }
            ColumnFamilyStore.this.metric.pendingFlushes.dec();
            if (this.flushFailure != null) {
                throw Throwables.propagate((Throwable)this.flushFailure);
            }
            return commitLogUpperBound;
        }
    }
}

