/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import org.apache.cassandra.audit.IAuditLogger;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.binlog.BinLog;
import org.apache.cassandra.utils.binlog.BinLogArchiver;
import org.apache.cassandra.utils.binlog.DeletingArchiver;
import org.apache.cassandra.utils.binlog.ExternalArchiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BinLogAuditLogger
implements IAuditLogger {
    protected static final Logger logger = LoggerFactory.getLogger(BinLogAuditLogger.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    private static final NoSpamLogger.NoSpamLogStatement droppedSamplesStatement = noSpamLogger.getStatement("Dropped {} binary log samples", 1L, TimeUnit.MINUTES);
    volatile BinLog binLog;
    protected volatile boolean blocking;
    protected Path path;
    private final AtomicLong droppedSamplesSinceLastLog = new AtomicLong();

    BinLogAuditLogger() {
    }

    public synchronized void configure(Path path, String rollCycle, boolean blocking, int maxQueueWeight, long maxLogSize, String archiveCommand, int maxArchiveRetries) {
        this.configure(path, rollCycle, blocking, maxQueueWeight, maxLogSize, true, archiveCommand, maxArchiveRetries);
    }

    public synchronized void configure(Path path, String rollCycle, boolean blocking, int maxQueueWeight, long maxLogSize, boolean cleanDirectory, String archiveCommand, int maxArchiveRetries) {
        BinLogArchiver archiver;
        Preconditions.checkNotNull((Object)path, (Object)"path was null");
        File pathAsFile = path.toFile();
        Preconditions.checkNotNull((Object)rollCycle, (Object)"rollCycle was null");
        rollCycle = rollCycle.toUpperCase();
        Preconditions.checkArgument((pathAsFile.exists() && pathAsFile.isDirectory() || !pathAsFile.exists() && pathAsFile.mkdirs() ? 1 : 0) != 0, (Object)"path exists and is not a directory or couldn't be created");
        Preconditions.checkArgument((pathAsFile.canRead() && pathAsFile.canWrite() && pathAsFile.canExecute() ? 1 : 0) != 0, (Object)"path is not readable, writable, and executable");
        Preconditions.checkNotNull((Object)RollCycles.valueOf((String)rollCycle), (Object)"unrecognized roll cycle");
        Preconditions.checkArgument((maxQueueWeight > 0 ? 1 : 0) != 0, (Object)"maxQueueWeight must be > 0");
        Preconditions.checkArgument((maxLogSize > 0L ? 1 : 0) != 0, (Object)"maxLogSize must be > 0");
        logger.info("Attempting to configure full query logger path: {} Roll cycle: {} Blocking: {} Max queue weight: {} Max log size:{}, archive command: {}", new Object[]{path, rollCycle, blocking, maxQueueWeight, maxLogSize, archiveCommand});
        if (this.binLog != null) {
            logger.warn("Full query logger already configured. Ignoring requested configuration.");
            throw new IllegalStateException("Already configured");
        }
        BinLogArchiver binLogArchiver = archiver = Strings.isNullOrEmpty((String)archiveCommand) ? new DeletingArchiver(maxLogSize) : new ExternalArchiver(archiveCommand, path, maxArchiveRetries);
        if (cleanDirectory) {
            Throwable error;
            logger.info("Cleaning directory: {} as requested", (Object)path);
            if (path.toFile().exists() && (error = BinLogAuditLogger.cleanDirectory(path.toFile(), null)) != null) {
                throw new RuntimeException(error);
            }
        }
        this.path = path;
        this.blocking = blocking;
        this.binLog = new BinLog(path, (RollCycle)RollCycles.valueOf((String)rollCycle), maxQueueWeight, archiver);
        this.binLog.start();
    }

    @Override
    public Path path() {
        return this.path;
    }

    public synchronized void reset(String fullQueryLogPath) {
        try {
            File pathFile;
            File fullQueryLogPathFile;
            HashSet pathsToClean = Sets.newHashSet();
            if (fullQueryLogPath != null && (fullQueryLogPathFile = new File(fullQueryLogPath)).exists()) {
                pathsToClean.add(fullQueryLogPathFile);
            }
            if (this.path != null && (pathFile = this.path.toFile()).exists()) {
                pathsToClean.add(pathFile);
            }
            logger.info("Reset (and deactivation) of full query log requested.");
            if (this.binLog != null) {
                logger.info("Stopping full query log. Cleaning {}.", (Object)pathsToClean);
                this.binLog.stop();
                this.binLog = null;
            } else {
                logger.info("Full query log already deactivated. Cleaning {}.", (Object)pathsToClean);
            }
            Throwable accumulate = null;
            for (File f : pathsToClean) {
                accumulate = BinLogAuditLogger.cleanDirectory(f, accumulate);
            }
            if (accumulate != null) {
                throw new RuntimeException(accumulate);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void stop() {
        try {
            logger.info("Deactivation of full query log requested.");
            if (this.binLog != null) {
                logger.info("Stopping full query log");
                this.binLog.stop();
                this.binLog = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean enabled() {
        return this.binLog != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logRecord(BinLog.ReleaseableWriteMarshallable record, BinLog binLog) {
        block9: {
            boolean putInQueue = false;
            try {
                if (this.blocking) {
                    try {
                        binLog.put(record);
                        putInQueue = true;
                        break block9;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!binLog.offer(record)) {
                    this.logDroppedSample();
                } else {
                    putInQueue = true;
                }
            }
            finally {
                if (!putInQueue) {
                    record.release();
                }
            }
        }
    }

    private void logDroppedSample() {
        this.droppedSamplesSinceLastLog.incrementAndGet();
        if (droppedSamplesStatement.warn(this.droppedSamplesSinceLastLog.get())) {
            this.droppedSamplesSinceLastLog.set(0L);
        }
    }

    private static Throwable cleanDirectory(File directory, Throwable accumulate) {
        if (!directory.exists()) {
            return Throwables.merge(accumulate, new RuntimeException(String.format("%s does not exists", directory)));
        }
        if (!directory.isDirectory()) {
            return Throwables.merge(accumulate, new RuntimeException(String.format("%s is not a directory", directory)));
        }
        for (File f : directory.listFiles()) {
            accumulate = BinLogAuditLogger.deleteRecursively(f, accumulate);
        }
        if (accumulate instanceof FSError) {
            FileUtils.handleFSError((FSError)accumulate);
        }
        return accumulate;
    }

    private static Throwable deleteRecursively(File fileOrDirectory, Throwable accumulate) {
        if (fileOrDirectory.isDirectory()) {
            for (File f : fileOrDirectory.listFiles()) {
                accumulate = FileUtils.deleteWithConfirm(f, accumulate);
            }
        }
        return FileUtils.deleteWithConfirm(fileOrDirectory, accumulate);
    }
}

