/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Collection;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaAnnouncementDiagnostics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaPushVerbHandler
implements IVerbHandler<Collection<Mutation>> {
    public static final SchemaPushVerbHandler instance = new SchemaPushVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(SchemaPushVerbHandler.class);

    @Override
    public void doVerb(Message<Collection<Mutation>> message) {
        logger.trace("Received schema push request from {}", (Object)message.from());
        SchemaAnnouncementDiagnostics.schemataMutationsReceived(message.from());
        StageManager.getStage(Stage.MIGRATION).submit(() -> Schema.instance.mergeAndAnnounceVersion((Collection)message.payload));
    }
}

