/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;

public interface ReplicaCollection<C extends ReplicaCollection<C>>
extends Iterable<Replica> {
    public Set<InetAddressAndPort> endpoints();

    public Replica get(int var1);

    public int size();

    public boolean isEmpty();

    public boolean contains(Replica var1);

    public int count(Predicate<Replica> var1);

    public C filter(Predicate<Replica> var1);

    public C filter(Predicate<Replica> var1, int var2);

    public Iterable<Replica> filterLazily(Predicate<Replica> var1);

    public Iterable<Replica> filterLazily(Predicate<Replica> var1, int var2);

    public C subList(int var1, int var2);

    public C sorted(Comparator<Replica> var1);

    @Override
    public Iterator<Replica> iterator();

    public Stream<Replica> stream();

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    public static interface Builder<C extends ReplicaCollection<C>>
    extends ReplicaCollection<C> {
        public C build();

        public Builder<C> add(Replica var1, Conflict var2);

        default public Builder<C> add(Replica replica) {
            return this.add(replica, Conflict.NONE);
        }

        default public Builder<C> addAll(Iterable<Replica> replicas, Conflict ignoreConflicts) {
            for (Replica replica : replicas) {
                this.add(replica, ignoreConflicts);
            }
            return this;
        }

        default public Builder<C> addAll(Iterable<Replica> replicas) {
            return this.addAll(replicas, Conflict.NONE);
        }

        public static enum Conflict {
            NONE,
            DUPLICATE,
            ALL;

        }
    }
}

