/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicationFactor;
import org.apache.cassandra.locator.TokenMetadata;

public class OldNetworkTopologyStrategy
extends AbstractReplicationStrategy {
    private final ReplicationFactor rf;

    public OldNetworkTopologyStrategy(String keyspaceName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(keyspaceName, tokenMetadata, snitch, configOptions);
        this.rf = ReplicationFactor.fromString((String)this.configOptions.get("replication_factor"));
    }

    @Override
    public EndpointsForRange calculateNaturalReplicas(Token token, TokenMetadata metadata) {
        Token t;
        ArrayList<Token> tokens = metadata.sortedTokens();
        if (tokens.isEmpty()) {
            return EndpointsForRange.empty(new Range<Token>(metadata.partitioner.getMinimumToken(), metadata.partitioner.getMinimumToken()));
        }
        Iterator<Token> iter = TokenMetadata.ringIterator(tokens, token, false);
        Token primaryToken = iter.next();
        Token previousToken = metadata.getPredecessor(primaryToken);
        Range<Token> tokenRange = new Range<Token>(previousToken, primaryToken);
        EndpointsForRange.Builder replicas = new EndpointsForRange.Builder(tokenRange, this.rf.allReplicas);
        assert (!this.rf.hasTransientReplicas()) : "support transient replicas";
        replicas.add(new Replica(metadata.getEndpoint(primaryToken), previousToken, primaryToken, true));
        boolean bDataCenter = false;
        boolean bOtherRack = false;
        while (replicas.size() < this.rf.allReplicas && iter.hasNext()) {
            t = iter.next();
            if (!this.snitch.getDatacenter(metadata.getEndpoint(primaryToken)).equals(this.snitch.getDatacenter(metadata.getEndpoint(t)))) {
                if (bDataCenter) continue;
                replicas.add(new Replica(metadata.getEndpoint(t), previousToken, primaryToken, true));
                bDataCenter = true;
                continue;
            }
            if (this.snitch.getRack(metadata.getEndpoint(primaryToken)).equals(this.snitch.getRack(metadata.getEndpoint(t))) || !this.snitch.getDatacenter(metadata.getEndpoint(primaryToken)).equals(this.snitch.getDatacenter(metadata.getEndpoint(t))) || bOtherRack) continue;
            replicas.add(new Replica(metadata.getEndpoint(t), previousToken, primaryToken, true));
            bOtherRack = true;
        }
        if (replicas.size() < this.rf.allReplicas) {
            iter = TokenMetadata.ringIterator(tokens, token, false);
            while (replicas.size() < this.rf.allReplicas && iter.hasNext()) {
                t = iter.next();
                Replica replica = new Replica(metadata.getEndpoint(t), previousToken, primaryToken, true);
                if (replicas.endpoints().contains(replica.endpoint())) continue;
                replicas.add(replica);
            }
        }
        return replicas.build();
    }

    @Override
    public ReplicationFactor getReplicationFactor() {
        return this.rf;
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        if (this.configOptions == null || this.configOptions.get("replication_factor") == null) {
            throw new ConfigurationException("SimpleStrategy requires a replication_factor strategy option.");
        }
        this.validateReplicationFactor((String)this.configOptions.get("replication_factor"));
    }

    @Override
    public Collection<String> recognizedOptions() {
        return Collections.singleton("replication_factor");
    }
}

