/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.base.Throwables;
import java.io.IOException;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.streaming.CassandraStreamHeader;
import org.apache.cassandra.db.streaming.CassandraStreamReader;
import org.apache.cassandra.db.streaming.CompressedInputStream;
import org.apache.cassandra.db.streaming.CompressionInfo;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.TrackedDataInputPlus;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.StreamMessageHeader;
import org.apache.cassandra.utils.ChecksumType;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraCompressedStreamReader
extends CassandraStreamReader {
    private static final Logger logger = LoggerFactory.getLogger(CassandraCompressedStreamReader.class);
    protected final CompressionInfo compressionInfo;

    public CassandraCompressedStreamReader(StreamMessageHeader header, CassandraStreamHeader streamHeader, StreamSession session) {
        super(header, streamHeader, session);
        this.compressionInfo = streamHeader.compressionInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SSTableMultiWriter read(DataInputPlus inputPlus) throws IOException {
        long totalSize = this.totalSize();
        ColumnFamilyStore cfs = ColumnFamilyStore.getIfExists(this.tableId);
        if (cfs == null) {
            throw new IOException("CF " + this.tableId + " was dropped during streaming");
        }
        logger.debug("[Stream #{}] Start receiving file #{} from {}, repairedAt = {}, size = {}, ks = '{}', pendingRepair = '{}', table = '{}'.", new Object[]{this.session.planId(), this.fileSeqNum, this.session.peer, this.repairedAt, totalSize, cfs.keyspace.getName(), this.pendingRepair, cfs.getTableName()});
        CassandraStreamReader.StreamDeserializer deserializer = null;
        Transactional writer = null;
        try (CompressedInputStream cis = new CompressedInputStream(inputPlus, this.compressionInfo, ChecksumType.CRC32, cfs::getCrcCheckChance);){
            TrackedDataInputPlus in = new TrackedDataInputPlus(cis);
            deserializer = new CassandraStreamReader.StreamDeserializer(cfs.metadata(), in, this.inputVersion, this.getHeader(cfs.metadata()));
            writer = this.createWriter(cfs, totalSize, this.repairedAt, this.pendingRepair, this.format);
            String filename = writer.getFilename();
            int sectionIdx = 0;
            for (SSTableReader.PartitionPositionBounds section : this.sections) {
                assert (cis.getTotalCompressedBytesRead() <= totalSize);
                long sectionLength = section.upperPosition - section.lowerPosition;
                logger.trace("[Stream #{}] Reading section {} with length {} from stream.", new Object[]{this.session.planId(), sectionIdx++, sectionLength});
                cis.position(section.lowerPosition);
                in.reset(0L);
                while (in.getBytesRead() < sectionLength) {
                    this.writePartition(deserializer, (SSTableMultiWriter)writer);
                    this.session.progress(filename, ProgressInfo.Direction.IN, cis.getTotalCompressedBytesRead(), totalSize);
                }
                assert (in.getBytesRead() == sectionLength);
            }
            logger.trace("[Stream #{}] Finished receiving file #{} from {} readBytes = {}, totalSize = {}", new Object[]{this.session.planId(), this.fileSeqNum, this.session.peer, FBUtilities.prettyPrintMemory(cis.getTotalCompressedBytesRead()), FBUtilities.prettyPrintMemory(totalSize)});
            Transactional transactional = writer;
            return transactional;
        }
        catch (Throwable e) {
            Object partitionKey = deserializer != null ? deserializer.partitionKey() : "";
            logger.warn("[Stream {}] Error while reading partition {} from stream on ks='{}' and table='{}'.", new Object[]{this.session.planId(), partitionKey, cfs.keyspace.getName(), cfs.getTableName()});
            if (writer != null) {
                writer.abort(e);
            }
            if (!org.apache.cassandra.utils.Throwables.extractIOExceptionCause(e).isPresent()) throw Throwables.propagate((Throwable)e);
            throw e;
        }
    }

    @Override
    protected long totalSize() {
        long size = 0L;
        for (CompressionMetadata.Chunk chunk : this.compressionInfo.chunks) {
            size += (long)(chunk.length + 4);
        }
        return size;
    }
}

