/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.hash.Hasher;
import java.util.List;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.WithOnlyQueriedData;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.db.transform.FilteredRows;
import org.apache.cassandra.db.transform.MoreRows;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.HashingUtils;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnfilteredRowIterators {
    private static final Logger logger = LoggerFactory.getLogger(UnfilteredRowIterators.class);

    private UnfilteredRowIterators() {
    }

    public static RowIterator filter(UnfilteredRowIterator iter, int nowInSec) {
        return FilteredRows.filter(iter, nowInSec);
    }

    public static UnfilteredRowIterator merge(List<UnfilteredRowIterator> iterators) {
        assert (!iterators.isEmpty());
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        return UnfilteredRowMergeIterator.create(iterators, null);
    }

    public static UnfilteredRowIterator merge(List<UnfilteredRowIterator> iterators, MergeListener mergeListener) {
        return UnfilteredRowMergeIterator.create(iterators, mergeListener);
    }

    public static UnfilteredRowIterator noRowsIterator(TableMetadata metadata, DecoratedKey partitionKey, Row staticRow, DeletionTime partitionDeletion, boolean isReverseOrder) {
        return EmptyIterators.unfilteredRow(metadata, partitionKey, isReverseOrder, staticRow, partitionDeletion);
    }

    public static UnfilteredRowIterator singleton(final Unfiltered unfiltered, TableMetadata metadata, DecoratedKey partitionKey, DeletionTime partitionLevelDeletion, RegularAndStaticColumns columns, Row staticRow, boolean isReverseOrder, EncodingStats encodingStats) {
        return new AbstractUnfilteredRowIterator(metadata, partitionKey, partitionLevelDeletion, columns, staticRow, isReverseOrder, encodingStats){
            boolean isDone;
            {
                super(metadata, partitionKey, partitionLevelDeletion, columns, staticRow, isReverseOrder, stats);
                this.isDone = false;
            }

            @Override
            protected Unfiltered computeNext() {
                if (!this.isDone) {
                    this.isDone = true;
                    return unfiltered;
                }
                return (Unfiltered)this.endOfData();
            }
        };
    }

    public static void digest(UnfilteredRowIterator iterator, Hasher hasher, int version) {
        HashingUtils.updateBytes(hasher, iterator.partitionKey().getKey().duplicate());
        iterator.partitionLevelDeletion().digest(hasher);
        iterator.columns().regulars.digest(hasher);
        if (iterator.staticRow() != Rows.EMPTY_STATIC_ROW) {
            iterator.columns().statics.digest(hasher);
        }
        HashingUtils.updateWithBoolean(hasher, iterator.isReverseOrder());
        iterator.staticRow().digest(hasher);
        while (iterator.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)iterator.next();
            unfiltered.digest(hasher);
        }
    }

    public static UnfilteredRowIterator withOnlyQueriedData(UnfilteredRowIterator iterator, ColumnFilter filter) {
        if (filter.allFetchedColumnsAreQueried()) {
            return iterator;
        }
        return Transformation.apply(iterator, new WithOnlyQueriedData(filter));
    }

    public static UnfilteredRowIterator concat(UnfilteredRowIterator iter1, UnfilteredRowIterator iter2) {
        assert (iter1.metadata().id.equals(iter2.metadata().id) && iter1.partitionKey().equals(iter2.partitionKey()) && iter1.partitionLevelDeletion().equals(iter2.partitionLevelDeletion()) && iter1.isReverseOrder() == iter2.isReverseOrder() && iter1.staticRow().equals(iter2.staticRow()));
        class Extend
        implements MoreRows<UnfilteredRowIterator> {
            boolean returned = false;
            final /* synthetic */ UnfilteredRowIterator val$iter2;

            Extend(UnfilteredRowIterator unfilteredRowIterator) {
                this.val$iter2 = unfilteredRowIterator;
            }

            @Override
            public UnfilteredRowIterator moreContents() {
                if (this.returned) {
                    return null;
                }
                this.returned = true;
                return this.val$iter2;
            }
        }
        return MoreRows.extend(iter1, new Extend(iter2), iter1.columns().mergeTo(iter2.columns()));
    }

    public static UnfilteredRowIterator concat(final Unfiltered first, UnfilteredRowIterator rest) {
        return new WrappingUnfilteredRowIterator(rest){
            private boolean hasReturnedFirst;

            @Override
            public boolean hasNext() {
                return this.hasReturnedFirst ? super.hasNext() : true;
            }

            @Override
            public Unfiltered next() {
                if (!this.hasReturnedFirst) {
                    this.hasReturnedFirst = true;
                    return first;
                }
                return super.next();
            }
        };
    }

    public static UnfilteredRowIterator withValidation(final UnfilteredRowIterator iterator, final String filename) {
        class Validator
        extends Transformation {
            Validator() {
            }

            @Override
            public Row applyToStatic(Row row) {
                this.validate(row);
                return row;
            }

            @Override
            public Row applyToRow(Row row) {
                this.validate(row);
                return row;
            }

            @Override
            public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
                this.validate(marker);
                return marker;
            }

            private void validate(Unfiltered unfiltered) {
                try {
                    unfiltered.validateData(iterator.metadata());
                }
                catch (MarshalException me) {
                    throw new CorruptSSTableException((Throwable)me, filename);
                }
            }
        }
        return Transformation.apply(iterator, new Validator());
    }

    public static UnfilteredRowIterator loggingIterator(UnfilteredRowIterator iterator, final String id, final boolean fullDetails) {
        final TableMetadata metadata = iterator.metadata();
        logger.info("[{}] Logging iterator on {}.{}, partition key={}, reversed={}, deletion={}", new Object[]{id, metadata.keyspace, metadata.name, metadata.partitionKeyType.getString(iterator.partitionKey().getKey()), iterator.isReverseOrder(), iterator.partitionLevelDeletion().markedForDeleteAt()});
        class Logger
        extends Transformation {
            Logger() {
            }

            @Override
            public Row applyToStatic(Row row) {
                if (!row.isEmpty()) {
                    logger.info("[{}] {}", (Object)id, (Object)row.toString(metadata, fullDetails));
                }
                return row;
            }

            @Override
            public Row applyToRow(Row row) {
                logger.info("[{}] {}", (Object)id, (Object)row.toString(metadata, fullDetails));
                return row;
            }

            @Override
            public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
                logger.info("[{}] {}", (Object)id, (Object)marker.toString(metadata));
                return marker;
            }
        }
        return Transformation.apply(iterator, new Logger());
    }

    private static class UnfilteredRowMergeIterator
    extends AbstractUnfilteredRowIterator {
        private final IMergeIterator<Unfiltered, Unfiltered> mergeIterator;
        private final MergeListener listener;

        private UnfilteredRowMergeIterator(TableMetadata metadata, List<UnfilteredRowIterator> iterators, RegularAndStaticColumns columns, DeletionTime partitionDeletion, boolean reversed, MergeListener listener) {
            super(metadata, iterators.get(0).partitionKey(), partitionDeletion, columns, UnfilteredRowMergeIterator.mergeStaticRows(iterators, columns.statics, listener, partitionDeletion), reversed, EncodingStats.merge(iterators, UnfilteredRowIterator::stats));
            this.mergeIterator = MergeIterator.get(iterators, reversed ? metadata.comparator.reversed() : metadata.comparator, new MergeReducer(iterators.size(), reversed, listener));
            this.listener = listener;
        }

        private static UnfilteredRowMergeIterator create(List<UnfilteredRowIterator> iterators, MergeListener listener) {
            try {
                UnfilteredRowMergeIterator.checkForInvalidInput(iterators);
                return new UnfilteredRowMergeIterator(iterators.get(0).metadata(), iterators, UnfilteredRowMergeIterator.collectColumns(iterators), UnfilteredRowMergeIterator.collectPartitionLevelDeletion(iterators, listener), iterators.get(0).isReverseOrder(), listener);
            }
            catch (Error | RuntimeException e) {
                try {
                    FBUtilities.closeAll(iterators);
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
        }

        private static void checkForInvalidInput(List<UnfilteredRowIterator> iterators) {
            if (iterators.isEmpty()) {
                return;
            }
            UnfilteredRowIterator first = iterators.get(0);
            for (int i = 1; i < iterators.size(); ++i) {
                UnfilteredRowIterator iter = iterators.get(i);
                assert (first.metadata().id.equals(iter.metadata().id));
                assert (first.partitionKey().equals(iter.partitionKey()));
                assert (first.isReverseOrder() == iter.isReverseOrder());
            }
        }

        private static DeletionTime collectPartitionLevelDeletion(List<UnfilteredRowIterator> iterators, MergeListener listener) {
            DeletionTime[] versions = listener == null ? null : new DeletionTime[iterators.size()];
            DeletionTime delTime = DeletionTime.LIVE;
            for (int i = 0; i < iterators.size(); ++i) {
                UnfilteredRowIterator iter = iterators.get(i);
                DeletionTime iterDeletion = iter.partitionLevelDeletion();
                if (listener != null) {
                    versions[i] = iterDeletion;
                }
                if (delTime.supersedes(iterDeletion)) continue;
                delTime = iterDeletion;
            }
            if (listener != null) {
                listener.onMergedPartitionLevelDeletion(delTime, versions);
            }
            return delTime;
        }

        private static Row mergeStaticRows(List<UnfilteredRowIterator> iterators, Columns columns, MergeListener listener, DeletionTime partitionDeletion) {
            if (columns.isEmpty()) {
                return Rows.EMPTY_STATIC_ROW;
            }
            if (iterators.stream().allMatch(iter -> iter.staticRow().isEmpty())) {
                return Rows.EMPTY_STATIC_ROW;
            }
            Row.Merger merger = new Row.Merger(iterators.size(), columns.hasComplex());
            for (int i = 0; i < iterators.size(); ++i) {
                merger.add(i, iterators.get(i).staticRow());
            }
            Row merged = merger.merge(partitionDeletion);
            if (merged == null) {
                merged = Rows.EMPTY_STATIC_ROW;
            }
            if (listener != null) {
                listener.onMergedRows(merged, merger.mergedRows());
            }
            return merged;
        }

        private static RegularAndStaticColumns collectColumns(List<UnfilteredRowIterator> iterators) {
            RegularAndStaticColumns first = iterators.get(0).columns();
            Columns statics = first.statics;
            Columns regulars = first.regulars;
            for (int i = 1; i < iterators.size(); ++i) {
                RegularAndStaticColumns cols = iterators.get(i).columns();
                statics = statics.mergeTo(cols.statics);
                regulars = regulars.mergeTo(cols.regulars);
            }
            return statics == first.statics && regulars == first.regulars ? first : new RegularAndStaticColumns(statics, regulars);
        }

        @Override
        protected Unfiltered computeNext() {
            while (this.mergeIterator.hasNext()) {
                Unfiltered merged = (Unfiltered)this.mergeIterator.next();
                if (merged == null) continue;
                return merged;
            }
            return (Unfiltered)this.endOfData();
        }

        @Override
        public void close() {
            FileUtils.closeQuietly(this.mergeIterator);
            if (this.listener != null) {
                this.listener.close();
            }
        }

        private class MergeReducer
        extends MergeIterator.Reducer<Unfiltered, Unfiltered> {
            private final MergeListener listener;
            private Unfiltered.Kind nextKind;
            private final Row.Merger rowMerger;
            private final RangeTombstoneMarker.Merger markerMerger;

            private MergeReducer(int size, boolean reversed, MergeListener listener) {
                this.rowMerger = new Row.Merger(size, UnfilteredRowMergeIterator.this.columns().regulars.hasComplex());
                this.markerMerger = new RangeTombstoneMarker.Merger(size, UnfilteredRowMergeIterator.this.partitionLevelDeletion(), reversed);
                this.listener = listener;
            }

            @Override
            public boolean trivialReduceIsTrivial() {
                return this.listener == null;
            }

            @Override
            public void reduce(int idx, Unfiltered current) {
                this.nextKind = current.kind();
                if (this.nextKind == Unfiltered.Kind.ROW) {
                    this.rowMerger.add(idx, (Row)current);
                } else {
                    this.markerMerger.add(idx, (RangeTombstoneMarker)current);
                }
            }

            @Override
            protected Unfiltered getReduced() {
                if (this.nextKind == Unfiltered.Kind.ROW) {
                    Row merged = this.rowMerger.merge(this.markerMerger.activeDeletion());
                    if (this.listener != null) {
                        this.listener.onMergedRows(merged == null ? BTreeRow.emptyRow(this.rowMerger.mergedClustering()) : merged, this.rowMerger.mergedRows());
                    }
                    return merged;
                }
                RangeTombstoneMarker merged = this.markerMerger.merge();
                if (this.listener != null) {
                    this.listener.onMergedRangeTombstoneMarkers(merged, this.markerMerger.mergedMarkers());
                }
                return merged;
            }

            @Override
            protected void onKeyChange() {
                if (this.nextKind == Unfiltered.Kind.ROW) {
                    this.rowMerger.clear();
                } else {
                    this.markerMerger.clear();
                }
            }
        }
    }

    public static interface MergeListener {
        public static final MergeListener NOOP = new MergeListener(){

            @Override
            public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
            }

            @Override
            public void onMergedRows(Row merged, Row[] versions) {
            }

            @Override
            public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
            }

            @Override
            public void close() {
            }
        };

        public void onMergedPartitionLevelDeletion(DeletionTime var1, DeletionTime[] var2);

        public void onMergedRows(Row var1, Row[] var2);

        public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker var1, RangeTombstoneMarker[] var2);

        public void close();
    }
}

