/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.repair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.LongPredicate;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.ActiveCompactionsTracker;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.repair.ValidationPartitionIterator;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraValidationIterator
extends ValidationPartitionIterator {
    private static final Logger logger = LoggerFactory.getLogger(CassandraValidationIterator.class);
    private final ColumnFamilyStore cfs;
    private final Refs<SSTableReader> sstables;
    private final String snapshotName;
    private final boolean isGlobalSnapshotValidation;
    private final boolean isSnapshotValidation;
    private final AbstractCompactionStrategy.ScannerList scanners;
    private final ValidationCompactionController controller;
    private final CompactionIterator ci;
    private final long estimatedBytes;
    private final long estimatedPartitions;
    private final Map<Range<Token>, Long> rangePartitionCounts;

    public static int getDefaultGcBefore(ColumnFamilyStore cfs, int nowInSec) {
        return cfs.isIndex() ? nowInSec : cfs.gcBefore(nowInSec);
    }

    private static Predicate<SSTableReader> getPreviewPredicate(PreviewKind previewKind) {
        switch (previewKind) {
            case ALL: {
                return s -> true;
            }
            case REPAIRED: {
                return s -> s.isRepaired();
            }
            case UNREPAIRED: {
                return s -> !s.isRepaired();
            }
        }
        throw new RuntimeException("Can't get preview predicate for preview kind " + (Object)((Object)previewKind));
    }

    @VisibleForTesting
    static synchronized Refs<SSTableReader> getSSTablesToValidate(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, UUID parentId, boolean isIncremental) {
        Refs<SSTableReader> sstables;
        ActiveRepairService.ParentRepairSession prs = ActiveRepairService.instance.getParentRepairSession(parentId);
        if (prs == null) {
            return new Refs<SSTableReader>();
        }
        HashSet<SSTableReader> sstablesToValidate = new HashSet<SSTableReader>();
        Predicate predicate = prs.isPreview() ? CassandraValidationIterator.getPreviewPredicate(prs.previewKind) : (isIncremental ? s -> parentId.equals(s.getSSTableMetadata().pendingRepair) : s -> !prs.isIncremental || !s.isRepaired());
        try (ColumnFamilyStore.RefViewFragment sstableCandidates = cfs.selectAndReference(View.select(SSTableSet.CANONICAL, (Predicate<SSTableReader>)predicate));){
            for (SSTableReader sstable : sstableCandidates.sstables) {
                if (!((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(ranges)) continue;
                sstablesToValidate.add(sstable);
            }
            sstables = Refs.tryRef(sstablesToValidate);
            if (sstables == null) {
                logger.error("Could not reference sstables");
                throw new RuntimeException("Could not reference sstables");
            }
        }
        return sstables;
    }

    public CassandraValidationIterator(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, UUID parentId, UUID sessionID, boolean isIncremental, int nowInSec) throws IOException {
        this.cfs = cfs;
        this.isGlobalSnapshotValidation = cfs.snapshotExists(parentId.toString());
        this.snapshotName = this.isGlobalSnapshotValidation ? parentId.toString() : sessionID.toString();
        this.isSnapshotValidation = cfs.snapshotExists(this.snapshotName);
        if (this.isSnapshotValidation) {
            this.sstables = cfs.getSnapshotSSTableReaders(this.snapshotName);
        } else {
            if (!isIncremental) {
                StorageService.instance.forceKeyspaceFlush(cfs.keyspace.getName(), cfs.name);
            }
            this.sstables = CassandraValidationIterator.getSSTablesToValidate(cfs, ranges, parentId, isIncremental);
        }
        Preconditions.checkArgument((this.sstables != null ? 1 : 0) != 0);
        this.controller = new ValidationCompactionController(cfs, CassandraValidationIterator.getDefaultGcBefore(cfs, nowInSec));
        this.scanners = cfs.getCompactionStrategyManager().getScanners(this.sstables, ranges);
        this.ci = new ValidationCompactionIterator(this.scanners.scanners, this.controller, nowInSec, CompactionManager.instance.active);
        long allPartitions = 0L;
        this.rangePartitionCounts = Maps.newHashMapWithExpectedSize((int)ranges.size());
        for (Range<Token> range : ranges) {
            long numPartitions = 0L;
            for (SSTableReader sstable : this.sstables) {
                numPartitions += sstable.estimatedKeysForRanges(Collections.singleton(range));
            }
            this.rangePartitionCounts.put(range, numPartitions);
            allPartitions += numPartitions;
        }
        this.estimatedPartitions = allPartitions;
        long estimatedTotalBytes = 0L;
        for (SSTableReader sstable : this.sstables) {
            for (SSTableReader.PartitionPositionBounds positionsForRanges : sstable.getPositionsForRanges(ranges)) {
                estimatedTotalBytes += positionsForRanges.upperPosition - positionsForRanges.lowerPosition;
            }
        }
        this.estimatedBytes = estimatedTotalBytes;
    }

    @Override
    public void close() {
        super.close();
        if (this.ci != null) {
            this.ci.close();
        }
        if (this.scanners != null) {
            this.scanners.close();
        }
        if (this.controller != null) {
            this.controller.close();
        }
        if (this.isSnapshotValidation && !this.isGlobalSnapshotValidation) {
            this.cfs.clearSnapshot(this.snapshotName);
        }
        if (this.sstables != null) {
            this.sstables.release();
        }
    }

    @Override
    public TableMetadata metadata() {
        return this.cfs.metadata.get();
    }

    @Override
    public boolean hasNext() {
        return this.ci.hasNext();
    }

    @Override
    public UnfilteredRowIterator next() {
        return this.ci.next();
    }

    @Override
    public long getEstimatedBytes() {
        return this.estimatedBytes;
    }

    @Override
    public long estimatedPartitions() {
        return this.estimatedPartitions;
    }

    @Override
    public Map<Range<Token>, Long> getRangePartitionCounts() {
        return this.rangePartitionCounts;
    }

    private static class ValidationCompactionIterator
    extends CompactionIterator {
        public ValidationCompactionIterator(List<ISSTableScanner> scanners, ValidationCompactionController controller, int nowInSec, ActiveCompactionsTracker activeCompactions) {
            super(OperationType.VALIDATION, scanners, controller, nowInSec, UUIDGen.getTimeUUID(), activeCompactions);
        }
    }

    private static class ValidationCompactionController
    extends CompactionController {
        public ValidationCompactionController(ColumnFamilyStore cfs, int gcBefore) {
            super(cfs, gcBefore);
        }

        @Override
        public LongPredicate getPurgeEvaluator(DecoratedKey key) {
            return time -> true;
        }
    }
}

