/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.schema.TableMetadata;

public class UnfilteredDeserializer {
    protected final TableMetadata metadata;
    protected final DataInputPlus in;
    protected final SerializationHelper helper;
    private final ClusteringPrefix.Deserializer clusteringDeserializer;
    private final SerializationHeader header;
    private int nextFlags;
    private int nextExtendedFlags;
    private boolean isReady;
    private boolean isDone;
    private final Row.Builder builder;

    private UnfilteredDeserializer(TableMetadata metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper) {
        this.metadata = metadata;
        this.in = in;
        this.helper = helper;
        this.header = header;
        this.clusteringDeserializer = new ClusteringPrefix.Deserializer(metadata.comparator, in, header);
        this.builder = BTreeRow.sortedBuilder();
    }

    public static UnfilteredDeserializer create(TableMetadata metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper) {
        return new UnfilteredDeserializer(metadata, in, header, helper);
    }

    public boolean hasNext() throws IOException {
        if (this.isReady) {
            return true;
        }
        this.prepareNext();
        return !this.isDone;
    }

    private void prepareNext() throws IOException {
        if (this.isDone) {
            return;
        }
        this.nextFlags = this.in.readUnsignedByte();
        if (UnfilteredSerializer.isEndOfPartition(this.nextFlags)) {
            this.isDone = true;
            this.isReady = false;
            return;
        }
        this.nextExtendedFlags = UnfilteredSerializer.readExtendedFlags(this.in, this.nextFlags);
        this.clusteringDeserializer.prepare(this.nextFlags, this.nextExtendedFlags);
        this.isReady = true;
    }

    public int compareNextTo(ClusteringBound bound) throws IOException {
        if (!this.isReady) {
            this.prepareNext();
        }
        assert (!this.isDone);
        return this.clusteringDeserializer.compareNextTo(bound);
    }

    public boolean nextIsRow() throws IOException {
        if (!this.isReady) {
            this.prepareNext();
        }
        return UnfilteredSerializer.kind(this.nextFlags) == Unfiltered.Kind.ROW;
    }

    public Unfiltered readNext() throws IOException {
        this.isReady = false;
        if (UnfilteredSerializer.kind(this.nextFlags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            ClusteringBoundOrBoundary bound = this.clusteringDeserializer.deserializeNextBound();
            return UnfilteredSerializer.serializer.deserializeMarkerBody(this.in, this.header, bound);
        }
        this.builder.newRow(this.clusteringDeserializer.deserializeNextClustering());
        return UnfilteredSerializer.serializer.deserializeRowBody(this.in, this.header, this.helper, this.nextFlags, this.nextExtendedFlags, this.builder);
    }

    public void clearState() {
        this.isReady = false;
        this.isDone = false;
    }

    public void skipNext() throws IOException {
        this.isReady = false;
        this.clusteringDeserializer.skipNext();
        if (UnfilteredSerializer.kind(this.nextFlags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            UnfilteredSerializer.serializer.skipMarkerBody(this.in);
        } else {
            UnfilteredSerializer.serializer.skipRowBody(this.in);
        }
    }
}

