/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.schema.TableId;

public interface IMutation {
    public void apply();

    public String getKeyspaceName();

    public Collection<TableId> getTableIds();

    public DecoratedKey key();

    public long getTimeout(TimeUnit var1);

    public String toString(boolean var1);

    public Collection<PartitionUpdate> getPartitionUpdates();

    default public void validateIndexedColumns() {
        for (PartitionUpdate pu : this.getPartitionUpdates()) {
            pu.validateIndexedColumns();
        }
    }

    public static long dataSize(Collection<? extends IMutation> mutations) {
        long size = 0L;
        for (IMutation iMutation : mutations) {
            for (PartitionUpdate update : iMutation.getPartitionUpdates()) {
                size += (long)update.dataSize();
            }
        }
        return size;
    }
}

