/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.cassandra.concurrent.LocalAwareExecutorService;
import org.apache.cassandra.concurrent.SEPExecutor;
import org.apache.cassandra.concurrent.SEPWorker;

public class SharedExecutorPool {
    public static final SharedExecutorPool SHARED = new SharedExecutorPool("SharedPool");
    final String poolName;
    final AtomicLong workerId = new AtomicLong();
    public final List<SEPExecutor> executors = new CopyOnWriteArrayList<SEPExecutor>();
    final AtomicInteger spinningCount = new AtomicInteger();
    final AtomicLong stopCheck = new AtomicLong();
    final ConcurrentSkipListMap<Long, SEPWorker> spinning = new ConcurrentSkipListMap();
    final ConcurrentSkipListMap<Long, SEPWorker> descheduled = new ConcurrentSkipListMap();
    volatile boolean shuttingDown = false;

    public SharedExecutorPool(String poolName) {
        this.poolName = poolName;
    }

    void schedule(SEPWorker.Work work) {
        Map.Entry<Long, SEPWorker> e;
        while (null != (e = this.spinning.pollFirstEntry()) || null != (e = this.descheduled.pollFirstEntry())) {
            if (!e.getValue().assign(work, false)) continue;
            return;
        }
        if (!work.isStop()) {
            new SEPWorker(this.workerId.incrementAndGet(), work, this);
        }
    }

    void maybeStartSpinningWorker() {
        int current = this.spinningCount.get();
        if (current == 0 && this.spinningCount.compareAndSet(0, 1)) {
            this.schedule(SEPWorker.Work.SPINNING);
        }
    }

    public synchronized LocalAwareExecutorService newExecutor(int maxConcurrency, int maxQueuedTasks, String jmxPath, String name) {
        SEPExecutor executor = new SEPExecutor(this, maxConcurrency, maxQueuedTasks, jmxPath, name);
        this.executors.add(executor);
        return executor;
    }

    public synchronized void shutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.shuttingDown = true;
        for (SEPExecutor executor : this.executors) {
            executor.shutdownNow();
        }
        this.terminateWorkers();
        long until = System.nanoTime() + unit.toNanos(timeout);
        for (SEPExecutor executor : this.executors) {
            executor.shutdown.await(until - System.nanoTime(), TimeUnit.NANOSECONDS);
            if (executor.isTerminated()) continue;
            throw new TimeoutException(executor.name + " not terminated");
        }
    }

    void terminateWorkers() {
        Map.Entry<Long, SEPWorker> e;
        assert (this.shuttingDown);
        while (null != (e = this.descheduled.pollFirstEntry())) {
            e.getValue().assign(SEPWorker.Work.SPINNING, false);
        }
        while (null != (e = this.spinning.pollFirstEntry())) {
            LockSupport.unpark(e.getValue().thread);
        }
    }
}

