/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.nio.file.Paths;
import net.openhft.chronicle.wire.WireOut;
import org.apache.cassandra.audit.AuditLogEntry;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.cassandra.audit.BinLogAuditLogger;
import org.apache.cassandra.audit.IAuditLogger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.binlog.BinLog;
import org.apache.cassandra.utils.concurrent.WeightedQueue;

public class BinAuditLogger
extends BinLogAuditLogger
implements IAuditLogger {
    public static final String TYPE = "type";
    public static final String AUDITLOG_TYPE = "AuditLog";
    public static final String AUDITLOG_MESSAGE = "message";

    public BinAuditLogger() {
        AuditLogOptions auditLoggingOptions = DatabaseDescriptor.getAuditLoggingOptions();
        this.configure(Paths.get(auditLoggingOptions.audit_logs_dir, new String[0]), auditLoggingOptions.roll_cycle, auditLoggingOptions.block, auditLoggingOptions.max_queue_weight, auditLoggingOptions.max_log_size, false, auditLoggingOptions.archive_command, auditLoggingOptions.max_archive_retries);
    }

    @Override
    public void log(AuditLogEntry auditLogEntry) {
        BinLog binLog = this.binLog;
        if (binLog == null || auditLogEntry == null) {
            return;
        }
        super.logRecord(new Message(auditLogEntry.getLogString()), binLog);
    }

    @VisibleForTesting
    public static class Message
    extends BinLog.ReleaseableWriteMarshallable
    implements WeightedQueue.Weighable {
        private final String message;

        public Message(String message) {
            this.message = message;
        }

        public void writeMarshallable(WireOut wire) {
            wire.write((CharSequence)BinAuditLogger.TYPE).text(BinAuditLogger.AUDITLOG_TYPE);
            wire.write((CharSequence)BinAuditLogger.AUDITLOG_MESSAGE).text(this.message);
        }

        @Override
        public void release() {
        }

        @Override
        public int weight() {
            return Ints.checkedCast((long)ObjectSizes.sizeOf(this.message));
        }
    }
}

