/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.UUID;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.sasi.SASIIndex;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.disk.PerSSTableIndexWriter;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;

class SASIIndexBuilder
extends SecondaryIndexBuilder {
    private final ColumnFamilyStore cfs;
    private final UUID compactionId = UUIDGen.getTimeUUID();
    private final SortedMap<SSTableReader, Map<ColumnDefinition, ColumnIndex>> sstables;
    private long bytesProcessed = 0L;
    private final long totalSizeInBytes;

    public SASIIndexBuilder(ColumnFamilyStore cfs, SortedMap<SSTableReader, Map<ColumnDefinition, ColumnIndex>> sstables) {
        long totalIndexBytes = 0L;
        for (SSTableReader sstable : sstables.keySet()) {
            totalIndexBytes += this.getPrimaryIndexLength(sstable);
        }
        this.cfs = cfs;
        this.sstables = sstables;
        this.totalSizeInBytes = totalIndexBytes;
    }

    @Override
    public void build() {
        AbstractType<?> keyValidator = this.cfs.metadata.getKeyValidator();
        for (Map.Entry<SSTableReader, Map<ColumnDefinition, ColumnIndex>> e : this.sstables.entrySet()) {
            SSTableReader sstable = e.getKey();
            Map<ColumnDefinition, ColumnIndex> indexes = e.getValue();
            RandomAccessReader dataFile = sstable.openDataReader();
            Throwable throwable = null;
            try {
                PerSSTableIndexWriter indexWriter = SASIIndex.newWriter(keyValidator, sstable.descriptor, indexes, OperationType.COMPACTION);
                long previousKeyPosition = 0L;
                KeyIterator keys = new KeyIterator(sstable.descriptor, this.cfs.metadata);
                Throwable throwable2 = null;
                try {
                    while (keys.hasNext()) {
                        if (this.isStopRequested()) {
                            throw new CompactionInterruptedException(this.getCompactionInfo());
                        }
                        DecoratedKey key = (DecoratedKey)keys.next();
                        long keyPosition = keys.getKeyPosition();
                        indexWriter.startPartition(key, keyPosition);
                        try {
                            RowIndexEntry indexEntry = sstable.getPosition(key, SSTableReader.Operator.EQ);
                            dataFile.seek(indexEntry.position);
                            ByteBufferUtil.readWithShortLength(dataFile);
                            try (SSTableIdentityIterator partition = new SSTableIdentityIterator(sstable, dataFile, key);){
                                indexWriter.nextUnfilteredCluster(partition.staticRow());
                                while (partition.hasNext()) {
                                    indexWriter.nextUnfilteredCluster((Unfiltered)partition.next());
                                }
                            }
                        }
                        catch (IOException ex) {
                            throw new FSReadError((Throwable)ex, sstable.getFilename());
                        }
                        this.bytesProcessed += keyPosition - previousKeyPosition;
                        previousKeyPosition = keyPosition;
                    }
                    this.completeSSTable(indexWriter, sstable, indexes.values());
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (keys == null) continue;
                    if (throwable2 != null) {
                        try {
                            keys.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    keys.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (dataFile == null) continue;
                if (throwable != null) {
                    try {
                        dataFile.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                dataFile.close();
            }
        }
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.cfs.metadata, OperationType.INDEX_BUILD, this.bytesProcessed, this.totalSizeInBytes, this.compactionId);
    }

    private long getPrimaryIndexLength(SSTable sstable) {
        File primaryIndex = new File(sstable.getIndexFilename());
        return primaryIndex.exists() ? primaryIndex.length() : 0L;
    }

    private void completeSSTable(PerSSTableIndexWriter indexWriter, SSTableReader sstable, Collection<ColumnIndex> indexes) {
        indexWriter.complete();
        for (ColumnIndex index : indexes) {
            File tmpIndex = new File(sstable.descriptor.filenameFor(index.getComponent()));
            if (!tmpIndex.exists()) continue;
            index.update(Collections.emptyList(), Collections.singletonList(sstable));
        }
    }
}

