/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.FrozenType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListType<T>
extends CollectionType<List<T>> {
    private static final Logger logger = LoggerFactory.getLogger(ListType.class);
    private static final Map<AbstractType<?>, ListType> instances = new HashMap();
    private static final Map<AbstractType<?>, ListType> frozenInstances = new HashMap();
    private final AbstractType<T> elements;
    public final ListSerializer<T> serializer;
    private final boolean isMultiCell;

    public static ListType<?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 1) {
            throw new ConfigurationException("ListType takes exactly 1 type parameter");
        }
        return ListType.getInstance(l.get(0), true);
    }

    public static synchronized <T> ListType<T> getInstance(AbstractType<T> elements, boolean isMultiCell) {
        Map<AbstractType<?>, ListType> internMap = isMultiCell ? instances : frozenInstances;
        ListType<T> t = internMap.get(elements);
        if (t == null) {
            t = new ListType<T>(elements, isMultiCell);
            internMap.put(elements, t);
        }
        return t;
    }

    private ListType(AbstractType<T> elements, boolean isMultiCell) {
        super(AbstractType.ComparisonType.CUSTOM, CollectionType.Kind.LIST);
        this.elements = elements;
        this.serializer = ListSerializer.getInstance(elements.getSerializer());
        this.isMultiCell = isMultiCell;
    }

    @Override
    public boolean referencesUserType(String userTypeName) {
        return this.getElementsType().referencesUserType(userTypeName);
    }

    public AbstractType<T> getElementsType() {
        return this.elements;
    }

    @Override
    public AbstractType<UUID> nameComparator() {
        return TimeUUIDType.instance;
    }

    @Override
    public AbstractType<T> valueComparator() {
        return this.elements;
    }

    @Override
    public ListSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public AbstractType<?> freeze() {
        if (this.isMultiCell) {
            return ListType.getInstance(this.elements, false);
        }
        return this;
    }

    @Override
    public AbstractType<?> freezeNestedMulticellTypes() {
        if (!this.isMultiCell()) {
            return this;
        }
        if (this.elements.isFreezable() && this.elements.isMultiCell()) {
            return ListType.getInstance(this.elements.freeze(), this.isMultiCell);
        }
        return ListType.getInstance(this.elements.freezeNestedMulticellTypes(), this.isMultiCell);
    }

    @Override
    public boolean isMultiCell() {
        return this.isMultiCell;
    }

    @Override
    public boolean isCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        return this.elements.isCompatibleWith(((ListType)previous).elements);
    }

    @Override
    public boolean isValueCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        return this.elements.isValueCompatibleWithInternal(((ListType)previous).elements);
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        return ListType.compareListOrSet(this.elements, o1, o2);
    }

    static int compareListOrSet(AbstractType<?> elementsComparator, ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        ByteBuffer bb1 = o1.duplicate();
        ByteBuffer bb2 = o2.duplicate();
        int size1 = CollectionSerializer.readCollectionSize(bb1, 3);
        int size2 = CollectionSerializer.readCollectionSize(bb2, 3);
        for (int i = 0; i < Math.min(size1, size2); ++i) {
            ByteBuffer v2;
            ByteBuffer v1 = CollectionSerializer.readValue(bb1, 3);
            int cmp = elementsComparator.compare(v1, v2 = CollectionSerializer.readValue(bb2, 3));
            if (cmp == 0) continue;
            return cmp;
        }
        return size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
    }

    @Override
    public String toString(boolean ignoreFreezing) {
        boolean includeFrozenType = !ignoreFreezing && !this.isMultiCell();
        StringBuilder sb = new StringBuilder();
        if (includeFrozenType) {
            sb.append(FrozenType.class.getName()).append("(");
        }
        sb.append(this.getClass().getName());
        sb.append(TypeParser.stringifyTypeParameters(Collections.singletonList(this.elements), ignoreFreezing || !this.isMultiCell));
        if (includeFrozenType) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<ByteBuffer> serializedValues(Iterator<Cell> cells) {
        assert (this.isMultiCell);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        while (cells.hasNext()) {
            bbs.add(cells.next().value());
        }
        return bbs;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = Json.decodeJson((String)parsed);
        }
        if (!(parsed instanceof List)) {
            throw new MarshalException(String.format("Expected a list, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        List list = (List)parsed;
        ArrayList<Term> terms = new ArrayList<Term>(list.size());
        for (Object element : list) {
            if (element == null) {
                throw new MarshalException("Invalid null element in list");
            }
            terms.add(this.elements.fromJSONObject(element));
        }
        return new Lists.DelayedValue(terms);
    }

    public static String setOrListToJsonString(ByteBuffer buffer, AbstractType elementsType, int protocolVersion) {
        StringBuilder sb = new StringBuilder("[");
        int size = CollectionSerializer.readCollectionSize(buffer, protocolVersion);
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(elementsType.toJSONString(CollectionSerializer.readValue(buffer, protocolVersion), protocolVersion));
        }
        return sb.append("]").toString();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return ListType.setOrListToJsonString(buffer, this.elements, protocolVersion);
    }
}

