/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.BasePartitions;
import org.apache.cassandra.db.transform.BaseRows;
import org.apache.cassandra.db.transform.StoppingTransformation;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class DataLimits {
    public static final Serializer serializer = new Serializer();
    public static final int NO_LIMIT = Integer.MAX_VALUE;
    public static final DataLimits NONE = new CQLLimits(Integer.MAX_VALUE){

        @Override
        public boolean hasEnoughLiveData(CachedPartition cached, int nowInSec) {
            return false;
        }

        @Override
        public UnfilteredPartitionIterator filter(UnfilteredPartitionIterator iter, int nowInSec) {
            return iter;
        }

        @Override
        public UnfilteredRowIterator filter(UnfilteredRowIterator iter, int nowInSec) {
            return iter;
        }
    };
    public static final DataLimits DISTINCT_NONE = new CQLLimits(Integer.MAX_VALUE, 1, true);

    public static DataLimits cqlLimits(int cqlRowLimit) {
        return cqlRowLimit == Integer.MAX_VALUE ? NONE : new CQLLimits(cqlRowLimit);
    }

    public static DataLimits cqlLimits(int cqlRowLimit, int perPartitionLimit) {
        return cqlRowLimit == Integer.MAX_VALUE && perPartitionLimit == Integer.MAX_VALUE ? NONE : new CQLLimits(cqlRowLimit, perPartitionLimit);
    }

    private static DataLimits cqlLimits(int cqlRowLimit, int perPartitionLimit, boolean isDistinct) {
        return cqlRowLimit == Integer.MAX_VALUE && perPartitionLimit == Integer.MAX_VALUE && !isDistinct ? NONE : new CQLLimits(cqlRowLimit, perPartitionLimit, isDistinct);
    }

    public static DataLimits distinctLimits(int cqlRowLimit) {
        return CQLLimits.distinct(cqlRowLimit);
    }

    public static DataLimits thriftLimits(int partitionLimit, int cellPerPartitionLimit) {
        return new ThriftLimits(partitionLimit, cellPerPartitionLimit);
    }

    public static DataLimits superColumnCountingLimits(int partitionLimit, int cellPerPartitionLimit) {
        return new SuperColumnCountingLimits(partitionLimit, cellPerPartitionLimit);
    }

    public abstract Kind kind();

    public abstract boolean isUnlimited();

    public abstract boolean isDistinct();

    public abstract DataLimits forPaging(int var1);

    public abstract DataLimits forPaging(int var1, ByteBuffer var2, int var3);

    public abstract DataLimits forShortReadRetry(int var1);

    public abstract boolean hasEnoughLiveData(CachedPartition var1, int var2);

    public abstract Counter newCounter(int var1, boolean var2);

    public abstract int count();

    public abstract int perPartitionCount();

    public UnfilteredPartitionIterator filter(UnfilteredPartitionIterator iter, int nowInSec) {
        return this.newCounter(nowInSec, false).applyTo(iter);
    }

    public UnfilteredRowIterator filter(UnfilteredRowIterator iter, int nowInSec) {
        return this.newCounter(nowInSec, false).applyTo(iter);
    }

    public PartitionIterator filter(PartitionIterator iter, int nowInSec) {
        return this.newCounter(nowInSec, true).applyTo(iter);
    }

    public abstract float estimateTotalResults(ColumnFamilyStore var1);

    public static class Serializer {
        public void serialize(DataLimits limits, DataOutputPlus out, int version) throws IOException {
            out.writeByte(limits.kind().ordinal());
            switch (limits.kind()) {
                case CQL_LIMIT: 
                case CQL_PAGING_LIMIT: {
                    CQLLimits cqlLimits = (CQLLimits)limits;
                    out.writeUnsignedVInt(cqlLimits.rowLimit);
                    out.writeUnsignedVInt(cqlLimits.perPartitionLimit);
                    out.writeBoolean(cqlLimits.isDistinct);
                    if (limits.kind() != Kind.CQL_PAGING_LIMIT) break;
                    CQLPagingLimits pagingLimits = (CQLPagingLimits)cqlLimits;
                    ByteBufferUtil.writeWithVIntLength(pagingLimits.lastReturnedKey, out);
                    out.writeUnsignedVInt(pagingLimits.lastReturnedKeyRemaining);
                    break;
                }
                case THRIFT_LIMIT: 
                case SUPER_COLUMN_COUNTING_LIMIT: {
                    ThriftLimits thriftLimits = (ThriftLimits)limits;
                    out.writeUnsignedVInt(thriftLimits.partitionLimit);
                    out.writeUnsignedVInt(thriftLimits.cellPerPartitionLimit);
                }
            }
        }

        public DataLimits deserialize(DataInputPlus in, int version) throws IOException {
            Kind kind = Kind.values()[in.readUnsignedByte()];
            switch (kind) {
                case CQL_LIMIT: 
                case CQL_PAGING_LIMIT: {
                    int rowLimit = (int)in.readUnsignedVInt();
                    int perPartitionLimit = (int)in.readUnsignedVInt();
                    boolean isDistinct = in.readBoolean();
                    if (kind == Kind.CQL_LIMIT) {
                        return DataLimits.cqlLimits(rowLimit, perPartitionLimit, isDistinct);
                    }
                    ByteBuffer lastKey = ByteBufferUtil.readWithVIntLength(in);
                    int lastRemaining = (int)in.readUnsignedVInt();
                    return new CQLPagingLimits(rowLimit, perPartitionLimit, isDistinct, lastKey, lastRemaining);
                }
                case THRIFT_LIMIT: 
                case SUPER_COLUMN_COUNTING_LIMIT: {
                    int partitionLimit = (int)in.readUnsignedVInt();
                    int cellPerPartitionLimit = (int)in.readUnsignedVInt();
                    return kind == Kind.THRIFT_LIMIT ? new ThriftLimits(partitionLimit, cellPerPartitionLimit) : new SuperColumnCountingLimits(partitionLimit, cellPerPartitionLimit);
                }
            }
            throw new AssertionError();
        }

        public long serializedSize(DataLimits limits, int version) {
            long size = TypeSizes.sizeof((byte)limits.kind().ordinal());
            switch (limits.kind()) {
                case CQL_LIMIT: 
                case CQL_PAGING_LIMIT: {
                    CQLLimits cqlLimits = (CQLLimits)limits;
                    size += (long)TypeSizes.sizeofUnsignedVInt(cqlLimits.rowLimit);
                    size += (long)TypeSizes.sizeofUnsignedVInt(cqlLimits.perPartitionLimit);
                    size += (long)TypeSizes.sizeof(cqlLimits.isDistinct);
                    if (limits.kind() != Kind.CQL_PAGING_LIMIT) break;
                    CQLPagingLimits pagingLimits = (CQLPagingLimits)cqlLimits;
                    size += (long)ByteBufferUtil.serializedSizeWithVIntLength(pagingLimits.lastReturnedKey);
                    size += (long)TypeSizes.sizeofUnsignedVInt(pagingLimits.lastReturnedKeyRemaining);
                    break;
                }
                case THRIFT_LIMIT: 
                case SUPER_COLUMN_COUNTING_LIMIT: {
                    ThriftLimits thriftLimits = (ThriftLimits)limits;
                    size += (long)TypeSizes.sizeofUnsignedVInt(thriftLimits.partitionLimit);
                    size += (long)TypeSizes.sizeofUnsignedVInt(thriftLimits.cellPerPartitionLimit);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return size;
        }
    }

    private static class SuperColumnCountingLimits
    extends ThriftLimits {
        private SuperColumnCountingLimits(int partitionLimit, int cellPerPartitionLimit) {
            super(partitionLimit, cellPerPartitionLimit);
        }

        @Override
        public Kind kind() {
            return Kind.SUPER_COLUMN_COUNTING_LIMIT;
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            assert (this.partitionLimit == 1);
            return new SuperColumnCountingLimits(this.partitionLimit, pageSize);
        }

        @Override
        public DataLimits forShortReadRetry(int toFetch) {
            return new SuperColumnCountingLimits(1, toFetch);
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            return new SuperColumnCountingCounter(nowInSec, assumeLiveData);
        }

        protected class SuperColumnCountingCounter
        extends ThriftLimits.ThriftCounter {
            public SuperColumnCountingCounter(int nowInSec, boolean assumeLiveData) {
                super(nowInSec, assumeLiveData);
            }

            @Override
            public Row applyToRow(Row row) {
                if (this.assumeLiveData || row.hasLiveData(this.nowInSec)) {
                    ++this.cellsCounted;
                    if (++this.cellsInCurrentPartition >= SuperColumnCountingLimits.this.cellPerPartitionLimit) {
                        this.stopInPartition();
                    }
                }
                return row;
            }
        }
    }

    private static class ThriftLimits
    extends DataLimits {
        protected final int partitionLimit;
        protected final int cellPerPartitionLimit;

        private ThriftLimits(int partitionLimit, int cellPerPartitionLimit) {
            this.partitionLimit = partitionLimit;
            this.cellPerPartitionLimit = cellPerPartitionLimit;
        }

        @Override
        public Kind kind() {
            return Kind.THRIFT_LIMIT;
        }

        @Override
        public boolean isUnlimited() {
            return this.partitionLimit == Integer.MAX_VALUE && this.cellPerPartitionLimit == Integer.MAX_VALUE;
        }

        @Override
        public boolean isDistinct() {
            return false;
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            assert (this.partitionLimit == 1);
            return new ThriftLimits(this.partitionLimit, pageSize);
        }

        @Override
        public DataLimits forPaging(int pageSize, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataLimits forShortReadRetry(int toFetch) {
            return new ThriftLimits(1, toFetch);
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean hasEnoughLiveData(CachedPartition cached, int nowInSec) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            return new ThriftCounter(nowInSec, assumeLiveData);
        }

        @Override
        public int count() {
            return this.partitionLimit * this.cellPerPartitionLimit;
        }

        @Override
        public int perPartitionCount() {
            return this.cellPerPartitionLimit;
        }

        @Override
        public float estimateTotalResults(ColumnFamilyStore cfs) {
            float cellsPerPartition = (float)cfs.getMeanColumns() / (float)cfs.metadata.partitionColumns().regulars.size();
            return cellsPerPartition * (float)cfs.estimateKeys();
        }

        public String toString() {
            return String.format("THRIFT LIMIT (partitions=%d, cells_per_partition=%d)", this.partitionLimit, this.cellPerPartitionLimit);
        }

        protected class ThriftCounter
        extends Counter {
            protected final int nowInSec;
            protected final boolean assumeLiveData;
            protected int partitionsCounted;
            protected int cellsCounted;
            protected int cellsInCurrentPartition;

            public ThriftCounter(int nowInSec, boolean assumeLiveData) {
                this.nowInSec = nowInSec;
                this.assumeLiveData = assumeLiveData;
            }

            @Override
            public void applyToPartition(DecoratedKey partitionKey, Row staticRow) {
                this.cellsInCurrentPartition = 0;
                if (!staticRow.isEmpty()) {
                    this.applyToRow(staticRow);
                }
            }

            @Override
            public Row applyToRow(Row row) {
                for (Cell cell : row.cells()) {
                    if (!this.assumeLiveData && !cell.isLive(this.nowInSec)) continue;
                    ++this.cellsCounted;
                    if (++this.cellsInCurrentPartition < ThriftLimits.this.cellPerPartitionLimit) continue;
                    this.stopInPartition();
                }
                return row;
            }

            @Override
            public void onPartitionClose() {
                if (++this.partitionsCounted >= ThriftLimits.this.partitionLimit) {
                    this.stop();
                }
                super.onPartitionClose();
            }

            @Override
            public int counted() {
                return this.cellsCounted;
            }

            @Override
            public int countedInCurrentPartition() {
                return this.cellsInCurrentPartition;
            }

            @Override
            public boolean isDone() {
                return this.partitionsCounted >= ThriftLimits.this.partitionLimit;
            }

            @Override
            public boolean isDoneForPartition() {
                return this.isDone() || this.cellsInCurrentPartition >= ThriftLimits.this.cellPerPartitionLimit;
            }
        }
    }

    private static class CQLPagingLimits
    extends CQLLimits {
        private final ByteBuffer lastReturnedKey;
        private final int lastReturnedKeyRemaining;

        public CQLPagingLimits(int rowLimit, int perPartitionLimit, boolean isDistinct, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            super(rowLimit, perPartitionLimit, isDistinct);
            this.lastReturnedKey = lastReturnedKey;
            this.lastReturnedKeyRemaining = lastReturnedKeyRemaining;
        }

        @Override
        public Kind kind() {
            return Kind.CQL_PAGING_LIMIT;
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataLimits forPaging(int pageSize, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            return new PagingAwareCounter(nowInSec, assumeLiveData);
        }

        private class PagingAwareCounter
        extends CQLLimits.CQLCounter {
            private PagingAwareCounter(int nowInSec, boolean assumeLiveData) {
                super(nowInSec, assumeLiveData);
            }

            @Override
            public void applyToPartition(DecoratedKey partitionKey, Row staticRow) {
                if (partitionKey.getKey().equals(CQLPagingLimits.this.lastReturnedKey)) {
                    this.rowInCurrentPartition = CQLPagingLimits.this.perPartitionLimit - CQLPagingLimits.this.lastReturnedKeyRemaining;
                    this.hasLiveStaticRow = false;
                } else {
                    super.applyToPartition(partitionKey, staticRow);
                }
            }
        }
    }

    private static class CQLLimits
    extends DataLimits {
        protected final int rowLimit;
        protected final int perPartitionLimit;
        protected final boolean isDistinct;

        private CQLLimits(int rowLimit) {
            this(rowLimit, Integer.MAX_VALUE);
        }

        private CQLLimits(int rowLimit, int perPartitionLimit) {
            this(rowLimit, perPartitionLimit, false);
        }

        private CQLLimits(int rowLimit, int perPartitionLimit, boolean isDistinct) {
            this.rowLimit = rowLimit;
            this.perPartitionLimit = perPartitionLimit;
            this.isDistinct = isDistinct;
        }

        private static CQLLimits distinct(int rowLimit) {
            return new CQLLimits(rowLimit, 1, true);
        }

        @Override
        public Kind kind() {
            return Kind.CQL_LIMIT;
        }

        @Override
        public boolean isUnlimited() {
            return this.rowLimit == Integer.MAX_VALUE && this.perPartitionLimit == Integer.MAX_VALUE;
        }

        @Override
        public boolean isDistinct() {
            return this.isDistinct;
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            return new CQLLimits(pageSize, this.perPartitionLimit, this.isDistinct);
        }

        @Override
        public DataLimits forPaging(int pageSize, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            return new CQLPagingLimits(pageSize, this.perPartitionLimit, this.isDistinct, lastReturnedKey, lastReturnedKeyRemaining);
        }

        @Override
        public DataLimits forShortReadRetry(int toFetch) {
            return new CQLLimits(toFetch, Integer.MAX_VALUE, this.isDistinct);
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean hasEnoughLiveData(CachedPartition cached, int nowInSec) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            return new CQLCounter(nowInSec, assumeLiveData);
        }

        @Override
        public int count() {
            return this.rowLimit;
        }

        @Override
        public int perPartitionCount() {
            return this.perPartitionLimit;
        }

        @Override
        public float estimateTotalResults(ColumnFamilyStore cfs) {
            float rowsPerPartition = (float)cfs.getMeanColumns() / (float)cfs.metadata.partitionColumns().regulars.size();
            return rowsPerPartition * (float)cfs.estimateKeys();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.rowLimit != Integer.MAX_VALUE) {
                sb.append("LIMIT ").append(this.rowLimit);
                if (this.perPartitionLimit != Integer.MAX_VALUE) {
                    sb.append(' ');
                }
            }
            if (this.perPartitionLimit != Integer.MAX_VALUE) {
                sb.append("PER PARTITION LIMIT ").append(this.perPartitionLimit);
            }
            return sb.toString();
        }

        protected class CQLCounter
        extends Counter {
            protected final int nowInSec;
            protected final boolean assumeLiveData;
            protected int rowCounted;
            protected int rowInCurrentPartition;
            protected boolean hasLiveStaticRow;

            public CQLCounter(int nowInSec, boolean assumeLiveData) {
                this.nowInSec = nowInSec;
                this.assumeLiveData = assumeLiveData;
            }

            @Override
            public void applyToPartition(DecoratedKey partitionKey, Row staticRow) {
                this.rowInCurrentPartition = 0;
                this.hasLiveStaticRow = !staticRow.isEmpty() && (this.assumeLiveData || staticRow.hasLiveData(this.nowInSec));
            }

            @Override
            public Row applyToRow(Row row) {
                if (this.assumeLiveData || row.hasLiveData(this.nowInSec)) {
                    this.incrementRowCount();
                }
                return row;
            }

            @Override
            public void onPartitionClose() {
                if (this.hasLiveStaticRow && this.rowInCurrentPartition == 0) {
                    this.incrementRowCount();
                }
                super.onPartitionClose();
            }

            private void incrementRowCount() {
                if (++this.rowCounted >= CQLLimits.this.rowLimit) {
                    this.stop();
                }
                if (++this.rowInCurrentPartition >= CQLLimits.this.perPartitionLimit) {
                    this.stopInPartition();
                }
            }

            @Override
            public int counted() {
                return this.rowCounted;
            }

            @Override
            public int countedInCurrentPartition() {
                return this.rowInCurrentPartition;
            }

            @Override
            public boolean isDone() {
                return this.rowCounted >= CQLLimits.this.rowLimit;
            }

            @Override
            public boolean isDoneForPartition() {
                return this.isDone() || this.rowInCurrentPartition >= CQLLimits.this.perPartitionLimit;
            }
        }
    }

    public static abstract class Counter
    extends StoppingTransformation<BaseRowIterator<?>> {
        private boolean enforceLimits = true;

        public Counter onlyCount() {
            this.enforceLimits = false;
            return this;
        }

        public PartitionIterator applyTo(PartitionIterator partitions) {
            return Transformation.apply(partitions, this);
        }

        public UnfilteredPartitionIterator applyTo(UnfilteredPartitionIterator partitions) {
            return Transformation.apply(partitions, this);
        }

        public UnfilteredRowIterator applyTo(UnfilteredRowIterator partition) {
            return (UnfilteredRowIterator)this.applyToPartition(partition);
        }

        public RowIterator applyTo(RowIterator partition) {
            return (RowIterator)this.applyToPartition(partition);
        }

        public abstract int counted();

        public abstract int countedInCurrentPartition();

        public abstract boolean isDone();

        public abstract boolean isDoneForPartition();

        @Override
        protected BaseRowIterator<?> applyToPartition(BaseRowIterator<?> partition) {
            return partition instanceof UnfilteredRowIterator ? Transformation.apply((UnfilteredRowIterator)partition, this) : Transformation.apply((RowIterator)partition, this);
        }

        protected abstract void applyToPartition(DecoratedKey var1, Row var2);

        @Override
        protected void attachTo(BasePartitions partitions) {
            if (this.enforceLimits) {
                super.attachTo(partitions);
            }
            if (this.isDone()) {
                this.stop();
            }
        }

        @Override
        protected void attachTo(BaseRows rows) {
            if (this.enforceLimits) {
                super.attachTo(rows);
            }
            this.applyToPartition(rows.partitionKey(), rows.staticRow());
            if (this.isDoneForPartition()) {
                this.stopInPartition();
            }
        }
    }

    public static enum Kind {
        CQL_LIMIT,
        CQL_PAGING_LIMIT,
        THRIFT_LIMIT,
        SUPER_COLUMN_COUNTING_LIMIT;

    }
}

