/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.restrictions.SingleRestriction;
import org.apache.cassandra.cql3.restrictions.TermSlice;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.MultiCBuilder;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SecondaryIndexManager;

public abstract class MultiColumnRestriction
implements SingleRestriction {
    protected final List<ColumnDefinition> columnDefs;

    public MultiColumnRestriction(List<ColumnDefinition> columnDefs) {
        this.columnDefs = columnDefs;
    }

    @Override
    public boolean isMultiColumn() {
        return true;
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.columnDefs.get(0);
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.columnDefs.get(this.columnDefs.size() - 1);
    }

    @Override
    public List<ColumnDefinition> getColumnDefs() {
        return this.columnDefs;
    }

    @Override
    public final SingleRestriction mergeWith(SingleRestriction otherRestriction) {
        if (!otherRestriction.isMultiColumn() && ((SingleColumnRestriction)otherRestriction).canBeConvertedToMultiColumnRestriction()) {
            return this.doMergeWith(((SingleColumnRestriction)otherRestriction).toMultiColumnRestriction());
        }
        return this.doMergeWith(otherRestriction);
    }

    protected abstract SingleRestriction doMergeWith(SingleRestriction var1);

    protected final String getColumnsInCommons(Restriction otherRestriction) {
        HashSet<ColumnDefinition> commons = new HashSet<ColumnDefinition>(this.getColumnDefs());
        commons.retainAll(otherRestriction.getColumnDefs());
        StringBuilder builder = new StringBuilder();
        for (ColumnDefinition columnDefinition : commons) {
            if (builder.length() != 0) {
                builder.append(" ,");
            }
            builder.append(columnDefinition.name);
        }
        return builder.toString();
    }

    @Override
    public final boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        for (Index index : indexManager.listIndexes()) {
            if (!this.isSupportedBy(index)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isSupportedBy(Index var1);

    public static class NotNullRestriction
    extends MultiColumnRestriction {
        public NotNullRestriction(List<ColumnDefinition> columnDefs) {
            super(columnDefs);
            assert (columnDefs.size() == 1);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        public String toString() {
            return "IS NOT NULL";
        }

        @Override
        public SingleRestriction doMergeWith(SingleRestriction otherRestriction) {
            throw RequestValidations.invalidRequest("%s cannot be restricted by a relation if it includes an IS NOT NULL clause", this.getColumnsInCommons(otherRestriction));
        }

        @Override
        protected boolean isSupportedBy(Index index) {
            for (ColumnDefinition column : this.columnDefs) {
                if (!index.supportsExpression(column, Operator.IS_NOT)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
            throw new UnsupportedOperationException("Cannot use IS NOT NULL restriction for slicing");
        }

        @Override
        public final void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexMananger, QueryOptions options) {
            throw new UnsupportedOperationException("Secondary indexes do not support IS NOT NULL restrictions");
        }
    }

    public static class SliceRestriction
    extends MultiColumnRestriction {
        private final TermSlice slice;

        public SliceRestriction(List<ColumnDefinition> columnDefs, Bound bound, boolean inclusive, Term term) {
            this(columnDefs, TermSlice.newInstance(bound, inclusive, term));
        }

        SliceRestriction(List<ColumnDefinition> columnDefs, TermSlice slice) {
            super(columnDefs);
            this.slice = slice;
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MultiCBuilder appendBoundTo(MultiCBuilder builder, Bound bound, QueryOptions options) {
            boolean reversed = this.getFirstColumn().isReversedType();
            EnumMap<Bound, List<ByteBuffer>> componentBounds = new EnumMap<Bound, List<ByteBuffer>>(Bound.class);
            componentBounds.put(Bound.START, this.componentBounds(Bound.START, options));
            componentBounds.put(Bound.END, this.componentBounds(Bound.END, options));
            ArrayList<List<ByteBuffer>> toAdd = new ArrayList<List<ByteBuffer>>();
            ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
            int m = this.columnDefs.size();
            for (int i = 0; i < m; ++i) {
                ColumnDefinition column = (ColumnDefinition)this.columnDefs.get(i);
                Bound b = bound.reverseIfNeeded(column);
                if (reversed != column.isReversedType()) {
                    reversed = column.isReversedType();
                    toAdd.add(values);
                    if (!this.hasComponent(b, i, componentBounds)) continue;
                    if (this.hasComponent(b.reverse(), i, componentBounds)) {
                        toAdd.add(values);
                    }
                    values = new ArrayList();
                    List<ByteBuffer> vals = componentBounds.get((Object)b);
                    int n = Math.min(i, vals.size());
                    for (int j = 0; j < n; ++j) {
                        ByteBuffer v = RequestValidations.checkNotNull(vals.get(j), "Invalid null value in condition for column %s", ((ColumnDefinition)this.columnDefs.get((int)j)).name);
                        values.add(v);
                    }
                }
                if (!this.hasComponent(b, i, componentBounds)) continue;
                ByteBuffer v = RequestValidations.checkNotNull(componentBounds.get((Object)b).get(i), "Invalid null value in condition for column %s", ((ColumnDefinition)this.columnDefs.get((int)i)).name);
                values.add(v);
            }
            toAdd.add(values);
            if (bound.isEnd()) {
                Collections.reverse(toAdd);
            }
            return builder.addAllElementsToAll(toAdd);
        }

        @Override
        protected boolean isSupportedBy(Index index) {
            for (ColumnDefinition def : this.columnDefs) {
                if (!this.slice.isSupportedBy(def, index)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasBound(Bound bound) {
            return this.slice.hasBound(bound);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            this.slice.addFunctionsTo(functions);
        }

        @Override
        public boolean isInclusive(Bound bound) {
            return this.slice.isInclusive(bound);
        }

        @Override
        public SingleRestriction doMergeWith(SingleRestriction otherRestriction) {
            RequestValidations.checkTrue(otherRestriction.isSlice(), "Column \"%s\" cannot be restricted by both an equality and an inequality relation", this.getColumnsInCommons(otherRestriction));
            if (!this.getFirstColumn().equals(otherRestriction.getFirstColumn())) {
                ColumnDefinition column = this.getFirstColumn().position() > otherRestriction.getFirstColumn().position() ? this.getFirstColumn() : otherRestriction.getFirstColumn();
                throw RequestValidations.invalidRequest("Column \"%s\" cannot be restricted by two inequalities not starting with the same column", column.name);
            }
            RequestValidations.checkFalse(this.hasBound(Bound.START) && otherRestriction.hasBound(Bound.START), "More than one restriction was found for the start bound on %s", this.getColumnsInCommons(otherRestriction));
            RequestValidations.checkFalse(this.hasBound(Bound.END) && otherRestriction.hasBound(Bound.END), "More than one restriction was found for the end bound on %s", this.getColumnsInCommons(otherRestriction));
            SliceRestriction otherSlice = (SliceRestriction)otherRestriction;
            List newColumnDefs = this.columnDefs.size() >= otherSlice.columnDefs.size() ? this.columnDefs : otherSlice.columnDefs;
            return new SliceRestriction(newColumnDefs, this.slice.merge(otherSlice.slice));
        }

        @Override
        public final void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) {
            throw RequestValidations.invalidRequest("Multi-column slice restrictions cannot be used for filtering.", new Object[0]);
        }

        public String toString() {
            return "SLICE" + this.slice;
        }

        private List<ByteBuffer> componentBounds(Bound b, QueryOptions options) {
            if (!this.slice.hasBound(b)) {
                return Collections.emptyList();
            }
            Term.Terminal terminal = this.slice.bound(b).bind(options);
            if (terminal instanceof Tuples.Value) {
                return ((Tuples.Value)terminal).getElements();
            }
            return Collections.singletonList(terminal.get(options.getProtocolVersion()));
        }

        private boolean hasComponent(Bound b, int index, EnumMap<Bound, List<ByteBuffer>> componentBounds) {
            return componentBounds.get((Object)b).size() > index;
        }
    }

    public static class InRestrictionWithMarker
    extends INRestriction {
        protected final AbstractMarker marker;

        public InRestrictionWithMarker(List<ColumnDefinition> columnDefs, AbstractMarker marker) {
            super(columnDefs);
            this.marker = marker;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
        }

        public String toString() {
            return "IN ?";
        }

        @Override
        protected List<List<ByteBuffer>> splitValues(QueryOptions options) {
            Tuples.InMarker inMarker = (Tuples.InMarker)this.marker;
            Tuples.InValue inValue = inMarker.bind(options);
            RequestValidations.checkNotNull(inValue, "Invalid null value for IN restriction", new Object[0]);
            return inValue.getSplitValues();
        }
    }

    public static class InRestrictionWithValues
    extends INRestriction {
        protected final List<Term> values;

        public InRestrictionWithValues(List<ColumnDefinition> columnDefs, List<Term> values) {
            super(columnDefs);
            this.values = values;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.values, functions);
        }

        public String toString() {
            return String.format("IN(%s)", this.values);
        }

        @Override
        protected List<List<ByteBuffer>> splitValues(QueryOptions options) {
            ArrayList<List<ByteBuffer>> buffers = new ArrayList<List<ByteBuffer>>(this.values.size());
            for (Term value : this.values) {
                Term.MultiItemTerminal term = (Term.MultiItemTerminal)value.bind(options);
                buffers.add(term.getElements());
            }
            return buffers;
        }
    }

    public static abstract class INRestriction
    extends MultiColumnRestriction {
        public INRestriction(List<ColumnDefinition> columnDefs) {
            super(columnDefs);
        }

        @Override
        public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
            List<List<ByteBuffer>> splitInValues = this.splitValues(options);
            builder.addAllElementsToAll(splitInValues);
            if (builder.containsNull()) {
                throw RequestValidations.invalidRequest("Invalid null value in condition for columns: %s", ColumnDefinition.toIdentifiers(this.columnDefs));
            }
            return builder;
        }

        @Override
        public boolean isIN() {
            return true;
        }

        @Override
        public SingleRestriction doMergeWith(SingleRestriction otherRestriction) {
            throw RequestValidations.invalidRequest("%s cannot be restricted by more than one relation if it includes a IN", this.getColumnsInCommons(otherRestriction));
        }

        @Override
        protected boolean isSupportedBy(Index index) {
            for (ColumnDefinition column : this.columnDefs) {
                if (!index.supportsExpression(column, Operator.IN)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) {
            List<List<ByteBuffer>> splitInValues = this.splitValues(options);
            RequestValidations.checkTrue(splitInValues.size() == 1, "IN restrictions are not supported on indexed columns");
            List<ByteBuffer> values = splitInValues.get(0);
            int m = this.columnDefs.size();
            for (int i = 0; i < m; ++i) {
                ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.get(i);
                filter.add(columnDef, Operator.EQ, values.get(i));
            }
        }

        protected abstract List<List<ByteBuffer>> splitValues(QueryOptions var1);
    }

    public static class EQRestriction
    extends MultiColumnRestriction {
        protected final Term value;

        public EQRestriction(List<ColumnDefinition> columnDefs, Term value) {
            super(columnDefs);
            this.value = value;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            this.value.addFunctionsTo(functions);
        }

        public String toString() {
            return String.format("EQ(%s)", this.value);
        }

        @Override
        public SingleRestriction doMergeWith(SingleRestriction otherRestriction) {
            throw RequestValidations.invalidRequest("%s cannot be restricted by more than one relation if it includes an Equal", this.getColumnsInCommons(otherRestriction));
        }

        @Override
        protected boolean isSupportedBy(Index index) {
            for (ColumnDefinition column : this.columnDefs) {
                if (!index.supportsExpression(column, Operator.EQ)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
            Tuples.Value t = (Tuples.Value)this.value.bind(options);
            List<ByteBuffer> values = t.getElements();
            int m = values.size();
            for (int i = 0; i < m; ++i) {
                builder.addElementToAll(values.get(i));
                RequestValidations.checkFalse(builder.containsNull(), "Invalid null value for column %s", ((ColumnDefinition)this.columnDefs.get((int)i)).name);
            }
            return builder;
        }

        @Override
        public final void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexMananger, QueryOptions options) {
            Tuples.Value t = (Tuples.Value)this.value.bind(options);
            List<ByteBuffer> values = t.getElements();
            int m = this.columnDefs.size();
            for (int i = 0; i < m; ++i) {
                ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.get(i);
                filter.add(columnDef, Operator.EQ, values.get(i));
            }
        }
    }
}

