/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.util.NavigableSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.RestrictionSet;
import org.apache.cassandra.cql3.restrictions.RestrictionSetWrapper;
import org.apache.cassandra.cql3.restrictions.SingleRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.MultiCBuilder;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.utils.btree.BTreeSet;

final class ClusteringColumnRestrictions
extends RestrictionSetWrapper {
    protected final ClusteringComparator comparator;
    private final boolean allowFiltering;

    public ClusteringColumnRestrictions(CFMetaData cfm) {
        this(cfm, false);
    }

    public ClusteringColumnRestrictions(CFMetaData cfm, boolean allowFiltering) {
        this(cfm.comparator, new RestrictionSet(), allowFiltering);
    }

    private ClusteringColumnRestrictions(ClusteringComparator comparator, RestrictionSet restrictionSet, boolean allowFiltering) {
        super(restrictionSet);
        this.comparator = comparator;
        this.allowFiltering = allowFiltering;
    }

    public ClusteringColumnRestrictions mergeWith(Restriction restriction) throws InvalidRequestException {
        SingleRestriction newRestriction = (SingleRestriction)restriction;
        RestrictionSet newRestrictionSet = this.restrictions.addRestriction(newRestriction);
        if (!this.isEmpty() && !this.allowFiltering) {
            SingleRestriction lastRestriction = this.restrictions.lastRestriction();
            ColumnDefinition lastRestrictionStart = lastRestriction.getFirstColumn();
            ColumnDefinition newRestrictionStart = restriction.getFirstColumn();
            RequestValidations.checkFalse(lastRestriction.isSlice() && newRestrictionStart.position() > lastRestrictionStart.position(), "Clustering column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by a non-EQ relation)", newRestrictionStart.name, lastRestrictionStart.name);
            if (newRestrictionStart.position() < lastRestrictionStart.position() && newRestriction.isSlice()) {
                throw RequestValidations.invalidRequest("PRIMARY KEY column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by a non-EQ relation)", this.restrictions.nextColumn((ColumnDefinition)newRestrictionStart).name, newRestrictionStart.name);
            }
        }
        return new ClusteringColumnRestrictions(this.comparator, newRestrictionSet, this.allowFiltering);
    }

    private boolean hasMultiColumnSlice() {
        for (SingleRestriction restriction : this.restrictions) {
            if (!restriction.isMultiColumn() || !restriction.isSlice()) continue;
            return true;
        }
        return false;
    }

    public NavigableSet<Clustering> valuesAsClustering(QueryOptions options) throws InvalidRequestException {
        MultiCBuilder builder = MultiCBuilder.create(this.comparator, this.hasIN());
        for (SingleRestriction r : this.restrictions) {
            r.appendTo(builder, options);
            if (!builder.hasMissingElements()) continue;
            break;
        }
        return builder.build();
    }

    public NavigableSet<ClusteringBound> boundsAsClustering(Bound bound, QueryOptions options) throws InvalidRequestException {
        MultiCBuilder builder = MultiCBuilder.create(this.comparator, this.hasIN() || this.hasMultiColumnSlice());
        int keyPosition = 0;
        for (SingleRestriction r : this.restrictions) {
            if (this.handleInFilter(r, keyPosition)) break;
            if (r.isSlice()) {
                r.appendBoundTo(builder, bound, options);
                return builder.buildBoundForSlice(bound.isStart(), r.isInclusive(bound), r.isInclusive(bound.reverse()), r.getColumnDefs());
            }
            r.appendBoundTo(builder, bound, options);
            if (builder.hasMissingElements()) {
                return BTreeSet.empty(this.comparator);
            }
            keyPosition = r.getLastColumn().position() + 1;
        }
        return builder.buildBound(bound.isStart(), true);
    }

    public final boolean hasContains() {
        return this.restrictions.stream().anyMatch(SingleRestriction::isContains);
    }

    public final boolean hasSlice() {
        return this.restrictions.stream().anyMatch(SingleRestriction::isSlice);
    }

    public final boolean needFiltering() {
        int position = 0;
        for (SingleRestriction restriction : this.restrictions) {
            if (this.handleInFilter(restriction, position)) {
                return true;
            }
            if (restriction.isSlice()) continue;
            position = restriction.getLastColumn().position() + 1;
        }
        return this.hasContains();
    }

    @Override
    public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
        int position = 0;
        for (SingleRestriction restriction : this.restrictions) {
            if (this.handleInFilter(restriction, position) || restriction.hasSupportingIndex(indexManager)) {
                restriction.addRowFilterTo(filter, indexManager, options);
                continue;
            }
            if (restriction.isSlice()) continue;
            position = restriction.getLastColumn().position() + 1;
        }
    }

    private boolean handleInFilter(SingleRestriction restriction, int index) {
        return restriction.isContains() || restriction.isLIKE() || index != restriction.getFirstColumn().position();
    }
}

