/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.disk;

import com.carrotsearch.hppc.LongSet;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedMap;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.Pair;

public interface TokenTreeBuilder
extends Iterable<Pair<Long, LongSet>> {
    public static final int BLOCK_BYTES = 4096;
    public static final int BLOCK_HEADER_BYTES = 64;
    public static final int OVERFLOW_TRAILER_BYTES = 64;
    public static final int OVERFLOW_TRAILER_CAPACITY = 8;
    public static final int TOKENS_PER_BLOCK = 248;
    public static final long MAX_OFFSET = 0x7FFFFFFFFFFFL;
    public static final byte LAST_LEAF_SHIFT = 1;
    public static final byte SHARED_HEADER_BYTES = 19;
    public static final byte ENTRY_TYPE_MASK = 3;
    public static final short AB_MAGIC = 23121;

    public void add(Long var1, long var2);

    public void add(SortedMap<Long, LongSet> var1);

    public void add(Iterator<Pair<Long, LongSet>> var1);

    public void add(TokenTreeBuilder var1);

    public boolean isEmpty();

    public long getTokenCount();

    public TokenTreeBuilder finish();

    public int serializedSize();

    public void write(DataOutputPlus var1) throws IOException;

    public static enum EntryType {
        SIMPLE,
        FACTORED,
        PACKED,
        OVERFLOW;


        public static EntryType of(int ordinal) {
            if (ordinal == SIMPLE.ordinal()) {
                return SIMPLE;
            }
            if (ordinal == FACTORED.ordinal()) {
                return FACTORED;
            }
            if (ordinal == PACKED.ordinal()) {
                return PACKED;
            }
            if (ordinal == OVERFLOW.ordinal()) {
                return OVERFLOW;
            }
            throw new IllegalArgumentException("Unknown ordinal: " + ordinal);
        }
    }
}

