/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.utils.MappedBuffer;

public class Term {
    protected final MappedBuffer content;
    protected final OnDiskIndexBuilder.TermSize termSize;

    public Term(MappedBuffer content, OnDiskIndexBuilder.TermSize size) {
        this.content = content;
        this.termSize = size;
    }

    public ByteBuffer getTerm() {
        long offset = this.termSize.isConstant() ? this.content.position() : this.content.position() + 2L;
        int length = this.termSize.isConstant() ? this.termSize.size : (int)this.content.getShort(this.content.position());
        return this.content.getPageRegion(offset, length);
    }

    public long getDataOffset() {
        long position = this.content.position();
        return position + (long)(this.termSize.isConstant() ? this.termSize.size : 2 + this.content.getShort(position));
    }

    public int compareTo(AbstractType<?> comparator, ByteBuffer query) {
        return this.compareTo(comparator, query, true);
    }

    public int compareTo(AbstractType<?> comparator, ByteBuffer query, boolean checkFully) {
        long position = this.content.position();
        int padding = this.termSize.isConstant() ? 0 : 2;
        int len = this.termSize.isConstant() ? this.termSize.size : (int)this.content.getShort(position);
        return this.content.comparePageTo(position + (long)padding, checkFully ? len : Math.min(len, query.remaining()), comparator, query);
    }
}

