/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.FileDirectSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.SyncUtil;

public class CompressedSegment
extends FileDirectSegment {
    static final int COMPRESSED_MARKER_SIZE = 12;
    final ICompressor compressor;

    CompressedSegment(CommitLog commitLog) {
        super(commitLog);
        this.compressor = commitLog.compressor;
    }

    ByteBuffer allocate(int size) {
        return this.compressor.preferredBufferType().allocate(size);
    }

    @Override
    ByteBuffer createBuffer(CommitLog commitLog) {
        return this.createBuffer(commitLog.compressor.preferredBufferType());
    }

    @Override
    void write(int startMarker, int nextMarker) {
        int contentStart = startMarker + 8;
        int length = nextMarker - contentStart;
        assert (length > 0 || length == 0 && !this.isStillAllocating());
        try {
            int neededBufferSize = this.compressor.initialCompressedBufferLength(length) + 12;
            ByteBuffer compressedBuffer = (ByteBuffer)reusableBufferHolder.get();
            if (this.compressor.preferredBufferType() != BufferType.typeOf(compressedBuffer) || compressedBuffer.capacity() < neededBufferSize) {
                FileUtils.clean(compressedBuffer);
                compressedBuffer = this.allocate(neededBufferSize);
                reusableBufferHolder.set(compressedBuffer);
            }
            ByteBuffer inputBuffer = this.buffer.duplicate();
            inputBuffer.limit(contentStart + length).position(contentStart);
            compressedBuffer.limit(compressedBuffer.capacity()).position(12);
            this.compressor.compress(inputBuffer, compressedBuffer);
            compressedBuffer.flip();
            compressedBuffer.putInt(8, length);
            this.writeSyncMarker(compressedBuffer, 0, (int)this.channel.position(), (int)this.channel.position() + compressedBuffer.remaining());
            this.commitLog.allocator.addSize(compressedBuffer.limit());
            this.channel.write(compressedBuffer);
            assert (this.channel.position() - this.lastWrittenPos == (long)compressedBuffer.limit());
            this.lastWrittenPos = this.channel.position();
            SyncUtil.force(this.channel, true);
        }
        catch (Exception e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    public long onDiskSize() {
        return this.lastWrittenPos;
    }
}

