/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Serializers {
    private final CFMetaData metadata;

    public Serializers(CFMetaData metadata) {
        this.metadata = metadata;
    }

    public ISerializer<ClusteringPrefix> indexEntryClusteringPrefixSerializer(final Version version, final SerializationHeader header) {
        if (!version.storeRows()) {
            return new ISerializer<ClusteringPrefix>(){

                @Override
                public void serialize(ClusteringPrefix clustering, DataOutputPlus out) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ClusteringPrefix deserialize(DataInputPlus in) throws IOException {
                    ByteBuffer bb = ByteBufferUtil.readWithShortLength(in);
                    assert (bb.hasRemaining());
                    int clusteringSize = Serializers.this.metadata.clusteringColumns().size();
                    if (clusteringSize == 0) {
                        return Clustering.EMPTY;
                    }
                    if (!Serializers.this.metadata.isCompound()) {
                        return Clustering.make(bb);
                    }
                    List<ByteBuffer> components = CompositeType.splitName(bb);
                    byte eoc = CompositeType.lastEOC(bb);
                    if (eoc == 0 || components.size() >= clusteringSize) {
                        if (components.size() > clusteringSize) {
                            components = components.subList(0, clusteringSize);
                        }
                        return Clustering.make(components.toArray(new ByteBuffer[clusteringSize]));
                    }
                    ClusteringPrefix.Kind boundKind = eoc > 0 ? ClusteringPrefix.Kind.EXCL_START_BOUND : ClusteringPrefix.Kind.INCL_START_BOUND;
                    return Slice.Bound.create(boundKind, components.toArray(new ByteBuffer[components.size()]));
                }

                @Override
                public long serializedSize(ClusteringPrefix clustering) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new ISerializer<ClusteringPrefix>(){

            @Override
            public void serialize(ClusteringPrefix clustering, DataOutputPlus out) throws IOException {
                ClusteringPrefix.serializer.serialize(clustering, out, version.correspondingMessagingVersion(), header.clusteringTypes());
            }

            @Override
            public ClusteringPrefix deserialize(DataInputPlus in) throws IOException {
                return ClusteringPrefix.serializer.deserialize(in, version.correspondingMessagingVersion(), header.clusteringTypes());
            }

            @Override
            public long serializedSize(ClusteringPrefix clustering) {
                return ClusteringPrefix.serializer.serializedSize(clustering, version.correspondingMessagingVersion(), header.clusteringTypes());
            }
        };
    }
}

