/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.hints.ChecksummedDataInput;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.utils.memory.BufferPool;

public final class CompressedChecksummedDataInput
extends ChecksummedDataInput {
    private final ICompressor compressor;
    private volatile long filePosition = 0L;
    private volatile ByteBuffer compressedBuffer = null;
    private final ByteBuffer metadataBuffer = ByteBuffer.allocate(8);

    public CompressedChecksummedDataInput(Builder builder) {
        super(builder);
        assert (this.regions == null);
        this.compressor = builder.compressor;
        this.filePosition = builder.position;
    }

    @Override
    public boolean isEOF() {
        return this.filePosition == this.channel.size() && this.buffer.remaining() == 0;
    }

    @Override
    protected void reBufferStandard() {
        int bufferSize;
        this.metadataBuffer.clear();
        this.channel.read(this.metadataBuffer, this.filePosition);
        this.filePosition += 8L;
        this.metadataBuffer.rewind();
        int uncompressedSize = this.metadataBuffer.getInt();
        int compressedSize = this.metadataBuffer.getInt();
        if (this.compressedBuffer == null || compressedSize > this.compressedBuffer.capacity()) {
            bufferSize = compressedSize + compressedSize / 20;
            if (this.compressedBuffer != null) {
                BufferPool.put(this.compressedBuffer);
            }
            this.compressedBuffer = CompressedChecksummedDataInput.allocateBuffer(bufferSize, this.compressor.preferredBufferType());
        }
        this.compressedBuffer.clear();
        this.compressedBuffer.limit(compressedSize);
        this.channel.read(this.compressedBuffer, this.filePosition);
        this.compressedBuffer.rewind();
        this.filePosition += (long)compressedSize;
        this.bufferOffset += (long)this.buffer.position();
        if (this.buffer.capacity() < uncompressedSize) {
            bufferSize = uncompressedSize + uncompressedSize / 20;
            BufferPool.put(this.buffer);
            this.buffer = CompressedChecksummedDataInput.allocateBuffer(bufferSize, this.compressor.preferredBufferType());
        }
        this.buffer.clear();
        this.buffer.limit(uncompressedSize);
        try {
            this.compressor.uncompress(this.compressedBuffer, this.buffer);
            this.buffer.flip();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    @Override
    protected void releaseBuffer() {
        super.releaseBuffer();
        if (this.compressedBuffer != null) {
            BufferPool.put(this.compressedBuffer);
            this.compressedBuffer = null;
        }
    }

    @Override
    protected void reBufferMmap() {
        throw new UnsupportedOperationException();
    }

    public static final CompressedChecksummedDataInput upgradeInput(ChecksummedDataInput input, ICompressor compressor) {
        long position = input.getPosition();
        input.close();
        Builder builder = new Builder(new ChannelProxy(input.getPath()));
        builder.withPosition(position);
        builder.withCompressor(compressor);
        return builder.build();
    }

    public static final class Builder
    extends ChecksummedDataInput.Builder {
        private long position;
        private ICompressor compressor;

        public Builder(ChannelProxy channel) {
            super(channel);
            this.bufferType = null;
        }

        @Override
        public CompressedChecksummedDataInput build() {
            assert (this.position >= 0L);
            assert (this.compressor != null);
            return new CompressedChecksummedDataInput(this);
        }

        public Builder withCompressor(ICompressor compressor) {
            this.compressor = compressor;
            this.bufferType = compressor.preferredBufferType();
            return this;
        }

        public Builder withPosition(long position) {
            this.position = position;
            return this;
        }
    }
}

