/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.exceptions.UnrecognizedEntityException;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStatement
implements CQLStatement {
    private static final Logger logger = LoggerFactory.getLogger(SelectStatement.class);
    private static final int DEFAULT_COUNT_PAGE_SIZE = 10000;
    public static final String REQUIRES_ALLOW_FILTERING_MESSAGE = "Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING";
    private final int boundTerms;
    public final CFMetaData cfm;
    public final Parameters parameters;
    private final Selection selection;
    private final Term limit;
    private final StatementRestrictions restrictions;
    private final boolean isReversed;
    private final Comparator<List<ByteBuffer>> orderingComparator;
    private final ColumnFilter queriedColumns;
    private static final Parameters defaultParameters = new Parameters(Collections.emptyMap(), false, false, false);

    public SelectStatement(CFMetaData cfm, int boundTerms, Parameters parameters, Selection selection, StatementRestrictions restrictions, boolean isReversed, Comparator<List<ByteBuffer>> orderingComparator, Term limit) {
        this.cfm = cfm;
        this.boundTerms = boundTerms;
        this.selection = selection;
        this.restrictions = restrictions;
        this.isReversed = isReversed;
        this.orderingComparator = orderingComparator;
        this.parameters = parameters;
        this.limit = limit;
        this.queriedColumns = this.gatherQueriedColumns();
    }

    @Override
    public Iterable<Function> getFunctions() {
        return Iterables.concat(this.selection.getFunctions(), this.restrictions.getFunctions(), this.limit != null ? this.limit.getFunctions() : Collections.emptySet());
    }

    private ColumnFilter gatherQueriedColumns() {
        if (this.selection.isWildcard()) {
            return ColumnFilter.all(this.cfm);
        }
        ColumnFilter.Builder builder = ColumnFilter.allColumnsBuilder(this.cfm);
        for (ColumnDefinition def : this.selection.getColumns()) {
            if (def.isPrimaryKeyColumn()) continue;
            builder.add(def);
        }
        builder.addAll(this.restrictions.nonPKRestrictedColumns(true));
        return builder.build();
    }

    static SelectStatement forSelection(CFMetaData cfm, Selection selection) {
        return new SelectStatement(cfm, 0, defaultParameters, selection, StatementRestrictions.empty(StatementType.SELECT, cfm), false, null, null);
    }

    public ResultSet.ResultMetadata getResultMetadata() {
        return this.selection.getResultMetadata(this.parameters.isJson);
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        if (this.cfm.isView()) {
            CFMetaData baseTable = View.findBaseTable(this.keyspace(), this.columnFamily());
            if (baseTable != null) {
                state.hasColumnFamilyAccess(baseTable, Permission.SELECT);
            }
        } else {
            state.hasColumnFamilyAccess(this.cfm, Permission.SELECT);
        }
        for (Function function : this.getFunctions()) {
            state.ensureHasPermission(Permission.EXECUTE, function);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage.Rows execute(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        RequestValidations.checkNotNull(cl, "Invalid empty consistency level", new Object[0]);
        cl.validateForRead(this.keyspace());
        int nowInSec = FBUtilities.nowInSeconds();
        int userLimit = this.getLimit(options);
        ReadQuery query = this.getQuery(options, nowInSec, userLimit);
        int pageSize = this.getPageSize(options);
        if (pageSize <= 0 || query.limits().count() <= pageSize) {
            return this.execute(query, options, state, nowInSec, userLimit);
        }
        QueryPager pager = query.getPager(options.getPagingState(), options.getProtocolVersion());
        return this.execute(Pager.forDistributedQuery(pager, cl, state.getClientState()), options, pageSize, nowInSec, userLimit);
    }

    private int getPageSize(QueryOptions options) {
        int pageSize = options.getPageSize();
        if (this.selection.isAggregate() && pageSize <= 0) {
            pageSize = 10000;
        }
        return pageSize;
    }

    public ReadQuery getQuery(QueryOptions options, int nowInSec) throws RequestValidationException {
        return this.getQuery(options, nowInSec, this.getLimit(options));
    }

    public ReadQuery getQuery(QueryOptions options, int nowInSec, int userLimit) throws RequestValidationException {
        DataLimits limit = this.getDataLimits(userLimit);
        if (this.restrictions.isKeyRange() || this.restrictions.usesSecondaryIndexing()) {
            return this.getRangeCommand(options, limit, nowInSec);
        }
        return this.getSliceCommands(options, limit, nowInSec);
    }

    private ResultMessage.Rows execute(ReadQuery query, QueryOptions options, QueryState state, int nowInSec, int userLimit) throws RequestValidationException, RequestExecutionException {
        try (PartitionIterator data = query.execute(options.getConsistency(), state.getClientState());){
            ResultMessage.Rows rows = this.processResults(data, options, nowInSec, userLimit);
            return rows;
        }
    }

    private ResultMessage.Rows execute(Pager pager, QueryOptions options, int pageSize, int nowInSec, int userLimit) throws RequestValidationException, RequestExecutionException {
        ResultMessage.Rows msg;
        if (this.selection.isAggregate()) {
            return this.pageAggregateQuery(pager, options, pageSize, nowInSec);
        }
        RequestValidations.checkFalse(this.needsPostQueryOrdering(), "Cannot page queries with both ORDER BY and a IN restriction on the partition key; you must either remove the ORDER BY or the IN and sort client side, or disable paging for this query");
        try (PartitionIterator page = pager.fetchPage(pageSize);){
            msg = this.processResults(page, options, nowInSec, userLimit);
        }
        if (!pager.isExhausted()) {
            msg.result.metadata.setHasMorePages(pager.state());
        }
        return msg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultMessage.Rows pageAggregateQuery(Pager pager, QueryOptions options, int pageSize, int nowInSec) throws RequestValidationException, RequestExecutionException {
        if (!this.restrictions.hasPartitionKeyRestrictions()) {
            logger.warn("Aggregation query used without partition key");
            ClientWarn.instance.warn("Aggregation query used without partition key");
        } else if (this.restrictions.keyIsInRelation()) {
            logger.warn("Aggregation query used on multiple partition keys (IN restriction)");
            ClientWarn.instance.warn("Aggregation query used on multiple partition keys (IN restriction)");
        }
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(this.parameters.isJson);
        block17: while (!pager.isExhausted()) {
            PartitionIterator iter = pager.fetchPage(pageSize);
            Throwable throwable = null;
            try {
                while (true) {
                    RowIterator partition;
                    block24: {
                        if (!iter.hasNext()) continue block17;
                        partition = (RowIterator)iter.next();
                        Throwable throwable2 = null;
                        try {
                            this.processPartition(partition, options, result, nowInSec);
                            if (partition == null) continue;
                            if (throwable2 == null) break block24;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (partition == null) throw throwable4;
                                if (throwable2 != null) {
                                    try {
                                        partition.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                                partition.close();
                                throw throwable4;
                            }
                        }
                        try {
                            partition.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    partition.close();
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (iter == null) continue;
                if (throwable != null) {
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                iter.close();
            }
        }
        return new ResultMessage.Rows(result.build(options.getProtocolVersion()));
    }

    private ResultMessage.Rows processResults(PartitionIterator partitions, QueryOptions options, int nowInSec, int userLimit) throws RequestValidationException {
        ResultSet rset = this.process(partitions, options, nowInSec, userLimit);
        return new ResultMessage.Rows(rset);
    }

    @Override
    public ResultMessage.Rows executeInternal(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        QueryPager pager;
        int nowInSec = FBUtilities.nowInSeconds();
        int userLimit = this.getLimit(options);
        ReadQuery query = this.getQuery(options, nowInSec, userLimit);
        int pageSize = this.getPageSize(options);
        try (ReadExecutionController executionController = query.executionController();){
            if (pageSize <= 0 || query.limits().count() <= pageSize) {
                try (PartitionIterator data = query.executeInternal(executionController);){
                    ResultMessage.Rows rows = this.processResults(data, options, nowInSec, userLimit);
                    return rows;
                }
            }
            pager = query.getPager(options.getPagingState(), options.getProtocolVersion());
        }
        ResultMessage.Rows rows = this.execute(Pager.forInternalQuery(pager, executionController), options, pageSize, nowInSec, userLimit);
        return rows;
    }

    public ResultSet process(PartitionIterator partitions, int nowInSec) throws InvalidRequestException {
        return this.process(partitions, QueryOptions.DEFAULT, nowInSec, this.getLimit(QueryOptions.DEFAULT));
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public StatementRestrictions getRestrictions() {
        return this.restrictions;
    }

    private ReadQuery getSliceCommands(QueryOptions options, DataLimits limit, int nowInSec) throws RequestValidationException {
        List<ByteBuffer> keys = this.restrictions.getPartitionKeys(options);
        if (keys.isEmpty()) {
            return ReadQuery.EMPTY;
        }
        ClusteringIndexFilter filter = this.makeClusteringIndexFilter(options);
        if (filter == null) {
            return ReadQuery.EMPTY;
        }
        RowFilter rowFilter = this.getRowFilter(options);
        ArrayList<SinglePartitionReadCommand> commands = new ArrayList<SinglePartitionReadCommand>(keys.size());
        for (ByteBuffer key : keys) {
            QueryProcessor.validateKey(key);
            DecoratedKey dk = this.cfm.decorateKey(ByteBufferUtil.clone(key));
            commands.add(SinglePartitionReadCommand.create(this.cfm, nowInSec, this.queriedColumns, rowFilter, limit, dk, filter));
        }
        return new SinglePartitionReadCommand.Group(commands, limit);
    }

    public SinglePartitionReadCommand internalReadForView(DecoratedKey key, int nowInSec) {
        QueryOptions options = QueryOptions.forInternalCalls(Collections.emptyList());
        ClusteringIndexFilter filter = this.makeClusteringIndexFilter(options);
        RowFilter rowFilter = this.getRowFilter(options);
        return SinglePartitionReadCommand.create(this.cfm, nowInSec, this.queriedColumns, rowFilter, DataLimits.NONE, key, filter);
    }

    private ReadQuery getRangeCommand(QueryOptions options, DataLimits limit, int nowInSec) throws RequestValidationException {
        ClusteringIndexFilter clusteringIndexFilter = this.makeClusteringIndexFilter(options);
        if (clusteringIndexFilter == null) {
            return ReadQuery.EMPTY;
        }
        RowFilter rowFilter = this.getRowFilter(options);
        AbstractBounds<PartitionPosition> keyBounds = this.restrictions.getPartitionKeyBounds(options);
        return keyBounds == null ? ReadQuery.EMPTY : new PartitionRangeReadCommand(this.cfm, nowInSec, this.queriedColumns, rowFilter, limit, new DataRange(keyBounds, clusteringIndexFilter), Optional.empty());
    }

    private ClusteringIndexFilter makeClusteringIndexFilter(QueryOptions options) throws InvalidRequestException {
        if (this.parameters.isDistinct) {
            return new ClusteringIndexSliceFilter(Slices.ALL, false);
        }
        if (this.restrictions.isColumnRange()) {
            Slices slices = this.makeSlices(options);
            if (slices == Slices.NONE && !this.selection.containsStaticColumns()) {
                return null;
            }
            return new ClusteringIndexSliceFilter(slices, this.isReversed);
        }
        NavigableSet<Clustering> clusterings = this.getRequestedRows(options);
        if (clusterings.isEmpty() && this.queriedColumns.fetchedColumns().statics.isEmpty()) {
            return null;
        }
        return new ClusteringIndexNamesFilter(clusterings, this.isReversed);
    }

    private Slices makeSlices(QueryOptions options) throws InvalidRequestException {
        NavigableSet<Slice.Bound> startBounds = this.restrictions.getClusteringColumnsBounds(Bound.START, options);
        NavigableSet<Slice.Bound> endBounds = this.restrictions.getClusteringColumnsBounds(Bound.END, options);
        assert (startBounds.size() == endBounds.size());
        if (startBounds.size() == 1) {
            Slice.Bound end;
            Slice.Bound start = (Slice.Bound)startBounds.first();
            return this.cfm.comparator.compare(start, end = (Slice.Bound)endBounds.first()) > 0 ? Slices.NONE : Slices.with(this.cfm.comparator, Slice.make(start, end));
        }
        Slices.Builder builder = new Slices.Builder(this.cfm.comparator, startBounds.size());
        Iterator startIter = startBounds.iterator();
        Iterator endIter = endBounds.iterator();
        while (startIter.hasNext() && endIter.hasNext()) {
            Slice.Bound end;
            Slice.Bound start = (Slice.Bound)startIter.next();
            if (this.cfm.comparator.compare(start, end = (Slice.Bound)endIter.next()) > 0) continue;
            builder.add(start, end);
        }
        return builder.build();
    }

    private DataLimits getDataLimits(int userLimit) {
        int cqlRowLimit = Integer.MAX_VALUE;
        if (!this.selection.isAggregate() && !this.needsPostQueryOrdering()) {
            cqlRowLimit = userLimit;
        }
        if (this.parameters.isDistinct) {
            return cqlRowLimit == Integer.MAX_VALUE ? DataLimits.DISTINCT_NONE : DataLimits.distinctLimits(cqlRowLimit);
        }
        return cqlRowLimit == Integer.MAX_VALUE ? DataLimits.NONE : DataLimits.cqlLimits(cqlRowLimit);
    }

    public int getLimit(QueryOptions options) {
        ByteBuffer b;
        int userLimit = Integer.MAX_VALUE;
        if (this.limit != null && (b = RequestValidations.checkNotNull(this.limit.bindAndGet(options), "Invalid null value of limit", new Object[0])) != ByteBufferUtil.UNSET_BYTE_BUFFER) {
            try {
                Int32Type.instance.validate(b);
                userLimit = (Integer)Int32Type.instance.compose(b);
                RequestValidations.checkTrue(userLimit > 0, "LIMIT must be strictly positive");
            }
            catch (MarshalException e) {
                throw new InvalidRequestException("Invalid limit value");
            }
        }
        return userLimit;
    }

    private NavigableSet<Clustering> getRequestedRows(QueryOptions options) throws InvalidRequestException {
        assert (!this.restrictions.isColumnRange());
        return this.restrictions.getClusteringColumns(options);
    }

    public RowFilter getRowFilter(QueryOptions options) throws InvalidRequestException {
        ColumnFamilyStore cfs = Keyspace.open(this.keyspace()).getColumnFamilyStore(this.columnFamily());
        SecondaryIndexManager secondaryIndexManager = cfs.indexManager;
        RowFilter filter = this.restrictions.getRowFilter(secondaryIndexManager, options);
        return filter;
    }

    private ResultSet process(PartitionIterator partitions, QueryOptions options, int nowInSec, int userLimit) throws InvalidRequestException {
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(this.parameters.isJson);
        while (partitions.hasNext()) {
            RowIterator partition = (RowIterator)partitions.next();
            Throwable throwable = null;
            try {
                this.processPartition(partition, options, result, nowInSec);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
        ResultSet cqlRows = result.build(options.getProtocolVersion());
        this.orderResults(cqlRows);
        cqlRows.trim(userLimit);
        return cqlRows;
    }

    public static ByteBuffer[] getComponents(CFMetaData cfm, DecoratedKey dk) {
        ByteBuffer key = dk.getKey();
        if (cfm.getKeyValidator() instanceof CompositeType) {
            return ((CompositeType)cfm.getKeyValidator()).split(key);
        }
        return new ByteBuffer[]{key};
    }

    void processPartition(RowIterator partition, QueryOptions options, Selection.ResultSetBuilder result, int nowInSec) throws InvalidRequestException {
        int protocolVersion = options.getProtocolVersion();
        ByteBuffer[] keyComponents = SelectStatement.getComponents(this.cfm, partition.partitionKey());
        Row staticRow = partition.staticRow();
        if (!partition.hasNext()) {
            if (!(staticRow.isEmpty() || this.restrictions.usesSecondaryIndexing() && !this.cfm.isStaticCompactTable() || this.restrictions.hasClusteringColumnsRestriction())) {
                result.newRow(protocolVersion);
                block10: for (ColumnDefinition def : this.selection.getColumns()) {
                    switch (def.kind) {
                        case PARTITION_KEY: {
                            result.add(keyComponents[def.position()]);
                            continue block10;
                        }
                        case STATIC: {
                            SelectStatement.addValue(result, def, staticRow, nowInSec, protocolVersion);
                            continue block10;
                        }
                    }
                    result.add(null);
                }
            }
            return;
        }
        while (partition.hasNext()) {
            Row row = (Row)partition.next();
            result.newRow(protocolVersion);
            for (ColumnDefinition def : this.selection.getColumns()) {
                switch (def.kind) {
                    case PARTITION_KEY: {
                        result.add(keyComponents[def.position()]);
                        break;
                    }
                    case CLUSTERING: {
                        result.add(row.clustering().get(def.position()));
                        break;
                    }
                    case REGULAR: {
                        SelectStatement.addValue(result, def, row, nowInSec, protocolVersion);
                        break;
                    }
                    case STATIC: {
                        SelectStatement.addValue(result, def, staticRow, nowInSec, protocolVersion);
                    }
                }
            }
        }
    }

    private static void addValue(Selection.ResultSetBuilder result, ColumnDefinition def, Row row, int nowInSec, int protocolVersion) {
        if (def.isComplex()) {
            assert (def.type.isCollection() && def.type.isMultiCell());
            ComplexColumnData complexData = row.getComplexColumnData(def);
            if (complexData == null) {
                result.add(null);
            } else {
                result.add(((CollectionType)def.type).serializeForNativeProtocol(def, complexData.iterator(), protocolVersion));
            }
        } else {
            result.add(row.getCell(def), nowInSec);
        }
    }

    private boolean needsPostQueryOrdering() {
        return this.restrictions.keyIsInRelation() && !this.parameters.orderings.isEmpty();
    }

    private void orderResults(ResultSet cqlRows) {
        if (cqlRows.size() == 0 || !this.needsPostQueryOrdering()) {
            return;
        }
        Collections.sort(cqlRows.rows, this.orderingComparator);
    }

    private static class CompositeComparator
    extends ColumnComparator<List<ByteBuffer>> {
        private final List<Comparator<ByteBuffer>> orderTypes;
        private final List<Integer> positions;

        private CompositeComparator(List<Comparator<ByteBuffer>> orderTypes, List<Integer> positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.size(); ++i) {
                int columnPos;
                Comparator<ByteBuffer> type = this.orderTypes.get(i);
                int comparison = this.compare(type, a.get(columnPos = this.positions.get(i).intValue()), b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    extends ColumnComparator<List<ByteBuffer>> {
        private final int index;
        private final Comparator<ByteBuffer> comparator;

        public SingleColumnComparator(int columnIndex, Comparator<ByteBuffer> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.compare(this.comparator, a.get(this.index), b.get(this.index));
        }
    }

    private static abstract class ColumnComparator<T>
    implements Comparator<T> {
        private ColumnComparator() {
        }

        protected final int compare(Comparator<ByteBuffer> comparator, ByteBuffer aValue, ByteBuffer bValue) {
            if (aValue == null) {
                return bValue == null ? 0 : -1;
            }
            return bValue == null ? 1 : comparator.compare(aValue, bValue);
        }
    }

    public static class Parameters {
        public final Map<ColumnIdentifier.Raw, Boolean> orderings;
        public final boolean isDistinct;
        public final boolean allowFiltering;
        public final boolean isJson;

        public Parameters(Map<ColumnIdentifier.Raw, Boolean> orderings, boolean isDistinct, boolean allowFiltering, boolean isJson) {
            this.orderings = orderings;
            this.isDistinct = isDistinct;
            this.allowFiltering = allowFiltering;
            this.isJson = isJson;
        }
    }

    public static class RawStatement
    extends CFStatement {
        public final Parameters parameters;
        public final List<RawSelector> selectClause;
        public final WhereClause whereClause;
        public final Term.Raw limit;

        public RawStatement(CFName cfName, Parameters parameters, List<RawSelector> selectClause, WhereClause whereClause, Term.Raw limit) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause;
            this.limit = limit;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            return this.prepare(false);
        }

        public ParsedStatement.Prepared prepare(boolean forView) throws InvalidRequestException {
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            VariableSpecifications boundNames = this.getBoundVariables();
            Selection selection = this.selectClause.isEmpty() ? Selection.wildcard(cfm) : Selection.fromSelectors(cfm, this.selectClause);
            StatementRestrictions restrictions = this.prepareRestrictions(cfm, boundNames, selection, forView);
            if (this.parameters.isDistinct) {
                RawStatement.validateDistinctSelection(cfm, selection, restrictions);
            }
            Comparator<List<ByteBuffer>> orderingComparator = null;
            boolean isReversed = false;
            if (!this.parameters.orderings.isEmpty()) {
                assert (!forView);
                RawStatement.verifyOrderingIsAllowed(restrictions);
                orderingComparator = this.getOrderingComparator(cfm, selection, restrictions);
                isReversed = this.isReversed(cfm);
                if (isReversed) {
                    orderingComparator = Collections.reverseOrder(orderingComparator);
                }
            }
            this.checkNeedsFiltering(restrictions);
            SelectStatement stmt = new SelectStatement(cfm, boundNames.size(), this.parameters, selection, restrictions, isReversed, orderingComparator, this.prepareLimit(boundNames));
            return new ParsedStatement.Prepared((CQLStatement)stmt, boundNames, boundNames.getPartitionKeyBindIndexes(cfm));
        }

        private StatementRestrictions prepareRestrictions(CFMetaData cfm, VariableSpecifications boundNames, Selection selection, boolean forView) throws InvalidRequestException {
            try {
                return new StatementRestrictions(StatementType.SELECT, cfm, this.whereClause, boundNames, selection.containsOnlyStaticColumns(), selection.containsACollection(), this.parameters.allowFiltering, forView);
            }
            catch (UnrecognizedEntityException e) {
                if (this.containsAlias(e.entity)) {
                    throw RequestValidations.invalidRequest("Aliases aren't allowed in the where clause ('%s')", e.relation);
                }
                throw e;
            }
        }

        private Term prepareLimit(VariableSpecifications boundNames) throws InvalidRequestException {
            if (this.limit == null) {
                return null;
            }
            Term prepLimit = this.limit.prepare(this.keyspace(), this.limitReceiver());
            prepLimit.collectMarkerSpecification(boundNames);
            return prepLimit;
        }

        private static void verifyOrderingIsAllowed(StatementRestrictions restrictions) throws InvalidRequestException {
            RequestValidations.checkFalse(restrictions.usesSecondaryIndexing(), "ORDER BY with 2ndary indexes is not supported.");
            RequestValidations.checkFalse(restrictions.isKeyRange(), "ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
        }

        private static void validateDistinctSelection(CFMetaData cfm, Selection selection, StatementRestrictions restrictions) throws InvalidRequestException {
            List<ColumnDefinition> requestedColumns = selection.getColumns();
            for (ColumnDefinition def : requestedColumns) {
                RequestValidations.checkFalse(!def.isPartitionKey() && !def.isStatic(), "SELECT DISTINCT queries must only request partition key columns and/or static columns (not %s)", def.name);
            }
            if (!restrictions.isKeyRange()) {
                return;
            }
            for (ColumnDefinition def : cfm.partitionKeyColumns()) {
                RequestValidations.checkTrue(requestedColumns.contains(def), "SELECT DISTINCT queries must request all the partition key columns (missing %s)", def.name);
            }
        }

        private void handleUnrecognizedOrderingColumn(ColumnIdentifier column) throws InvalidRequestException {
            RequestValidations.checkFalse(this.containsAlias(column), "Aliases are not allowed in order by clause ('%s')", column);
            RequestValidations.checkFalse(true, "Order by on unknown column %s", column);
        }

        private Comparator<List<ByteBuffer>> getOrderingComparator(CFMetaData cfm, Selection selection, StatementRestrictions restrictions) throws InvalidRequestException {
            if (!restrictions.keyIsInRelation()) {
                return null;
            }
            Map<ColumnIdentifier, Integer> orderingIndexes = this.getOrderingIndex(cfm, selection);
            ArrayList<Integer> idToSort = new ArrayList<Integer>();
            ArrayList<AbstractType> sorters = new ArrayList<AbstractType>();
            for (ColumnIdentifier.Raw raw : this.parameters.orderings.keySet()) {
                ColumnIdentifier identifier = raw.prepare(cfm);
                ColumnDefinition orderingColumn = cfm.getColumnDefinition(identifier);
                idToSort.add(orderingIndexes.get(orderingColumn.name));
                sorters.add(orderingColumn.type);
            }
            return idToSort.size() == 1 ? new SingleColumnComparator((Integer)idToSort.get(0), (Comparator)sorters.get(0)) : new CompositeComparator(sorters, idToSort);
        }

        private Map<ColumnIdentifier, Integer> getOrderingIndex(CFMetaData cfm, Selection selection) throws InvalidRequestException {
            HashMap<ColumnIdentifier, Integer> orderingIndexes = new HashMap<ColumnIdentifier, Integer>();
            for (ColumnIdentifier.Raw raw : this.parameters.orderings.keySet()) {
                int index;
                ColumnIdentifier column = raw.prepare(cfm);
                ColumnDefinition def = cfm.getColumnDefinition(column);
                if (def == null) {
                    this.handleUnrecognizedOrderingColumn(column);
                }
                if ((index = selection.getResultSetIndex(def)) < 0) {
                    index = selection.addColumnForOrdering(def);
                }
                orderingIndexes.put(def.name, index);
            }
            return orderingIndexes;
        }

        private boolean isReversed(CFMetaData cfm) throws InvalidRequestException {
            Boolean[] reversedMap = new Boolean[cfm.clusteringColumns().size()];
            int i = 0;
            for (Map.Entry<ColumnIdentifier.Raw, Boolean> entry : this.parameters.orderings.entrySet()) {
                ColumnIdentifier column = entry.getKey().prepare(cfm);
                boolean reversed = entry.getValue();
                ColumnDefinition def = cfm.getColumnDefinition(column);
                if (def == null) {
                    this.handleUnrecognizedOrderingColumn(column);
                }
                RequestValidations.checkTrue(def.isClusteringColumn(), "Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", column);
                RequestValidations.checkTrue(i++ == def.position(), "Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY");
                reversedMap[def.position()] = reversed != def.isReversedType();
            }
            Boolean isReversed = null;
            for (Boolean b : reversedMap) {
                if (b == null) continue;
                if (isReversed == null) {
                    isReversed = b;
                    continue;
                }
                RequestValidations.checkTrue(isReversed.equals(b), "Unsupported order by relation");
            }
            assert (isReversed != null);
            return isReversed;
        }

        private void checkNeedsFiltering(StatementRestrictions restrictions) throws InvalidRequestException {
            if (!this.parameters.allowFiltering && (restrictions.isKeyRange() || restrictions.usesSecondaryIndexing())) {
                RequestValidations.checkFalse(restrictions.needFiltering(), SelectStatement.REQUIRES_ALLOW_FILTERING_MESSAGE);
            }
        }

        private boolean containsAlias(final ColumnIdentifier name) {
            return Iterables.any(this.selectClause, (Predicate)new Predicate<RawSelector>(){

                public boolean apply(RawSelector raw) {
                    return name.equals(raw.alias);
                }
            });
        }

        private ColumnSpecification limitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.columnFamily(), new ColumnIdentifier("[limit]", true), Int32Type.instance);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.cfName).add("selectClause", this.selectClause).add("whereClause", (Object)this.whereClause).add("isDistinct", this.parameters.isDistinct).toString();
        }
    }

    private static abstract class Pager {
        protected QueryPager pager;

        protected Pager(QueryPager pager) {
            this.pager = pager;
        }

        public static Pager forInternalQuery(QueryPager pager, ReadExecutionController executionController) {
            return new InternalPager(pager, executionController);
        }

        public static Pager forDistributedQuery(QueryPager pager, ConsistencyLevel consistency, ClientState clientState) {
            return new NormalPager(pager, consistency, clientState);
        }

        public boolean isExhausted() {
            return this.pager.isExhausted();
        }

        public PagingState state() {
            return this.pager.state();
        }

        public abstract PartitionIterator fetchPage(int var1);

        public static class InternalPager
        extends Pager {
            private final ReadExecutionController executionController;

            private InternalPager(QueryPager pager, ReadExecutionController executionController) {
                super(pager);
                this.executionController = executionController;
            }

            @Override
            public PartitionIterator fetchPage(int pageSize) {
                return this.pager.fetchPageInternal(pageSize, this.executionController);
            }
        }

        public static class NormalPager
        extends Pager {
            private final ConsistencyLevel consistency;
            private final ClientState clientState;

            private NormalPager(QueryPager pager, ConsistencyLevel consistency, ClientState clientState) {
                super(pager);
                this.consistency = consistency;
                this.clientState = clientState;
            }

            @Override
            public PartitionIterator fetchPage(int pageSize) {
                return this.pager.fetchPage(pageSize, this.consistency, this.clientState);
            }
        }
    }
}

