/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

class CompactionHistoryRow
implements Comparable<CompactionHistoryRow> {
    private final String id;
    private final String ksName;
    private final String cfName;
    private final long compactedAt;
    private final long bytesIn;
    private final long bytesOut;
    private final String rowMerged;

    CompactionHistoryRow(String id, String ksName, String cfName, long compactedAt, long bytesIn, long bytesOut, String rowMerged) {
        this.id = id;
        this.ksName = ksName;
        this.cfName = cfName;
        this.compactedAt = compactedAt;
        this.bytesIn = bytesIn;
        this.bytesOut = bytesOut;
        this.rowMerged = rowMerged;
    }

    @Override
    public int compareTo(CompactionHistoryRow chc) {
        return Long.signum(chc.compactedAt - this.compactedAt);
    }

    public Object[] getAllAsArray() {
        Object[] obj = new Object[7];
        obj[0] = this.id;
        obj[1] = this.ksName;
        obj[2] = this.cfName;
        Instant instant = Instant.ofEpochMilli(this.compactedAt);
        LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        obj[3] = ldt.toString();
        obj[4] = this.bytesIn;
        obj[5] = this.bytesOut;
        obj[6] = this.rowMerged;
        return obj;
    }
}

