/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.lifecycle.LogFile;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.LogTransaction;

final class LogAwareFileLister {
    private final Path folder;
    private final BiFunction<File, Directories.FileType, Boolean> filter;
    private final Directories.OnTxnErr onTxnErr;
    NavigableMap<File, Directories.FileType> files = new TreeMap<File, Directories.FileType>();

    @VisibleForTesting
    LogAwareFileLister(Path folder, BiFunction<File, Directories.FileType, Boolean> filter, Directories.OnTxnErr onTxnErr) {
        this.folder = folder;
        this.filter = filter;
        this.onTxnErr = onTxnErr;
    }

    public List<File> list() {
        try {
            return this.innerList();
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Failed to list files in %s", this.folder), t);
        }
    }

    List<File> innerList() throws Throwable {
        LogAwareFileLister.list(Files.newDirectoryStream(this.folder)).stream().filter(f -> !LogFile.isLogFile(f)).forEach(f -> this.files.put((File)f, Directories.FileType.FINAL));
        LogAwareFileLister.list(Files.newDirectoryStream(this.folder, '*' + LogFile.EXT)).stream().filter(LogFile::isLogFile).forEach(this::classifyFiles);
        return this.files.entrySet().stream().filter(e -> this.filter.apply((File)e.getKey(), (Directories.FileType)((Object)((Object)e.getValue())))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    static List<File> list(DirectoryStream<Path> stream) throws IOException {
        try {
            List<File> list = StreamSupport.stream(stream.spliterator(), false).map(Path::toFile).filter(f -> !f.isDirectory()).collect(Collectors.toList());
            return list;
        }
        finally {
            stream.close();
        }
    }

    void classifyFiles(File txnFile) {
        LogFile txn = LogFile.make(txnFile);
        this.readTxnLog(txn);
        this.classifyFiles(txn);
        this.files.put(txnFile, Directories.FileType.TXN_LOG);
    }

    void readTxnLog(LogFile txn) {
        if (!txn.verify() && this.onTxnErr == Directories.OnTxnErr.THROW) {
            throw new LogTransaction.CorruptTransactionLogException("Some records failed verification. See earlier in log for details.", txn);
        }
    }

    void classifyFiles(LogFile txnFile) {
        Map<LogRecord, Set<File>> oldFiles = txnFile.getFilesOfType(this.files.navigableKeySet(), LogRecord.Type.REMOVE);
        Map<LogRecord, Set<File>> newFiles = txnFile.getFilesOfType(this.files.navigableKeySet(), LogRecord.Type.ADD);
        if (txnFile.completed()) {
            this.setTemporary(txnFile, oldFiles.values(), newFiles.values());
            return;
        }
        if (LogAwareFileLister.allFilesPresent(txnFile, oldFiles, newFiles)) {
            this.setTemporary(txnFile, oldFiles.values(), newFiles.values());
            return;
        }
        if (!txnFile.exists()) {
            return;
        }
        this.readTxnLog(txnFile);
        if (txnFile.completed()) {
            this.setTemporary(txnFile, oldFiles.values(), newFiles.values());
            return;
        }
        throw new RuntimeException(String.format("Failed to list directory files in %s, inconsistent disk state for transaction %s", this.folder, txnFile));
    }

    private static boolean allFilesPresent(LogFile txnFile, Map<LogRecord, Set<File>> oldFiles, Map<LogRecord, Set<File>> newFiles) {
        LogRecord lastRecord = txnFile.getLastRecord();
        return !Stream.concat(oldFiles.entrySet().stream(), newFiles.entrySet().stream().filter(e -> e.getKey() != lastRecord)).filter(e -> ((LogRecord)e.getKey()).numFiles > ((Set)e.getValue()).size()).findFirst().isPresent();
    }

    private void setTemporary(LogFile txnFile, Collection<Set<File>> oldFiles, Collection<Set<File>> newFiles) {
        Collection<Set<File>> temporary = txnFile.committed() ? oldFiles : newFiles;
        temporary.stream().flatMap(Collection::stream).forEach(f -> this.files.put((File)f, Directories.FileType.TEMPORARY));
    }

    @VisibleForTesting
    static Set<File> getTemporaryFiles(File folder) {
        return LogAwareFileLister.listFiles(folder, Directories.FileType.TEMPORARY);
    }

    @VisibleForTesting
    static Set<File> getFinalFiles(File folder) {
        return LogAwareFileLister.listFiles(folder, Directories.FileType.FINAL);
    }

    @VisibleForTesting
    static Set<File> listFiles(File folder, Directories.FileType ... types) {
        List<Directories.FileType> match = Arrays.asList(types);
        return new LogAwareFileLister(folder.toPath(), (file, type) -> match.contains(type), Directories.OnTxnErr.IGNORE).list().stream().collect(Collectors.toSet());
    }
}

