/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractCompositeType
extends AbstractType<ByteBuffer> {
    private static final String COLON = ":";
    private static final Pattern COLON_PAT = Pattern.compile(":");
    private static final String ESCAPED_COLON = "\\\\:";
    private static final Pattern ESCAPED_COLON_PAT = Pattern.compile("\\\\:");

    protected AbstractCompositeType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        boolean isStatic2;
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        ByteBuffer bb1 = o1.duplicate();
        ByteBuffer bb2 = o2.duplicate();
        boolean isStatic1 = this.readIsStatic(bb1);
        if (isStatic1 != (isStatic2 = this.readIsStatic(bb2))) {
            return isStatic1 ? -1 : 1;
        }
        int i = 0;
        ByteBuffer previous = null;
        while (bb1.remaining() > 0 && bb2.remaining() > 0) {
            byte b2;
            ByteBuffer value2;
            ByteBuffer value1;
            AbstractType<?> comparator = this.getComparator(i, bb1, bb2);
            int cmp = comparator.compareCollectionMembers(value1 = ByteBufferUtil.readBytesWithShortLength(bb1), value2 = ByteBufferUtil.readBytesWithShortLength(bb2), previous);
            if (cmp != 0) {
                return cmp;
            }
            previous = value1;
            byte b1 = bb1.get();
            if (b1 != (b2 = bb2.get())) {
                return b1 - b2;
            }
            ++i;
        }
        if (bb1.remaining() == 0) {
            return bb2.remaining() == 0 ? 0 : -1;
        }
        return 1;
    }

    protected abstract boolean readIsStatic(ByteBuffer var1);

    public ByteBuffer[] split(ByteBuffer name) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>();
        ByteBuffer bb = name.duplicate();
        this.readIsStatic(bb);
        int i = 0;
        while (bb.remaining() > 0) {
            this.getComparator(i++, bb);
            l.add(ByteBufferUtil.readBytesWithShortLength(bb));
            bb.get();
        }
        return l.toArray(new ByteBuffer[l.size()]);
    }

    public static String escape(String input) {
        if (input.isEmpty()) {
            return input;
        }
        String res = COLON_PAT.matcher(input).replaceAll(ESCAPED_COLON);
        char last = res.charAt(res.length() - 1);
        return last == '\\' || last == '!' ? res + '!' : res;
    }

    static String unescape(String input) {
        if (input.isEmpty()) {
            return input;
        }
        String res = ESCAPED_COLON_PAT.matcher(input).replaceAll(COLON);
        char last = res.charAt(res.length() - 1);
        return last == '!' ? res.substring(0, res.length() - 1) : res;
    }

    static List<String> split(String input) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        int prev = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != ':' || i > 0 && input.charAt(i - 1) == '\\') continue;
            res.add(input.substring(prev, i));
            prev = i + 1;
        }
        res.add(input.substring(prev, input.length()));
        return res;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        StringBuilder sb = new StringBuilder();
        ByteBuffer bb = bytes.duplicate();
        this.readIsStatic(bb);
        int i = 0;
        while (bb.remaining() > 0) {
            if (bb.remaining() != bytes.remaining()) {
                sb.append(COLON);
            }
            AbstractType<?> comparator = this.getAndAppendComparator(i, bb, sb);
            ByteBuffer value = ByteBufferUtil.readBytesWithShortLength(bb);
            sb.append(AbstractCompositeType.escape(comparator.getString(value)));
            byte b = bb.get();
            if (b != 0) {
                sb.append(b < 0 ? ":_" : ":!");
                break;
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public ByteBuffer fromString(String source) {
        List<String> parts = AbstractCompositeType.split(source);
        ArrayList<ByteBuffer> components = new ArrayList<ByteBuffer>(parts.size());
        ArrayList<ParsedComparator> comparators = new ArrayList<ParsedComparator>(parts.size());
        int totalLength = 0;
        int i = 0;
        boolean lastByteIsOne = false;
        boolean lastByteIsMinusOne = false;
        for (String part : parts) {
            if (part.equals("!")) {
                lastByteIsOne = true;
                break;
            }
            if (part.equals("_")) {
                lastByteIsMinusOne = true;
                break;
            }
            ParsedComparator p = this.parseComparator(i, part);
            AbstractType<?> type = p.getAbstractType();
            part = p.getRemainingPart();
            ByteBuffer component = type.fromString(AbstractCompositeType.unescape(part));
            totalLength += p.getComparatorSerializedSize() + 2 + component.remaining() + 1;
            components.add(component);
            comparators.add(p);
            ++i;
        }
        ByteBuffer bb = ByteBuffer.allocate(totalLength);
        i = 0;
        for (ByteBuffer component : components) {
            ((ParsedComparator)comparators.get(i)).serializeComparator(bb);
            ByteBufferUtil.writeShortLength(bb, component.remaining());
            bb.put(component);
            bb.put((byte)0);
            ++i;
        }
        if (lastByteIsOne) {
            bb.put(bb.limit() - 1, (byte)1);
        } else if (lastByteIsMinusOne) {
            bb.put(bb.limit() - 1, (byte)-1);
        }
        bb.rewind();
        return bb;
    }

    @Override
    public Term fromJSONObject(Object parsed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        ByteBuffer bb = bytes.duplicate();
        this.readIsStatic(bb);
        int i = 0;
        ByteBuffer previous = null;
        while (bb.remaining() > 0) {
            AbstractType<?> comparator = this.validateComparator(i, bb);
            if (bb.remaining() < 2) {
                throw new MarshalException("Not enough bytes to read value size of component " + i);
            }
            int length = ByteBufferUtil.readShortLength(bb);
            if (bb.remaining() < length) {
                throw new MarshalException("Not enough bytes to read value of component " + i);
            }
            ByteBuffer value = ByteBufferUtil.readBytes(bb, length);
            comparator.validateCollectionMember(value, previous);
            if (bb.remaining() == 0) {
                throw new MarshalException("Not enough bytes to read the end-of-component byte of component" + i);
            }
            byte b = bb.get();
            if (b != 0 && bb.remaining() != 0) {
                throw new MarshalException("Invalid bytes remaining after an end-of-component at component" + i);
            }
            previous = value;
            ++i;
        }
    }

    @Override
    public abstract ByteBuffer decompose(Object ... var1);

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return BytesSerializer.instance;
    }

    protected abstract AbstractType<?> getComparator(int var1, ByteBuffer var2);

    protected abstract AbstractType<?> getComparator(int var1, ByteBuffer var2, ByteBuffer var3);

    protected abstract AbstractType<?> getAndAppendComparator(int var1, ByteBuffer var2, StringBuilder var3);

    protected abstract AbstractType<?> validateComparator(int var1, ByteBuffer var2) throws MarshalException;

    protected abstract ParsedComparator parseComparator(int var1, String var2);

    protected static interface ParsedComparator {
        public AbstractType<?> getAbstractType();

        public String getRemainingPart();

        public int getComparatorSerializedSize();

        public void serializeComparator(ByteBuffer var1);
    }
}

