/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.exceptions.InvalidRequestException;

public interface Term {
    public void collectMarkerSpecification(VariableSpecifications var1);

    public Terminal bind(QueryOptions var1) throws InvalidRequestException;

    public ByteBuffer bindAndGet(QueryOptions var1) throws InvalidRequestException;

    public boolean containsBindMarker();

    public Iterable<Function> getFunctions();

    public static abstract class NonTerminal
    implements Term {
        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            Terminal t = this.bind(options);
            return t == null ? null : t.get(options.getProtocolVersion());
        }
    }

    public static abstract class MultiItemTerminal
    extends Terminal {
        public abstract List<ByteBuffer> getElements();
    }

    public static abstract class Terminal
    implements Term {
        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Terminal bind(QueryOptions options) {
            return this;
        }

        public Set<Function> getFunctions() {
            return Collections.emptySet();
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        public abstract ByteBuffer get(int var1) throws InvalidRequestException;

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            return this.get(options.getProtocolVersion());
        }
    }

    public static abstract class MultiColumnRaw
    extends Raw {
        public abstract Term prepare(String var1, List<? extends ColumnSpecification> var2) throws InvalidRequestException;
    }

    public static abstract class Raw
    implements AssignmentTestable {
        public abstract Term prepare(String var1, ColumnSpecification var2) throws InvalidRequestException;

        public abstract String getText();

        public String toString() {
            return this.getText();
        }
    }
}

