/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.SuperColumnCompatibility;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ExpirationDateOverflowHandling;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnknownColumnException;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowAndDeletionMergeIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LegacyLayout {
    private static final Logger logger = LoggerFactory.getLogger(LegacyLayout.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    public static final int MAX_CELL_NAME_LENGTH = 65535;
    public static final int STATIC_PREFIX = 65535;
    public static final int DELETION_MASK = 1;
    public static final int EXPIRATION_MASK = 2;
    public static final int COUNTER_MASK = 4;
    public static final int COUNTER_UPDATE_MASK = 8;
    private static final int RANGE_TOMBSTONE_MASK = 16;
    private static final ColumnDefinition INVALID_DROPPED_COMPLEX_SUBSTITUTE_COLUMN = new ColumnDefinition("", "", ColumnIdentifier.getInterned(ByteBufferUtil.EMPTY_BYTE_BUFFER, UTF8Type.instance), SetType.getInstance(UTF8Type.instance, true), -1, ColumnDefinition.Kind.REGULAR);

    private LegacyLayout() {
    }

    public static AbstractType<?> makeLegacyComparator(CFMetaData metadata) {
        ClusteringComparator comparator = metadata.comparator;
        if (!metadata.isCompound()) {
            assert (comparator.size() == 1);
            return comparator.subtype(0);
        }
        boolean hasCollections = metadata.hasCollectionColumns() || metadata.hasDroppedCollectionColumns();
        ArrayList types = new ArrayList(comparator.size() + (metadata.isDense() ? 0 : 1) + (hasCollections ? 1 : 0));
        types.addAll(comparator.subtypes());
        if (!metadata.isDense()) {
            types.add(UTF8Type.instance);
            if (hasCollections) {
                HashMap<ByteBuffer, CollectionType> defined = new HashMap<ByteBuffer, CollectionType>();
                for (CFMetaData.DroppedColumn droppedColumn : metadata.getDroppedColumns().values()) {
                    if (!(droppedColumn.type instanceof CollectionType) || !droppedColumn.type.isMultiCell()) continue;
                    defined.put(ByteBufferUtil.bytes(droppedColumn.name), (CollectionType)droppedColumn.type);
                }
                for (ColumnDefinition columnDefinition : metadata.partitionColumns()) {
                    if (!(columnDefinition.type instanceof CollectionType) || !columnDefinition.type.isMultiCell()) continue;
                    defined.put(columnDefinition.name.bytes, (CollectionType)columnDefinition.type);
                }
                types.add(ColumnToCollectionType.getInstance(defined));
            }
        }
        return CompositeType.getInstance(types);
    }

    public static LegacyCellName decodeCellName(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer cellname) throws UnknownColumnException {
        assert (cellname != null);
        if (metadata.isSuper()) {
            assert (superColumnName != null);
            return LegacyLayout.decodeForSuperColumn(metadata, Clustering.make(superColumnName), cellname);
        }
        assert (superColumnName == null);
        return LegacyLayout.decodeCellName(metadata, cellname);
    }

    private static LegacyCellName decodeForSuperColumn(CFMetaData metadata, Clustering clustering, ByteBuffer subcol) {
        ColumnDefinition def = metadata.getColumnDefinition(subcol);
        if (def != null) {
            return new LegacyCellName(clustering, def, null);
        }
        def = metadata.compactValueColumn();
        assert (def != null && def.type instanceof MapType);
        return new LegacyCellName(clustering, def, subcol);
    }

    public static LegacyCellName decodeCellName(CFMetaData metadata, ByteBuffer cellname) throws UnknownColumnException {
        return LegacyLayout.decodeCellName(metadata, cellname, false);
    }

    public static LegacyCellName decodeCellName(CFMetaData metadata, ByteBuffer cellname, boolean readAllAsDynamic) throws UnknownColumnException {
        ByteBuffer collectionElement;
        ByteBuffer column;
        Clustering clustering = LegacyLayout.decodeClustering(metadata, cellname);
        if (metadata.isSuper()) {
            return LegacyLayout.decodeForSuperColumn(metadata, clustering, CompositeType.extractComponent(cellname, 1));
        }
        if (metadata.isDense() || metadata.isCompactTable() && readAllAsDynamic) {
            return new LegacyCellName(clustering, metadata.compactValueColumn(), null);
        }
        ByteBuffer byteBuffer = column = metadata.isCompound() ? CompositeType.extractComponent(cellname, metadata.comparator.size()) : cellname;
        if (column == null) {
            if (metadata.partitionColumns().isEmpty()) {
                return new LegacyCellName(clustering, null, null);
            }
            throw new IllegalArgumentException("No column name component found in cell name");
        }
        if (!column.hasRemaining()) {
            return new LegacyCellName(clustering, null, null);
        }
        ColumnDefinition def = metadata.getColumnDefinition(column);
        if (metadata.isCompactTable()) {
            if (def == null || def.isPrimaryKeyColumn()) {
                return new LegacyCellName(Clustering.make(column), metadata.compactValueColumn(), null);
            }
        } else if (def == null) {
            throw new UnknownColumnException(metadata, column);
        }
        ByteBuffer byteBuffer2 = collectionElement = metadata.isCompound() ? CompositeType.extractComponent(cellname, metadata.comparator.size() + 1) : null;
        if (collectionElement != null && def.type instanceof CollectionType) {
            ((CollectionType)def.type).nameComparator().validateIfFixedSize(collectionElement);
        }
        return new LegacyCellName(def.isStatic() ? Clustering.STATIC_CLUSTERING : clustering, def, collectionElement);
    }

    public static LegacyBound decodeSliceBound(CFMetaData metadata, ByteBuffer bound, boolean isStart) {
        return LegacyLayout.decodeBound(metadata, bound, isStart, false);
    }

    public static LegacyBound decodeTombstoneBound(CFMetaData metadata, ByteBuffer bound, boolean isStart) {
        return LegacyLayout.decodeBound(metadata, bound, isStart, true);
    }

    private static LegacyBound decodeBound(CFMetaData metadata, ByteBuffer bound, boolean isStart, boolean isDeletion) {
        boolean isInclusive;
        byte eoc;
        List<ByteBuffer> components;
        boolean isStatic;
        int clusteringSize;
        block18: {
            block19: {
                if (!bound.hasRemaining()) {
                    return isStart ? LegacyBound.BOTTOM : LegacyBound.TOP;
                }
                if (!metadata.isCompound()) {
                    metadata.comparator.subtype(0).validateIfFixedSize(bound);
                    return new LegacyBound(isStart ? ClusteringBound.inclusiveStartOf(bound) : ClusteringBound.inclusiveEndOf(bound), false, null);
                }
                clusteringSize = metadata.comparator.size();
                isStatic = metadata.isCompound() && CompositeType.isStaticName(bound);
                components = CompositeType.splitName(bound);
                eoc = CompositeType.lastEOC(bound);
                for (int i = 0; i < Math.min(clusteringSize, components.size()); ++i) {
                    metadata.comparator.subtype(i).validateIfFixedSize(components.get(i));
                }
                if ($assertionsDisabled || !isStatic) break block18;
                if (components.size() < clusteringSize) break block19;
                if (Iterables.all(components.subList(0, clusteringSize), ByteBufferUtil.EMPTY_BYTE_BUFFER::equals)) break block18;
            }
            throw new AssertionError();
        }
        ColumnDefinition collectionName = null;
        if (components.size() > clusteringSize) {
            assert (!metadata.isCompactTable()) : LegacyLayout.toDebugHex(components);
            if (components.size() > clusteringSize + 1) {
                if (isDeletion) {
                    throw new IllegalArgumentException("Invalid bound " + LegacyLayout.toDebugHex(components) + ": deletion can have at most one extra component");
                }
                if (clusteringSize + 2 != components.size()) {
                    throw new IllegalArgumentException("Invalid bound " + LegacyLayout.toDebugHex(components) + ": complex slices require exactly two extra components");
                }
                LegacyLayout.decodeBoundLookupComplexColumn(metadata, components, clusteringSize, isStatic);
                components.remove(clusteringSize + 1);
            } else if (isDeletion) {
                collectionName = LegacyLayout.decodeBoundLookupComplexColumn(metadata, components, clusteringSize, isStatic);
            } else if (components.get(clusteringSize).hasRemaining()) {
                LegacyLayout.decodeBoundVerifySimpleColumn(metadata, components, clusteringSize, isStatic);
            }
            components.remove(clusteringSize);
        }
        if (isStart) {
            isInclusive = eoc <= 0;
        } else {
            boolean bl = isInclusive = eoc >= 0;
            if (eoc == 0 && components.size() < clusteringSize) {
                components.add(ByteBufferUtil.EMPTY_BYTE_BUFFER);
                isInclusive = false;
            }
        }
        ClusteringPrefix.Kind boundKind = ClusteringBound.boundKind(isStart, isInclusive);
        ClusteringBound cb = ClusteringBound.create(boundKind, components.toArray(new ByteBuffer[components.size()]));
        return new LegacyBound(cb, isStatic, collectionName);
    }

    private static ColumnDefinition decodeBoundLookupComplexColumn(CFMetaData metadata, List<ByteBuffer> components, int clusteringSize, boolean isStatic) {
        ByteBuffer columnNameBytes = components.get(clusteringSize);
        ColumnDefinition columnName = metadata.getColumnDefinition(columnNameBytes);
        if (columnName == null || !columnName.isComplex()) {
            columnName = metadata.getDroppedColumnDefinition(columnNameBytes, isStatic);
            if (columnName == null) {
                throw new IllegalArgumentException("Invalid bound " + LegacyLayout.toDebugHex(components) + ": expected complex column at position " + clusteringSize);
            }
            if (!columnName.isComplex()) {
                columnName = INVALID_DROPPED_COMPLEX_SUBSTITUTE_COLUMN;
            }
        }
        return columnName;
    }

    private static void decodeBoundVerifySimpleColumn(CFMetaData metadata, List<ByteBuffer> components, int clusteringSize, boolean isStatic) {
        ByteBuffer columnNameBytes = components.get(clusteringSize);
        ColumnDefinition columnName = metadata.getColumnDefinition(columnNameBytes);
        if (!(columnName != null && columnName.isSimple() || (columnName = metadata.getDroppedColumnDefinition(columnNameBytes, isStatic)) != null)) {
            throw new IllegalArgumentException("Invalid bound " + LegacyLayout.toDebugHex(components) + ": expected simple column at position " + clusteringSize);
        }
    }

    private static String toDebugHex(Collection<ByteBuffer> buffers) {
        return buffers.stream().map(ByteBufferUtil::bytesToHex).collect(Collectors.joining());
    }

    public static ByteBuffer encodeBound(CFMetaData metadata, ClusteringBound bound, boolean isStart) {
        if (bound == ClusteringBound.BOTTOM || bound == ClusteringBound.TOP || metadata.comparator.size() == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ClusteringPrefix clustering = bound.clustering();
        if (!metadata.isCompound()) {
            assert (clustering.size() == 1);
            return clustering.get(0);
        }
        CompositeType ctype = CompositeType.getInstance(metadata.comparator.subtypes());
        CompositeType.Builder builder = ctype.builder();
        for (int i = 0; i < clustering.size(); ++i) {
            builder.add(clustering.get(i));
        }
        if (isStart) {
            return bound.isInclusive() ? builder.build() : builder.buildAsEndOfRange();
        }
        return bound.isInclusive() ? builder.buildAsEndOfRange() : builder.build();
    }

    public static ByteBuffer encodeCellName(CFMetaData metadata, ClusteringPrefix clustering, ByteBuffer columnName, ByteBuffer collectionElement) {
        boolean isStatic;
        boolean bl = isStatic = clustering == Clustering.STATIC_CLUSTERING;
        if (!metadata.isCompound()) {
            if (isStatic) {
                return columnName;
            }
            assert (clustering.size() == 1) : "Expected clustering size to be 1, but was " + clustering.size();
            return clustering.get(0);
        }
        int clusteringSize = metadata.comparator.size();
        int size = clusteringSize + (metadata.isDense() ? 0 : 1) + (collectionElement == null ? 0 : 1);
        if (metadata.isSuper()) {
            size = clusteringSize + 1;
        }
        ByteBuffer[] values = new ByteBuffer[size];
        for (int i = 0; i < clusteringSize; ++i) {
            if (isStatic) {
                values[i] = ByteBufferUtil.EMPTY_BYTE_BUFFER;
                continue;
            }
            ByteBuffer v = clustering.get(i);
            if (v == null) {
                return CompositeType.build(Arrays.copyOfRange(values, 0, i));
            }
            values[i] = v;
        }
        if (metadata.isSuper()) {
            assert (columnName != null);
            values[clusteringSize] = columnName.equals(SuperColumnCompatibility.SUPER_COLUMN_MAP_COLUMN) ? collectionElement : columnName;
        } else {
            if (!metadata.isDense()) {
                values[clusteringSize] = columnName;
            }
            if (collectionElement != null) {
                values[clusteringSize + 1] = collectionElement;
            }
        }
        return CompositeType.build(isStatic, values);
    }

    public static Clustering decodeClustering(CFMetaData metadata, ByteBuffer value) {
        int csize = metadata.comparator.size();
        if (csize == 0) {
            return Clustering.EMPTY;
        }
        if (metadata.isCompound() && CompositeType.isStaticName(value)) {
            return Clustering.STATIC_CLUSTERING;
        }
        List<ByteBuffer> components = metadata.isCompound() ? CompositeType.splitName(value) : Collections.singletonList(value);
        for (int i = 0; i < Math.min(csize, components.size()); ++i) {
            AbstractType<?> type = metadata.comparator.subtype(i);
            type.validateIfFixedSize(components.get(i));
        }
        return Clustering.make(components.subList(0, Math.min(csize, components.size())).toArray(new ByteBuffer[csize]));
    }

    public static ByteBuffer encodeClustering(CFMetaData metadata, ClusteringPrefix clustering) {
        if (clustering.size() == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (!metadata.isCompound()) {
            assert (clustering.size() == 1);
            return clustering.get(0);
        }
        ByteBuffer[] values = new ByteBuffer[clustering.size()];
        for (int i = 0; i < clustering.size(); ++i) {
            values[i] = clustering.get(i);
        }
        return CompositeType.build(values);
    }

    private static int maxLiveCellsPerPartition(ReadCommand command) {
        if (command == null) {
            return Integer.MAX_VALUE;
        }
        DataLimits limits = command.limits();
        if (limits.isDistinct()) {
            return command.columnFilter().fetchedColumns().statics.isEmpty() ? 1 : Integer.MAX_VALUE;
        }
        switch (limits.kind()) {
            case THRIFT_LIMIT: 
            case SUPER_COLUMN_COUNTING_LIMIT: {
                return limits.perPartitionCount();
            }
        }
        return Integer.MAX_VALUE;
    }

    public static LegacyUnfilteredPartition fromUnfilteredRowIterator(ReadCommand command, UnfilteredRowIterator iterator) {
        ImmutableBTreePartition partition = ImmutableBTreePartition.create(iterator);
        DeletionInfo info = partition.deletionInfo();
        Pair<LegacyRangeTombstoneList, Iterator<LegacyCell>> pair = LegacyLayout.fromRowIterator(partition.metadata(), partition.iterator(), partition.staticRow());
        LegacyRangeTombstoneList rtl = (LegacyRangeTombstoneList)pair.left;
        List<Object> cells = Lists.newArrayList((Iterator)((Iterator)pair.right));
        int maxCellsPerPartition = LegacyLayout.maxLiveCellsPerPartition(command);
        cells = LegacyLayout.maybeTrimLiveCells(cells, maxCellsPerPartition, command);
        if (info.hasRanges()) {
            Iterator<RangeTombstone> rangeTombstoneIterator = info.rangeIterator(false);
            while (rangeTombstoneIterator.hasNext()) {
                RangeTombstone rt = rangeTombstoneIterator.next();
                Slice slice = rt.deletedSlice();
                LegacyBound start = new LegacyBound(slice.start(), false, null);
                LegacyBound end = new LegacyBound(slice.end(), false, null);
                rtl.add(start, end, rt.deletionTime().markedForDeleteAt(), rt.deletionTime().localDeletionTime());
            }
        }
        return new LegacyUnfilteredPartition(info.getPartitionDeletion(), rtl, cells);
    }

    private static List<LegacyCell> maybeTrimLiveCells(List<LegacyCell> cells, int maxLiveCells, ReadCommand command) {
        if (null == command || maxLiveCells >= cells.size()) {
            return cells;
        }
        int nowInSec = command.nowInSec();
        int live = 0;
        int dead = 0;
        for (int i = 0; i < cells.size() && live < maxLiveCells; ++i) {
            if (cells.get(i).isLive(nowInSec)) {
                ++live;
                continue;
            }
            ++dead;
        }
        return cells.subList(0, live + dead);
    }

    public static void serializeAsLegacyPartition(ReadCommand command, UnfilteredRowIterator partition, DataOutputPlus out, int version) throws IOException {
        assert (version < 10);
        out.writeBoolean(true);
        LegacyUnfilteredPartition legacyPartition = LegacyLayout.fromUnfilteredRowIterator(command, partition);
        UUIDSerializer.serializer.serialize(partition.metadata().cfId, out, version);
        DeletionTime.serializer.serialize(legacyPartition.partitionDeletion, out);
        legacyPartition.rangeTombstones.serialize(out, partition.metadata());
        out.writeInt(legacyPartition.cells.size());
        for (LegacyCell cell : legacyPartition.cells) {
            ByteBufferUtil.writeWithShortLength(cell.name.encode(partition.metadata()), out);
            out.writeByte(cell.serializationFlags());
            if (cell.isExpiring()) {
                out.writeInt(cell.ttl);
                out.writeInt(cell.localDeletionTime);
            } else {
                if (cell.isTombstone()) {
                    out.writeLong(cell.timestamp);
                    out.writeInt(TypeSizes.sizeof(cell.localDeletionTime));
                    out.writeInt(cell.localDeletionTime);
                    continue;
                }
                if (cell.isCounterUpdate()) {
                    out.writeLong(cell.timestamp);
                    long count = CounterContext.instance().getUpdateCount(cell.value);
                    ByteBufferUtil.writeWithLength(ByteBufferUtil.bytes(count), out);
                    continue;
                }
                if (cell.isCounter()) {
                    out.writeLong(Long.MIN_VALUE);
                }
            }
            out.writeLong(cell.timestamp);
            ByteBufferUtil.writeWithLength(cell.value, out);
        }
    }

    public static UnfilteredRowIterator deserializeLegacyPartition(DataInputPlus in, int version, SerializationHelper.Flag flag, ByteBuffer key) throws IOException {
        assert (version < 10);
        boolean present = in.readBoolean();
        if (!present) {
            return null;
        }
        CFMetaData metadata = CFMetaData.serializer.deserialize(in, version);
        LegacyDeletionInfo info = LegacyDeletionInfo.deserialize(metadata, in);
        int size = in.readInt();
        Iterator<LegacyCell> cells = LegacyLayout.deserializeCells(metadata, in, flag, size);
        SerializationHelper helper = new SerializationHelper(metadata, version, flag);
        return LegacyLayout.onWireCellstoUnfilteredRowIterator(metadata, metadata.partitioner.decorateKey(key), info, cells, false, helper);
    }

    public static long serializedSizeAsLegacyPartition(ReadCommand command, UnfilteredRowIterator partition, int version) {
        assert (version < 10);
        if (partition.isEmpty()) {
            return TypeSizes.sizeof(false);
        }
        long size = TypeSizes.sizeof(true);
        LegacyUnfilteredPartition legacyPartition = LegacyLayout.fromUnfilteredRowIterator(command, partition);
        size += UUIDSerializer.serializer.serializedSize(partition.metadata().cfId, version);
        size += DeletionTime.serializer.serializedSize(legacyPartition.partitionDeletion);
        size += legacyPartition.rangeTombstones.serializedSize(partition.metadata());
        size += (long)TypeSizes.sizeof(legacyPartition.cells.size());
        for (LegacyCell cell : legacyPartition.cells) {
            size += (long)ByteBufferUtil.serializedSizeWithShortLength(cell.name.encode(partition.metadata()));
            ++size;
            if (cell.isExpiring()) {
                size += (long)TypeSizes.sizeof(cell.ttl);
                size += (long)TypeSizes.sizeof(cell.localDeletionTime);
            } else {
                if (cell.isTombstone()) {
                    size += (long)TypeSizes.sizeof(cell.timestamp);
                    size += (long)TypeSizes.sizeof(TypeSizes.sizeof(cell.localDeletionTime));
                    size += (long)TypeSizes.sizeof(cell.localDeletionTime);
                    continue;
                }
                if (cell.isCounterUpdate()) {
                    size += (long)TypeSizes.sizeof(cell.timestamp);
                    long count = CounterContext.instance().getUpdateCount(cell.value);
                    size += (long)ByteBufferUtil.serializedSizeWithLength(ByteBufferUtil.bytes(count));
                    continue;
                }
                if (cell.isCounter()) {
                    size += (long)TypeSizes.sizeof(Long.MIN_VALUE);
                }
            }
            size += (long)TypeSizes.sizeof(cell.timestamp);
            size += (long)ByteBufferUtil.serializedSizeWithLength(cell.value);
        }
        return size;
    }

    public static UnfilteredRowIterator toUnfilteredRowIterator(CFMetaData metadata, DecoratedKey key, LegacyDeletionInfo delInfo, Iterator<LegacyCell> cells) {
        SerializationHelper helper = new SerializationHelper(metadata, 0, SerializationHelper.Flag.LOCAL);
        return LegacyLayout.toUnfilteredRowIterator(metadata, key, delInfo, cells, false, helper);
    }

    public static UnfilteredRowIterator onWireCellstoUnfilteredRowIterator(CFMetaData metadata, DecoratedKey key, LegacyDeletionInfo delInfo, Iterator<LegacyCell> cells, boolean reversed, SerializationHelper helper) {
        if (metadata.isStaticCompactTable() || reversed) {
            ArrayList l = new ArrayList();
            Iterators.addAll(l, cells);
            Collections.sort(l, LegacyLayout.legacyCellComparator(metadata, reversed));
            cells = l.iterator();
        }
        return LegacyLayout.toUnfilteredRowIterator(metadata, key, delInfo, cells, reversed, helper);
    }

    private static UnfilteredRowIterator toUnfilteredRowIterator(CFMetaData metadata, DecoratedKey key, LegacyDeletionInfo delInfo, Iterator<LegacyCell> cells, boolean reversed, SerializationHelper helper) {
        MergeIterator.Reducer<LegacyAtom, LegacyAtom> reducer = new MergeIterator.Reducer<LegacyAtom, LegacyAtom>(){
            private LegacyAtom atom;

            @Override
            public void reduce(int idx, LegacyAtom current) {
                assert (this.atom == null);
                this.atom = current;
            }

            @Override
            protected LegacyAtom getReduced() {
                return this.atom;
            }

            @Override
            protected void onKeyChange() {
                this.atom = null;
            }
        };
        List<Iterator> iterators = Arrays.asList(LegacyLayout.asLegacyAtomIterator(cells), LegacyLayout.asLegacyAtomIterator(delInfo.inRowRangeTombstones()));
        PeekingIterator atoms = Iterators.peekingIterator(MergeIterator.get(iterators, LegacyLayout.legacyAtomComparator(metadata), reducer));
        Row staticRow = atoms.hasNext() && ((LegacyAtom)atoms.peek()).isStatic() ? LegacyLayout.getNextRow(CellGrouper.staticGrouper(metadata, helper), (PeekingIterator<? extends LegacyAtom>)atoms) : Rows.EMPTY_STATIC_ROW;
        Iterator<Row> rows = LegacyLayout.convertToRows(new CellGrouper(metadata, helper), (PeekingIterator<LegacyAtom>)atoms);
        Iterator<RangeTombstone> ranges = delInfo.deletionInfo.rangeIterator(reversed);
        return new RowAndDeletionMergeIterator(metadata, key, delInfo.deletionInfo.getPartitionDeletion(), ColumnFilter.all(metadata), staticRow, reversed, EncodingStats.NO_STATS, rows, ranges, true);
    }

    public static Row extractStaticColumns(CFMetaData metadata, DataInputPlus in, Columns statics) throws IOException {
        LegacyAtom atom;
        assert (!statics.isEmpty());
        assert (metadata.isCompactTable());
        if (metadata.isSuper()) {
            throw new UnsupportedOperationException();
        }
        HashSet<ByteBuffer> columnsToFetch = new HashSet<ByteBuffer>(statics.size());
        for (ColumnDefinition column : statics) {
            columnsToFetch.add(column.name.bytes);
        }
        Row.Builder builder = BTreeRow.unsortedBuilder(FBUtilities.nowInSeconds());
        builder.newRow(Clustering.STATIC_CLUSTERING);
        boolean foundOne = false;
        while ((atom = LegacyLayout.readLegacyAtomSkippingUnknownColumn(metadata, in)) != null) {
            if (atom.isCell()) {
                LegacyCell cell = atom.asCell();
                if (!columnsToFetch.contains(cell.name.encode(metadata))) continue;
                foundOne = true;
                cell.name.column.type.validateIfFixedSize(cell.value);
                builder.addCell(new BufferCell(cell.name.column, cell.timestamp, cell.ttl, cell.localDeletionTime, cell.value, null));
                continue;
            }
            LegacyRangeTombstone tombstone = atom.asRangeTombstone();
            throw new UnsupportedOperationException();
        }
        return foundOne ? builder.build() : Rows.EMPTY_STATIC_ROW;
    }

    private static LegacyAtom readLegacyAtomSkippingUnknownColumn(CFMetaData metadata, DataInputPlus in) throws IOException {
        while (true) {
            try {
                return LegacyLayout.readLegacyAtom(metadata, in, false);
            }
            catch (UnknownColumnException unknownColumnException) {
                continue;
            }
            break;
        }
    }

    private static Row getNextRow(CellGrouper grouper, PeekingIterator<? extends LegacyAtom> cells) {
        if (!cells.hasNext()) {
            return null;
        }
        grouper.reset();
        while (cells.hasNext() && grouper.addAtom((LegacyAtom)cells.peek())) {
            cells.next();
        }
        return grouper.getRow();
    }

    private static Iterator<LegacyAtom> asLegacyAtomIterator(Iterator<? extends LegacyAtom> iter) {
        return iter;
    }

    private static Iterator<Row> convertToRows(final CellGrouper grouper, final PeekingIterator<LegacyAtom> atoms) {
        return new AbstractIterator<Row>(){

            @Override
            protected Row computeNext() {
                if (!atoms.hasNext()) {
                    return (Row)this.endOfData();
                }
                return LegacyLayout.getNextRow(grouper, (PeekingIterator<? extends LegacyAtom>)atoms);
            }
        };
    }

    public static Pair<LegacyRangeTombstoneList, Iterator<LegacyCell>> fromRowIterator(RowIterator iterator) {
        return LegacyLayout.fromRowIterator(iterator.metadata(), iterator, iterator.staticRow());
    }

    private static Pair<LegacyRangeTombstoneList, Iterator<LegacyCell>> fromRowIterator(final CFMetaData metadata, final Iterator<Row> iterator, final Row staticRow) {
        final LegacyRangeTombstoneList deletions = new LegacyRangeTombstoneList(new LegacyBoundComparator(metadata.comparator), 10);
        AbstractIterator<LegacyCell> cells = new AbstractIterator<LegacyCell>(){
            private Iterator<LegacyCell> currentRow = this.initializeRow();

            private Iterator<LegacyCell> initializeRow() {
                if (staticRow == null || staticRow.isEmpty()) {
                    return Collections.emptyIterator();
                }
                Pair row = LegacyLayout.fromRow(metadata, staticRow);
                deletions.addAll((LegacyRangeTombstoneList)row.left);
                return (Iterator)row.right;
            }

            @Override
            protected LegacyCell computeNext() {
                while (!this.currentRow.hasNext()) {
                    if (!iterator.hasNext()) {
                        return (LegacyCell)this.endOfData();
                    }
                    Pair row = LegacyLayout.fromRow(metadata, (Row)iterator.next());
                    deletions.addAll((LegacyRangeTombstoneList)row.left);
                    this.currentRow = (Iterator)row.right;
                }
                return this.currentRow.next();
            }
        };
        return Pair.create(deletions, cells);
    }

    private static Pair<LegacyRangeTombstoneList, Iterator<LegacyCell>> fromRow(final CFMetaData metadata, final Row row) {
        LegacyRangeTombstoneList deletions = new LegacyRangeTombstoneList(new LegacyBoundComparator(metadata.comparator), 10);
        if (!row.deletion().isLive()) {
            Clustering clustering = row.clustering();
            ClusteringBound startBound = ClusteringBound.inclusiveStartOf(clustering);
            ClusteringBound endBound = ClusteringBound.inclusiveEndOf(clustering);
            LegacyBound start = new LegacyBound(startBound, false, null);
            LegacyBound end = new LegacyBound(endBound, false, null);
            deletions.add(start, end, row.deletion().time().markedForDeleteAt(), row.deletion().time().localDeletionTime());
        }
        for (ColumnData cd : row) {
            boolean isStatic;
            DeletionTime delTime;
            ColumnDefinition col = cd.column();
            if (col.isSimple() || (delTime = ((ComplexColumnData)cd).complexDeletion()).isLive()) continue;
            Clustering clustering = row.clustering();
            boolean bl = isStatic = clustering == Clustering.STATIC_CLUSTERING;
            assert (isStatic == col.isStatic());
            ClusteringBound startBound = isStatic ? LegacyDeletionInfo.staticBound(metadata, true) : ClusteringBound.inclusiveStartOf(clustering);
            ClusteringBound endBound = isStatic ? LegacyDeletionInfo.staticBound(metadata, false) : ClusteringBound.inclusiveEndOf(clustering);
            LegacyBound start = new LegacyBound(startBound, isStatic, col);
            LegacyBound end = new LegacyBound(endBound, isStatic, col);
            deletions.add(start, end, delTime.markedForDeleteAt(), delTime.localDeletionTime());
        }
        AbstractIterator<LegacyCell> cells = new AbstractIterator<LegacyCell>(){
            private final Iterator<Cell> cells;
            private boolean hasReturnedRowMarker;
            {
                this.cells = row.cellsInLegacyOrder(metadata, false).iterator();
                this.hasReturnedRowMarker = metadata.isCompactTable();
            }

            @Override
            protected LegacyCell computeNext() {
                if (!this.hasReturnedRowMarker) {
                    this.hasReturnedRowMarker = true;
                    if (!row.primaryKeyLivenessInfo().isEmpty()) {
                        LegacyCellName cellName = new LegacyCellName(row.clustering(), null, null);
                        LivenessInfo info = row.primaryKeyLivenessInfo();
                        return new LegacyCell(info.isExpiring() ? LegacyCell.Kind.EXPIRING : LegacyCell.Kind.REGULAR, cellName, ByteBufferUtil.EMPTY_BYTE_BUFFER, info.timestamp(), info.localExpirationTime(), info.ttl());
                    }
                }
                if (!this.cells.hasNext()) {
                    return (LegacyCell)this.endOfData();
                }
                return LegacyLayout.makeLegacyCell(row.clustering(), this.cells.next());
            }
        };
        return Pair.create(deletions, cells);
    }

    private static LegacyCell makeLegacyCell(Clustering clustering, Cell cell) {
        LegacyCell.Kind kind = cell.isCounterCell() ? LegacyCell.Kind.COUNTER : (cell.isTombstone() ? LegacyCell.Kind.DELETED : (cell.isExpiring() ? LegacyCell.Kind.EXPIRING : LegacyCell.Kind.REGULAR));
        CellPath path = cell.path();
        assert (path == null || path.size() == 1);
        LegacyCellName name = new LegacyCellName(clustering, cell.column(), path == null ? null : path.get(0));
        return new LegacyCell(kind, name, cell.value(), cell.timestamp(), cell.localDeletionTime(), cell.ttl());
    }

    public static RowIterator toRowIterator(CFMetaData metadata, DecoratedKey key, Iterator<LegacyCell> cells, int nowInSec) {
        SerializationHelper helper = new SerializationHelper(metadata, 0, SerializationHelper.Flag.LOCAL);
        return UnfilteredRowIterators.filter(LegacyLayout.toUnfilteredRowIterator(metadata, key, LegacyDeletionInfo.live(), cells, false, helper), nowInSec);
    }

    public static Comparator<LegacyCell> legacyCellComparator(CFMetaData metadata) {
        return LegacyLayout.legacyCellComparator(metadata, false);
    }

    public static Comparator<LegacyCell> legacyCellComparator(CFMetaData metadata, boolean reversed) {
        final Comparator<LegacyCellName> cellNameComparator = LegacyLayout.legacyCellNameComparator(metadata, reversed);
        return new Comparator<LegacyCell>(){

            @Override
            public int compare(LegacyCell cell1, LegacyCell cell2) {
                LegacyCellName c1 = cell1.name;
                LegacyCellName c2 = cell2.name;
                int c = cellNameComparator.compare(c1, c2);
                if (c != 0) {
                    return c;
                }
                if (cell1.timestamp != cell2.timestamp) {
                    return cell1.timestamp < cell2.timestamp ? -1 : 1;
                }
                if (cell1.localDeletionTime != cell2.localDeletionTime) {
                    return cell1.localDeletionTime < cell2.localDeletionTime ? -1 : 1;
                }
                return cell1.value.compareTo(cell2.value);
            }
        };
    }

    public static Comparator<LegacyCellName> legacyCellNameComparator(final CFMetaData metadata, final boolean reversed) {
        return new Comparator<LegacyCellName>(){

            @Override
            public int compare(LegacyCellName c1, LegacyCellName c2) {
                if (c1.clustering == Clustering.STATIC_CLUSTERING) {
                    if (c2.clustering != Clustering.STATIC_CLUSTERING) {
                        return -1;
                    }
                } else {
                    if (c2.clustering == Clustering.STATIC_CLUSTERING) {
                        return 1;
                    }
                    int c = metadata.comparator.compare(c1.clustering, c2.clustering);
                    if (c != 0) {
                        return reversed ? -c : c;
                    }
                }
                if (c1.column != c2.column) {
                    if (c1.column == null) {
                        return -1;
                    }
                    if (c2.column == null) {
                        return 1;
                    }
                    assert (c1.column.isRegular() || c1.column.isStatic());
                    assert (c2.column.isRegular() || c2.column.isStatic());
                    int cmp = c1.column.compareTo(c2.column);
                    if (cmp != 0) {
                        return cmp;
                    }
                }
                assert (c1.collectionElement == null == (c2.collectionElement == null));
                if (c1.collectionElement != null) {
                    AbstractType<?> colCmp = ((CollectionType)c1.column.type).nameComparator();
                    return colCmp.compare(c1.collectionElement, c2.collectionElement);
                }
                return 0;
            }
        };
    }

    private static boolean equalValues(ClusteringPrefix c1, ClusteringPrefix c2, ClusteringComparator comparator) {
        assert (c1.size() == c2.size());
        for (int i = 0; i < c1.size(); ++i) {
            if (comparator.compareComponent(i, c1.get(i), c2.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    static Comparator<LegacyAtom> legacyAtomComparator(CFMetaData metadata) {
        return (o1, o2) -> {
            int clusteringComparison;
            if (o1.isStatic() != o2.isStatic()) {
                return o1.isStatic() ? -1 : 1;
            }
            ClusteringPrefix c1 = o1.clustering();
            ClusteringPrefix c2 = o2.clustering();
            if (c1.size() != c2.size() || o1.isCell() == o2.isCell() || !LegacyLayout.equalValues(c1, c2, metadata.comparator)) {
                clusteringComparison = metadata.comparator.compare(c1, c2);
            } else {
                LegacyRangeTombstone rt = o1.isCell() ? o2.asRangeTombstone() : o1.asRangeTombstone();
                int n = clusteringComparison = rt.isCollectionTombstone() ? 0 : metadata.comparator.compare(c1, c2);
            }
            if (clusteringComparison != 0) {
                return clusteringComparison;
            }
            if (o1.isCell()) {
                LegacyCell cell1 = o1.asCell();
                if (o2.isCell()) {
                    LegacyCell cell2 = o2.asCell();
                    if (cell1.name.column == null) {
                        return cell2.name.column == null ? 0 : -1;
                    }
                    return cell2.name.column == null ? 1 : cell1.name.column.compareTo(cell2.name.column);
                }
                LegacyRangeTombstone rt2 = o2.asRangeTombstone();
                assert (rt2.isCollectionTombstone());
                if (cell1.name.column == null) {
                    return -1;
                }
                int cmp = cell1.name.column.compareTo(rt2.start.collectionName);
                return cmp == 0 ? 1 : cmp;
            }
            assert (o2.isCell());
            LegacyCell cell2 = o2.asCell();
            LegacyRangeTombstone rt1 = o1.asRangeTombstone();
            assert (rt1.isCollectionTombstone());
            if (cell2.name.column == null) {
                return 1;
            }
            int cmp = rt1.start.collectionName.compareTo(cell2.name.column);
            return cmp == 0 ? -1 : cmp;
        };
    }

    public static LegacyAtom readLegacyAtom(CFMetaData metadata, DataInputPlus in, boolean readAllAsDynamic) throws IOException, UnknownColumnException {
        ByteBuffer cellname = ByteBufferUtil.readWithShortLength(in);
        if (!cellname.hasRemaining()) {
            return null;
        }
        try {
            int b = in.readUnsignedByte();
            return (b & 0x10) != 0 ? LegacyLayout.readLegacyRangeTombstoneBody(metadata, in, cellname) : LegacyLayout.readLegacyCellBody(metadata, in, cellname, b, SerializationHelper.Flag.LOCAL, readAllAsDynamic);
        }
        catch (UnknownColumnException e) {
            if (!metadata.ksName.equals("system") && metadata.getDroppedColumnDefinition(e.columnName) == null) {
                logger.warn(String.format("Got cell for unknown column %s in sstable of %s.%s: This suggest a problem with the schema which doesn't list this column. Even if that column was dropped, it should have been listed as such", metadata.ksName, metadata.cfName, UTF8Type.instance.compose(e.columnName)), (Throwable)e);
            }
            throw e;
        }
    }

    public static LegacyCell readLegacyCell(CFMetaData metadata, DataInput in, SerializationHelper.Flag flag) throws IOException, UnknownColumnException {
        ByteBuffer cellname = ByteBufferUtil.readWithShortLength(in);
        int b = in.readUnsignedByte();
        return LegacyLayout.readLegacyCellBody(metadata, in, cellname, b, flag, false);
    }

    public static LegacyCell readLegacyCellBody(CFMetaData metadata, DataInput in, ByteBuffer cellname, int mask, SerializationHelper.Flag flag, boolean readAllAsDynamic) throws IOException, UnknownColumnException {
        if ((mask & 4) != 0) {
            in.readLong();
            long ts = in.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(in);
            if (flag == SerializationHelper.Flag.FROM_REMOTE || flag == SerializationHelper.Flag.LOCAL && CounterContext.instance().shouldClearLocal(value)) {
                value = CounterContext.instance().clearAllLocal(value);
            }
            return new LegacyCell(LegacyCell.Kind.COUNTER, LegacyLayout.decodeCellName(metadata, cellname, readAllAsDynamic), value, ts, Integer.MAX_VALUE, 0);
        }
        if ((mask & 2) != 0) {
            int ttl = in.readInt();
            int expiration = in.readInt();
            long ts = in.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(in);
            return new LegacyCell(LegacyCell.Kind.EXPIRING, LegacyLayout.decodeCellName(metadata, cellname, readAllAsDynamic), value, ts, expiration, ttl);
        }
        long ts = in.readLong();
        ByteBuffer value = ByteBufferUtil.readWithLength(in);
        LegacyCellName name = LegacyLayout.decodeCellName(metadata, cellname, readAllAsDynamic);
        return (mask & 8) != 0 ? new LegacyCell(LegacyCell.Kind.COUNTER, name, CounterContext.instance().createUpdate(ByteBufferUtil.toLong(value)), ts, Integer.MAX_VALUE, 0) : ((mask & 1) == 0 ? new LegacyCell(LegacyCell.Kind.REGULAR, name, value, ts, Integer.MAX_VALUE, 0) : new LegacyCell(LegacyCell.Kind.DELETED, name, ByteBufferUtil.EMPTY_BYTE_BUFFER, ts, ByteBufferUtil.toInt(value), 0));
    }

    public static LegacyRangeTombstone readLegacyRangeTombstoneBody(CFMetaData metadata, DataInputPlus in, ByteBuffer boundname) throws IOException {
        LegacyBound min = LegacyLayout.decodeTombstoneBound(metadata, boundname, true);
        LegacyBound max = LegacyLayout.decodeTombstoneBound(metadata, ByteBufferUtil.readWithShortLength(in), false);
        DeletionTime dt = DeletionTime.serializer.deserialize(in);
        return new LegacyRangeTombstone(min, max, dt);
    }

    public static Iterator<LegacyCell> deserializeCells(final CFMetaData metadata, final DataInput in, final SerializationHelper.Flag flag, final int size) {
        return new AbstractIterator<LegacyCell>(){
            private int i = 0;

            @Override
            protected LegacyCell computeNext() {
                if (this.i >= size) {
                    return (LegacyCell)this.endOfData();
                }
                ++this.i;
                try {
                    return LegacyLayout.readLegacyCell(metadata, in, flag);
                }
                catch (UnknownColumnException e) {
                    if (metadata.ksName.equals("system") || metadata.getDroppedColumnDefinition(e.columnName) != null) {
                        return this.computeNext();
                    }
                    throw new IOError(e);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        };
    }

    public static class LegacyRangeTombstoneList {
        private final LegacyBoundComparator comparator;
        LegacyBound[] starts;
        LegacyBound[] ends;
        private long[] markedAts;
        private int[] delTimes;
        private int size;

        private LegacyRangeTombstoneList(LegacyBoundComparator comparator, LegacyBound[] starts, LegacyBound[] ends, long[] markedAts, int[] delTimes, int size) {
            assert (starts.length == ends.length && starts.length == markedAts.length && starts.length == delTimes.length);
            this.comparator = comparator;
            this.starts = starts;
            this.ends = ends;
            this.markedAts = markedAts;
            this.delTimes = delTimes;
            this.size = size;
        }

        public LegacyRangeTombstoneList(LegacyBoundComparator comparator, int capacity) {
            this(comparator, new LegacyBound[capacity], new LegacyBound[capacity], new long[capacity], new int[capacity], 0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < this.size; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('(').append(this.starts[i]).append(", ").append(this.ends[i]).append(')');
            }
            return sb.append(']').toString();
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        public void add(LegacyBound start, LegacyBound end, long markedAt, int delTime) {
            if (this.isEmpty()) {
                this.addInternal(0, start, end, markedAt, delTime);
                return;
            }
            int c = this.comparator.compare(this.ends[this.size - 1], start);
            if (c <= 0) {
                this.addInternal(this.size, start, end, markedAt, delTime);
            } else {
                int pos = Arrays.binarySearch(this.ends, 0, this.size, start, this.comparator);
                this.insertFrom(pos >= 0 ? pos : -pos - 1, start, end, markedAt, delTime);
            }
        }

        public void addAll(LegacyRangeTombstoneList tombstones) {
            if (tombstones.isEmpty()) {
                return;
            }
            if (this.isEmpty()) {
                LegacyRangeTombstoneList.copyArrays(tombstones, this);
                return;
            }
            if (this.size > 10 * tombstones.size) {
                for (int i = 0; i < tombstones.size; ++i) {
                    this.add(tombstones.starts[i], tombstones.ends[i], tombstones.markedAts[i], tombstones.delTimes[i]);
                }
            } else {
                int i = 0;
                int j = 0;
                while (i < this.size && j < tombstones.size) {
                    if (this.comparator.compare(tombstones.starts[j], this.ends[i]) <= 0) {
                        this.insertFrom(i, tombstones.starts[j], tombstones.ends[j], tombstones.markedAts[j], tombstones.delTimes[j]);
                        ++j;
                        continue;
                    }
                    ++i;
                }
                while (j < tombstones.size) {
                    this.addInternal(this.size, tombstones.starts[j], tombstones.ends[j], tombstones.markedAts[j], tombstones.delTimes[j]);
                    ++j;
                }
            }
        }

        private static void copyArrays(LegacyRangeTombstoneList src, LegacyRangeTombstoneList dst) {
            dst.grow(src.size);
            System.arraycopy(src.starts, 0, dst.starts, 0, src.size);
            System.arraycopy(src.ends, 0, dst.ends, 0, src.size);
            System.arraycopy(src.markedAts, 0, dst.markedAts, 0, src.size);
            System.arraycopy(src.delTimes, 0, dst.delTimes, 0, src.size);
            dst.size = src.size;
        }

        private void insertFrom(int i, LegacyBound start, LegacyBound end, long markedAt, int delTime) {
            while (i < this.size) {
                assert (i == 0 || this.comparator.compare(this.ends[i - 1], start) <= 0);
                int c = this.comparator.compare(start, this.ends[i]);
                assert (c <= 0);
                if (c == 0) {
                    if (this.comparator.compare(this.starts[i], this.ends[i]) == 0) {
                        if (markedAt > this.markedAts[i]) {
                            this.removeInternal(i);
                            continue;
                        }
                        if (this.comparator.compare(start, end) == 0) {
                            return;
                        }
                    }
                    ++i;
                    continue;
                }
                if (markedAt > this.markedAts[i]) {
                    int endCmp;
                    if (this.comparator.compare(this.starts[i], start) < 0) {
                        this.addInternal(i, this.starts[i], start, this.markedAts[i], this.delTimes[i]);
                        ++i;
                    }
                    if ((endCmp = this.comparator.compare(end, this.starts[i])) <= 0) {
                        if (endCmp == 0 && this.comparator.compare(this.starts[i], this.ends[i]) == 0) {
                            this.setInternal(i, start, end, markedAt, delTime);
                        } else {
                            this.addInternal(i, start, end, markedAt, delTime);
                        }
                        return;
                    }
                    int cmp = this.comparator.compare(this.ends[i], end);
                    if (cmp <= 0) {
                        if (i == this.size - 1) {
                            this.setInternal(i, start, end, markedAt, delTime);
                            return;
                        }
                        this.setInternal(i, start, this.ends[i], markedAt, delTime);
                        if (cmp == 0) {
                            return;
                        }
                        start = this.ends[i];
                        ++i;
                        continue;
                    }
                    this.addInternal(i, start, end, markedAt, delTime);
                    this.setInternal(++i, end, this.ends[i], this.markedAts[i], this.delTimes[i]);
                    return;
                }
                if (this.comparator.compare(start, this.starts[i]) < 0) {
                    if (this.comparator.compare(end, this.starts[i]) <= 0) {
                        this.addInternal(i, start, end, markedAt, delTime);
                        return;
                    }
                    this.addInternal(i, start, this.starts[i], markedAt, delTime);
                    ++i;
                }
                if (this.comparator.compare(end, this.ends[i]) <= 0) {
                    return;
                }
                start = this.ends[i];
                ++i;
            }
            this.addInternal(i, start, end, markedAt, delTime);
        }

        private int capacity() {
            return this.starts.length;
        }

        private void addInternal(int i, LegacyBound start, LegacyBound end, long markedAt, int delTime) {
            assert (i >= 0);
            if (this.size == this.capacity()) {
                this.growToFree(i);
            } else if (i < this.size) {
                this.moveElements(i);
            }
            this.setInternal(i, start, end, markedAt, delTime);
            ++this.size;
        }

        private void removeInternal(int i) {
            assert (i >= 0);
            System.arraycopy(this.starts, i + 1, this.starts, i, this.size - i - 1);
            System.arraycopy(this.ends, i + 1, this.ends, i, this.size - i - 1);
            System.arraycopy(this.markedAts, i + 1, this.markedAts, i, this.size - i - 1);
            System.arraycopy(this.delTimes, i + 1, this.delTimes, i, this.size - i - 1);
            --this.size;
            this.starts[this.size] = null;
            this.ends[this.size] = null;
        }

        private void growToFree(int i) {
            int newLength = this.capacity() * 3 / 2 + 1;
            this.grow(i, newLength);
        }

        private void grow(int newLength) {
            if (this.capacity() < newLength) {
                this.grow(-1, newLength);
            }
        }

        private void grow(int i, int newLength) {
            this.starts = LegacyRangeTombstoneList.grow(this.starts, this.size, newLength, i);
            this.ends = LegacyRangeTombstoneList.grow(this.ends, this.size, newLength, i);
            this.markedAts = LegacyRangeTombstoneList.grow(this.markedAts, this.size, newLength, i);
            this.delTimes = LegacyRangeTombstoneList.grow(this.delTimes, this.size, newLength, i);
        }

        private static LegacyBound[] grow(LegacyBound[] a, int size, int newLength, int i) {
            if (i < 0 || i >= size) {
                return Arrays.copyOf(a, newLength);
            }
            LegacyBound[] newA = new LegacyBound[newLength];
            System.arraycopy(a, 0, newA, 0, i);
            System.arraycopy(a, i, newA, i + 1, size - i);
            return newA;
        }

        private static long[] grow(long[] a, int size, int newLength, int i) {
            if (i < 0 || i >= size) {
                return Arrays.copyOf(a, newLength);
            }
            long[] newA = new long[newLength];
            System.arraycopy(a, 0, newA, 0, i);
            System.arraycopy(a, i, newA, i + 1, size - i);
            return newA;
        }

        private static int[] grow(int[] a, int size, int newLength, int i) {
            if (i < 0 || i >= size) {
                return Arrays.copyOf(a, newLength);
            }
            int[] newA = new int[newLength];
            System.arraycopy(a, 0, newA, 0, i);
            System.arraycopy(a, i, newA, i + 1, size - i);
            return newA;
        }

        private void moveElements(int i) {
            if (i >= this.size) {
                return;
            }
            System.arraycopy(this.starts, i, this.starts, i + 1, this.size - i);
            System.arraycopy(this.ends, i, this.ends, i + 1, this.size - i);
            System.arraycopy(this.markedAts, i, this.markedAts, i + 1, this.size - i);
            System.arraycopy(this.delTimes, i, this.delTimes, i + 1, this.size - i);
            this.starts[i] = null;
        }

        private void setInternal(int i, LegacyBound start, LegacyBound end, long markedAt, int delTime) {
            this.starts[i] = start;
            this.ends[i] = end;
            this.markedAts[i] = markedAt;
            this.delTimes[i] = delTime;
        }

        public void updateDigest(MessageDigest digest) {
            ByteBuffer longBuffer = ByteBuffer.allocate(8);
            for (int i = 0; i < this.size; ++i) {
                int j;
                for (j = 0; j < this.starts[i].bound.size(); ++j) {
                    digest.update(this.starts[i].bound.get(j).duplicate());
                }
                if (this.starts[i].collectionName != null) {
                    digest.update(this.starts[i].collectionName.name.bytes.duplicate());
                }
                for (j = 0; j < this.ends[i].bound.size(); ++j) {
                    digest.update(this.ends[i].bound.get(j).duplicate());
                }
                if (this.ends[i].collectionName != null) {
                    digest.update(this.ends[i].collectionName.name.bytes.duplicate());
                }
                longBuffer.putLong(0, this.markedAts[i]);
                digest.update(longBuffer.array(), 0, 8);
            }
        }

        public void serialize(DataOutputPlus out, CFMetaData metadata) throws IOException {
            out.writeInt(this.size);
            if (this.size == 0) {
                return;
            }
            if (metadata.isCompound()) {
                this.serializeCompound(out, metadata.isDense());
            } else {
                this.serializeSimple(out);
            }
        }

        private void serializeCompound(DataOutputPlus out, boolean isDense) throws IOException {
            ArrayList types = new ArrayList(this.comparator.clusteringComparator.subtypes());
            if (!isDense) {
                types.add(UTF8Type.instance);
            }
            CompositeType type = CompositeType.getInstance(types);
            for (int i = 0; i < this.size; ++i) {
                LegacyBound start = this.starts[i];
                LegacyBound end = this.ends[i];
                CompositeType.Builder startBuilder = type.builder(start.isStatic);
                CompositeType.Builder endBuilder = type.builder(end.isStatic);
                for (int j = 0; j < start.bound.clustering().size(); ++j) {
                    startBuilder.add(start.bound.get(j));
                    endBuilder.add(end.bound.get(j));
                }
                if (start.collectionName != null) {
                    startBuilder.add(start.collectionName.name.bytes);
                }
                if (end.collectionName != null) {
                    endBuilder.add(end.collectionName.name.bytes);
                }
                ByteBufferUtil.writeWithShortLength(startBuilder.build(), out);
                ByteBufferUtil.writeWithShortLength(endBuilder.buildAsEndOfRange(), out);
                out.writeInt(this.delTimes[i]);
                out.writeLong(this.markedAts[i]);
            }
        }

        private void serializeSimple(DataOutputPlus out) throws IOException {
            ArrayList types = new ArrayList(this.comparator.clusteringComparator.subtypes());
            assert (types.size() == 1) : types;
            for (int i = 0; i < this.size; ++i) {
                LegacyBound start = this.starts[i];
                LegacyBound end = this.ends[i];
                ClusteringPrefix startClustering = start.bound.clustering();
                ClusteringPrefix endClustering = end.bound.clustering();
                assert (startClustering.size() == 1);
                assert (endClustering.size() == 1);
                ByteBufferUtil.writeWithShortLength(startClustering.get(0), out);
                ByteBufferUtil.writeWithShortLength(endClustering.get(0), out);
                out.writeInt(this.delTimes[i]);
                out.writeLong(this.markedAts[i]);
            }
        }

        public long serializedSize(CFMetaData metadata) {
            long size = 0L;
            size += (long)TypeSizes.sizeof(this.size);
            if (this.size == 0) {
                return size;
            }
            if (metadata.isCompound()) {
                return size + this.serializedSizeCompound(metadata.isDense());
            }
            return size + this.serializedSizeSimple();
        }

        private long serializedSizeCompound(boolean isDense) {
            long size = 0L;
            ArrayList types = new ArrayList(this.comparator.clusteringComparator.subtypes());
            if (!isDense) {
                types.add(UTF8Type.instance);
            }
            CompositeType type = CompositeType.getInstance(types);
            for (int i = 0; i < this.size; ++i) {
                int j;
                LegacyBound start = this.starts[i];
                LegacyBound end = this.ends[i];
                CompositeType.Builder startBuilder = type.builder();
                CompositeType.Builder endBuilder = type.builder();
                for (j = 0; j < start.bound.size(); ++j) {
                    startBuilder.add(start.bound.get(j));
                }
                for (j = 0; j < end.bound.size(); ++j) {
                    endBuilder.add(end.bound.get(j));
                }
                if (start.collectionName != null) {
                    startBuilder.add(start.collectionName.name.bytes);
                }
                if (end.collectionName != null) {
                    endBuilder.add(end.collectionName.name.bytes);
                }
                size += (long)ByteBufferUtil.serializedSizeWithShortLength(startBuilder.build());
                size += (long)ByteBufferUtil.serializedSizeWithShortLength(endBuilder.buildAsEndOfRange());
                size += (long)TypeSizes.sizeof(this.delTimes[i]);
                size += (long)TypeSizes.sizeof(this.markedAts[i]);
            }
            return size;
        }

        private long serializedSizeSimple() {
            long size = 0L;
            ArrayList types = new ArrayList(this.comparator.clusteringComparator.subtypes());
            assert (types.size() == 1) : types;
            for (int i = 0; i < this.size; ++i) {
                LegacyBound start = this.starts[i];
                LegacyBound end = this.ends[i];
                ClusteringPrefix startClustering = start.bound.clustering();
                ClusteringPrefix endClustering = end.bound.clustering();
                assert (startClustering.size() == 1);
                assert (endClustering.size() == 1);
                size += (long)ByteBufferUtil.serializedSizeWithShortLength(startClustering.get(0));
                size += (long)ByteBufferUtil.serializedSizeWithShortLength(endClustering.get(0));
                size += (long)TypeSizes.sizeof(this.delTimes[i]);
                size += (long)TypeSizes.sizeof(this.markedAts[i]);
            }
            return size;
        }
    }

    private static class LegacyBoundComparator
    implements Comparator<LegacyBound> {
        ClusteringComparator clusteringComparator;

        public LegacyBoundComparator(ClusteringComparator clusteringComparator) {
            this.clusteringComparator = clusteringComparator;
        }

        @Override
        public int compare(LegacyBound a, LegacyBound b) {
            int cmp;
            if (a == LegacyBound.BOTTOM) {
                return b == LegacyBound.BOTTOM ? 0 : -1;
            }
            if (b == LegacyBound.BOTTOM) {
                return 1;
            }
            if (a.isStatic != b.isStatic) {
                return a.isStatic ? -1 : 1;
            }
            int sa = a.bound.size();
            int sb = b.bound.size();
            for (int i = 0; i < Math.min(sa, sb); ++i) {
                int cmp2 = this.clusteringComparator.compareComponent(i, a.bound.get(i), b.bound.get(i));
                if (cmp2 == 0) continue;
                return cmp2;
            }
            if (sa != sb) {
                return sa < sb ? a.bound.kind().comparedToClustering : -b.bound.kind().comparedToClustering;
            }
            if (a.collectionName == null != (b.collectionName == null)) {
                return a.collectionName == null ? -1 : 1;
            }
            if (a.collectionName != null && (cmp = UTF8Type.instance.compare(a.collectionName.name.bytes, b.collectionName.name.bytes)) != 0) {
                return cmp;
            }
            return ClusteringPrefix.Kind.compare(a.bound.kind(), b.bound.kind());
        }
    }

    public static class LegacyDeletionInfo {
        public final MutableDeletionInfo deletionInfo;
        public final List<LegacyRangeTombstone> inRowTombstones = new ArrayList<LegacyRangeTombstone>();

        private LegacyDeletionInfo(MutableDeletionInfo deletionInfo) {
            this.deletionInfo = deletionInfo;
        }

        public static LegacyDeletionInfo live() {
            return new LegacyDeletionInfo(MutableDeletionInfo.live());
        }

        public void add(DeletionTime topLevel) {
            this.deletionInfo.add(topLevel);
        }

        private static ClusteringBound staticBound(CFMetaData metadata, boolean isStart) {
            ByteBuffer[] values = new ByteBuffer[metadata.comparator.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ByteBufferUtil.EMPTY_BYTE_BUFFER;
            }
            return isStart ? ClusteringBound.inclusiveStartOf(values) : ClusteringBound.inclusiveEndOf(values);
        }

        public void add(CFMetaData metadata, LegacyRangeTombstone tombstone) {
            if (metadata.hasStaticColumns()) {
                if (tombstone.stop.isStatic) {
                    if (tombstone.start == LegacyBound.BOTTOM) {
                        tombstone = tombstone.withNewStart(new LegacyBound(LegacyDeletionInfo.staticBound(metadata, true), true, null));
                    }
                    this.inRowTombstones.add(tombstone);
                    return;
                }
                if (tombstone.start.isStatic) {
                    if (tombstone.start.bound.isInclusive()) {
                        this.inRowTombstones.add(tombstone.withNewEnd(new LegacyBound(LegacyDeletionInfo.staticBound(metadata, false), true, null)));
                    }
                    tombstone = tombstone.withNewStart(LegacyBound.BOTTOM);
                } else if (tombstone.start == LegacyBound.BOTTOM) {
                    this.inRowTombstones.add(new LegacyRangeTombstone(new LegacyBound(LegacyDeletionInfo.staticBound(metadata, true), true, null), new LegacyBound(LegacyDeletionInfo.staticBound(metadata, false), true, null), tombstone.deletionTime));
                }
            }
            if (tombstone.isCollectionTombstone() || tombstone.isRowDeletion(metadata)) {
                this.inRowTombstones.add(tombstone);
            } else {
                this.add(metadata, new RangeTombstone(Slice.make(tombstone.start.bound, tombstone.stop.bound), tombstone.deletionTime));
            }
        }

        public void add(CFMetaData metadata, RangeTombstone tombstone) {
            this.deletionInfo.add(tombstone, metadata.comparator);
        }

        public Iterator<LegacyRangeTombstone> inRowRangeTombstones() {
            return this.inRowTombstones.iterator();
        }

        public static LegacyDeletionInfo deserialize(CFMetaData metadata, DataInputPlus in) throws IOException {
            DeletionTime topLevel = DeletionTime.serializer.deserialize(in);
            int rangeCount = in.readInt();
            if (rangeCount == 0) {
                return new LegacyDeletionInfo(new MutableDeletionInfo(topLevel));
            }
            LegacyDeletionInfo delInfo = new LegacyDeletionInfo(new MutableDeletionInfo(topLevel));
            for (int i = 0; i < rangeCount; ++i) {
                LegacyBound start = LegacyLayout.decodeTombstoneBound(metadata, ByteBufferUtil.readWithShortLength(in), true);
                LegacyBound end = LegacyLayout.decodeTombstoneBound(metadata, ByteBufferUtil.readWithShortLength(in), false);
                int delTime = in.readInt();
                long markedAt = in.readLong();
                delInfo.add(metadata, new LegacyRangeTombstone(start, end, new DeletionTime(markedAt, delTime)));
            }
            return delInfo;
        }
    }

    public static class LegacyRangeTombstone
    implements LegacyAtom {
        public final LegacyBound start;
        public final LegacyBound stop;
        public final DeletionTime deletionTime;

        public LegacyRangeTombstone(LegacyBound start, LegacyBound stop, DeletionTime deletionTime) {
            if (start.collectionName == null != (stop.collectionName == null)) {
                if (start.collectionName == null) {
                    stop = new LegacyBound(ClusteringBound.inclusiveEndOf(stop.bound.values), stop.isStatic, null);
                } else {
                    start = new LegacyBound(ClusteringBound.inclusiveStartOf(start.bound.values), start.isStatic, null);
                }
            } else if (!Objects.equals(start.collectionName, stop.collectionName)) {
                start = new LegacyBound(start.bound, start.isStatic, null);
                stop = new LegacyBound(stop.bound, stop.isStatic, null);
            }
            this.start = start;
            this.stop = stop;
            this.deletionTime = deletionTime;
        }

        @Override
        public ClusteringPrefix clustering() {
            return this.start.bound;
        }

        public LegacyRangeTombstone withNewStart(LegacyBound newStart) {
            return new LegacyRangeTombstone(newStart, this.stop, this.deletionTime);
        }

        public LegacyRangeTombstone withNewStart(ClusteringBound newStart) {
            return this.withNewStart(new LegacyBound(newStart, this.start.isStatic, null));
        }

        public LegacyRangeTombstone withNewEnd(LegacyBound newStop) {
            return new LegacyRangeTombstone(this.start, newStop, this.deletionTime);
        }

        public LegacyRangeTombstone withNewEnd(ClusteringBound newEnd) {
            return this.withNewEnd(new LegacyBound(newEnd, this.stop.isStatic, null));
        }

        @Override
        public boolean isCell() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return this.start.isStatic || this.stop.isStatic;
        }

        @Override
        public LegacyCell asCell() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LegacyRangeTombstone asRangeTombstone() {
            return this;
        }

        @Override
        public boolean isRowAtom(CFMetaData metadata) {
            return this.isCollectionTombstone() || this.isRowDeletion(metadata);
        }

        public boolean isCollectionTombstone() {
            return this.start.collectionName != null;
        }

        public boolean isRowDeletion(CFMetaData metadata) {
            if (this.start.collectionName != null || this.stop.collectionName != null || this.start.bound.size() != metadata.comparator.size() || this.stop.bound.size() != metadata.comparator.size()) {
                return false;
            }
            for (int i = 0; i < this.start.bound.size(); ++i) {
                if (Objects.equals(this.start.bound.get(i), this.stop.bound.get(i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return String.format("RT(%s-%s, %s)", this.start, this.stop, this.deletionTime);
        }
    }

    public static class LegacyCell
    implements LegacyAtom {
        private static final int DELETION_MASK = 1;
        private static final int EXPIRATION_MASK = 2;
        private static final int COUNTER_MASK = 4;
        private static final int COUNTER_UPDATE_MASK = 8;
        private static final int RANGE_TOMBSTONE_MASK = 16;
        public final Kind kind;
        public final LegacyCellName name;
        public final ByteBuffer value;
        public final long timestamp;
        public final int localDeletionTime;
        public final int ttl;

        @VisibleForTesting
        public LegacyCell(Kind kind, LegacyCellName name, ByteBuffer value, long timestamp, int localDeletionTime, int ttl) {
            this.kind = kind;
            this.name = name;
            this.value = value;
            this.timestamp = timestamp;
            this.localDeletionTime = localDeletionTime;
            this.ttl = ttl;
        }

        public static LegacyCell regular(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer name, ByteBuffer value, long timestamp) throws UnknownColumnException {
            return new LegacyCell(Kind.REGULAR, LegacyLayout.decodeCellName(metadata, superColumnName, name), value, timestamp, Integer.MAX_VALUE, 0);
        }

        public static LegacyCell expiring(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer name, ByteBuffer value, long timestamp, int ttl, int nowInSec) throws UnknownColumnException {
            return new LegacyCell(Kind.EXPIRING, LegacyLayout.decodeCellName(metadata, superColumnName, name), value, timestamp, ExpirationDateOverflowHandling.computeLocalExpirationTime(nowInSec, ttl), ttl);
        }

        public static LegacyCell tombstone(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer name, long timestamp, int nowInSec) throws UnknownColumnException {
            return new LegacyCell(Kind.DELETED, LegacyLayout.decodeCellName(metadata, superColumnName, name), ByteBufferUtil.EMPTY_BYTE_BUFFER, timestamp, nowInSec, 0);
        }

        public static LegacyCell counterUpdate(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer name, long value) throws UnknownColumnException {
            ByteBuffer counterValue = CounterContext.instance().createUpdate(value);
            return LegacyCell.counter(LegacyLayout.decodeCellName(metadata, superColumnName, name), counterValue);
        }

        public static LegacyCell counter(LegacyCellName name, ByteBuffer value) {
            return new LegacyCell(Kind.COUNTER, name, value, FBUtilities.timestampMicros(), Integer.MAX_VALUE, 0);
        }

        public byte serializationFlags() {
            if (this.isExpiring()) {
                return 2;
            }
            if (this.isTombstone()) {
                return 1;
            }
            if (this.isCounterUpdate()) {
                return 8;
            }
            if (this.isCounter()) {
                return 4;
            }
            return 0;
        }

        public boolean isCounterUpdate() {
            return this.isCounter() && CounterContext.instance().isUpdate(this.value);
        }

        @Override
        public ClusteringPrefix clustering() {
            return this.name.clustering;
        }

        @Override
        public boolean isStatic() {
            return this.name.clustering == Clustering.STATIC_CLUSTERING;
        }

        @Override
        public boolean isCell() {
            return true;
        }

        @Override
        public LegacyCell asCell() {
            return this;
        }

        @Override
        public LegacyRangeTombstone asRangeTombstone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRowAtom(CFMetaData metaData) {
            return true;
        }

        public boolean isCounter() {
            return this.kind == Kind.COUNTER;
        }

        public boolean isExpiring() {
            return this.kind == Kind.EXPIRING;
        }

        public boolean isTombstone() {
            return this.kind == Kind.DELETED;
        }

        public boolean isLive(int nowInSec) {
            if (this.isTombstone()) {
                return false;
            }
            return !this.isExpiring() || nowInSec < this.localDeletionTime;
        }

        public String toString() {
            return String.format("LegacyCell(%s, name=%s, v=%s, ts=%s, ldt=%s, ttl=%s)", new Object[]{this.kind, this.name, ByteBufferUtil.bytesToHex(this.value), this.timestamp, this.localDeletionTime, this.ttl});
        }

        public static enum Kind {
            REGULAR,
            EXPIRING,
            DELETED,
            COUNTER;

        }
    }

    public static interface LegacyAtom {
        public boolean isCell();

        public ClusteringPrefix clustering();

        public boolean isStatic();

        public LegacyCell asCell();

        public LegacyRangeTombstone asRangeTombstone();

        public boolean isRowAtom(CFMetaData var1);
    }

    public static class LegacyBound {
        public static final LegacyBound BOTTOM = new LegacyBound(ClusteringBound.BOTTOM, false, null);
        public static final LegacyBound TOP = new LegacyBound(ClusteringBound.TOP, false, null);
        public final ClusteringBound bound;
        public final boolean isStatic;
        public final ColumnDefinition collectionName;

        public LegacyBound(ClusteringBound bound, boolean isStatic, ColumnDefinition collectionName) {
            this.bound = bound;
            this.isStatic = isStatic;
            this.collectionName = collectionName;
        }

        public Clustering getAsClustering(CFMetaData metadata) {
            if (this.isStatic) {
                return Clustering.STATIC_CLUSTERING;
            }
            assert (this.bound.size() == metadata.comparator.size());
            ByteBuffer[] values = new ByteBuffer[this.bound.size()];
            for (int i = 0; i < this.bound.size(); ++i) {
                values[i] = this.bound.get(i);
            }
            return Clustering.make(values);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.bound.kind()).append('(');
            for (int i = 0; i < this.bound.size(); ++i) {
                sb.append(i > 0 ? ":" : "").append(this.bound.get(i) == null ? "null" : ByteBufferUtil.bytesToHex(this.bound.get(i)));
            }
            sb.append(')');
            return String.format("Bound(%s, collection=%s)", sb.toString(), this.collectionName == null ? "null" : this.collectionName.name);
        }
    }

    public static class LegacyCellName {
        public final Clustering clustering;
        public final ColumnDefinition column;
        public final ByteBuffer collectionElement;

        @VisibleForTesting
        public LegacyCellName(Clustering clustering, ColumnDefinition column, ByteBuffer collectionElement) {
            this.clustering = clustering;
            this.column = column;
            this.collectionElement = collectionElement;
        }

        public static LegacyCellName create(Clustering clustering, ColumnDefinition column) {
            return new LegacyCellName(clustering, column, null);
        }

        public ByteBuffer encode(CFMetaData metadata) {
            return LegacyLayout.encodeCellName(metadata, this.clustering, this.column == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.column.name.bytes, this.collectionElement);
        }

        public ByteBuffer superColumnSubName() {
            assert (this.collectionElement != null);
            return this.collectionElement;
        }

        public ByteBuffer superColumnName() {
            return this.clustering.get(0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.clustering.size(); ++i) {
                sb.append(i > 0 ? ":" : "").append(this.clustering.get(i) == null ? "null" : ByteBufferUtil.bytesToHex(this.clustering.get(i)));
            }
            return String.format("Cellname(clustering=%s, column=%s, collElt=%s)", sb.toString(), this.column == null ? "null" : this.column.name, this.collectionElement == null ? "null" : ByteBufferUtil.bytesToHex(this.collectionElement));
        }
    }

    public static class LegacyUnfilteredPartition {
        public final DeletionTime partitionDeletion;
        public final LegacyRangeTombstoneList rangeTombstones;
        public final List<LegacyCell> cells;

        private LegacyUnfilteredPartition(DeletionTime partitionDeletion, LegacyRangeTombstoneList rangeTombstones, List<LegacyCell> cells) {
            this.partitionDeletion = partitionDeletion;
            this.rangeTombstones = rangeTombstones;
            this.cells = cells;
        }

        public void digest(CFMetaData metadata, MessageDigest digest) {
            for (LegacyCell cell : this.cells) {
                digest.update(cell.name.encode(metadata).duplicate());
                if (cell.isCounter()) {
                    CounterContext.instance().updateDigest(digest, cell.value);
                } else {
                    digest.update(cell.value.duplicate());
                }
                FBUtilities.updateWithLong(digest, cell.timestamp);
                FBUtilities.updateWithByte(digest, cell.serializationFlags());
                if (cell.isExpiring()) {
                    FBUtilities.updateWithInt(digest, cell.ttl);
                }
                if (!cell.isCounter()) continue;
                FBUtilities.updateWithLong(digest, Long.MIN_VALUE);
            }
            if (this.partitionDeletion.markedForDeleteAt() != Long.MIN_VALUE) {
                digest.update(ByteBufferUtil.bytes(this.partitionDeletion.markedForDeleteAt()));
            }
            if (!this.rangeTombstones.isEmpty()) {
                this.rangeTombstones.updateDigest(digest);
            }
        }
    }

    public static class CellGrouper {
        private static final int FAKE_TTL = 1;
        public final CFMetaData metadata;
        private final boolean isStatic;
        private final SerializationHelper helper;
        private final Row.Builder builder;
        private Clustering clustering;
        private LegacyRangeTombstone rowDeletion;
        private LegacyRangeTombstone collectionDeletion;
        private boolean hasValidCells = false;
        private LivenessInfo invalidLivenessInfo = null;

        public CellGrouper(CFMetaData metadata, SerializationHelper helper) {
            this(metadata, helper, false);
        }

        private CellGrouper(CFMetaData metadata, SerializationHelper helper, boolean isStatic) {
            this.metadata = metadata;
            this.isStatic = isStatic;
            this.helper = helper;
            this.builder = BTreeRow.unsortedBuilder(FBUtilities.nowInSeconds());
        }

        public static CellGrouper staticGrouper(CFMetaData metadata, SerializationHelper helper) {
            return new CellGrouper(metadata, helper, true);
        }

        public void reset() {
            this.clustering = null;
            this.rowDeletion = null;
            this.collectionDeletion = null;
            this.invalidLivenessInfo = null;
            this.hasValidCells = false;
        }

        public boolean addAtom(LegacyAtom atom) {
            assert (atom.isRowAtom(this.metadata)) : "Unexpected non in-row legacy range tombstone " + atom;
            return atom.isCell() ? this.addCell(atom.asCell()) : this.addRangeTombstone(atom.asRangeTombstone());
        }

        private boolean addCell(LegacyCell cell) {
            if (this.clustering == null) {
                this.clustering = cell.name.clustering;
                assert (!this.isStatic || this.clustering == Clustering.STATIC_CLUSTERING);
                this.builder.newRow(this.clustering);
            } else if (!this.clustering.equals(cell.name.clustering)) {
                return false;
            }
            if (this.rowDeletion != null && this.rowDeletion.deletionTime.deletes(cell.timestamp)) {
                return true;
            }
            ColumnDefinition column = cell.name.column;
            if (column == null) {
                assert (!cell.value.hasRemaining());
                if (!cell.isTombstone()) {
                    this.builder.addPrimaryKeyLivenessInfo(LivenessInfo.withExpirationTime(cell.timestamp, cell.ttl, cell.localDeletionTime));
                } else if (this.metadata.isIndex()) {
                    this.builder.addRowDeletion(Row.Deletion.regular(new DeletionTime(cell.timestamp, cell.localDeletionTime)));
                } else {
                    this.builder.addPrimaryKeyLivenessInfo(LivenessInfo.create(cell.timestamp, 1, cell.localDeletionTime));
                }
                this.hasValidCells = true;
            } else {
                if (column.isPrimaryKeyColumn() && this.metadata.isCQLTable()) {
                    noSpamLogger.warn("Illegal cell name for CQL3 table {}.{}. {} is defined as a primary key column", this.metadata.ksName, this.metadata.cfName, column.name);
                    if (this.invalidLivenessInfo != null) {
                        LivenessInfo newInvalidLiveness = LivenessInfo.create(cell.timestamp, cell.isTombstone() ? 1 : cell.ttl, cell.localDeletionTime);
                        if (newInvalidLiveness.supersedes(this.invalidLivenessInfo)) {
                            this.invalidLivenessInfo = newInvalidLiveness;
                        }
                    } else {
                        this.invalidLivenessInfo = LivenessInfo.create(cell.timestamp, cell.isTombstone() ? 1 : cell.ttl, cell.localDeletionTime);
                    }
                    return true;
                }
                if (this.collectionDeletion != null && this.collectionDeletion.start.collectionName.name.equals(column.name) && this.collectionDeletion.deletionTime.deletes(cell.timestamp)) {
                    return true;
                }
                if (this.helper.includes(column)) {
                    this.hasValidCells = true;
                    CellPath path = null;
                    if (column.isComplex()) {
                        this.helper.startOfComplexColumn(column);
                        CellPath cellPath = path = cell.name.collectionElement == null ? null : CellPath.create(cell.name.collectionElement);
                        if (!this.helper.includes(path)) {
                            return true;
                        }
                    }
                    column.type.validateIfFixedSize(cell.value);
                    BufferCell c = new BufferCell(column, cell.timestamp, cell.ttl, cell.localDeletionTime, cell.value, path);
                    if (!this.helper.isDropped(c, column.isComplex())) {
                        this.builder.addCell(c);
                    }
                    if (column.isComplex()) {
                        this.helper.endOfComplexColumn();
                    }
                }
            }
            return true;
        }

        private boolean addRangeTombstone(LegacyRangeTombstone tombstone) {
            if (tombstone.isRowDeletion(this.metadata)) {
                return this.addRowTombstone(tombstone);
            }
            assert (tombstone.isCollectionTombstone());
            return this.addCollectionTombstone(tombstone);
        }

        private boolean addRowTombstone(LegacyRangeTombstone tombstone) {
            if (this.clustering != null) {
                if (this.clustering.equals(tombstone.start.getAsClustering(this.metadata))) {
                    if (this.rowDeletion == null || tombstone.deletionTime.supersedes(this.rowDeletion.deletionTime)) {
                        this.builder.addRowDeletion(Row.Deletion.regular(tombstone.deletionTime));
                        this.rowDeletion = tombstone;
                        this.hasValidCells = true;
                    }
                    return true;
                }
                return false;
            }
            this.clustering = tombstone.start.getAsClustering(this.metadata);
            this.builder.newRow(this.clustering);
            this.builder.addRowDeletion(Row.Deletion.regular(tombstone.deletionTime));
            this.rowDeletion = tombstone;
            this.hasValidCells = true;
            return true;
        }

        private boolean addCollectionTombstone(LegacyRangeTombstone tombstone) {
            if (!this.helper.includes(tombstone.start.collectionName)) {
                return true;
            }
            this.helper.startOfComplexColumn(tombstone.start.collectionName);
            if (this.helper.isDroppedComplexDeletion(tombstone.deletionTime)) {
                return true;
            }
            if (this.clustering == null) {
                this.clustering = tombstone.start.getAsClustering(this.metadata);
                this.builder.newRow(this.clustering);
            } else if (!this.clustering.equals(tombstone.start.getAsClustering(this.metadata))) {
                return false;
            }
            this.builder.addComplexDeletion(tombstone.start.collectionName, tombstone.deletionTime);
            if (this.rowDeletion == null || tombstone.deletionTime.supersedes(this.rowDeletion.deletionTime)) {
                this.collectionDeletion = tombstone;
            }
            this.hasValidCells = true;
            return true;
        }

        public boolean startsAfterCurrentRow(LegacyRangeTombstone rangeTombstone) {
            return this.clustering != null && this.metadata.comparator.compare(rangeTombstone.start.bound, (ClusteringPrefix)this.clustering) > 0;
        }

        public Clustering currentRowClustering() {
            return this.clustering;
        }

        public Row getRow() {
            if (!this.hasValidCells && this.invalidLivenessInfo != null) {
                this.builder.addPrimaryKeyLivenessInfo(this.invalidLivenessInfo);
            }
            return this.builder.build();
        }
    }
}

