/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HeapUtils {
    private static final Logger logger = LoggerFactory.getLogger(HeapUtils.class);

    public static void generateHeapDump() {
        String jmapPath;
        Path dumpPath;
        Long processId = HeapUtils.getProcessId();
        if (processId == null) {
            logger.error("The process ID could not be retrieved. Skipping heap dump generation.");
            return;
        }
        String heapDumpPath = HeapUtils.getHeapDumpPathOption();
        if (heapDumpPath == null) {
            String cassandraHome = System.getenv("CASSANDRA_HOME");
            if (cassandraHome == null) {
                return;
            }
            heapDumpPath = cassandraHome;
        }
        if (Files.isDirectory(dumpPath = FileSystems.getDefault().getPath(heapDumpPath, new String[0]), new LinkOption[0])) {
            dumpPath = dumpPath.resolve("java_pid" + processId + ".hprof");
        }
        String jmapCommand = (jmapPath = HeapUtils.getJmapPath()) == null ? "jmap" : jmapPath;
        String[] dumpCommands = new String[]{jmapCommand, "-dump:format=b,file=" + dumpPath, processId.toString()};
        String[] histoCommands = new String[]{jmapCommand, "-histo", processId.toString()};
        try {
            HeapUtils.logProcessOutput(Runtime.getRuntime().exec(dumpCommands));
            HeapUtils.logProcessOutput(Runtime.getRuntime().exec(histoCommands));
        }
        catch (IOException e) {
            logger.error("The heap dump could not be generated due to the following error: ", (Throwable)e);
        }
    }

    private static String getJmapPath() {
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            return null;
        }
        File javaBinDirectory = new File(javaHome, "bin");
        Object[] files = javaBinDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("jmap");
            }
        });
        return ArrayUtils.isEmpty((Object[])files) ? null : ((File)files[0]).getPath();
    }

    private static void logProcessOutput(Process p) throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            StrBuilder builder = new StrBuilder();
            while ((line = input.readLine()) != null) {
                builder.appendln(line);
            }
            logger.info(builder.toString());
        }
    }

    private static String getHeapDumpPathOption() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMxBean.getInputArguments();
        String heapDumpPathOption = null;
        for (String argument : inputArguments) {
            if (!argument.startsWith("-XX:HeapDumpPath=")) continue;
            heapDumpPathOption = argument;
        }
        if (heapDumpPathOption == null) {
            return null;
        }
        return heapDumpPathOption.substring(17, heapDumpPathOption.length());
    }

    private static Long getProcessId() {
        long pid = NativeLibrary.getProcessID();
        if (pid >= 0L) {
            return pid;
        }
        return HeapUtils.getProcessIdFromJvmName();
    }

    private static Long getProcessIdFromJvmName() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Long.valueOf(jvmName.split("@")[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private HeapUtils() {
    }
}

