/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogSegmentManager;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.SyncUtil;

public class MemoryMappedSegment
extends CommitLogSegment {
    MemoryMappedSegment(CommitLog commitLog, AbstractCommitLogSegmentManager manager) {
        super(commitLog, manager);
        int firstSync = this.buffer.position();
        this.buffer.putInt(firstSync + 0, 0);
        this.buffer.putInt(firstSync + 4, 0);
    }

    @Override
    ByteBuffer createBuffer(CommitLog commitLog) {
        try {
            MappedByteBuffer mappedFile = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, DatabaseDescriptor.getCommitLogSegmentSize());
            this.manager.addSize(DatabaseDescriptor.getCommitLogSegmentSize());
            return mappedFile;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.logFile);
        }
    }

    @Override
    void write(int startMarker, int nextMarker) {
        if (nextMarker <= this.buffer.capacity() - 8) {
            this.buffer.putInt(nextMarker, 0);
            this.buffer.putInt(nextMarker + 4, 0);
        }
        this.writeSyncMarker(this.buffer, startMarker, startMarker, nextMarker);
        try {
            SyncUtil.force((MappedByteBuffer)this.buffer);
        }
        catch (Exception e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
        NativeLibrary.trySkipCache(this.fd, (long)startMarker, nextMarker, this.logFile.getAbsolutePath());
    }

    @Override
    public long onDiskSize() {
        return DatabaseDescriptor.getCommitLogSegmentSize();
    }

    @Override
    protected void internalClose() {
        if (FileUtils.isCleanerAvailable) {
            FileUtils.clean(this.buffer);
        }
        super.internalClose();
    }
}

