/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.UUIDGen;

public class PrepareMessage
extends Message.Request {
    public static final Message.Codec<PrepareMessage> codec = new Message.Codec<PrepareMessage>(){

        @Override
        public PrepareMessage decode(ByteBuf body, ProtocolVersion version) {
            String query = CBUtil.readLongString(body);
            return new PrepareMessage(query);
        }

        @Override
        public void encode(PrepareMessage msg, ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeLongString(msg.query, dest);
        }

        @Override
        public int encodedSize(PrepareMessage msg, ProtocolVersion version) {
            return CBUtil.sizeOfLongString(msg.query);
        }
    };
    private final String query;

    public PrepareMessage(String query) {
        super(Message.Type.PREPARE);
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state, long queryStartNanoTime) {
        try {
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                Tracing.instance.begin("Preparing CQL3 query", state.getClientAddress(), (Map<String, String>)ImmutableMap.of((Object)"query", (Object)this.query));
            }
            ResultMessage.Prepared response = ClientState.getCQLQueryHandler().prepare(this.query, state, this.getCustomPayload());
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage.Prepared prepared = response;
            return prepared;
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        return "PREPARE " + this.query;
    }
}

