/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import java.net.InetAddress;
import java.util.NavigableMap;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.NoReplicationTokenAllocator;
import org.apache.cassandra.dht.tokenallocator.ReplicationAwareTokenAllocator;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocator;

public class TokenAllocatorFactory {
    public static TokenAllocator<InetAddress> createTokenAllocator(NavigableMap<Token, InetAddress> sortedTokens, ReplicationStrategy<InetAddress> strategy, IPartitioner partitioner) {
        if (strategy.replicas() == 1) {
            return new NoReplicationTokenAllocator<InetAddress>(sortedTokens, strategy, partitioner);
        }
        return new ReplicationAwareTokenAllocator<InetAddress>(sortedTokens, strategy, partitioner);
    }
}

