/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorBase;

public class NoReplicationTokenAllocator<Unit>
extends TokenAllocatorBase<Unit> {
    PriorityQueue<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> sortedUnits = Queues.newPriorityQueue();
    Map<Unit, PriorityQueue<TokenAllocatorBase.Weighted<TokenAllocatorBase.TokenInfo>>> tokensInUnits = Maps.newHashMap();
    private static final double MAX_TAKEOVER_RATIO = 0.9;
    private static final double MIN_TAKEOVER_RATIO = 0.09999999999999998;

    public NoReplicationTokenAllocator(NavigableMap<Token, Unit> sortedTokens, ReplicationStrategy<Unit> strategy, IPartitioner partitioner) {
        super(sortedTokens, strategy, partitioner);
    }

    private TokenAllocatorBase.TokenInfo<Unit> createTokenInfos(Map<Unit, TokenAllocatorBase.UnitInfo<Unit>> units) {
        if (units.isEmpty()) {
            return null;
        }
        TokenAllocatorBase.TokenInfo<Unit> prev = null;
        TokenAllocatorBase.TokenInfo first = null;
        for (Map.Entry en : this.sortedTokens.entrySet()) {
            Token t = (Token)en.getKey();
            TokenAllocatorBase.UnitInfo<Unit> ni = units.get(en.getValue());
            TokenAllocatorBase.TokenInfo<Unit> ti = new TokenAllocatorBase.TokenInfo<Unit>(t, ni);
            first = ti.insertAfter(first, prev);
            prev = ti;
        }
        TokenAllocatorBase.TokenInfo curr = first;
        this.tokensInUnits.clear();
        this.sortedUnits.clear();
        do {
            this.populateTokenInfoAndAdjustUnit(curr);
        } while ((curr = (TokenAllocatorBase.TokenInfo)curr.next) != first);
        for (TokenAllocatorBase.UnitInfo<Unit> unitInfo : units.values()) {
            this.sortedUnits.add(new TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo<Unit>>(unitInfo.ownership, unitInfo));
        }
        return first;
    }

    protected void createTokenInfos() {
        this.createTokenInfos(this.createUnitInfos(Maps.newHashMap()));
    }

    private void populateTokenInfoAndAdjustUnit(TokenAllocatorBase.TokenInfo<Unit> token) {
        token.replicationStart = token.prevInRing().token;
        token.replicationThreshold = token.token;
        token.replicatedOwnership = token.replicationStart.size(token.token);
        token.owningUnit.ownership += token.replicatedOwnership;
        PriorityQueue unitTokens = this.tokensInUnits.get(token.owningUnit.unit);
        if (unitTokens == null) {
            unitTokens = Queues.newPriorityQueue();
            this.tokensInUnits.put(token.owningUnit.unit, unitTokens);
        }
        unitTokens.add(new TokenAllocatorBase.Weighted<TokenAllocatorBase.TokenInfo<Unit>>(token.replicatedOwnership, token));
    }

    private Collection<Token> generateRandomTokens(TokenAllocatorBase.UnitInfo<Unit> newUnit, int numTokens, Map<Unit, TokenAllocatorBase.UnitInfo<Unit>> unitInfos) {
        HashSet<Token> tokens = new HashSet<Token>(numTokens);
        while (tokens.size() < numTokens) {
            Token token = this.partitioner.getRandomToken();
            if (this.sortedTokens.containsKey(token)) continue;
            tokens.add(token);
            this.sortedTokens.put(token, newUnit.unit);
        }
        unitInfos.put(newUnit.unit, newUnit);
        this.createTokenInfos(unitInfos);
        return tokens;
    }

    @Override
    public Collection<Token> addUnit(Unit newUnit, int numTokens) {
        double average;
        TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo> unit;
        assert (!this.tokensInUnits.containsKey(newUnit));
        HashMap groups = Maps.newHashMap();
        TokenAllocatorBase.UnitInfo<Unit> newUnitInfo = new TokenAllocatorBase.UnitInfo<Unit>(newUnit, 0.0, groups, this.strategy);
        Map unitInfos = this.createUnitInfos(groups);
        if (unitInfos.isEmpty()) {
            return this.generateRandomTokens(newUnitInfo, numTokens, unitInfos);
        }
        if (numTokens > this.sortedTokens.size()) {
            return this.generateRandomTokens(newUnitInfo, numTokens, unitInfos);
        }
        TokenAllocatorBase.TokenInfo head = this.createTokenInfos(unitInfos);
        double targetAverage = 0.0;
        double sum = 0.0;
        ArrayList<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> unitsToChange = new ArrayList<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>>();
        for (int i = 0; i < numTokens && (unit = this.sortedUnits.peek()) != null && !(unit.weight <= (average = (sum += unit.weight) / (double)(unitsToChange.size() + 2))); ++i) {
            this.sortedUnits.remove();
            unitsToChange.add(unit);
            targetAverage = average;
        }
        ArrayList newTokens = Lists.newArrayListWithCapacity((int)numTokens);
        int nr = 0;
        for (TokenAllocatorBase.Weighted weighted : unitsToChange) {
            int tokensToChange = numTokens / unitsToChange.size() + (nr < numTokens % unitsToChange.size() ? 1 : 0);
            Queue unitTokens = this.tokensInUnits.get(((TokenAllocatorBase.UnitInfo)weighted.value).unit);
            ArrayList tokens = Lists.newArrayListWithCapacity((int)tokensToChange);
            double workWeight = 0.0;
            for (int i = 0; i < tokensToChange; ++i) {
                TokenAllocatorBase.Weighted wt = (TokenAllocatorBase.Weighted)unitTokens.remove();
                tokens.add(wt);
                workWeight += wt.weight;
                ((TokenAllocatorBase.UnitInfo)weighted.value).ownership -= wt.weight;
            }
            double toTakeOver = weighted.weight - targetAverage;
            for (TokenAllocatorBase.Weighted wt : tokens) {
                double slice;
                if (toTakeOver < workWeight) {
                    slice = toTakeOver / workWeight;
                    if (slice < 0.09999999999999998) {
                        slice = 0.09999999999999998;
                    }
                    if (slice > 0.9) {
                        slice = 0.9;
                    }
                } else {
                    slice = 0.9;
                }
                Token token = this.partitioner.split(((TokenAllocatorBase.TokenInfo)wt.value).prevInRing().token, ((TokenAllocatorBase.TokenInfo)wt.value).token, slice);
                this.sortedTokens.put(token, newUnit);
                TokenAllocatorBase.TokenInfo<Unit> ti = new TokenAllocatorBase.TokenInfo<Unit>(token, newUnitInfo);
                ti.insertAfter(head, ((TokenAllocatorBase.TokenInfo)wt.value).prevInRing());
                this.populateTokenInfoAndAdjustUnit(ti);
                this.populateTokenInfoAndAdjustUnit((TokenAllocatorBase.TokenInfo)wt.value);
                newTokens.add(token);
            }
            this.sortedUnits.add(new TokenAllocatorBase.Weighted(((TokenAllocatorBase.UnitInfo)weighted.value).ownership, weighted.value));
            ++nr;
        }
        this.sortedUnits.add(new TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo<Unit>>(newUnitInfo.ownership, newUnitInfo));
        return newTokens;
    }

    void removeUnit(Unit n) {
        Iterator<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> it = this.sortedUnits.iterator();
        while (it.hasNext()) {
            if (!((TokenAllocatorBase.UnitInfo)it.next().value).unit.equals(n)) continue;
            it.remove();
            break;
        }
        PriorityQueue<TokenAllocatorBase.Weighted<TokenAllocatorBase.TokenInfo>> tokenInfos = this.tokensInUnits.remove(n);
        ArrayList tokens = Lists.newArrayListWithCapacity((int)tokenInfos.size());
        for (TokenAllocatorBase.Weighted<TokenAllocatorBase.TokenInfo> tokenInfo : tokenInfos) {
            tokens.add(((TokenAllocatorBase.TokenInfo)tokenInfo.value).token);
        }
        this.sortedTokens.keySet().removeAll(tokens);
    }

    @Override
    public int getReplicas() {
        return 1;
    }
}

