/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.rows.AbstractRangeTombstoneMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class RangeTombstoneBoundaryMarker
extends AbstractRangeTombstoneMarker<ClusteringBoundary> {
    private final DeletionTime endDeletion;
    private final DeletionTime startDeletion;

    public RangeTombstoneBoundaryMarker(ClusteringBoundary bound, DeletionTime endDeletion, DeletionTime startDeletion) {
        super(bound);
        assert (bound.isBoundary());
        this.endDeletion = endDeletion;
        this.startDeletion = startDeletion;
    }

    public static RangeTombstoneBoundaryMarker exclusiveCloseInclusiveOpen(boolean reversed, ByteBuffer[] boundValues, DeletionTime closeDeletion, DeletionTime openDeletion) {
        ClusteringBoundary bound = ClusteringBoundary.exclusiveCloseInclusiveOpen(reversed, boundValues);
        DeletionTime endDeletion = reversed ? openDeletion : closeDeletion;
        DeletionTime startDeletion = reversed ? closeDeletion : openDeletion;
        return new RangeTombstoneBoundaryMarker(bound, endDeletion, startDeletion);
    }

    public static RangeTombstoneBoundaryMarker inclusiveCloseExclusiveOpen(boolean reversed, ByteBuffer[] boundValues, DeletionTime closeDeletion, DeletionTime openDeletion) {
        ClusteringBoundary bound = ClusteringBoundary.inclusiveCloseExclusiveOpen(reversed, boundValues);
        DeletionTime endDeletion = reversed ? openDeletion : closeDeletion;
        DeletionTime startDeletion = reversed ? closeDeletion : openDeletion;
        return new RangeTombstoneBoundaryMarker(bound, endDeletion, startDeletion);
    }

    public DeletionTime endDeletionTime() {
        return this.endDeletion;
    }

    public DeletionTime startDeletionTime() {
        return this.startDeletion;
    }

    @Override
    public DeletionTime closeDeletionTime(boolean reversed) {
        return reversed ? this.startDeletion : this.endDeletion;
    }

    @Override
    public DeletionTime openDeletionTime(boolean reversed) {
        return reversed ? this.endDeletion : this.startDeletion;
    }

    @Override
    public boolean openIsInclusive(boolean reversed) {
        return ((ClusteringBoundary)this.bound).kind() == ClusteringPrefix.Kind.EXCL_END_INCL_START_BOUNDARY ^ reversed;
    }

    @Override
    public ClusteringBound openBound(boolean reversed) {
        return ((ClusteringBoundary)this.bound).openBound(reversed);
    }

    @Override
    public ClusteringBound closeBound(boolean reversed) {
        return ((ClusteringBoundary)this.bound).closeBound(reversed);
    }

    @Override
    public boolean closeIsInclusive(boolean reversed) {
        return ((ClusteringBoundary)this.bound).kind() == ClusteringPrefix.Kind.INCL_END_EXCL_START_BOUNDARY ^ reversed;
    }

    @Override
    public boolean isOpen(boolean reversed) {
        return true;
    }

    @Override
    public boolean isClose(boolean reversed) {
        return true;
    }

    @Override
    public RangeTombstoneBoundaryMarker copy(AbstractAllocator allocator) {
        return new RangeTombstoneBoundaryMarker(((ClusteringBoundary)this.clustering()).copy(allocator), this.endDeletion, this.startDeletion);
    }

    public static RangeTombstoneBoundaryMarker makeBoundary(boolean reversed, ClusteringBound close, ClusteringBound open, DeletionTime closeDeletion, DeletionTime openDeletion) {
        assert (ClusteringPrefix.Kind.compare(close.kind(), open.kind()) == 0) : "Both bound don't form a boundary";
        boolean isExclusiveClose = close.isExclusive() || close.isInclusive() && open.isInclusive() && openDeletion.supersedes(closeDeletion);
        return isExclusiveClose ? RangeTombstoneBoundaryMarker.exclusiveCloseInclusiveOpen(reversed, close.getRawValues(), closeDeletion, openDeletion) : RangeTombstoneBoundaryMarker.inclusiveCloseExclusiveOpen(reversed, close.getRawValues(), closeDeletion, openDeletion);
    }

    public RangeTombstoneBoundMarker createCorrespondingCloseMarker(boolean reversed) {
        return new RangeTombstoneBoundMarker(this.closeBound(reversed), this.endDeletion);
    }

    public RangeTombstoneBoundMarker createCorrespondingOpenMarker(boolean reversed) {
        return new RangeTombstoneBoundMarker(this.openBound(reversed), this.startDeletion);
    }

    @Override
    public void digest(MessageDigest digest) {
        ((ClusteringBoundary)this.bound).digest(digest);
        this.endDeletion.digest(digest);
        this.startDeletion.digest(digest);
    }

    @Override
    public String toString(CFMetaData metadata) {
        return String.format("Marker %s@%d-%d", ((ClusteringBoundary)this.bound).toString(metadata), this.endDeletion.markedForDeleteAt(), this.startDeletion.markedForDeleteAt());
    }

    public boolean equals(Object other) {
        if (!(other instanceof RangeTombstoneBoundaryMarker)) {
            return false;
        }
        RangeTombstoneBoundaryMarker that = (RangeTombstoneBoundaryMarker)other;
        return ((ClusteringBoundary)this.bound).equals(that.bound) && this.endDeletion.equals(that.endDeletion) && this.startDeletion.equals(that.startDeletion);
    }

    public int hashCode() {
        return Objects.hash(this.bound, this.endDeletion, this.startDeletion);
    }
}

